/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.cad.common.check.AbstractCalcCheckAction;
import kd.macc.cad.common.check.CalcCheckContext;
import kd.macc.cad.common.check.CalcCheckHelper;
import kd.macc.sca.algox.calc.input.CalcDataArgs;
import kd.macc.sca.algox.enums.CalcReportResultEnum;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.TimeUtils;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

public class RestoreCheckHelper {
    private static final Log logger = LogFactory.getLog(RestoreCheckHelper.class);

    public static void doCheck(String param, CalcDataArgs args) {
        Date startTime = TimeServiceHelper.now();
        JSONObject jsonObject = JSONObject.fromObject((Object)param);
        JSONArray checkItemList = new ArrayList(10);
        if (jsonObject.get("checkItemList") != null) {
            checkItemList = jsonObject.getJSONArray("checkItemList");
        }
        Long checkReportId = jsonObject.getLong("checkReportId");
        Long taskRecordId = args.getTaskRecordId();
        String calType = "sca_differencecalcwizards";
        CalcCheckContext calcCheckContext = new CalcCheckContext();
        calcCheckContext.setCheckParamJs(jsonObject);
        calcCheckContext.setCheckResultId(checkReportId);
        calcCheckContext.setTaskId(taskRecordId);
        calcCheckContext.setTaskType(calType);
        calcCheckContext.setGlobalId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        calcCheckContext.setOrgId(Long.valueOf(jsonObject.getLong("org")));
        calcCheckContext.setCostAccountId(Long.valueOf(jsonObject.getLong("costaccount")));
        calcCheckContext.setPeriodId(Long.valueOf(jsonObject.getLong("period")));
        calcCheckContext.setCurrencyId(Long.valueOf(jsonObject.getLong("currencyId")));
        calcCheckContext.setPeriodStartDate(TimeUtils.parseDate(jsonObject.getString("startDate")));
        calcCheckContext.setPeriodEndDate(TimeUtils.parseDate(jsonObject.getString("endDate")));
        int checkMode = jsonObject.get("checkMode") == null ? 2 : jsonObject.getInt("checkMode");
        calcCheckContext.setCheckMode(checkMode);
        List checkActionList = CalcCheckHelper.getCheckActionList((CalcCheckContext)calcCheckContext, (List)checkItemList, (String)calType, (String)jsonObject.getString("appNum"));
        for (AbstractCalcCheckAction action : checkActionList) {
            action.execute();
        }
        Long failCount = 0L;
        Long remindCount = 0L;
        if (!CadEmptyUtils.isEmpty(checkActionList)) {
            failCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getFailCount();
            remindCount = ((AbstractCalcCheckAction)checkActionList.get(0)).getContext().getRemindCount();
            args.setCheckNoPassCount(Integer.parseInt(String.valueOf(failCount)));
            args.setCheckRemindCount(Integer.parseInt(String.valueOf(remindCount)));
            args.setCheckResultId(checkReportId);
        }
        jsonObject.accumulate("time", TimeUtils.getSecond(startTime, TimeServiceHelper.now()));
        jsonObject.accumulate("checkFailCount", (Object)failCount);
        jsonObject.accumulate("remindCount", (Object)remindCount);
        jsonObject.accumulate("successCcCount", 0);
        jsonObject.accumulate("taskRecordId", (Object)taskRecordId);
        if (checkMode == 1) {
            RestoreCheckHelper.updateTaskRecordNextPagePara(jsonObject, taskRecordId);
        }
        RestoreCheckHelper.endDiffCheckCalcReport(checkReportId, failCount, remindCount);
    }

    private static void updateTaskRecordNextPagePara(JSONObject checkparam, Long checkResultId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        DynamicObject taskRecord = BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"nextpagepara,progress,status", (QFilter[])new QFilter[]{filter});
        if (!CadEmptyUtils.isEmpty(taskRecord)) {
            if ("2".equals(taskRecord.getString("status"))) {
                taskRecord.set("status", (Object)"4");
            }
            checkparam.accumulate("checkResultId", (Object)checkResultId);
            taskRecord.set("nextpagepara", (Object)checkparam.toString());
            SaveServiceHelper.update((DynamicObject)taskRecord);
        }
    }

    public static Long initDiffCheckCalcReport(String checkParams) {
        JSONObject checkParamJs = JSONObject.fromObject((Object)checkParams);
        DynamicObject calcReport = BusinessDataServiceHelper.newDynamicObject((String)"sca_restore_calcreport");
        Long calcReportId = DBServiceHelper.genGlobalLongId();
        calcReport.set("id", (Object)calcReportId);
        calcReport.set("taskname", (Object)ResManager.loadKDString((String)"\u5dee\u5f02\u5206\u644a\u8ba1\u7b97\u5408\u6cd5\u6027\u68c0\u67e5", (String)"RestoreCheckHelper_0", (String)"macc-sca-algox", (Object[])new Object[0]));
        calcReport.set("billtype", (Object)"1");
        calcReport.set("type", (Object)"2");
        calcReport.set("progress", (Object)0);
        calcReport.set("org", (Object)checkParamJs.getString("org"));
        calcReport.set("costaccount", (Object)checkParamJs.getString("costaccount"));
        calcReport.set("period", (Object)checkParamJs.getString("period"));
        calcReport.set("executor", (Object)RequestContext.get().getUserId());
        calcReport.set("calcdate", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{calcReport});
        return calcReportId;
    }

    private static void endDiffCheckCalcReport(Long calcReportId, Long failCount, Long remindCount) {
        String selectfields = "id,calcdate,type,progress,usetime";
        QFilter filter = new QFilter("id", "=", (Object)calcReportId);
        DynamicObject calcReport = BusinessDataServiceHelper.loadSingle((String)"sca_restore_calcreport", (String)selectfields, (QFilter[])new QFilter[]{filter});
        if (calcReport != null) {
            if (failCount != 0L) {
                calcReport.set("type", (Object)"3");
            } else if (remindCount != 0L) {
                calcReport.set("type", (Object)"5");
            } else {
                calcReport.set("type", (Object)"4");
            }
            calcReport.set("progress", (Object)100);
            long second = TimeUtils.getSecond(calcReport.getDate("calcdate"), new Date());
            calcReport.set("usetime", (Object)(second > 0L ? second : 1L));
            SaveServiceHelper.update((DynamicObject)calcReport);
        }
    }

    public static int getDiffCalcReportEntryFailCount(Long checkResultId) {
        QFilter filter = new QFilter("id", "=", (Object)checkResultId);
        filter.and(new QFilter("entryentity.result", "=", (Object)CalcReportResultEnum.CALCREPORT_NOPASS.getValue()));
        DynamicObjectCollection checkFailRs = QueryServiceHelper.query((String)"sca_restore_calcreport", (String)"entryentity.id", (QFilter[])new QFilter[]{filter});
        return CadEmptyUtils.isEmpty(checkFailRs) ? 0 : checkFailRs.size();
    }
}

