/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.constants.RestoreCalcCheck;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CalcReportHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import org.apache.commons.lang.StringUtils;

public class RestoreTaskHelper {
    public static final Long PDEND_TASKID = 888831469932296192L;
    public static final Long PDENDENTRY_CHECK_TASKID = 888831548223175680L;
    public static final Long PDENDENTRY_MATALLOC_TASKID = 888831548223175681L;
    public static final Long PDENDENTRY_MFGALLOC_TASKID = 888860514069822464L;
    public static final Long PDENDENTRY_MATCALC_TASKID = 888863948466600960L;
    public static final Long PDENDENTRY_MFGCALC_TASKID = 888863948466600961L;
    public static final Long PDENDENTRY_COSTCENTERCALC_TASKID = 888863948466600962L;
    public static final Long PDENDENTRY_CREATEDIFFBILL_TASKID = 888863948466600963L;
    public static final String STATUS_DOING = "2";
    public static final String STATUS_FAIL = "3";
    public static final String STATUS_OK = "4";

    public static void upateTaskRecord(Long taskId, int mProgess, String status, Long executor) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            long totalProgress = record.getLong("progress") + (long)mProgess;
            if (totalProgress >= 100L) {
                record.set("progress", (Object)100);
            } else {
                record.set("progress", (Object)totalProgress);
            }
            record.set("time", (Object)TimeUtils.getSecond(record.getDate("starttime"), new Date()));
            record.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void upateTaskRecordEntry(Long taskId, Long taskDetailId, int seq, String status, Long executor) {
        RestoreTaskHelper.upateTaskRecordEntry(taskId, taskDetailId, seq, status, executor, null, null);
    }

    public static void upateTaskRecordEntry(Long taskId, Long taskDetailId, int seq, String status, Long executor, String errorDetail, String bigText) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.seq,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.subparam,entryentity.subparam_tag,entryentity.detail", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0 || entry.getInt("seq") != seq) continue;
                entry.set("substatus", (Object)status);
                if (STATUS_DOING.equals(status) && entry.getDate("substarttime") == null) {
                    entry.set("substarttime", (Object)new Date());
                }
                if (STATUS_OK.equals(status)) {
                    entry.set("subtime", (Object)TimeUtils.getMilliSecond(entry.getDate("substarttime"), new Date()));
                }
                if (kd.bos.util.StringUtils.isNotEmpty((String)errorDetail)) {
                    entry.set("detail", (Object)(errorDetail.length() > 255 ? errorDetail.substring(0, 255) : errorDetail));
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)bigText)) continue;
                entry.set("subparam", (Object)(StringUtils.substring((String)bigText, (int)0, (int)50) + "..."));
                entry.set("subparam_tag", (Object)bigText);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static int saveTaskRecordEntry(Long taskId, Long taskDetailId, String item, String status, Long executor) {
        return RestoreTaskHelper.saveTaskRecordEntry(taskId, taskDetailId, item, status, executor, null);
    }

    public static int saveTaskRecordEntry(Long taskId, Long taskDetailId, String item, String status, Long executor, String bigText) {
        String recordFields = "id,entryentity.id,entryentity.seq,entryentity.subname,entryentity.substarttime,entryentity.substatus,entryentity.subnextentity,entryentity.detailconfig,entryentity.subparam,entryentity.subparam_tag";
        DynamicObject record = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskrecord", (String)recordFields);
        int seq = 0;
        if (!CadEmptyUtils.isEmpty(record)) {
            DynamicObjectCollection taskrecordEntrys = record.getDynamicObjectCollection("entryentity");
            String selectFields = "entryentity.id,entryentity.subnextentity";
            DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)RestoreCalcCheck.CALCTASKID, (String)"sca_taskconfig", (String)selectFields);
            DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject taskConfigEntry : taskConfigEntrys) {
                if (taskDetailId.compareTo(taskConfigEntry.getLong("id")) != 0) continue;
                DynamicObject taskrecordEntry = taskrecordEntrys.addNew();
                seq = taskrecordEntrys.size();
                taskrecordEntry.set("seq", (Object)seq);
                taskrecordEntry.set("subname", (Object)item);
                taskrecordEntry.set("substarttime", (Object)new Date());
                taskrecordEntry.set("substatus", (Object)status);
                taskrecordEntry.set("subnextentity", (Object)taskConfigEntry.getString("subnextentity"));
                taskrecordEntry.set("detailconfig", taskConfigEntry.getPkValue());
                if (!kd.bos.util.StringUtils.isNotEmpty((String)bigText)) continue;
                taskrecordEntry.set("subparam", (Object)(StringUtils.substring((String)bigText, (int)0, (int)50) + "..."));
                taskrecordEntry.set("subparam_tag", (Object)bigText);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
        return seq;
    }

    public static void upateTaskRecordDetailPara(Long taskConfigId, Long taskConfigDetailId, String detail, String nextPagePara, Long executor) {
        Long lastRecordId = RestoreTaskHelper.getLastTaskRecordId(taskConfigId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
                entry.set("subparam", (Object)nextPagePara);
                entry.set("detail", (Object)detail);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void writeErroToTaskRecordEntry(Long taskConfigId, Exception erro, Long executor) {
        Long lastRecordId;
        QFilter filter;
        Object[] records;
        if (erro == null || erro.getStackTrace() == null || erro.getStackTrace().length < 1) {
            return;
        }
        StringBuilder erroStr = new StringBuilder();
        String errormsg = erro.getCause() == null ? (erro.getLocalizedMessage() == null ? "" : erro.getLocalizedMessage()) : erro.getCause().getMessage();
        erroStr.append(errormsg).append("\n");
        if (!(erro instanceof KDBizException)) {
            for (StackTraceElement traceElement : erro.getStackTrace()) {
                erroStr.append(traceElement).append("\n");
            }
        }
        if (!CadEmptyUtils.isEmpty(records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam,entryentity.subparam_tag,entryentity.substatus substatus", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", (Object)(lastRecordId = RestoreTaskHelper.getLastTaskRecordId(taskConfigId, executor)))}, (String)"starttime desc"))) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            DynamicObject entry = (DynamicObject)entrys.get(entrys.size() - 1);
            if (entry != null) {
                entry.set("substatus", (Object)STATUS_FAIL);
                entry.set("detail", (Object)org.apache.commons.lang3.StringUtils.substring((String)erroStr.toString(), (int)0, (int)255));
                entry.set("subparam", (Object)"");
                entry.set("subparam_tag", (Object)org.apache.commons.lang3.StringUtils.substring((String)erroStr.toString(), (int)0, (int)2000000));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static Long getLastTaskRecordId(Long taskConfigId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskConfigId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty(records) ? 0L : records[0].getLong("id");
    }

    public static DynamicObject getTaskRecord(Long taskId) {
        QFilter filter = new QFilter("id", "=", (Object)taskId);
        return BusinessDataServiceHelper.loadSingle((String)"sca_taskrecord", (String)"id,time,nextpagepara", (QFilter[])new QFilter[]{filter});
    }

    public static void updateNextPagePara(Long taskId, String nextPagePara) {
        DynamicObject taskRecord = RestoreTaskHelper.getTaskRecord(taskId);
        if (taskRecord == null) {
            return;
        }
        taskRecord.set("nextpagepara", (Object)nextPagePara);
        SaveServiceHelper.update((DynamicObject)taskRecord);
    }

    public static void startTask(IFormView view, Long taskId, String param) {
        Long taskRecordId = RestoreTaskHelper.initTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_taskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    public static void startTask(IFormView view, IDataModel model, Long taskId, String param, String taskType, Date calTime) {
        Long calcReportId = CalcReportHelper.initCalcReport(taskId, model, taskType, calTime);
        Long taskRecordId = RestoreTaskHelper.initTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_taskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.setCustomParam("calcReportId", (Object)calcReportId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    private static Long initTaskRecord(Long taskId) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskConfig.getString("name"));
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        taskrecord.set("nextpage", (Object)taskConfig.getString("nextentity"));
        taskrecord.set("taskconfig", (Object)taskConfig.getLong("id"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }
}

