/*
 * Decompiled with CFR 0.152.
 */
package kd.macc.sca.algox.utils;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.macc.sca.algox.utils.CadEmptyUtils;
import kd.macc.sca.algox.utils.CalcReportHelper;
import kd.macc.sca.algox.utils.FactCostReductTaskHelper;
import kd.macc.sca.algox.utils.TimeUtils;
import net.sf.json.JSONObject;

public class TaskHelper {
    protected static final Log logger = LogFactory.getLog(TaskHelper.class);
    public static final Long PDEND_TASKID = 888831469932296192L;
    public static final Long PDENDENTRY_CHECK_TASKID = 888831548223175680L;
    public static final Long PDENDENTRY_MATALLOC_TASKID = 888831548223175681L;
    public static final Long PDENDENTRY_MFGALLOC_TASKID = 888860514069822464L;
    public static final Long PDENDENTRY_MATCALC_TASKID = 888863948466600960L;
    public static final Long PDENDENTRY_MFGCALC_TASKID = 888863948466600961L;
    public static final Long PDENDENTRY_COSTCENTERCALC_TASKID = 888863948466600962L;
    public static final Long PDENDENTRY_CREATEDIFFBILL_TASKID = 888863948466600963L;
    public static final String STATUS_DOING = "2";
    public static final String STATUS_FAIL = "3";
    public static final String STATUS_OK = "4";

    public static void upateTaskRecord(Long taskId, int mProgess, String status, Long executor) {
        Long lastRecordId = TaskHelper.getLastTaskRecordId(taskId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            long totalProgress = record.getLong("progress") + (long)mProgess;
            logger.info("\u66f4\u65b0\u524d\u8fdb\u5ea6\uff1a" + totalProgress);
            if (totalProgress < 100L) {
                record.set("progress", (Object)totalProgress);
            } else if (mProgess == 100) {
                record.set("progress", (Object)100);
                logger.info("\u5355\u6b21\u66f4\u65b0\u8fdb\u5ea6100\uff1a\u8ba1\u7b97\u7ed3\u675f" + totalProgress);
            } else {
                record.set("progress", (Object)99);
            }
            record.set("time", (Object)TimeUtils.getSecond(record.getDate("starttime"), new Date()));
            record.set("status", (Object)status);
            SaveServiceHelper.update((DynamicObject)record);
        }
        logger.info("\u672c\u6b21\u66f4\u65b0\u8fdb\u5ea6\uff1a" + mProgess);
    }

    public static void upateTaskRecordDetail(Long taskId, Long taskDetailId, String status, Long executor) {
        Long lastRecordId = TaskHelper.getLastTaskRecordId(taskId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (CadEmptyUtils.isEmpty(records)) {
            return;
        }
        Object record = records[0];
        DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            if (taskDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
            entry.set("substatus", (Object)status);
            if (STATUS_DOING.equals(status)) {
                entry.set("substarttime", (Object)TimeServiceHelper.now());
            }
            if (STATUS_OK.equals(status)) {
                long oldTime = entry.getLong("subtime");
                Long subTime = TimeUtils.getMilliSecond(entry.getDate("substarttime"), TimeServiceHelper.now());
                entry.set("subtime", (Object)(subTime + oldTime));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void upateTaskRecordDetailPara(Long taskConfigId, Long taskConfigDetailId, String detail, String nextPagePara, Long executor) {
        Long lastRecordId = TaskHelper.getLastTaskRecordId(taskConfigId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (taskConfigDetailId.compareTo(entry.getLong("detailconfig")) != 0) continue;
                entry.set("subparam", (Object)nextPagePara);
                entry.set("detail", (Object)detail);
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static void writeErroToDetailTask(Long taskConfigId, Exception erro, Long executor) {
        if (erro == null || erro.getStackTrace() == null || erro.getStackTrace().length < 1) {
            return;
        }
        StringBuilder erroStr = new StringBuilder();
        erroStr.append(erro.getCause()).append("\n");
        for (StackTraceElement traceElement : erro.getStackTrace()) {
            erroStr.append(traceElement).append("\n");
        }
        logger.error("\u8ba1\u7b97\u4efb\u52a1\u6267\u884c\u5f02\u5e38\uff1a" + erroStr);
        Long lastRecordId = TaskHelper.getLastTaskRecordId(taskConfigId, executor);
        QFilter filter = new QFilter("id", "=", (Object)lastRecordId);
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,progress,time,starttime,status,entryentity.detailconfig,entryentity.substatus,entryentity.substarttime,entryentity.subtime,entryentity.detail,entryentity.subparam,entryentity.substatus substatus", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        if (!CadEmptyUtils.isEmpty(records)) {
            Object record = records[0];
            DynamicObjectCollection entrys = record.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                if (!STATUS_DOING.equals(entry.getString("substatus"))) continue;
                entry.set("substatus", (Object)STATUS_FAIL);
                entry.set("detail", (Object)(erroStr.length() > 255 ? erroStr.substring(0, 255) : erroStr.toString()));
            }
            SaveServiceHelper.update((DynamicObject)record);
        }
    }

    public static Long getLastTaskRecordId(Long taskConfigId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskConfigId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty(records) ? 0L : records[0].getLong("id");
    }

    public static DynamicObject getLastTaskRecord(Long taskId, Long executor) {
        QFilter filter = new QFilter("taskconfig", "=", (Object)taskId);
        filter.and(new QFilter("executor", "=", (Object)executor));
        Object[] records = BusinessDataServiceHelper.load((String)"sca_taskrecord", (String)"id,time,nextpagepara", (QFilter[])new QFilter[]{filter}, (String)"starttime desc");
        return CadEmptyUtils.isEmpty(records) ? null : records[0];
    }

    public static void updateNextPagePara(Long taskId, Long executor, String nextPagePara) {
        DynamicObject taskRecord = TaskHelper.getLastTaskRecord(taskId, executor);
        if (taskRecord == null) {
            return;
        }
        logger.info("\u4efb\u52a1\u8bb0\u5f55\u53c2\u6570\uff1a" + nextPagePara);
        taskRecord.set("nextpagepara", (Object)nextPagePara);
        SaveServiceHelper.update((DynamicObject)taskRecord);
    }

    public static void startTask(IFormView view, Long taskId, String param) {
        Long taskRecordId = TaskHelper.initTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_taskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    public static void startTask(IFormView view, IDataModel model, Long taskId, String param, String taskType) {
        Date calTime = TimeServiceHelper.now();
        Long checkReportId = CalcReportHelper.initCalcReport(model, taskType, calTime);
        Long calcReportId = CalcReportHelper.initCalcReport(taskId, model, taskType, calTime);
        Long taskRecordId = TaskHelper.initTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_taskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.setCustomParam("checkReportId", (Object)checkReportId);
        lsp.setCustomParam("calcReportId", (Object)calcReportId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    private static Long initTaskRecord(Long taskId) {
        DynamicObject taskConfig = BusinessDataServiceHelper.loadSingle((Object)taskId, (String)"sca_taskconfig");
        DynamicObject taskrecord = BusinessDataServiceHelper.newDynamicObject((String)"sca_taskrecord");
        Long id = DBServiceHelper.genGlobalLongId();
        Date startTime = new Date();
        taskrecord.set("id", (Object)id);
        taskrecord.set("taskname", (Object)taskConfig.getString("name"));
        taskrecord.set("starttime", (Object)startTime);
        taskrecord.set("time", (Object)0);
        taskrecord.set("status", (Object)2);
        taskrecord.set("progress", (Object)0);
        taskrecord.set("executor", (Object)RequestContext.get().getUserId());
        taskrecord.set("nextpage", (Object)taskConfig.getString("nextentity"));
        taskrecord.set("taskconfig", (Object)taskConfig.getLong("id"));
        DynamicObjectCollection taskConfigEntrys = taskConfig.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection taskrecordEntrys = taskrecord.getDynamicObjectCollection("entryentity");
        int seq = 1;
        for (DynamicObject entry : taskConfigEntrys) {
            DynamicObject taskrecordEntry = taskrecordEntrys.addNew();
            taskrecordEntry.set("detailconfig", entry.getPkValue());
            taskrecordEntry.set("subname", (Object)entry.getString("subname"));
            taskrecordEntry.set("subnextentity", (Object)entry.getString("subnextentity"));
            taskrecordEntry.set("substatus", (Object)1);
            if (seq == 1) {
                taskrecordEntry.set("substarttime", (Object)startTime);
            }
            taskrecordEntry.set("seq", (Object)seq++);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskrecord});
        return id;
    }

    public static void startTaskForCostReduct(IFormView view, IDataModel model, Long taskId, String param) {
        Date calTime = TimeServiceHelper.now();
        Long checkReportId = FactCostReductTaskHelper.initCheckReport(taskId, model, calTime);
        Long calcReportId = FactCostReductTaskHelper.initCalcReport(taskId, model, calTime);
        Long taskRecordId = FactCostReductTaskHelper.initTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_costredtaskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.setCustomParam("calcReportId", (Object)calcReportId);
        lsp.setCustomParam("checkReportId", (Object)checkReportId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }

    public static void startTaskForCostReduct(IFormView view, Long taskId, String param) {
        Long checkReportId = FactCostReductTaskHelper.initCostReductReport(taskId, JSONObject.fromObject((Object)param));
        Long calcReportId = FactCostReductTaskHelper.initCostReductReport(taskId, JSONObject.fromObject((Object)param));
        Long taskRecordId = FactCostReductTaskHelper.initTaskRecord(taskId);
        FormShowParameter lsp = new FormShowParameter();
        lsp.setFormId("sca_costredtaskrunning");
        lsp.setCustomParam("calcParam", (Object)param);
        lsp.setCustomParam("taskConfigId", (Object)taskId);
        lsp.setCustomParam("taskRecordId", (Object)taskRecordId);
        lsp.setCustomParam("calcReportId", (Object)calcReportId);
        lsp.setCustomParam("checkReportId", (Object)checkReportId);
        lsp.getOpenStyle().setShowType(ShowType.Floating);
        view.showForm(lsp);
    }
}

