/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cps;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.business.custom.ext.CPSResultGetDataSetImpl;
import kd.mmc.mrp.business.custom.ext.ICPSResultGetDataSet;

public class CPSResultRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        CPSResultGetDataSetImpl defPlugin = new CPSResultGetDataSetImpl();
        PluginProxy pluginProxy = PluginProxy.create((Object)defPlugin, ICPSResultGetDataSet.class, (String)"MRP_CPS_RESULT_GROUP_EXT", null);
        List dataSets = pluginProxy.callReplaceIfPresent(p -> p.getGroupDataSet(param, arg1));
        if (!dataSets.isEmpty() && dataSets.get(0) != null) {
            return (DataSet)dataSets.get(0);
        }
        FilterInfo filter = param.getFilter();
        QFilter[] qFilter = this.getQFilter(filter);
        String detailSQL = this.getDetailSQL();
        DataSet detailDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_detail", (String)detailSQL, (QFilter[])qFilter, null);
        detailDataSet = detailDataSet.where("exceptionnumber not like '%101%'");
        detailDataSet = detailDataSet.where("exceptionnumber not like '%87%'");
        DataSet select = detailDataSet.copy().where("llc != '0'").select("e_billid,e_billentryid,e_cpsdate e_cpsdate1");
        select = select.groupBy(new String[]{"e_billid", "e_billentryid"}).max("e_cpsdate1").finish();
        detailDataSet = detailDataSet.where("llc = '0'");
        detailDataSet = detailDataSet.leftJoin(select).on("e_billid", "e_billid").on("e_billentryid", "e_billentryid").select(detailDataSet.getRowMeta().getFieldNames(), new String[]{"e_cpsdate1"}).finish();
        detailDataSet = detailDataSet.updateField("e_cpsdate", "case when e_cpsdate1 != null then e_cpsdate1 else e_cpsdate end");
        detailDataSet = detailDataSet.removeFields(new String[]{"e_cpsdate1"});
        String shortageSQL = this.getShortageSQL();
        DataSet shortageDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_cps_shortage", (String)shortageSQL, (QFilter[])qFilter, null);
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%101%'");
        shortageDataSet = shortageDataSet.where("exceptionnumber not like '%87%'");
        shortageDataSet = shortageDataSet.where("llc = '0'");
        DataSet union = detailDataSet.union(shortageDataSet);
        union = union.updateField("ishandle", "case when ishandle then 0 else 1 end");
        DataSet headDataSet = union.groupBy(new String[]{"e_lognumber", "e_requireorg", "e_billtype", "e_billtypef7", "e_billid", "e_billentryid", "e_billno", "e_billrow"}).max("e_startdate").max("e_origindemanddate").finish();
        headDataSet = headDataSet.addFields(new String[]{"e_billid", "e_billentryid"}, new String[]{"e_billid1", "e_billentryid1"});
        headDataSet = headDataSet.removeFields(new String[]{"e_billid", "e_billentryid"});
        DataSet finish = union.groupBy(new String[]{"e_billid", "e_billentryid", "e_material"}).max("e_configuredcode").max("e_tracknumber").max("e_auxpty").sum("e_cpsqty").max("e_requiredate").sum("e_cancpsqty").max("e_cpsdate").max("ishandle").finish();
        finish = finish.addField("case when e_cancpsqty = 0 then 'C' else (case when e_cancpsqty < e_cpsqty then 'D' else (case when ishandle = 1 then 'B' else 'A' end) end) end", "e_status");
        HashSet materialSet = new HashSet(16);
        finish.copy().forEach(row -> materialSet.add(row.getLong("e_material")));
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,baseunit e_unit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
        DataSet dataSet = finish.leftJoin(materialDataSet).on("e_material", "id").select(finish.getRowMeta().getFieldNames(), materialDataSet.getRowMeta().getFieldNames()).finish();
        finish = dataSet.leftJoin(headDataSet).on("e_billid", "e_billid1").on("e_billentryid", "e_billentryid1").select(dataSet.getRowMeta().getFieldNames(), headDataSet.getRowMeta().getFieldNames()).finish();
        if (filter.getString("filter_status") != null) {
            String status = filter.getString("filter_status");
            String[] split = status.split(",");
            StringBuilder s = new StringBuilder();
            s.append("e_status in ");
            s.append('(');
            for (int i = 0; i < split.length; ++i) {
                s.append('\'').append(split[i]);
                if (i == split.length - 1) {
                    s.append('\'');
                    continue;
                }
                s.append("',");
            }
            s.append(')');
            finish = finish.filter(s.toString());
        }
        return finish;
    }

    private String getDetailSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("caculatelog e_lognumber,entryentity.requireorg e_requireorg,");
        sql.append("entryentity.demandbilltype e_billtype,");
        sql.append("entryentity.billid e_billid,entryentity.billentryid e_billentryid,entryentity.demandbillf7 e_billtypef7,");
        sql.append("entryentity.billno e_billno,entryentity.billentryseq e_billrow,");
        sql.append("entryentity.supmaterial e_material,entryentity.configuredcode e_configuredcode,");
        sql.append("entryentity.tracknumber e_tracknumber,entryentity.demandauxpty e_auxpty,");
        sql.append("entryentity.demandqty e_cpsqty,entryentity.demanddate e_requiredate,");
        sql.append("entryentity.supplyqty e_cancpsqty,entryentity.ishandle ishandle,");
        sql.append("createtime e_startdate,entryentity.llc llc,entryentity.origindemanddate e_origindemanddate,entryentity.exceptionnumber exceptionnumber,entryentity.supplydate e_cpsdate");
        return sql.toString();
    }

    private String getShortageSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("caculatelog e_lognumber,entryentity.requireorg e_requireorg,");
        sql.append("entryentity.demandbilltype e_billtype,");
        sql.append("entryentity.billid e_billid,entryentity.billentryid e_billentryid,entryentity.demandbillf7 e_billtypef7,");
        sql.append("entryentity.billno e_billno,entryentity.billentryseq e_billrow,");
        sql.append("entryentity.material e_material,entryentity.configuredcode e_configuredcode,");
        sql.append("entryentity.tracknumber e_tracknumber,entryentity.demandauxpty e_auxpty,");
        sql.append("entryentity.srcdemandqty e_cpsqty,entryentity.demanddate e_requiredate,");
        sql.append("entryentity.srcdemandqty - entryentity.adjustqty e_cancpsqty,entryentity.ishandle ishandle,");
        sql.append("null e_startdate,entryentity.llc llc,entryentity.origindemanddate e_origindemanddate,entryentity.exceptionnumber exceptionnumber,entryentity.supplydate e_cpsdate");
        return sql.toString();
    }

    private QFilter[] getQFilter(FilterInfo filter) {
        ArrayList<QFilter> qfList = new ArrayList<QFilter>();
        DynamicObject runlog = filter.getDynamicObject("filter_log");
        qfList.add(new QFilter("caculatelog", "=", (Object)runlog.getString("number")));
        qfList.add(new QFilter("entryentity.id", "!=", (Object)0L));
        if (filter.getValue("filter_requireorg") != null) {
            qfList.add(new QFilter("entryentity.requireorg", "=", filter.getDynamicObject("filter_requireorg").getPkValue()));
        }
        if (filter.getValue("filter_billtype") != null && !"".equals(filter.getString("filter_billtype"))) {
            qfList.add(new QFilter("entryentity.demandbilltype", "=", (Object)filter.getString("filter_billtype")));
        }
        if (filter.getValue("filter_billno") != null && !"".equals(filter.getString("filter_billno"))) {
            qfList.add(new QFilter("entryentity.billno", "=", (Object)filter.getString("filter_billno")));
        }
        if (filter.getValue("filter_rowno") != null) {
            qfList.add(new QFilter("entryentity.billentryseq", "=", (Object)filter.getInt("filter_rowno")));
        }
        if (filter.getValue("filter_material") != null) {
            qfList.add(new QFilter("entryentity.material", "=", filter.getDynamicObject("filter_material").getPkValue()));
        }
        return qfList.toArray(new QFilter[0]);
    }
}

