/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.cpstrack.CpsTrackRptUtil;

public class CpsTrackOmMFTOrderRptQuery
extends AbstractReportListDataPlugin {
    private static final String BILL_OM_MFTORDER = "om_mftorder";
    private static final String BILL_SM_SALORDER = "sm_salorder";
    private static final String BILL_MRP_PLANORDER = "mrp_planorder";
    private static final String BILL_PM_PURORDERBILL = "pm_purorderbill";
    private static final String BILL_PM_OM_PURORDERBILL = "pm_om_purorderbill";
    private static final String SMENTRYID = "smentryid";
    private static final String BILL_OM_ = "om_";
    private static final Log logger = LogFactory.getLog(CpsTrackOmMFTOrderRptQuery.class);

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        long starttime = System.currentTimeMillis();
        Map customParam = param.getCustomParam();
        ArrayList<QFilter> mftqfFilters = new ArrayList<QFilter>(customParam.size());
        ArrayList<QFilter> purqfFilters = new ArrayList<QFilter>(customParam.size());
        QFilter salorderFilter = null;
        if (customParam.get(SMENTRYID) != null) {
            List ids = (List)customParam.get(SMENTRYID);
            salorderFilter = new QFilter("billentry.id", "in", (Object)ids);
        }
        MainEntityType mftorderEntityType = EntityMetadataCache.getDataEntityType((String)BILL_OM_MFTORDER);
        MainEntityType ompurordeREntityType = EntityMetadataCache.getDataEntityType((String)BILL_PM_OM_PURORDERBILL);
        FilterInfo filter = param.getFilter();
        List mftqFilters = filter.getQFilters();
        ArrayList<String> exprs = new ArrayList<String>(mftqFilters.size());
        ArrayList<String> wheres = new ArrayList<String>(mftqFilters.size());
        Iterator iterator = mftqFilters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (!property.startsWith(BILL_OM_)) {
                iterator.remove();
                continue;
            }
            QFilter purqfFilter = this.dealQFilter(qFilter, exprs, ompurordeREntityType, wheres);
            QFilter mftqfFilter = this.dealQFilter(qFilter, exprs, mftorderEntityType, wheres);
            mftqfFilters.add(mftqfFilter);
            purqfFilters.add(purqfFilter);
        }
        DataSet allData = this.getAllData(mftqfFilters, purqfFilters, exprs, salorderFilter);
        DataSet dealData = this.dealData(allData);
        for (String expr : wheres) {
            dealData = dealData.where(expr);
        }
        long endtime = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u91c7\u8d2d\u5355\u636e\u8017\u65f6" + (endtime - starttime) + "ms");
        return CpsTrackRptUtil.sortAndFilter(param, dealData, "mrp_cps_tracks", BILL_OM_MFTORDER);
    }

    private QFilter dealQFilter(QFilter qFilter, List<String> exprs, MainEntityType entityType, List<String> wheres) {
        QFilter copyqFilter = qFilter.copy();
        this.analysisDealQFilter(copyqFilter, exprs, entityType, wheres);
        CpsTrackRptUtil.setProperty(copyqFilter, entityType, BILL_OM_);
        List list = copyqFilter.getNests(true);
        for (QFilter.QFilterNest qFilterNest : list) {
            QFilter qf = qFilterNest.getFilter();
            this.analysisDealQFilter(qf, exprs, entityType, wheres);
            CpsTrackRptUtil.setProperty(qf, entityType, BILL_OM_);
        }
        return copyqFilter;
    }

    private void analysisDealQFilter(QFilter qFilter, List<String> exprs, MainEntityType dataEntityType, List<String> whereFilters) {
        String property;
        switch (property = qFilter.getProperty()) {
            case "om_cpstatus": {
                qFilter.__setProperty("1");
                qFilter.__setCP("=");
                qFilter.__setValue((Object)1);
                break;
            }
            default: {
                CpsTrackRptUtil.setWhereFilter(qFilter, BILL_OM_, whereFilters, dataEntityType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet dealData(DataSet dataSet) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>(28);
                BigDecimal qty = row.getBigDecimal("om_qty") != null ? row.getBigDecimal("om_qty") : BigDecimal.ZERO;
                BigDecimal planqty = row.getBigDecimal("om_planqty") != null ? row.getBigDecimal("om_planqty") : BigDecimal.ZERO;
                String billname = row.getString("om_billname");
                BigDecimal receiveqty = BigDecimal.ZERO;
                BigDecimal invqty = BigDecimal.ZERO;
                if (BILL_OM_MFTORDER.equals(billname)) {
                    receiveqty = row.getBigDecimal("om_receiveqty") != null ? row.getBigDecimal("om_receiveqty") : BigDecimal.ZERO;
                    invqty = row.getBigDecimal("om_invqty") != null ? row.getBigDecimal("om_invqty") : BigDecimal.ZERO;
                } else if (BILL_PM_OM_PURORDERBILL.equals(billname)) {
                    receiveqty = row.getBigDecimal("om_receiveqty2") != null ? row.getBigDecimal("om_receiveqty2") : BigDecimal.ZERO;
                    invqty = row.getBigDecimal("om_invqty2") != null ? row.getBigDecimal("om_invqty2") : BigDecimal.ZERO;
                }
                map.put("omid", row.getLong("omid"));
                map.put("omentryid", row.getLong("omentryid"));
                map.put("om_billname", row.getString("om_billname"));
                map.put("om_billname.name", row.getString("om_billname.name"));
                map.put("om_billno", row.getString("om_billno"));
                map.put("om_billdate", row.getDate("om_billdate"));
                map.put("om_billstatus", row.get("om_billstatus"));
                map.put("om_transactiontype", row.get("om_transactiontype"));
                map.put("om_transactiontype.name", row.get("om_transactiontype.name"));
                map.put("om_transouttypeid", row.get("om_transouttypeid"));
                map.put("om_org", row.get("om_org"));
                map.put("om_org.name", row.get("om_org.name"));
                map.put("om_material", row.get("om_material"));
                map.put("om_material.number", row.get("om_material.number"));
                map.put("om_auxproperty", row.get("om_auxproperty"));
                map.put("om_unit", row.get("om_unit"));
                map.put("om_unit.name", row.get("om_unit.name"));
                map.put("om_qty", qty);
                map.put("om_planqty", planqty);
                map.put("om_planbegintime", row.getDate("om_planbegintime"));
                map.put("om_planendtime", row.getDate("om_planendtime"));
                map.put("om_deliverdate", row.get("om_deliverdate"));
                map.put("om_producedept", row.get("om_producedept"));
                map.put("om_producedept.name", row.get("om_producedept.name"));
                map.put("om_supplier", row.get("om_supplier"));
                map.put("om_supplier.name", row.get("om_supplier.name"));
                map.put("om_orderid", row.get("om_orderid"));
                map.put("om_pmbillno", row.get("om_pmbillno"));
                map.put("om_bom", row.get("om_bom"));
                map.put("om_bomid", row.get("om_bomid"));
                map.put("om_bomversionid", row.get("om_bomversionid"));
                map.put("om_bomversion", row.get("om_bomversion"));
                map.put("om_planstatus", row.getString("om_planstatus"));
                map.put("om_taskstatus", row.getString("om_taskstatus"));
                map.put("om_pickstatus", row.getString("om_pickstatus"));
                map.put("om_bizstatus", row.getString("om_bizstatus"));
                map.put("om_receiveqty", receiveqty);
                map.put("om_unreceiveqty", qty.subtract(receiveqty));
                map.put("om_invqty", invqty);
                map.put("om_uninvqty", qty.subtract(invqty));
                map.put("om_batchno", row.getString("om_batchno"));
                map.put("om_configuredcode", row.get("om_configuredcode"));
                map.put("om_configuredcode.number", row.get("om_configuredcode.number"));
                map.put("om_tracknumber", row.get("om_tracknumber"));
                map.put("om_tracknumber.number", row.get("om_tracknumber.number"));
                Date now = new Date();
                now = CpsTrackRptUtil.getCompDate(now);
                Date planendtime = row.getDate("om_planendtime");
                planendtime = CpsTrackRptUtil.getCompDate(planendtime);
                Date deliverdate = row.getDate("om_deliverdate");
                deliverdate = CpsTrackRptUtil.getCompDate(deliverdate);
                if (BILL_OM_MFTORDER.equals(billname) && planendtime != null && now.compareTo(planendtime) > 0 || BILL_PM_OM_PURORDERBILL.equals(billname) && deliverdate != null && now.compareTo(deliverdate) > 0) {
                    if (qty.compareTo(receiveqty) > 0 && qty.compareTo(invqty) > 0) {
                        map.put("om_excutexception", ResManager.loadKDString((String)"\u672a\u6309\u65f6\u5b8c\u5de5", (String)"CpsTrackOmMFTOrderRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    } else {
                        map.put("om_excutexception", "");
                    }
                } else {
                    map.put("om_excutexception", "");
                }
                Integer integer = row.getInteger("om_priority");
                if (integer == null) {
                    map.put("om_priority", 100);
                } else {
                    map.put("om_priority", integer);
                }
                map.put("om_cpqty", BigDecimal.ZERO);
                map.put("om_cpstatus", "");
                map.put("om_llc", 0);
                map.put("om_project", 0L);
                list.add(map);
            }
        }
        finally {
            dataSet.close();
        }
        return this.getReturnData(list);
    }

    private DataSet getReturnData(List<Map<String, Object>> list) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("omid", (DataType)DateType.LongType, true));
        fields.add(new Field("omentryid", (DataType)DateType.LongType, true));
        fields.add(new Field("om_billname", (DataType)DateType.StringType, true));
        fields.add(new Field("om_billname.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_billno", (DataType)DateType.StringType, true));
        fields.add(new Field("om_billdate", (DataType)DateType.DateType, true));
        fields.add(new Field("om_billstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("om_transactiontype", (DataType)DateType.LongType, true));
        fields.add(new Field("om_transactiontype.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_transouttypeid", (DataType)DateType.StringType, true));
        fields.add(new Field("om_supplier", (DataType)DateType.LongType, true));
        fields.add(new Field("om_supplier.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_orderid", (DataType)DateType.LongType, true));
        fields.add(new Field("om_pmbillno", (DataType)DateType.StringType, true));
        fields.add(new Field("om_org", (DataType)DateType.LongType, true));
        fields.add(new Field("om_org.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_material", (DataType)DateType.LongType, true));
        fields.add(new Field("om_material.number", (DataType)DateType.StringType, true));
        fields.add(new Field("om_auxproperty", (DataType)DateType.LongType, true));
        fields.add(new Field("om_unit", (DataType)DateType.LongType, true));
        fields.add(new Field("om_unit.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_qty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_planqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_planbegintime", (DataType)DateType.DateType, true));
        fields.add(new Field("om_planendtime", (DataType)DateType.DateType, true));
        fields.add(new Field("om_deliverdate", (DataType)DateType.DateType, true));
        fields.add(new Field("om_producedept", (DataType)DateType.LongType, true));
        fields.add(new Field("om_producedept.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_bom", (DataType)DateType.StringType, true));
        fields.add(new Field("om_bomid", (DataType)DateType.LongType, true));
        fields.add(new Field("om_bomversionid", (DataType)DateType.LongType, true));
        fields.add(new Field("om_bomversion", (DataType)DateType.StringType, true));
        fields.add(new Field("om_planstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("om_taskstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("om_pickstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("om_bizstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("om_receiveqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_unreceiveqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_invqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_uninvqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_batchno", (DataType)DateType.StringType, true));
        fields.add(new Field("om_configuredcode", (DataType)DateType.LongType, true));
        fields.add(new Field("om_configuredcode.number", (DataType)DateType.StringType, true));
        fields.add(new Field("om_tracknumber", (DataType)DateType.LongType, true));
        fields.add(new Field("om_tracknumber.number", (DataType)DateType.StringType, true));
        fields.add(new Field("om_project", (DataType)DateType.LongType, true));
        fields.add(new Field("om_project.name", (DataType)DateType.StringType, true));
        fields.add(new Field("om_excutexception", (DataType)DateType.StringType, true));
        fields.add(new Field("om_priority", (DataType)DateType.IntegerType, true));
        fields.add(new Field("om_cpqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("om_cpstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("om_llc", (DataType)DateType.IntegerType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map<String, Object> entry : list) {
            Object[] values = new Object[fields.size()];
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = entry.get(field[i].getName());
            }
            builder.append(values);
        }
        return builder.build();
    }

    private DataSet getAllData(List<QFilter> applyQfFilters, List<QFilter> omPurQfFilters, List<String> exprs, QFilter salorderFilter) {
        DataSet applydataSet = this.getOmMftOrderData(applyQfFilters, salorderFilter);
        DataSet purdataSet = this.getOmPurOrderData(omPurQfFilters, salorderFilter);
        DataSet dataSet = applydataSet.union(purdataSet);
        DataSet pmorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_PM_PURORDERBILL, "id pmid,billentry.id pmentryid,billno om_pmbillno,billentry.receiveqty om_receiveqty,billentry.invqty om_invqty ", null);
        dataSet = dataSet.join(pmorderRows, JoinType.LEFT).on("om_orderentryid", "pmentryid").on("om_orderid", "pmid").select(dataSet.getRowMeta().getFieldNames(), pmorderRows.getRowMeta().getFieldNames()).finish();
        for (String expr : exprs) {
            dataSet = dataSet.where(expr);
        }
        if (salorderFilter == null) {
            return dataSet;
        }
        DataSet planorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_MRP_PLANORDER, "to_char(id) planid,demandbillid,demandbillentryid", new QFilter[]{new QFilter("demandbillentity", "=", (Object)BILL_SM_SALORDER)});
        DataSet salorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_SM_SALORDER, "id smid, to_char(billentry.id) smentryid", new QFilter[]{salorderFilter});
        dataSet = dataSet.join(planorderRows, JoinType.INNER).on("om_sourceentryseq", "planid").select(dataSet.getRowMeta().getFieldNames(), planorderRows.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.join(salorderRows, JoinType.INNER).on("demandbillentryid", SMENTRYID).select(dataSet.getRowMeta().getFieldNames(), salorderRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }

    private DataSet getOmPurOrderData(List<QFilter> omPurQfFilters, QFilter qFilter) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_PM_OM_PURORDERBILL);
        StringBuilder sql = new StringBuilder();
        sql.append("id omid,");
        sql.append("billentry.id omentryid,");
        sql.append("'").append(BILL_PM_OM_PURORDERBILL).append("' om_billname,");
        sql.append("'").append(dataEntityType.getDisplayName().getLocaleValue()).append("' om_billname.name,");
        sql.append("billno om_billno,");
        sql.append("biztime om_billdate,");
        sql.append("billstatus om_billstatus,");
        sql.append("0 om_transactiontype,");
        sql.append("'' om_transactiontype.name,");
        sql.append("transouttypeid om_transouttypeid,");
        sql.append("org om_org,");
        sql.append("org.name om_org.name,");
        sql.append("supplier om_supplier,");
        sql.append("supplier.name om_supplier.name,");
        sql.append("billentry.material.masterid om_material,");
        sql.append("billentry.material.masterid.number om_material.number,");
        sql.append("billentry.auxpty om_auxproperty,");
        sql.append("billentry.unit om_unit,");
        sql.append("billentry.unit.name om_unit.name,");
        sql.append("billentry.baseqty om_baseqty,");
        sql.append("billentry.qty om_qty,");
        sql.append("0 om_planqty,");
        sql.append("null om_planbegintime,");
        sql.append("null om_planendtime,");
        sql.append("billentry.deliverdate om_deliverdate,");
        sql.append("0 om_producedept,");
        sql.append("'' om_producedept.name,");
        sql.append("0 om_orderid,");
        sql.append("0 om_orderentryid,");
        sql.append("billentry.bomid om_bomid,");
        sql.append("billentry.bomname om_bom,");
        sql.append("billentry.bomversion om_bomversionid,");
        sql.append("billentry.bomversionname om_bomversion,");
        sql.append("'' om_planstatus,");
        sql.append("'' om_taskstatus,");
        sql.append("billentry.pickstatus om_pickstatus,");
        sql.append("billentry.invqty om_invqty2,");
        sql.append("billentry.receiveqty om_receiveqty2,");
        sql.append("'' om_bizstatus,");
        sql.append("to_char(billentry.srcbillid) om_sourceentryseq,");
        sql.append("billentry.batchno om_batchno,");
        sql.append("billentry.configuredcode om_configuredcode,");
        sql.append("billentry.configuredcode.number om_configuredcode.number,");
        sql.append("billentry.tracknumber om_tracknumber,");
        sql.append("billentry.tracknumber.number om_tracknumber.number ");
        if (qFilter != null) {
            omPurQfFilters.add(new QFilter("billentry.srcbillentity", "=", (Object)BILL_MRP_PLANORDER));
        }
        omPurQfFilters.add(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        omPurQfFilters.add(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BILL_PM_OM_PURORDERBILL, (String)sql.toString(), (QFilter[])omPurQfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"om_billno"});
        DataSet priorityRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mrp_cps_priority", "orderid,orderentryid,billentity,priority om_priority", null);
        dataSet = dataSet.join(priorityRows, JoinType.LEFT).on("omid", "orderid").on("omentryid", "orderentryid").on("om_billname", "billentity").select(dataSet.getRowMeta().getFieldNames(), priorityRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }

    private DataSet getOmMftOrderData(List<QFilter> omMftQfFilters, QFilter qFilter) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_OM_MFTORDER);
        StringBuilder sql = new StringBuilder();
        sql.append("id omid,");
        sql.append("treeentryentity.id omentryid,");
        sql.append("'").append(BILL_OM_MFTORDER).append("' om_billname,");
        sql.append("'").append(dataEntityType.getDisplayName().getLocaleValue()).append("' om_billname.name,");
        sql.append("billno om_billno,");
        sql.append("billdate om_billdate,");
        sql.append("billstatus om_billstatus,");
        sql.append("transactiontype om_transactiontype,");
        sql.append("transactiontype.name om_transactiontype.name,");
        sql.append("'' om_transouttypeid,");
        sql.append("org om_org,");
        sql.append("org.name om_org.name,");
        sql.append("treeentryentity.supplier om_supplier,");
        sql.append("treeentryentity.supplier.name om_supplier.name,");
        sql.append("treeentryentity.material.masterid om_material,");
        sql.append("treeentryentity.material.masterid.number om_material.number,");
        sql.append("treeentryentity.auxproperty om_auxproperty,");
        sql.append("treeentryentity.unit om_unit,");
        sql.append("treeentryentity.unit.name om_unit.name,");
        sql.append("treeentryentity.baseqty om_baseqty,");
        sql.append("treeentryentity.qty om_qty,");
        sql.append("treeentryentity.planqty om_planqty,");
        sql.append("treeentryentity.planbegintime om_planbegintime,");
        sql.append("treeentryentity.planendtime om_planendtime,");
        sql.append("null om_deliverdate,");
        sql.append("treeentryentity.producedept om_producedept,");
        sql.append("treeentryentity.producedept.name om_producedept.name,");
        sql.append("treeentryentity.orderid om_orderid,");
        sql.append("treeentryentity.orderentryid om_orderentryid,");
        sql.append("treeentryentity.bomid om_bomid,");
        sql.append("treeentryentity.bomid.number om_bom,");
        sql.append("treeentryentity.bomid.version.id om_bomversionid,");
        sql.append("treeentryentity.bomid.version.name om_bomversion,");
        sql.append("treeentryentity.planstatus om_planstatus,");
        sql.append("treeentryentity.taskstatus om_taskstatus,");
        sql.append("treeentryentity.pickstatus om_pickstatus,");
        sql.append("0 om_invqty2,");
        sql.append("0 om_receiveqty2,");
        sql.append("treeentryentity.bizstatus om_bizstatus,");
        sql.append("treeentryentity.sourceentryseq om_sourceentryseq,");
        sql.append("treeentryentity.batchno om_batchno,");
        sql.append("treeentryentity.configuredcode om_configuredcode,");
        sql.append("treeentryentity.configuredcode.number om_configuredcode.number,");
        sql.append("treeentryentity.tracknumber om_tracknumber,");
        sql.append("treeentryentity.tracknumber.number om_tracknumber.number ");
        omMftQfFilters.add(new QFilter("treeentryentity.bizstatus", "!=", (Object)"C"));
        if (qFilter != null) {
            omMftQfFilters.add(new QFilter("treeentryentity.sourcebilltype", "=", (Object)BILL_MRP_PLANORDER));
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BILL_OM_MFTORDER, (String)sql.toString(), (QFilter[])omMftQfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"om_billno"});
        DataSet priorityRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mrp_cps_priority", "orderid,orderentryid,billentity,priority om_priority", null);
        dataSet = dataSet.join(priorityRows, JoinType.LEFT).on("omid", "orderid").on("omentryid", "orderentryid").on("om_billname", "billentity").select(dataSet.getRowMeta().getFieldNames(), priorityRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }
}

