/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.cpstrack.CpsTrackRptUtil;

public class CpsTrackPmOrderRptQuery
extends AbstractReportListDataPlugin {
    private static final String BILL_PM_PURORDERBILL = "pm_purorderbill";
    private static final String BILL_PM_PURAPPLYBILL = "pm_purapplybill";
    private static final String BILL_MRP_PLANORDER = "mrp_planorder";
    private static final String BILL_SM_SALORDER = "sm_salorder";
    private static final String SMENTRYID = "smentryid";
    private static final String BILL_PM_ = "pm_";
    private static final Log logger = LogFactory.getLog(CpsTrackPmOrderRptQuery.class);

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        long starttime = System.currentTimeMillis();
        Map customParam = param.getCustomParam();
        ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(customParam.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_PM_PURAPPLYBILL);
        FilterInfo filter = param.getFilter();
        QFilter salorderFilter = null;
        if (customParam.get(SMENTRYID) != null) {
            List ids = (List)customParam.get(SMENTRYID);
            salorderFilter = new QFilter("billentry.id", "in", (Object)ids);
        }
        List qFilters = filter.getQFilters();
        ArrayList<String> exprs = new ArrayList<String>(qFilters.size());
        ArrayList<String> wheres = new ArrayList<String>(qFilters.size());
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (!property.startsWith(BILL_PM_)) {
                iterator.remove();
                continue;
            }
            this.analysisDealQFilter(qFilter, exprs, dataEntityType, wheres);
            CpsTrackRptUtil.setProperty(qFilter, dataEntityType, BILL_PM_);
            List list = qFilter.getNests(true);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                QFilter.QFilterNest qFilterNest = (QFilter.QFilterNest)iterator2.next();
                QFilter qf = qFilterNest.getFilter();
                this.analysisDealQFilter(qf, exprs, dataEntityType, wheres);
                CpsTrackRptUtil.setProperty(qf, dataEntityType, BILL_PM_);
            }
        }
        qfFilters.addAll(qFilters);
        DataSet allData = this.getAllData(qfFilters, qfFilters, exprs, salorderFilter);
        DataSet dealData = this.dealData(allData);
        for (String expr : wheres) {
            dealData = dealData.where(expr);
        }
        long endtime = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u91c7\u8d2d\u5355\u636e\u8017\u65f6" + (endtime - starttime) + "ms");
        return CpsTrackRptUtil.sortAndFilter(param, dealData, "mrp_cps_tracks", BILL_PM_PURAPPLYBILL);
    }

    private void analysisDealQFilter(QFilter qFilter, List<String> exprs, MainEntityType dataEntityType, List<String> whereFilters) {
        CpsTrackRptUtil.setWhereFilter(qFilter, BILL_PM_, whereFilters, dataEntityType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet dealData(DataSet dataSet) {
        final LinkedHashMap maps = new LinkedHashMap();
        ArrayList<Long> ids = new ArrayList<Long>();
        try {
            while (dataSet.hasNext()) {
                Integer integer;
                Row row = dataSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>(28);
                BigDecimal applyqty = row.getBigDecimal("pm_applyqty") != null ? row.getBigDecimal("pm_applyqty") : BigDecimal.ZERO;
                BigDecimal qty = row.getBigDecimal("pm_qty") != null ? row.getBigDecimal("pm_qty") : BigDecimal.ZERO;
                BigDecimal joinqty = row.getBigDecimal("pm_joinqty") != null ? row.getBigDecimal("pm_joinqty") : BigDecimal.ZERO;
                BigDecimal receiveqty = row.getBigDecimal("pm_receiveqty") != null ? row.getBigDecimal("pm_receiveqty") : BigDecimal.ZERO;
                BigDecimal orderqty = row.getBigDecimal("pm_orderqty") != null ? row.getBigDecimal("pm_orderqty") : BigDecimal.ZERO;
                String billname = row.getString("pm_billname");
                Long pmentryid = row.getLong("pmentryid");
                map.put("pmid", row.getLong("pmid"));
                map.put("pmentryid", pmentryid);
                map.put("pm_billname", billname);
                map.put("pm_billname.name", row.getString("pm_billname.name"));
                map.put("pm_billno", row.getString("pm_billno"));
                map.put("pm_billtype", row.getString("pm_billtype"));
                map.put("pm_billtype.name", row.getString("pm_billtype.name"));
                map.put("pm_biztype", row.get("pm_biztype"));
                map.put("pm_biztype.name", row.get("pm_biztype.name"));
                map.put("pm_biztime", row.getDate("pm_biztime"));
                map.put("pm_billstatus", row.getString("pm_billstatus"));
                map.put("pm_org", row.get("pm_org"));
                map.put("pm_org.name", row.getString("pm_org.name"));
                map.put("pm_dept", row.get("pm_dept"));
                map.put("pm_dept.name", row.getString("pm_dept.name"));
                map.put("pm_bizuser", row.getLong("pm_bizuser"));
                map.put("pm_bizuser.name", row.getString("pm_bizuser.name"));
                map.put("pm_supplier", row.getLong("pm_supplier"));
                map.put("pm_supplier.name", row.getString("pm_supplier.name"));
                map.put("pm_entryreqorg", row.getLong("pm_entryreqorg"));
                map.put("pm_entryreqorg.name", row.getString("pm_entryreqorg.name"));
                map.put("pm_entryrecorg", row.getLong("pm_entryrecorg"));
                map.put("pm_entryrecorg.name", row.getString("pm_entryrecorg.name"));
                map.put("pm_ownertype", row.getString("pm_ownertype"));
                map.put("pm_owner", row.get("pm_owner"));
                map.put("pm_owner.name", row.getString("pm_owner.name"));
                map.put("pm_material", row.getLong("pm_material"));
                map.put("pm_material.number", row.getString("pm_material.number"));
                map.put("pm_auxpty", row.getLong("pm_auxpty"));
                map.put("pm_unit", row.getLong("pm_unit"));
                map.put("pm_unit.name", row.getString("pm_unit.name"));
                map.put("pm_applyqty", applyqty);
                map.put("pm_qty", qty);
                map.put("pm_joinqty", joinqty);
                map.put("pm_reqdate", row.getDate("pm_reqdate"));
                map.put("pm_receiveqty", receiveqty);
                map.put("pm_orderqty", orderqty);
                if (BILL_PM_PURAPPLYBILL.equals(billname)) {
                    map.put("pm_unorderqty", qty.subtract(orderqty));
                } else if (BILL_PM_PURORDERBILL.equals(billname)) {
                    map.put("pm_unorderqty", joinqty.subtract(orderqty));
                    ids.add(pmentryid);
                }
                map.put("pm_project", row.getLong("pm_project"));
                map.put("pm_project.name", row.getString("pm_project.name"));
                map.put("pm_configuredcode", row.getLong("pm_configuredcode"));
                map.put("pm_configuredcode.number", row.getString("pm_configuredcode.number"));
                map.put("pm_tracknumber", row.getLong("pm_tracknumber"));
                map.put("pm_tracknumber.number", row.getString("pm_tracknumber.number"));
                Date now = new Date();
                now = CpsTrackRptUtil.getCompDate(now);
                Date reqdate = row.getDate("pm_reqdate");
                reqdate = CpsTrackRptUtil.getCompDate(reqdate);
                if (BILL_PM_PURAPPLYBILL.equals(billname)) {
                    if (reqdate != null && now.compareTo(reqdate) > 0 && qty.compareTo(orderqty) > 0) {
                        map.put("pm_excutexception", ResManager.loadKDString((String)"\u672a\u5b8c\u5168\u91c7\u8d2d", (String)"CpsTrackPmOrderRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                } else if (BILL_PM_PURORDERBILL.equals(billname) && reqdate != null && now.compareTo(reqdate) > 0 && joinqty.compareTo(orderqty) > 0) {
                    map.put("pm_excutexception", ResManager.loadKDString((String)"\u672a\u5b8c\u5168\u5230\u8d27", (String)"CpsTrackPmOrderRptQuery_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                }
                if ((integer = row.getInteger("pm_priority")) == null) {
                    map.put("pm_priority", 100);
                } else {
                    map.put("pm_priority", integer);
                }
                maps.put(pmentryid, map);
            }
        }
        finally {
            dataSet.close();
        }
        StringBuilder sql = new StringBuilder("select fentryid, FDetailID from t_pm_purorderdeliverentry where fentryid in (?");
        for (int i = 1; i < ids.size(); ++i) {
            sql.append(", ?");
        }
        sql.append(")");
        if (!ids.isEmpty()) {
            DB.query((DBRoute)new DBRoute("scm"), (String)sql.toString(), (Object[])ids.toArray(), (ResultSetHandler)new ResultSetHandler<String>(){

                public String handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        Long id = rs.getLong("fentryid");
                        Map map = (Map)maps.get(id);
                        map.put("pm_deliveryschedule", ResManager.loadKDString((String)"\u5df2\u7ef4\u62a4", (String)"CpsTrackPmOrderRptQuery_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                    return "";
                }
            });
        }
        return this.getReturnData(maps.values());
    }

    private DataSet getReturnData(Collection<Map<String, Object>> collection) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("pmid", (DataType)DateType.LongType, true));
        fields.add(new Field("pmentryid", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_billname", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_billname.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_billno", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_billtype", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_billtype.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_biztype", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_biztype.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_biztime", (DataType)DateType.DateType, true));
        fields.add(new Field("pm_billstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_org", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_org.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_dept", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_dept.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_bizuser", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_bizuser.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_supplier", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_supplier.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_entryreqorg", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_entryreqorg.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_entryrecorg", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_entryrecorg.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_ownertype", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_owner", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_owner.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_material", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_material.number", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_auxpty", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_unit", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_unit.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_applyqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pm_qty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pm_joinqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pm_reqdate", (DataType)DateType.DateType, true));
        fields.add(new Field("pm_receiveqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pm_orderqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pm_unorderqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("pm_excutexception", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_project", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_project.name", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_deliveryschedule", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_tracknumber", (DataType)DateType.LongType, true));
        fields.add(new Field("pm_tracknumber.number", (DataType)DateType.StringType, true));
        fields.add(new Field("pm_priority", (DataType)DateType.IntegerType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map<String, Object> entry : collection) {
            Object[] values = new Object[fields.size()];
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = entry.get(field[i].getName());
            }
            builder.append(values);
        }
        return builder.build();
    }

    private DataSet getAllData(List<QFilter> applyQfFilters, List<QFilter> purQfFilters, List<String> exprs, QFilter salorderFilter) {
        DataSet applydataSet = this.getApplyOrderData(applyQfFilters);
        DataSet purdataSet = this.getpurOrderData(purQfFilters);
        DataSet dataSet = applydataSet.union(purdataSet);
        for (String expr : exprs) {
            dataSet = dataSet.where(expr);
        }
        if (salorderFilter == null) {
            return dataSet;
        }
        dataSet = dataSet.addField("pm_srcbillid", "srcbillid");
        DataSet applyorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_PM_PURAPPLYBILL, "billentry.id pmapplyid, billentry.srcbillentryid smentryid,billentry.srcbillid srcbillid", null);
        DataSet pur = purdataSet.join(applyorderRows, JoinType.INNER).on("pm_srcbillentryid", "pmapplyid").select(purdataSet.getRowMeta().getFieldNames(), new String[]{"srcbillid"}).finish();
        dataSet = dataSet.union(pur);
        DataSet planorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_MRP_PLANORDER, "id planid,demandbillid,demandbillentryid", new QFilter[]{new QFilter("demandbillentity", "=", (Object)BILL_SM_SALORDER)});
        DataSet salorderRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), BILL_SM_SALORDER, "id smid, to_char(billentry.id) smentryid", new QFilter[]{salorderFilter});
        dataSet = dataSet.join(planorderRows, JoinType.INNER).on("srcbillid", "planid").select(dataSet.getRowMeta().getFieldNames(), planorderRows.getRowMeta().getFieldNames()).finish();
        dataSet = dataSet.join(salorderRows, JoinType.INNER).on("demandbillentryid", SMENTRYID).select(dataSet.getRowMeta().getFieldNames(), salorderRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }

    private DataSet getpurOrderData(List<QFilter> purQfFilters) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_PM_PURORDERBILL);
        StringBuilder sql = new StringBuilder();
        sql.append("id pmid,");
        sql.append("'").append(BILL_PM_PURORDERBILL).append("' pm_billname,");
        sql.append("'").append(dataEntityType.getDisplayName().getLocaleValue()).append("' pm_billname.name,");
        sql.append("billno pm_billno,");
        sql.append("billtype pm_billtype,");
        sql.append("billtype.name pm_billtype.name,");
        sql.append("biztype pm_biztype,");
        sql.append("biztype.name pm_biztype.name,");
        sql.append("billstatus pm_billstatus,");
        sql.append("biztime pm_biztime,");
        sql.append("org pm_org,");
        sql.append("org.name pm_org.name,");
        sql.append("dept pm_dept,");
        sql.append("dept.name pm_dept.name,");
        sql.append("operator.operatorid pm_bizuser,");
        sql.append("operator.operatorid.name pm_bizuser.name,");
        sql.append("supplier pm_supplier,");
        sql.append("supplier.name pm_supplier.name,");
        sql.append("billentry.entryreqorg pm_entryreqorg,");
        sql.append("billentry.entryreqorg.name pm_entryreqorg.name,");
        sql.append("billentry.entryrecorg pm_entryrecorg,");
        sql.append("billentry.entryrecorg.name pm_entryrecorg.name,");
        sql.append("billentry.srcbillid pm_srcbillid,");
        sql.append("billentry.ownertype pm_ownertype,");
        sql.append("billentry.owner pm_owner,");
        sql.append("billentry.owner.name pm_owner.name,");
        sql.append("billentry.material.masterid pm_material,");
        sql.append("billentry.material.masterid.number pm_material.number,");
        sql.append("billentry.auxpty pm_auxpty,");
        sql.append("billentry.id pmentryid,");
        sql.append("billentry.unit pm_unit,");
        sql.append("billentry.unit.name pm_unit.name,");
        sql.append("0 pm_applyqty,");
        sql.append("0 pm_qty,");
        sql.append("billentry.qty pm_joinqty,");
        sql.append("billentry.deliverdate pm_reqdate,");
        sql.append("billentry.receiveqty pm_receiveqty,");
        sql.append("(billentry.invqty-billentry.returnqty) pm_orderqty,");
        sql.append("billentry.project pm_project,");
        sql.append("billentry.project.name pm_project.name,");
        sql.append("billentry.configuredcode pm_configuredcode,");
        sql.append("billentry.configuredcode.number pm_configuredcode.number,");
        sql.append("billentry.tracknumber pm_tracknumber,");
        sql.append("billentry.tracknumber.number pm_tracknumber.number,");
        sql.append("billentry.srcbillentryid pm_srcbillentryid");
        purQfFilters.add(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        purQfFilters.add(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BILL_PM_PURORDERBILL, (String)sql.toString(), (QFilter[])purQfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"pm_billno"});
        DataSet priorityRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mrp_cps_priority", "orderid,orderentryid,billentity,priority pm_priority", null);
        dataSet = dataSet.join(priorityRows, JoinType.LEFT).on("pmid", "orderid").on("pmentryid", "orderentryid").on("pm_billname", "billentity").select(dataSet.getRowMeta().getFieldNames(), priorityRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }

    private DataSet getApplyOrderData(List<QFilter> applyQfFilters) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_PM_PURAPPLYBILL);
        StringBuilder sql = new StringBuilder();
        sql.append("id pmid,");
        sql.append("'").append(BILL_PM_PURAPPLYBILL).append("' pm_billname,");
        sql.append("'").append(dataEntityType.getDisplayName().getLocaleValue()).append("' pm_billname.name,");
        sql.append("billno pm_billno,");
        sql.append("billtype pm_billtype,");
        sql.append("billtype.name pm_billtype.name,");
        sql.append("biztype pm_biztype,");
        sql.append("biztype.name pm_biztype.name,");
        sql.append("billstatus pm_billstatus,");
        sql.append("biztime pm_biztime,");
        sql.append("org pm_org,");
        sql.append("org.name pm_org.name,");
        sql.append("dept pm_dept,");
        sql.append("dept.name pm_dept.name,");
        sql.append("bizuser pm_bizuser,");
        sql.append("bizuser.name pm_bizuser.name,");
        sql.append("billentry.supplier pm_supplier,");
        sql.append("billentry.supplier.name pm_supplier.name,");
        sql.append("billentry.entryreqorg pm_entryreqorg,");
        sql.append("billentry.entryreqorg.name pm_entryreqorg.name,");
        sql.append("billentry.entryrecorg pm_entryrecorg,");
        sql.append("billentry.entryrecorg.name pm_entryrecorg.name,");
        sql.append("billentry.srcbillid pm_srcbillid,");
        sql.append("'' pm_ownertype,");
        sql.append("0L pm_owner,");
        sql.append("'' pm_owner.name,");
        sql.append("billentry.material.masterid pm_material,");
        sql.append("billentry.material.masterid.number pm_material.number,");
        sql.append("billentry.auxpty pm_auxpty,");
        sql.append("billentry.id pmentryid,");
        sql.append("billentry.unit pm_unit,");
        sql.append("billentry.unit.name pm_unit.name,");
        sql.append("billentry.applyqty pm_applyqty,");
        sql.append("billentry.qty pm_qty,");
        sql.append("billentry.joinqty pm_joinqty,");
        sql.append("billentry.reqdate pm_reqdate,");
        sql.append("0 pm_receiveqty,");
        sql.append("billentry.joinqty pm_orderqty,");
        sql.append("billentry.project pm_project,");
        sql.append("billentry.project.name pm_project.name,");
        sql.append("billentry.configuredcode pm_configuredcode,");
        sql.append("billentry.configuredcode.number pm_configuredcode.number,");
        sql.append("billentry.tracknumber pm_tracknumber,");
        sql.append("billentry.tracknumber.number pm_tracknumber.number,");
        sql.append("billentry.srcbillentryid pm_srcbillentryid");
        applyQfFilters.add(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        applyQfFilters.add(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BILL_PM_PURAPPLYBILL, (String)sql.toString(), (QFilter[])applyQfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"pm_billno"});
        DataSet priorityRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mrp_cps_priority", "orderid,orderentryid,billentity,priority pm_priority", null);
        dataSet = dataSet.join(priorityRows, JoinType.LEFT).on("pmid", "orderid").on("pmentryid", "orderentryid").on("pm_billname", "billentity").select(dataSet.getRowMeta().getFieldNames(), priorityRows.getRowMeta().getFieldNames()).finish();
        return dataSet;
    }
}

