/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.cpstrack;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.cpstrack.CpsTrackRptUtil;

public class CpsTrackRptQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(CpsTrackRptQuery.class);
    private static final String BILL_SM_SALORDER = "sm_salorder";
    private static final String SHIPMENTSTATUS = "sm_shipmentstatus";
    private static final String OUTBOUNDSTATUS = "sm_outboundstatus";
    private static final String BILL_SM_ = "sm_";

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        Map customParam = param.getCustomParam();
        long starttime = System.currentTimeMillis();
        ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(customParam.size());
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)BILL_SM_SALORDER);
        FilterInfo filter = param.getFilter();
        List qFilters = filter.getQFilters();
        if (qFilters.isEmpty()) {
            List filterItems = filter.getFilterItems();
            Iterator it = filterItems.iterator();
            while (it.hasNext()) {
                FilterItemInfo filterItemInfo = (FilterItemInfo)it.next();
                String propName = filterItemInfo.getPropName();
                if (!propName.startsWith(BILL_SM_)) {
                    it.remove();
                    continue;
                }
                Object value = filterItemInfo.getValue();
                String compareType = filterItemInfo.getCompareType();
                qFilters.add(new QFilter(propName, compareType, value));
            }
        }
        ArrayList<String> exprs = new ArrayList<String>(qFilters.size());
        ArrayList<String> wheres = new ArrayList<String>(qFilters.size());
        Iterator iterator = qFilters.iterator();
        while (iterator.hasNext()) {
            QFilter qFilter = (QFilter)iterator.next();
            String property = qFilter.getProperty();
            if (!property.startsWith(BILL_SM_)) {
                iterator.remove();
                continue;
            }
            this.analysisDealQFilter(qFilter, exprs, dataEntityType, wheres);
            CpsTrackRptUtil.setProperty(qFilter, dataEntityType, BILL_SM_);
            List list = qFilter.getNests(true);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                QFilter.QFilterNest qFilterNest = (QFilter.QFilterNest)iterator2.next();
                QFilter qf = qFilterNest.getFilter();
                this.analysisDealQFilter(qf, exprs, dataEntityType, wheres);
                CpsTrackRptUtil.setProperty(qf, dataEntityType, BILL_SM_);
            }
        }
        qfFilters.addAll(qFilters);
        DataSet allData = this.getAllData(qfFilters, exprs);
        DataSet dealData = this.dealData(allData);
        for (String expr : wheres) {
            dealData = dealData.where(expr);
        }
        long endtime = System.currentTimeMillis();
        logger.info("\u67e5\u8be2\u9500\u552e\u8ba2\u5355\u8017\u65f6" + (endtime - starttime) + "ms");
        return CpsTrackRptUtil.sortAndFilter(param, dealData, "mrp_cps_tracks", BILL_SM_SALORDER);
    }

    private void analysisDealQFilter(QFilter qFilter, List<String> exprs, MainEntityType dataEntityType, List<String> whereFilters) {
        String property = qFilter.getProperty();
        Object value = qFilter.getValue();
        switch (property) {
            case "sm_shipmentstatus": {
                if (StringUtils.isBlank((Object)value)) {
                    qFilter.__setProperty("1");
                    qFilter.__setCP("=");
                    qFilter.__setValue((Object)1);
                    break;
                }
                if ("0".equals(value.toString())) {
                    qFilter.__setProperty("deliqty");
                    qFilter.__setCP("=");
                    qFilter.__setValue((Object)BigDecimal.ZERO);
                    break;
                }
                if ("1".equals(value.toString())) {
                    qFilter.__setProperty("deliqty");
                    qFilter.__setCP(">");
                    qFilter.__setValue((Object)BigDecimal.ZERO);
                    exprs.add("sm_deliqty < sm_qty");
                    break;
                }
                if (!"2".equals(value.toString())) break;
                qFilter.__setProperty("1");
                qFilter.__setCP("=");
                qFilter.__setValue((Object)1);
                exprs.add("sm_deliqty = sm_qty");
                break;
            }
            case "sm_outboundstatus": {
                if (StringUtils.isBlank((Object)value)) {
                    qFilter.__setProperty("1");
                    qFilter.__setCP("=");
                    qFilter.__setValue((Object)1);
                    break;
                }
                if ("0".equals(value.toString())) {
                    qFilter.__setProperty("invqty");
                    qFilter.__setCP("=");
                    qFilter.__setValue((Object)BigDecimal.ZERO);
                    break;
                }
                if ("1".equals(value.toString())) {
                    qFilter.__setProperty("invqty");
                    qFilter.__setCP(">");
                    qFilter.__setValue((Object)BigDecimal.ZERO);
                    exprs.add("sm_invqty < sm_qty");
                    break;
                }
                if ("2".equals(value.toString())) {
                    qFilter.__setProperty("1");
                    qFilter.__setCP("=");
                    qFilter.__setValue((Object)1);
                    exprs.add("sm_invqty = sm_qty");
                    break;
                }
                if (!"3".equals(value.toString())) break;
                qFilter.__setProperty("invqty");
                qFilter.__setCP(">");
                qFilter.__setValue((Object)BigDecimal.ZERO);
                qFilter.and(new QFilter("deliverydate", "<", (Object)new Date()));
                exprs.add("sm_invqty < sm_qty");
                break;
            }
            default: {
                CpsTrackRptUtil.setWhereFilter(qFilter, BILL_SM_, whereFilters, dataEntityType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet dealData(DataSet dataSet) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        try {
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                HashMap<String, Object> map = new HashMap<String, Object>(28);
                BigDecimal qty = row.getBigDecimal("sm_qty") != null ? row.getBigDecimal("sm_qty") : BigDecimal.ZERO;
                BigDecimal deliqty = row.getBigDecimal("sm_deliqty") != null ? row.getBigDecimal("sm_deliqty") : BigDecimal.ZERO;
                BigDecimal invqty = row.getBigDecimal("sm_invqty") != null ? row.getBigDecimal("sm_invqty") : BigDecimal.ZERO;
                map.put("smid", row.getLong("smid"));
                map.put("smentryid", row.getLong("smentryid"));
                map.put("sm_billno", row.getString("sm_billno"));
                map.put("sm_billtype", row.getString("sm_billtype"));
                map.put("sm_billtype.name", row.getString("sm_billtype.name"));
                map.put("sm_biztype", row.get("sm_biztype"));
                map.put("sm_biztype.name", row.get("sm_biztype.name"));
                map.put("sm_bizdate", row.getDate("sm_bizdate"));
                map.put("sm_billstatus", row.getString("sm_billstatus"));
                map.put("sm_org", row.get("sm_org"));
                map.put("sm_org.name", row.get("sm_org.name"));
                map.put("sm_dept", row.get("sm_dept"));
                map.put("sm_dept.name", row.get("sm_dept.name"));
                map.put("sm_customer", row.get("sm_customer"));
                map.put("sm_customer.name", row.get("sm_customer.name"));
                map.put("sm_material", row.get("sm_material"));
                map.put("sm_material.number", row.get("sm_material.number"));
                map.put("sm_auxpty", row.get("sm_auxpty"));
                map.put("sm_unit", row.get("sm_unit"));
                map.put("sm_unit.name", row.get("sm_unit.name"));
                map.put("sm_qty", qty);
                map.put("sm_deliverydate", row.getDate("sm_deliverydate"));
                map.put("sm_deliqty", deliqty);
                map.put("sm_undeliqty", qty.subtract(deliqty));
                map.put("sm_invqty", invqty);
                map.put("sm_uninvqty", qty.subtract(invqty));
                Date now = new Date();
                now = CpsTrackRptUtil.getCompDate(now);
                if (map.get("sm_orderdeliverentry") == null) {
                    Date deliverydate = row.getDate("sm_deliverydate");
                    if ((deliverydate = CpsTrackRptUtil.getCompDate(deliverydate)) != null && now.compareTo(deliverydate) > 0 && qty.subtract(invqty).compareTo(BigDecimal.ZERO) > 0) {
                        map.put("sm_excutexception", ResManager.loadKDString((String)"\u672a\u5b8c\u5168\u51fa\u5e93", (String)"CpsTrackRptQuery_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    } else {
                        map.put("sm_excutexception", "");
                    }
                }
                map.put("sm_e_stockorg", row.get("sm_e_stockorg"));
                map.put("sm_e_stockorg.name", row.get("sm_e_stockorg.name"));
                map.put("sm_ownertype", row.getString("sm_ownertype"));
                map.put("sm_owner", row.get("sm_owner"));
                map.put("sm_owner.name", row.get("sm_owner.name"));
                map.put("sm_lotnumber", row.getString("sm_lotnumber"));
                map.put("sm_project", row.get("sm_project"));
                map.put("sm_project.name", row.get("sm_project.name"));
                map.put("sm_configuredcode", row.get("sm_configuredcode"));
                map.put("sm_configuredcode.number", row.get("sm_configuredcode.number"));
                map.put("sm_tracknumber", row.get("sm_tracknumber"));
                map.put("sm_tracknumber.number", row.get("sm_tracknumber.number"));
                map.put("sm_d_plandate", row.getDate("sm_d_plandate"));
                map.put("sm_d_plandeliverydate", row.getDate("sm_d_plandeliverydate"));
                map.put("sm_d_planqty", row.getBigDecimal("sm_d_planqty"));
                Integer integer = row.getInteger("sm_priority");
                if (integer == null) {
                    map.put("sm_priority", 100);
                } else {
                    map.put("sm_priority", integer);
                }
                list.add(map);
            }
        }
        finally {
            dataSet.close();
        }
        return this.getReturnData(list);
    }

    private DataSet getReturnData(List<Map<String, Object>> list) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("smid", (DataType)DateType.LongType, true));
        fields.add(new Field("smentryid", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_billno", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_billtype", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_billtype.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_biztype", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_biztype.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_bizdate", (DataType)DateType.DateType, true));
        fields.add(new Field("sm_billstatus", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_org", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_org.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_dept", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_dept.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_customer", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_customer.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_material", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_material.number", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_auxpty", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_unit", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_unit.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_qty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("sm_deliverydate", (DataType)DateType.DateType, true));
        fields.add(new Field("sm_deliqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("sm_undeliqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("sm_invqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("sm_uninvqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("sm_e_stockorg", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_e_stockorg.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_excutexception", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_ownertype", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_owner", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_owner.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_lotnumber", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_project", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_project.name", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_configuredcode", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_configuredcode.number", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_tracknumber", (DataType)DateType.LongType, true));
        fields.add(new Field("sm_tracknumber.number", (DataType)DateType.StringType, true));
        fields.add(new Field("sm_d_plandate", (DataType)DateType.DateType, true));
        fields.add(new Field("sm_d_plandeliverydate", (DataType)DateType.DateType, true));
        fields.add(new Field("sm_d_planqty", (DataType)DateType.BigDecimalType, true));
        fields.add(new Field("sm_priority", (DataType)DateType.IntegerType, true));
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (Map<String, Object> entry : list) {
            Object[] values = new Object[fields.size()];
            Field[] field = metas.getFields();
            for (int i = 0; i < field.length; ++i) {
                values[i] = entry.get(field[i].getName());
            }
            builder.append(values);
        }
        return builder.build();
    }

    private DataSet getAllData(List<QFilter> qfFilters, List<String> exprs) {
        StringBuilder sql = new StringBuilder();
        sql.append("id smid,");
        sql.append("billno sm_billno,");
        sql.append("'").append(BILL_SM_SALORDER).append("' sm_billname,");
        sql.append("billtype sm_billtype,");
        sql.append("billtype.name sm_billtype.name,");
        sql.append("biztype sm_biztype,");
        sql.append("biztype.name sm_biztype.name,");
        sql.append("bizdate sm_bizdate,");
        sql.append("billstatus sm_billstatus,");
        sql.append("org sm_org,");
        sql.append("org.name sm_org.name,");
        sql.append("dept sm_dept,");
        sql.append("dept.name sm_dept.name,");
        sql.append("customer sm_customer,");
        sql.append("customer.name sm_customer.name,");
        sql.append("billentry.material.masterid sm_material,");
        sql.append("billentry.material.masterid.number sm_material.number,");
        sql.append("billentry.auxpty sm_auxpty,");
        sql.append("billentry.id smentryid,");
        sql.append("billentry.unit sm_unit,");
        sql.append("billentry.unit.name sm_unit.name,");
        sql.append("billentry.qty sm_qty,");
        sql.append("billentry.deliverydate sm_deliverydate,");
        sql.append("billentry.deliqty sm_deliqty,");
        sql.append("billentry.invqty sm_invqty,");
        sql.append("billentry.e_stockorg sm_e_stockorg,");
        sql.append("billentry.e_stockorg.name sm_e_stockorg.name,");
        sql.append("billentry.ownertype sm_ownertype,");
        sql.append("billentry.owner sm_owner,");
        sql.append("billentry.owner.name sm_owner.name,");
        sql.append("billentry.lotnumber sm_lotnumber,");
        sql.append("billentry.project sm_project,");
        sql.append("billentry.project.name sm_project.name,");
        sql.append("billentry.configuredcode sm_configuredcode,");
        sql.append("billentry.configuredcode.number sm_configuredcode.number,");
        sql.append("billentry.tracknumber sm_tracknumber,");
        sql.append("billentry.tracknumber.number sm_tracknumber.number,");
        sql.append("billentry.orderdeliverentry sm_orderdeliverentry,");
        sql.append("billentry.orderdeliverentry.d_plandate sm_d_plandate,");
        sql.append("billentry.orderdeliverentry.d_plandeliverydate sm_d_plandeliverydate,");
        sql.append("billentry.orderdeliverentry.d_planqty sm_d_planqty");
        qfFilters.add(new QFilter("billentry.rowclosestatus", "=", (Object)"A"));
        qfFilters.add(new QFilter("billentry.rowterminatestatus", "=", (Object)"A"));
        qfFilters.add(new QFilter("isvirtualbill", "=", (Object)"0"));
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)BILL_SM_SALORDER, (String)sql.toString(), (QFilter[])qfFilters.toArray(new QFilter[0]), null).orderBy(new String[]{"sm_billno"});
        DataSet priorityRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "mrp_cps_priority", "orderid,orderentryid,billentity,priority sm_priority", null);
        dataSet = dataSet.join(priorityRows, JoinType.LEFT).on("smid", "orderid").on("smentryid", "orderentryid").on("sm_billname", "billentity").select(dataSet.getRowMeta().getFieldNames(), priorityRows.getRowMeta().getFieldNames()).finish();
        for (String expr : exprs) {
            dataSet = dataSet.where(expr);
        }
        return dataSet;
    }
}

