/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.gross;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.entity.gross.MaterialInfo;
import kd.mmc.mrp.common.entity.gross.RequireTypeSummaryEntity2;
import kd.mmc.mrp.common.util.FilePermissionUtil;
import kd.mmc.mrp.report.util.ReportUtil;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class GrossDemandAllExport
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(GrossDemandAllExport.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private String targetEntity;
    private static final String COUNT = "count";
    private static final String SUM = "sum";

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(String targetEntity) {
        this.targetEntity = targetEntity;
    }

    private String getTip() {
        String tip = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6295\u653e%1$d/%2$d\u6761", (String)"GrossDemandAllExport_0", (String)"mmc-mrp-report", (Object[])new Object[0]), this.getCount(), this.getSum());
        return tip;
    }

    private int getProgress() {
        int sum;
        int count = StringUtils.isBlank((Object)this.getCount()) ? 0 : this.getCount();
        int n = sum = StringUtils.isBlank((Object)this.getSum()) ? 0 : this.getSum();
        if (sum == 0) {
            return 0;
        }
        return count * 100 / sum;
    }

    private synchronized void setCount(int dropcount) {
        int olddropcount = this.getCount();
        int oldcount = StringUtils.isBlank((Object)olddropcount) ? 0 : olddropcount;
        this.getPageCache().put(COUNT, String.valueOf(oldcount + dropcount));
    }

    private synchronized int getCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(COUNT));
    }

    private void setSum(int sum) {
        this.getPageCache().put(SUM, String.valueOf(sum));
    }

    private int getSum() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(SUM)) ? 0 : Integer.parseInt(this.getPageCache().get(SUM));
    }

    private void settaskid(String taskid) {
        this.getPageCache().put("taskid", taskid);
    }

    private String gettaskid() {
        return this.getPageCache().get("taskid");
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        this.settaskid("-1");
        progressBar.start();
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        Label lblTip;
        int progress = this.getProgress();
        if (progress == 0) {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(ResManager.loadKDString((String)"\u51c6\u5907\u5bfc\u51fa...", (String)"GrossDemandAllExport_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
            paramProgressEvent.setProgress(0);
            logger.info("\u6bdb\u9700\u6c42\u7236\u9879\u5bfc\u51fa");
        } else {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(this.getTip());
            paramProgressEvent.setProgress(this.getProgress());
        }
        if ("0".equals(this.gettaskid())) {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.stop();
            this.getView().close();
            return;
        }
        if ("-1".equals(this.gettaskid())) {
            try {
                this.settaskid("-2");
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                Object id = formShowParameter.getCustomParam("id");
                Object type = formShowParameter.getCustomParam("radiogroupfield");
                this.getAllDatas(id, type);
            }
            catch (Exception ex) {
                logger.error("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)ex);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e\u5931\u8d25\u3002", (String)"GrossDemandAllExport_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
                this.settaskid("0");
                return;
            }
        }
        int count = this.getCount();
        int sum = this.getSum();
        if (count != 0 && sum != 0 && count == sum) {
            Label lblTip2 = (Label)this.getControl("labelap");
            lblTip2.setText(String.format(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u91cf\u4e3a\uff1a%s", (String)"GrossDemandAllExport_3", (String)"mmc-mrp-report", (Object[])new Object[0]), sum / 5));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f", (String)"GrossDemandAllExport_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            this.settaskid("0");
        }
    }

    private void getAllDatas(Object id, Object type) {
        HashSet<Long> materialSet = new HashSet<Long>();
        try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)DBRoute.of((String)"scm"), (String)"select distinct fsupplymaterialid from t_mrp_peginfodataentry where fid = ?", (Object[])new Object[]{id});){
            for (Row row : dataSet) {
                materialSet.add(row.getLong("fsupplymaterialid"));
            }
        }
        this.setSum(materialSet.size() * 5);
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.supplymaterial cmaterial_2,");
        sql.append("entryentity.supplyauxpty auxproperty_2,");
        sql.append("entryentity.configuredcodesup configuredcode_2,");
        sql.append("entryentity.requirematerial pmaterial_2,");
        sql.append("entryentity.demandauxpty pauxproperty_2,");
        sql.append("entryentity.configuredcodedem pconfiguredcode_2,");
        sql.append("entryentity.requireorg requireorg_2,");
        sql.append("entryentity.requireoperator demuser_2,");
        sql.append("entryentity.supplyoperator supuser_2,");
        sql.append("entryentity.supplyqty supplyqty,");
        sql.append("entryentity.supplydate supplydate");
        QFilter qf1 = new QFilter("id", "=", id);
        QFilter qf2 = new QFilter("entryentity.supplydate", "is not null", (Object)"");
        DataSet materialRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bd_material", "id,number,name", null);
        DataSet demuserRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_user", "id demuserid,name demusername", null);
        DataSet supuserRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bos_user", "id supuserid,name supusername", null);
        DataSet configuredcodeRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bd_configuredcode", "id configuredcodeid,number configuredcodenumber", null);
        DataSet pconfiguredcodeRows = ORM.create().queryDataSet(((Object)((Object)this)).getClass().getName(), "bd_configuredcode", "id pconfiguredcodeid,number pconfiguredcodenumber", null);
        DataSet datas = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_peginfodata", (String)sql.toString(), (QFilter[])new QFilter[]{qf1, qf2}, null).groupBy(new String[]{"cmaterial_2", "pmaterial_2", "requireorg_2", "demuser_2", "supuser_2", "supplyqty", "supplydate", "configuredcode_2", "pconfiguredcode_2", "auxproperty_2", "pauxproperty_2"}).sum("supplyqty", "total_2").finish();
        DataSet dataSet = datas.join(materialRows, JoinType.LEFT).on("pmaterial_2", "id").select(datas.getRowMeta().getFieldNames(), materialRows.getRowMeta().getFieldNames()).finish();
        DataSet dataSet1 = dataSet.join(demuserRows, JoinType.LEFT).on("demuser_2", "demuserid").select(dataSet.getRowMeta().getFieldNames(), demuserRows.getRowMeta().getFieldNames()).finish();
        DataSet dataSet2 = dataSet1.join(supuserRows, JoinType.LEFT).on("supuser_2", "supuserid").select(dataSet1.getRowMeta().getFieldNames(), supuserRows.getRowMeta().getFieldNames()).finish();
        DataSet dataSet3 = dataSet2.join(configuredcodeRows, JoinType.LEFT).on("configuredcode_2", "configuredcodeid").select(dataSet2.getRowMeta().getFieldNames(), configuredcodeRows.getRowMeta().getFieldNames()).finish();
        try (DataSet dataSet4 = dataSet3.join(pconfiguredcodeRows, JoinType.LEFT).on("pconfiguredcode_2", "pconfiguredcodeid").select(dataSet3.getRowMeta().getFieldNames(), pconfiguredcodeRows.getRowMeta().getFieldNames()).finish();){
            if (dataSet4.hasNext()) {
                try {
                    this.dealData(materialSet, dataSet4, id, type);
                }
                catch (IOException e) {
                    logger.error("\u5bfc\u51fa\u6bdb\u9700\u6c42\u6570\u636e\u62a5\u9519\uff1a", (Throwable)e);
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossDemandAllExport_5", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealData(Set<Long> materialIdSet, DataSet dataSet, Object id, Object type) throws IOException {
        boolean isWeek = "1".equals(type);
        Calendar calcreate = Calendar.getInstance();
        HashMap<Long, String> numberMap = new HashMap<Long, String>(materialIdSet.size());
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)}, null);){
            for (Row row : datas) {
                numberMap.put(row.getLong("id"), row.getString("number"));
            }
        }
        ReportList list = (ReportList)this.getView().getParentView().getControl("reportparentlistap");
        List columns = list.getReportModel().getColumns();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"mrp_peginfodata", (String)"id,createtime,entryentity.supplydate", (QFilter[])new QFilter[]{new QFilter("id", "=", id)}, (String)"entryentity.supplydate asc", (int)1);
        Date createTime = ((DynamicObject)datas.get(0)).getDate("createtime");
        Date supplydate = ((DynamicObject)datas.get(0)).getDate("entryentity.supplydate");
        if (supplydate == null) {
            return;
        }
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            int x = 0;
            int n = columns.size();
            for (int i = 0; i < n; ++i) {
                AbstractReportColumn abstractReportColumn = (AbstractReportColumn)columns.get(i);
                SXSSFCell cell = firstrow.createCell(i - x, CellType.STRING);
                cell.setCellValue(abstractReportColumn.getCaption().toString());
            }
            int rowNum = 1;
            Integer starttime = Integer.valueOf((String)this.getView().getParentView().getModel().getValue("starttime"));
            Integer endtime = Integer.valueOf((String)this.getView().getParentView().getModel().getValue("endtime"));
            if (createTime != null && supplydate != null && createTime.compareTo(supplydate) < 0) {
                calcreate.setTime(createTime);
            } else {
                calcreate.setTime(supplydate);
            }
            calcreate.add(3, starttime - 1);
            for (Long materialId : materialIdSet) {
                RequireTypeSummaryEntity2 sumEntity;
                HashMap<MaterialInfo, BigDecimal> qtyMap = new HashMap<MaterialInfo, BigDecimal>();
                DataSet da = dataSet.copy().filter("cmaterial_2 = " + materialId);
                HashMap<MaterialInfo, Map> materialMap = new HashMap<MaterialInfo, Map>(32);
                for (Row row : da) {
                    Long parentMaterialId = row.getLong("pmaterial_2");
                    Long configuredcode = row.getLong("configuredcode_2");
                    Long pconfiguredcode = row.getLong("pconfiguredcode_2");
                    Long auxproperty = row.getLong("auxproperty_2");
                    Long pauxproperty = row.getLong("pauxproperty_2");
                    MaterialInfo materialInfo = new MaterialInfo(materialId, configuredcode, auxproperty);
                    Map materialInfoMap = materialMap.computeIfAbsent(materialInfo, k -> new HashMap());
                    sumEntity = materialInfoMap.computeIfAbsent(parentMaterialId, k -> new RequireTypeSummaryEntity2(isWeek, endtime - (starttime - 1), calcreate.getTime(), materialId, configuredcode, parentMaterialId, pconfiguredcode, null, null, pauxproperty));
                    BigDecimal qtysum = qtyMap.computeIfAbsent(materialInfo, k -> BigDecimal.ZERO);
                    String demuser = row.getString("demusername");
                    String supuser = row.getString("supusername");
                    String parentMaterialNumber = row.getString("number");
                    String parentMaterialName = row.getString("name");
                    sumEntity.setParentMaterialNumber(parentMaterialNumber);
                    sumEntity.setParentMaterialName(parentMaterialName);
                    BigDecimal qty = row.getBigDecimal("total_2");
                    Date date = row.getDate("supplydate");
                    if (StringUtils.isNotBlank((CharSequence)demuser)) {
                        sumEntity.setDemuser(demuser);
                    }
                    if (StringUtils.isNotBlank((CharSequence)supuser)) {
                        sumEntity.setSupuser(supuser);
                    }
                    String configuredcodeNumber = row.getString("configuredcodenumber");
                    String pconfiguredcodeNumber = row.getString("pconfiguredcodenumber");
                    if (StringUtils.isNotBlank((CharSequence)configuredcodeNumber)) {
                        sumEntity.setConfiguredcodeNumber(configuredcodeNumber);
                    }
                    if (StringUtils.isNotBlank((CharSequence)pconfiguredcodeNumber)) {
                        sumEntity.setPconfiguredcodeNumber(pconfiguredcodeNumber);
                    }
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    if (isWeek) {
                        cal.setFirstDayOfWeek(2);
                        int day = cal.get(7);
                        if (day == 1) {
                            day = 8;
                        }
                        cal.add(5, cal.getFirstDayOfWeek() - day);
                        String dateString = cal.get(1) + "/" + (cal.get(2) + 1) + "/" + cal.get(5);
                        if (sumEntity.getQtyMap().containsKey(dateString)) {
                            qtyMap.put(materialInfo, qtysum.add(qty));
                            sumEntity.getQtyMap().put(dateString, qty.add((BigDecimal)sumEntity.getQtyMap().get(dateString)));
                            sumEntity.getQtyMap().put("total_1", qty.add((BigDecimal)sumEntity.getQtyMap().get("total_1")));
                        }
                    } else {
                        String monthOfYear = cal.get(1) + "/" + (cal.get(2) + 1);
                        if (sumEntity.getQtyMap().containsKey(monthOfYear)) {
                            qtyMap.put(materialInfo, qtysum.add(qty));
                            sumEntity.getQtyMap().put(monthOfYear, qty.add((BigDecimal)sumEntity.getQtyMap().get(monthOfYear)));
                            sumEntity.getQtyMap().put("total_1", qty.add((BigDecimal)sumEntity.getQtyMap().get("total_1")));
                        }
                    }
                    materialInfoMap.put(parentMaterialId, sumEntity);
                    materialMap.put(materialInfo, materialInfoMap);
                }
                da.close();
                DynamicObject peginfodata = BusinessDataServiceHelper.newDynamicObject((String)"mrp_peginfodata");
                DynamicObjectCollection entryentitys = peginfodata.getDynamicObjectCollection("entryentity");
                for (Map.Entry matrtialInfoentry : materialMap.entrySet()) {
                    Map value = (Map)matrtialInfoentry.getValue();
                    MaterialInfo materialInfo = (MaterialInfo)matrtialInfoentry.getKey();
                    DynamicObject entryentity = new DynamicObject(entryentitys.getDynamicObjectType());
                    for (Map.Entry entry : value.entrySet()) {
                        sumEntity = (RequireTypeSummaryEntity2)entry.getValue();
                        SXSSFRow row = sheet.createRow(rowNum);
                        x = 0;
                        int m = columns.size();
                        for (int k2 = 0; k2 < m; ++k2) {
                            String auxpropertyStr;
                            ReportColumn column = (ReportColumn)columns.get(k2);
                            if ("cmaterial_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue((String)numberMap.get(materialId));
                                continue;
                            }
                            if ("auxproperty_2".equals(column.getFieldKey())) {
                                Long auxproperty = materialInfo.getAuxproperty();
                                auxpropertyStr = ReportUtil.getDisplayValueForReport(entryentity, "supplymaterial", "supplyauxpty", materialId, auxproperty);
                                row.createCell(k2 - x).setCellValue(auxpropertyStr);
                                continue;
                            }
                            if ("configuredcode_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue(sumEntity.getConfiguredcodeNumber());
                                continue;
                            }
                            if ("pmaterial_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue(sumEntity.getParentMaterialNumber());
                                continue;
                            }
                            if ("pauxproperty_2".equals(column.getFieldKey())) {
                                Long pauxproperty = sumEntity.getPauxproperty();
                                auxpropertyStr = ReportUtil.getDisplayValueForReport(entryentity, "requirematerial", "demandauxpty", materialId, pauxproperty);
                                row.createCell(k2 - x).setCellValue(auxpropertyStr);
                                continue;
                            }
                            if ("pconfiguredcode_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue(sumEntity.getPconfiguredcodeNumber());
                                continue;
                            }
                            if ("pmaterialname_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue(sumEntity.getParentMaterialName());
                                continue;
                            }
                            if ("demuser_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue(sumEntity.getDemuser());
                                continue;
                            }
                            if ("supuser_2".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue(sumEntity.getSupuser());
                                continue;
                            }
                            if ("fseq".equals(column.getFieldKey())) {
                                row.createCell(k2 - x).setCellValue((double)rowNum);
                                continue;
                            }
                            if ("pct_1".equals(column.getFieldKey())) {
                                if (qtyMap.get(materialInfo) == null || ((BigDecimal)qtyMap.get(materialInfo)).compareTo(BigDecimal.ZERO) == 0) {
                                    row.createCell(k2 - x).setCellValue("0%");
                                    continue;
                                }
                                row.createCell(k2 - x).setCellValue(((BigDecimal)sumEntity.getQtyMap().get("total_1")).multiply(new BigDecimal(100)).divide((BigDecimal)qtyMap.get(materialInfo), 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "%");
                                continue;
                            }
                            row.createCell(k2 - x).setCellValue(new Double(((BigDecimal)sumEntity.getQtyMap().get(column.getFieldKey())).toString()).doubleValue());
                        }
                        ++rowNum;
                    }
                }
                this.setCount(4);
            }
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u67e5\u8be2-\u7236\u9879\u9700\u6c42\u7c7b\u578b\u6c47\u603b-\u6279\u91cf\u5bfc\u51fa.xlsx", (String)"GrossDemandAllExport_6", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)"mrp_grossquery", (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
            this.setCount(materialIdSet.size());
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
    }
}

