/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.gross;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.DateType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.common.entity.gross.MaterialInfo;
import kd.mmc.mrp.common.entity.gross.RequireTypeSummaryEntity;

public class GrossDemandGroupRptQuery
extends AbstractReportListDataPlugin {
    private static ThreadLocal<List<String>> threadLocal = new ThreadLocal();

    public DataSet query(ReportQueryParam param, Object arg1) throws Throwable {
        FilterInfo filter = param.getFilter();
        DynamicObjectCollection dynamicObjectCollection = filter.getDynamicObjectCollection("material");
        HashSet<Long> materialIdSet = new HashSet<Long>();
        for (DynamicObject obj : dynamicObjectCollection) {
            materialIdSet.add(obj.getLong("id"));
        }
        HashSet<MaterialInfo> materialInfos = new HashSet<MaterialInfo>(materialIdSet.size());
        DataSet dataSet = this.getAllData(filter, materialIdSet);
        Integer starttime = Integer.valueOf(filter.getString("starttime"));
        Integer endtime = Integer.valueOf(filter.getString("endtime"));
        ArrayList<String> columns = new ArrayList<String>();
        HashMap<MaterialInfo, Set<String>> requireTypeMap = new HashMap<MaterialInfo, Set<String>>();
        Map<MaterialInfo, Map<String, RequireTypeSummaryEntity>> map = this.dealData(filter, materialIdSet, dataSet, columns, requireTypeMap, starttime, endtime, materialInfos);
        threadLocal.set(columns);
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("cmaterial_1", (DataType)DateType.StringType, true));
        fields.add(new Field("auxproperty_1", (DataType)DateType.StringType, true));
        fields.add(new Field("configuredcode_1", (DataType)DateType.StringType, true));
        fields.add(new Field("requiresource_1", (DataType)DateType.StringType, true));
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            fields.add(new Field((String)columns.get(i), (DataType)DateType.StringType, true));
        }
        RowMeta metas = new RowMeta(fields.toArray(new Field[0]));
        Algo algo = Algo.create((String)((Object)((Object)this)).getClass().getName());
        DataSetBuilder builder = algo.createDataSetBuilder(metas);
        for (MaterialInfo materialInfo : materialInfos) {
            if (!map.containsKey(materialInfo)) continue;
            Long materialId = materialInfo.getMaterialId();
            Long configuredcode = materialInfo.getConfiguredcode();
            Long auxproperty = materialInfo.getAuxproperty();
            Map<String, RequireTypeSummaryEntity> materialMap = map.get(materialInfo);
            Set requireTypeSet = (Set)requireTypeMap.get(materialInfo);
            RequireTypeSummaryEntity requireTypeSummaryEntity = materialMap.get(materialId + "sum");
            Object[] values = new Object[fields.size()];
            values[0] = requireTypeSummaryEntity.getMaterialId();
            values[1] = auxproperty;
            values[2] = configuredcode;
            values[3] = requireTypeSummaryEntity.getRequireResource();
            int n2 = requireTypeSummaryEntity.getDateList().size();
            for (int i = 0; i < n2; ++i) {
                String name = (String)requireTypeSummaryEntity.getDateList().get(i);
                values[4 + i] = ((BigDecimal)requireTypeSummaryEntity.getQtyMap().get(name)).setScale(2, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString();
            }
            builder.append(values);
            for (String key : requireTypeSet) {
                requireTypeSummaryEntity = materialMap.get(materialId + key);
                values = new Object[fields.size()];
                values[0] = requireTypeSummaryEntity.getMaterialId();
                values[1] = auxproperty;
                values[2] = configuredcode;
                values[3] = requireTypeSummaryEntity.getRequireResource();
                int n3 = requireTypeSummaryEntity.getDateList().size();
                for (int i = 0; i < n3; ++i) {
                    String name = (String)requireTypeSummaryEntity.getDateList().get(i);
                    values[4 + i] = ((BigDecimal)requireTypeSummaryEntity.getQtyMap().get(name)).setScale(2, RoundingMode.HALF_DOWN).stripTrailingZeros().toPlainString();
                }
                builder.append(values);
            }
        }
        return builder.build();
    }

    private Map<MaterialInfo, Map<String, RequireTypeSummaryEntity>> dealData(FilterInfo filter, Set<Long> materialIdSet, DataSet dataSet, List<String> columns, Map<MaterialInfo, Set<String>> requireTypeMap, Integer starttime, Integer endtime, Set<MaterialInfo> materialInfos) {
        HashMap<MaterialInfo, Map<String, RequireTypeSummaryEntity>> map = new HashMap<MaterialInfo, Map<String, RequireTypeSummaryEntity>>();
        boolean isWeek = "1".equals(filter.getString("radiogroupfield"));
        Calendar createtime = Calendar.getInstance();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"mrp_peginfodata", (String)"id,createtime,entryentity.supplydate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)filter.getLong("id"))}, (String)"entryentity.supplydate asc", (int)1);
        if (datas == null || datas.size() <= 0) {
            return map;
        }
        Date createTime = ((DynamicObject)datas.get(0)).getDate("createtime");
        Date supplydate = ((DynamicObject)datas.get(0)).getDate("entryentity.supplydate");
        if (supplydate == null) {
            return map;
        }
        if (createTime != null && supplydate != null && createTime.compareTo(supplydate) < 0) {
            createtime.setTime(createTime);
        } else {
            createtime.setTime(supplydate);
        }
        createtime.add(3, starttime - 1);
        if (columns.size() == 0) {
            columns.addAll(new RequireTypeSummaryEntity(isWeek, endtime - (starttime - 1), createtime.getTime(), Long.valueOf(0L), Long.valueOf(0L), "").getDateList());
        }
        try (DataSet d = dataSet.copy();){
            for (Long materialId : materialIdSet) {
                DataSet da = d.copy().filter("cmaterial_1 = " + materialId);
                if (da.hasNext()) {
                    for (Row row : da) {
                        Date date = row.getDate("supplydate");
                        String requireResource = row.getString("requiresource_1");
                        Long configuredcode = row.getLong("configuredcode_1");
                        Long auxproperty = row.getLong("auxproperty_1");
                        MaterialInfo materialInfo = new MaterialInfo(materialId, configuredcode, auxproperty);
                        materialInfos.add(materialInfo);
                        Map materialConfiguredcodeMap = map.computeIfAbsent(materialInfo, k -> new HashMap());
                        BigDecimal qty = row.getBigDecimal("supplyqty");
                        RequireTypeSummaryEntity sumEntity = materialConfiguredcodeMap.computeIfAbsent(materialId + "sum", k -> new RequireTypeSummaryEntity(isWeek, endtime - (starttime - 1), createtime.getTime(), materialId, configuredcode, ResManager.loadKDString((String)"\u5408\u8ba1", (String)"GrossDemandGroupRptQuery_0", (String)"mmc-mrp-report", (Object[])new Object[0])));
                        RequireTypeSummaryEntity requireEntity = materialConfiguredcodeMap.computeIfAbsent(materialId + requireResource, k -> new RequireTypeSummaryEntity(isWeek, endtime - (starttime - 1), createtime.getTime(), materialId, configuredcode, requireResource));
                        Set requireTypes = requireTypeMap.computeIfAbsent(materialInfo, k -> new HashSet());
                        requireTypes.add(requireResource);
                        Calendar cal = Calendar.getInstance();
                        cal.setTime(date);
                        if (isWeek) {
                            cal.setFirstDayOfWeek(2);
                            int day = cal.get(7);
                            if (day == 1) {
                                day = 8;
                            }
                            cal.add(5, cal.getFirstDayOfWeek() - day);
                            String dateString = cal.get(1) + "/" + (cal.get(2) + 1) + "/" + cal.get(5);
                            if (!requireEntity.getQtyMap().containsKey(dateString)) continue;
                            requireEntity.getQtyMap().put(dateString, qty.add((BigDecimal)requireEntity.getQtyMap().get(dateString)));
                            sumEntity.getQtyMap().put(dateString, qty.add((BigDecimal)sumEntity.getQtyMap().get(dateString)));
                            requireEntity.getQtyMap().put("total", qty.add((BigDecimal)requireEntity.getQtyMap().get("total")));
                            sumEntity.getQtyMap().put("total", qty.add((BigDecimal)sumEntity.getQtyMap().get("total")));
                            continue;
                        }
                        String monthOfYear = cal.get(1) + "/" + (cal.get(2) + 1);
                        if (!requireEntity.getQtyMap().containsKey(monthOfYear)) continue;
                        requireEntity.getQtyMap().put(monthOfYear, qty.add((BigDecimal)requireEntity.getQtyMap().get(monthOfYear)));
                        sumEntity.getQtyMap().put(monthOfYear, qty.add((BigDecimal)sumEntity.getQtyMap().get(monthOfYear)));
                        requireEntity.getQtyMap().put("total", qty.add((BigDecimal)requireEntity.getQtyMap().get("total")));
                        sumEntity.getQtyMap().put("total", qty.add((BigDecimal)sumEntity.getQtyMap().get("total")));
                    }
                }
                da.close();
            }
        }
        return map;
    }

    private DataSet getAllData(FilterInfo filter, Set<Long> materialIdSet) {
        StringBuilder sql = new StringBuilder();
        sql.append("entryentity.supplymaterial cmaterial_1,");
        sql.append("entryentity.supplyauxpty auxproperty_1,");
        sql.append("entryentity.requirebilltpye requiresource_1,");
        sql.append("entryentity.supplyqty supplyqty,");
        sql.append("entryentity.supplydate supplydate,");
        sql.append("entryentity.configuredcodesup configuredcode_1");
        long id = filter.getLong("id");
        QFilter qf1 = new QFilter("id", "=", (Object)id);
        QFilter qf2 = new QFilter("entryentity.supplydate", "is not null", (Object)"");
        QFilter qf3 = new QFilter("entryentity.supplymaterial", "in", materialIdSet);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_peginfodata", (String)sql.toString(), (QFilter[])new QFilter[]{qf1, qf2, qf3}, null).groupBy(new String[]{"cmaterial_1", "requiresource_1", "configuredcode_1", "auxproperty_1", "supplydate"}).sum("supplyqty").finish();
        return dataSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List<String> list = threadLocal.get();
        List columns2 = super.getColumns(columns);
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ReportColumn qty = new ReportColumn();
            if ("total".equals(list.get(i))) {
                qty.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u6c47\u603b", (String)"GrossDemandGroupRptQuery_1", (String)"mmc-mrp-report", (Object[])new Object[0])));
            } else {
                qty.setCaption(new LocaleString(list.get(i)));
            }
            qty.setFieldKey(list.get(i));
            qty.setWidth(new LocaleString("80px"));
            qty.setFieldType("text");
            qty.setZeroShow(true);
            ColumnStyle c = new ColumnStyle();
            c.setTextAlign("right");
            qty.setStyle(c);
            columns2.add(qty);
        }
        threadLocal.remove();
        return columns2;
    }
}

