/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.format.FlexValueFormatter;
import kd.bos.form.operate.FormOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.userconfig.GridConfigDAO;
import kd.mmc.mrp.common.util.FilePermissionUtil;
import kd.mmc.mrp.report.util.ReportUtil;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class GrossdemandSourceExportPlugin
extends AbstractReportFormPlugin {
    private static final Log logger = LogFactory.getLog(GrossdemandSourceExportPlugin.class);
    Map<String, FlexValueFormatter> flexFormaterMap = new HashMap<String, FlexValueFormatter>();

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        ReportList list;
        int rowCount;
        FormOperate operate = (FormOperate)e.getSource();
        if ("export".equals(operate.getOperateKey()) && (rowCount = (list = (ReportList)this.getControl("reportlistap")).getReportModel().getRowCount()) == 0) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossdemandSourceExportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"GrossdemandSourceExportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if ("export".equals(e.getOperateKey())) {
            ReportList list = (ReportList)this.getControl("reportlistap");
            this.exportExcel(list);
        }
    }

    private void exportExcel(ReportList list) {
        Object localeValue;
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d,\u8bf7\u7a0d\u7b49\u3002", (String)"GrossdemandSourceExportPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0])));
        String queryCache = this.getPageCache().get("queryCache");
        if (queryCache == null) {
            this.getView().hideLoading();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u7f13\u5b58\u51fa\u73b0\u5076\u53d1\u95ee\u9898\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u6b21\u67e5\u8be2\u5bfc\u51fa\u3002", (String)"GrossdemandSourceExportPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        QFilter caculatelogQFilter = null;
        QFilter materialcodesQFilter = null;
        QFilter materialparentcodesQFilter = null;
        QFilter productmodelsQFilter = null;
        QFilter requirementtypesQFilter = null;
        List query = SerializationUtils.fromJsonStringToList((String)queryCache, Map.class);
        if (query != null) {
            String requirementtypes;
            List productmodels;
            List materialparentcodes;
            List materialcodes;
            Map map = (Map)query.get(0);
            Long caculatelog = (Long)map.get("caculatelogs");
            if (caculatelog != null) {
                caculatelogQFilter = new QFilter("caculatelog", "=", (Object)caculatelog);
            }
            if ((materialcodes = (List)map.get("materialcodes")) != null) {
                materialcodesQFilter = new QFilter("materialcode.id", "in", (Object)materialcodes);
            }
            if ((materialparentcodes = (List)map.get("materialparentcodes")) != null) {
                materialparentcodesQFilter = new QFilter("materialparentcode.id", "in", (Object)materialparentcodes);
            }
            if ((productmodels = (List)map.get("productmodels")) != null) {
                productmodelsQFilter = new QFilter("productmodel.id", "in", (Object)productmodels);
            }
            if ((requirementtypes = (String)map.get("requirementtypes")) != null) {
                requirementtypesQFilter = new QFilter("requirementtype", "in", (Object)requirementtypes);
            }
        }
        logger.warn("GrossdemandSourceExportPlugin-readline,\u6570\u636e\u5bfc\u51fa\u4e2d");
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet();
        int width = Math.max(3840, Math.min(65280, sheet.getColumnWidth(0) * 12 / 10));
        GridConfigDAO gridConfigDAO = new GridConfigDAO();
        List gridConfigs = gridConfigDAO.getGridConfig(this.getView().getFormShowParameter().getFormId(), "reportlistap");
        boolean isAllVisble = true;
        SXSSFRow firstrow = sheet.createRow(0);
        HashMap maps = Maps.newHashMapWithExpectedSize((int)8);
        MainEntityType type = this.getModel().getDataEntityType();
        int n = 0;
        if (gridConfigs.size() == 0) {
            this.setListmap(list, firstrow, sheet, width);
        } else {
            for (int i = 0; i < gridConfigs.size(); ++i) {
                GridConfigurationRow gridConfigurationRow = (GridConfigurationRow)gridConfigs.get(i);
                localeValue = gridConfigurationRow.getFieldName().getLocaleValue();
                String fieldKey = gridConfigurationRow.getFieldKey();
                boolean hide = gridConfigurationRow.isHide();
                if (hide) continue;
                isAllVisble = false;
                firstrow.createCell(n).setCellValue((String)localeValue);
                sheet.setColumnWidth(n, width);
                DynamicProperty property = type.getProperty(fieldKey);
                if (property == null) continue;
                Class propertyType = property.getPropertyType();
                if (propertyType.equals(DynamicObject.class)) {
                    if ("productmodel".equals(fieldKey) || "materialgroup".equals(fieldKey)) {
                        maps.put(n, fieldKey + ".name");
                    } else if ("auxproperty".equals(fieldKey) || "pauxproperty".equals(fieldKey)) {
                        maps.put(n, fieldKey);
                    } else {
                        maps.put(n, fieldKey + ".number");
                    }
                } else {
                    maps.put(n, fieldKey);
                }
                ++n;
            }
            if (isAllVisble) {
                try {
                    workbook.close();
                }
                catch (IOException e) {
                    throw new KDBizException(e.getMessage());
                }
                this.getView().hideLoading();
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u62a5\u8868\u5b57\u6bb5\u5168\u90e8\u9690\u85cf\u65f6\uff0c\u65e0\u6cd5\u5bfc\u51fa\u3002", (String)"GrossdemandSourceExportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
                return;
            }
        }
        Long starttime = System.currentTimeMillis();
        DataSet dataset = QueryServiceHelper.queryDataSet((String)GrossdemandSourceExportPlugin.class.getName(), (String)"mrp_gdd_source_base", (String)"caculatelog.number,materialcode,materialcode.number,materialparentcode,materialparentcode.number,requirementtype,qty,productmodel.name,pbom.number,materialgroup.name,configuredcode.number,pconfiguredcode.number,auxproperty,pauxproperty", (QFilter[])new QFilter[]{caculatelogQFilter, materialcodesQFilter, materialparentcodesQFilter, productmodelsQFilter, requirementtypesQFilter}, null);
        localeValue = null;
        try {
            int i = 1;
            while (dataset.hasNext()) {
                DynamicObject mrp_gddsourcebase = BusinessDataServiceHelper.newDynamicObject((String)"mrp_gdd_source_base");
                Row daterow = dataset.next();
                SXSSFRow row = sheet.createRow(i);
                if (maps != null && maps.size() > 0) {
                    for (Map.Entry map : maps.entrySet()) {
                        String value;
                        if (((String)map.getValue()).contains("qty")) {
                            row.createCell(((Integer)map.getKey()).intValue()).setCellValue(daterow.getDouble((String)map.getValue()).doubleValue());
                            continue;
                        }
                        if (((String)map.getValue()).equals("auxproperty")) {
                            value = ReportUtil.getDisplayValueForReport(mrp_gddsourcebase, "materialcode", (String)map.getValue(), daterow.getLong("materialcode"), daterow.getLong((String)map.getValue()));
                            row.createCell(((Integer)map.getKey()).intValue()).setCellValue(value);
                            continue;
                        }
                        if (((String)map.getValue()).contains("pauxproperty")) {
                            value = ReportUtil.getDisplayValueForReport(mrp_gddsourcebase, "materialparentcode", (String)map.getValue(), daterow.getLong("materialparentcode"), daterow.getLong((String)map.getValue()));
                            row.createCell(((Integer)map.getKey()).intValue()).setCellValue(value);
                            continue;
                        }
                        row.createCell(((Integer)map.getKey()).intValue()).setCellValue(daterow.getString((String)map.getValue()));
                    }
                } else {
                    row.createCell(0).setCellValue(daterow.getString("caculatelog.number"));
                    row.createCell(1).setCellValue(daterow.getString("materialcode.number"));
                    String auxproperty = ReportUtil.getDisplayValueForReport(mrp_gddsourcebase, "materialcode", "auxproperty", daterow.getLong("materialcode"), daterow.getLong("auxproperty"));
                    row.createCell(2).setCellValue(auxproperty);
                    row.createCell(3).setCellValue(daterow.getString("configuredcode.number"));
                    row.createCell(4).setCellValue(daterow.getString("materialparentcode.number"));
                    String pauxproperty = ReportUtil.getDisplayValueForReport(mrp_gddsourcebase, "materialparentcode", "pauxproperty", daterow.getLong("materialparentcode"), daterow.getLong("pauxproperty"));
                    row.createCell(5).setCellValue(pauxproperty);
                    row.createCell(6).setCellValue(daterow.getString("pconfiguredcode.number"));
                    row.createCell(7).setCellValue(daterow.getString("requirementtype"));
                    row.createCell(8).setCellValue(new Double(daterow.getString("qty")).doubleValue());
                    row.createCell(9).setCellValue(daterow.getString("productmodel.name"));
                    row.createCell(10).setCellValue(daterow.getString("pbom.number"));
                    row.createCell(11).setCellValue(daterow.getString("materialgroup.name"));
                }
                ++i;
            }
        }
        catch (Throwable i) {
            localeValue = i;
            throw i;
        }
        finally {
            if (dataset != null) {
                if (localeValue != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable i) {
                        ((Throwable)localeValue).addSuppressed(i);
                    }
                } else {
                    dataset.close();
                }
            }
        }
        Long endtime = System.currentTimeMillis();
        logger.warn(String.format("GrossdemandSourceExportPlugin-time,\u8bfb\u53d6\u6570\u636e\u7684\u8017\u65f6: %s MS", endtime - starttime));
        try {
            starttime = System.currentTimeMillis();
            ByteArrayOutputStream outStream = null;
            ByteArrayInputStream inStream = null;
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u6bdb\u9700\u6c42\u6765\u6e90.xlsx", (String)"GrossdemandSourceExportPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            endtime = System.currentTimeMillis();
            logger.warn(String.format("GrossdemandSourceExportPlugin-time,\u5199\u4e0b\u8f7d\u6587\u4ef6\u7684\u8017\u65f6: %s MS", endtime - starttime));
            starttime = System.currentTimeMillis();
            this.getView().download(tempUrl);
            endtime = System.currentTimeMillis();
            logger.warn(String.format("GrossdemandSourceExportPlugin-time,\u4e0b\u8f7d\u6587\u4ef6\u7684\u8017\u65f6: %s MS", endtime - starttime));
            outStream.close();
            inStream.close();
            workbook.close();
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        this.getView().hideLoading();
    }

    private void setListmap(ReportList list, SXSSFRow firstrow, SXSSFSheet sheet, int width) {
        firstrow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"GrossdemandSourceExportPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(0, width);
        firstrow.createCell(1).setCellValue(ResManager.loadKDString((String)"\u7f16\u7801", (String)"GrossdemandSourceExportPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(1, width);
        firstrow.createCell(2).setCellValue(ResManager.loadKDString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"GrossdemandSourceExportPlugin_14", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(2, width);
        firstrow.createCell(3).setCellValue(ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"GrossdemandSourceExportPlugin_7", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(3, width);
        firstrow.createCell(4).setCellValue(ResManager.loadKDString((String)"\u7236\u9879\u7f16\u7801", (String)"GrossdemandSourceExportPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(4, width);
        firstrow.createCell(5).setCellValue(ResManager.loadKDString((String)"\u7236\u9879\u8f85\u52a9\u5c5e\u6027", (String)"GrossdemandSourceExportPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(5, width);
        firstrow.createCell(6).setCellValue(ResManager.loadKDString((String)"\u7236\u9879\u914d\u7f6e\u53f7", (String)"GrossdemandSourceExportPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(6, width);
        firstrow.createCell(7).setCellValue(ResManager.loadKDString((String)"\u9700\u6c42\u7c7b\u578b", (String)"GrossdemandSourceExportPlugin_10", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(7, width);
        firstrow.createCell(8).setCellValue(ResManager.loadKDString((String)"\u6570\u91cf", (String)"GrossdemandSourceExportPlugin_11", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(8, width);
        firstrow.createCell(9).setCellValue(ResManager.loadKDString((String)"\u4ea7\u54c1\u578b\u53f7", (String)"GrossdemandSourceExportPlugin_12", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(9, width);
        firstrow.createCell(10).setCellValue("PBOM");
        sheet.setColumnWidth(10, width);
        firstrow.createCell(11).setCellValue(ResManager.loadKDString((String)"\u7f16\u7801\u5206\u7c7b", (String)"GrossdemandSourceExportPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0]));
        sheet.setColumnWidth(11, width);
    }
}

