/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

public class SluggishSupplyRptQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String BILL_DETIAL = "mrp_calcdetail";
    private static final String FILTER_OPERATION = "filter_operation";
    private static final String FILTER_MATERIAL = "filter_material";
    private static final String FILTER_PRODUCT_PLANNER = "filter_product_planner";
    private static final String FILTER_PURCHASING_PLANNER = "filter_purchasing_planner";
    private static final String FILTER_PRODUCT_LINE = "filter_product_line";
    private static final String FILTER_SUPPLY_TYPE = "filter_supply_type";
    private static final String FILTER_SUPPLY_DETAILS = "filter_supply_details";
    private static final String FILTER_SUPPLY_PLANSCOPE = "filter_supplyplanscope";
    private static final String FILTER_SUPPLY_ORG = "filter_supplyorg";
    private final String algoKey = ((Object)((Object)this)).getClass().getSimpleName();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        String selectFields = this.getSelectFields();
        List<QFilter> filters = this.wrapperQFilters(reportQueryParam.getFilter());
        DataSet dataSet = ORM.create().queryDataSet(this.algoKey, BILL_DETIAL, selectFields, filters.toArray(new QFilter[0]));
        DataSet addDataSet = dataSet.addNullField(new String[]{"product_planner", "restructuringqty"}).addField("adjustqty + restructuringqty", "realcancelqty");
        return this.deal(addDataSet, filters);
    }

    private boolean isEmptyId(String id) {
        return StringUtils.isBlank((CharSequence)id) || "0".equals(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet deal(DataSet dataSet, List<QFilter> filters) {
        ArrayList<Map> datas = new ArrayList<Map>();
        RowMeta rowMeta = dataSet.getRowMeta();
        StringBuilder sb = new StringBuilder();
        HashMap summaryQtyMap = Maps.newHashMapWithExpectedSize((int)16);
        try {
            for (Row row : dataSet) {
                Map data = rowMeta.toMap(row);
                String supBillId = (String)data.get("sup_bill_id");
                String supBillEntryId = (String)data.get("sup_bill_entryId");
                BigDecimal supplyQty = data.getOrDefault("total_supply", BigDecimal.ZERO);
                if (this.isEmptyId(supBillId)) continue;
                datas.add(data);
                sb.append(supBillId).append('_').append(supBillEntryId);
                String key = sb.toString();
                BigDecimal summary = summaryQtyMap.computeIfAbsent(key, k -> BigDecimal.ZERO);
                summaryQtyMap.put(key, summary.add(supplyQty));
                sb.setLength(0);
            }
        }
        finally {
            dataSet.close();
        }
        Algo algo = Algo.create((String)this.algoKey);
        DataSetBuilder builder = algo.createDataSetBuilder(rowMeta);
        String[] fieldNames = rowMeta.getFieldNames();
        for (Map data : datas) {
            sb.append(data.get("sup_bill_id")).append('_').append(data.get("sup_bill_entryId"));
            data.put("total_supply", summaryQtyMap.getOrDefault(sb.toString(), BigDecimal.ZERO));
            sb.setLength(0);
            Object[] value = new Object[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                value[i] = data.get(fieldNames[i]);
            }
            builder.append(value);
        }
        return builder.build();
    }

    private String getSelectFields() {
        return "caculatelog operation, entryentity.material material, entryentity.material.baseunit baseunit, entryentity.supplyauxpty supplyauxpty, entryentity.material.offeringcode.group.parent.parent.parent product_line, entryentity.requireoperator purchasing_planner, entryentity.supplybilltype supply_type, entryentity.supplybillno supply_billno, entryentity.adjustqty total_supply, entryentity.adjustqty adjustqty, entryentity.supplyorg supplyorg, entryentity.supplybillid sup_bill_id, entryentity.supplybillentryid sup_bill_entryId, entryentity.supplyplanscope supplyplanscope, entryentity.configuredcode configuredcode, entryentity.suptracknumber tracknumber, entryentity.supplyproject project, entryentity.supplydetail supply_details";
    }

    private List<QFilter> wrapperQFilters(FilterInfo filterInfo) {
        DynamicObject supplyorg;
        DynamicObject planscope;
        String supplyDetails;
        String supplyType;
        DynamicObject productLine;
        DynamicObject purchasingPlanner;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject calLog = filterInfo.getDynamicObject(FILTER_OPERATION);
        if (calLog == null) {
            filters.add(new QFilter("1`", "!=", (Object)1));
            return filters;
        }
        filters.add(new QFilter("caculatelog", "=", (Object)calLog.getString("number")));
        filters.add(new QFilter("entryentity.adjustsuggest", "=", (Object)"\u5efa\u8bae\u53d6\u6d88"));
        DynamicObject material = filterInfo.getDynamicObject(FILTER_MATERIAL);
        if (material != null) {
            filters.add(new QFilter("entryentity.material", "=", material.getPkValue()));
        }
        if ((purchasingPlanner = filterInfo.getDynamicObject(FILTER_PURCHASING_PLANNER)) != null) {
            filters.add(new QFilter("entryentity.requireoperator", "=", purchasingPlanner.getPkValue()));
        }
        if ((productLine = filterInfo.getDynamicObject(FILTER_PRODUCT_LINE)) != null) {
            filters.add(new QFilter("entryentity.material.offeringcode.group.parent.parent.parent", "=", productLine.getPkValue()));
        }
        if (StringUtils.isNotBlank((CharSequence)(supplyType = filterInfo.getString(FILTER_SUPPLY_TYPE)))) {
            filters.add(QFilter.like((String)"entryentity.supplybilltype", (String)supplyType));
        }
        if (StringUtils.isNotBlank((CharSequence)(supplyDetails = filterInfo.getString(FILTER_SUPPLY_DETAILS)))) {
            filters.add(QFilter.like((String)"entryentity.supplydetail", (String)supplyDetails));
        }
        if ((planscope = filterInfo.getDynamicObject(FILTER_SUPPLY_PLANSCOPE)) != null) {
            filters.add(new QFilter("entryentity.supplyplanscope", "=", planscope.getPkValue()));
        }
        if ((supplyorg = filterInfo.getDynamicObject(FILTER_SUPPLY_ORG)) != null) {
            filters.add(new QFilter("entryentity.supplyorg", "=", supplyorg.getPkValue()));
        }
        return filters;
    }
}

