/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.plananalysis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.proxy.ReportListProxy;
import kd.mmc.mrp.business.helper.PlanOperatorGroupHelper;
import kd.mmc.mrp.business.helper.PlanViewOrgHelper;
import kd.mmc.mrp.common.util.ControlUtil;
import kd.mmc.mrp.common.util.DateUtils;
import kd.mmc.mrp.common.util.FilePermissionUtil;
import kd.mmc.mrp.common.util.ShowTipsUtil;
import kd.mmc.mrp.report.plananalysis.AbstractMRPRptPlugin;
import kd.mmc.mrp.report.util.SummaryListExporter;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class SummaryListRptPlugin
extends AbstractMRPRptPlugin
implements AfterF7SelectListener,
HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(SummaryListRptPlugin.class);
    private static final String MATERIALSTANDAR = "materialstandar";
    private static final String M_MATERIALGROUPBEGIN = "materialgroupbegins";
    private static final String M_MATERIALGROUPEND = "materialgroupend";
    private static final String M_MATERIALBEGIN = "materialbegins";
    private static final String SHOWKEYCOLS = "showkeycols";
    private static final String M_MATERIALEND = "materialend";

    public boolean verifyQuery(ReportQueryParam queryParam) {
        return this.verifyData(queryParam);
    }

    private boolean verifyData(ReportQueryParam queryParam) {
        String colsStr;
        FilterInfo filter = queryParam.getFilter();
        ArrayList<String> list = new ArrayList<String>(1);
        if (filter.getValue("calclogno") == null) {
            list.add(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"SummaryListRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (!this.checkShowkeycols(colsStr = filter.getString(SHOWKEYCOLS))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u7269\u6599\u3001\u4e1a\u52a1\u7ec4\u7ec7\u3001\u7269\u6599\u5c5e\u6027\u3001\u8ba1\u5212\u8303\u56f4\u56db\u4e2a\u6c47\u603b\u7ef4\u5ea6\u3002", (String)"SummaryListRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        if (!list.isEmpty()) {
            this.getView().showTipNotification(ShowTipsUtil.appendShowTips((String[])list.toArray(new String[0])));
            return false;
        }
        if (!(filter.getBoolean("fabricatedpart") || filter.getBoolean("externalprocessinpart") || filter.getBoolean("purchasedpart") || filter.getBoolean("storagepart"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u52fe\u9009\u4e00\u4e2a\u7269\u6599\u5c5e\u6027\u3002", (String)"SummaryListRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean checkShowkeycols(String colsStr) {
        if (StringUtils.isEmpty((CharSequence)colsStr)) {
            return false;
        }
        String[] colsStrs = colsStr.split(",");
        HashSet<String> colsStrSet = new HashSet<String>(Arrays.asList(colsStrs));
        if (!colsStrSet.contains("org")) {
            return false;
        }
        if (!colsStrSet.contains("materialattr")) {
            return false;
        }
        if (!colsStrSet.contains("material")) {
            return false;
        }
        return colsStrSet.contains("planscope");
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit base = (BasedataEdit)this.getControl(M_MATERIALGROUPBEGIN);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        base = (BasedataEdit)this.getControl(M_MATERIALGROUPEND);
        base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        base = (BasedataEdit)this.getControl("calclogno");
        if (base != null) {
            base.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("filter_org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit operator = (BasedataEdit)this.getControl("filter_operator");
        operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent e) {
        super.beforeF7Select(e);
        BasedataEdit base = (BasedataEdit)e.getSource();
        if (M_MATERIALGROUPBEGIN.equals(base.getFieldKey()) || M_MATERIALGROUPEND.equals(base.getFieldKey())) {
            if (this.getModel().getValue(MATERIALSTANDAR) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7269\u6599\u5206\u7c7b\u6807\u51c6\u3002", (String)"SummaryListRptPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                DynamicObject obj = (DynamicObject)this.getModel().getValue(MATERIALSTANDAR);
                ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
                QFilter filter = new QFilter("standard.id", "=", obj.getPkValue());
                formShowParameter.setCustomParam("groupStandard", obj.getPkValue());
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
            }
        } else if ("calclogno".equals(base.getFieldKey())) {
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter filter = new QFilter("clearstatus", "!=", (Object)Character.valueOf('B'));
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
        } else if ("filter_org".equals(base.getFieldKey())) {
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            formShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
            QFilter idFilter = new QFilter("id", "in", (Object)PlanViewOrgHelper.getOrgIdsByPlanView());
            filterParameter.getQFilters().add(idFilter);
        } else if ("filter_operator".equals(base.getFieldKey())) {
            Set set = PlanOperatorGroupHelper.getOperatorUserByGroup();
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", (Object)set);
            formShowParameter.getListFilterParameter().getQFilters().add(filter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
    }

    private void setSameValue(IDataModel model, String name, DynamicObjectCollection value) {
        if (value == null || value.isEmpty()) {
            model.setValue(name, null);
            this.getView().setEnable(Boolean.TRUE, new String[]{name});
        } else if (value.size() == 1) {
            model.setValue(name, ((DynamicObject)value.get(0)).get("fbasedataid"));
            this.getView().setEnable(Boolean.TRUE, new String[]{name});
        } else {
            model.setValue(name, null);
            this.getView().setEnable(Boolean.FALSE, new String[]{name});
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("material".equals(e.getFieldName())) {
            DynamicObject data = e.getRowData();
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("formId", "mrp_detailedlist_rpt");
            DynamicObject org = (DynamicObject)this.getModel().getValue("planorg");
            Long planOrg = org == null ? 0L : org.getLong("id");
            DynamicObject log = (DynamicObject)this.getModel().getValue("calclogno");
            Long logId = log == null ? 0L : log.getLong("id");
            para.put("planorg", planOrg);
            para.put("calclogno", logId);
            para.put("materialnumber", data.getDynamicObject("material").getPkValue());
            para.put("materialattr", data.getString("materialattr"));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeDatas = e.getChangeSet();
        switch (key) {
            case "materialstandar": {
                this.getModel().setValue(M_MATERIALGROUPBEGIN, null);
                this.getModel().setValue(M_MATERIALGROUPEND, null);
                break;
            }
            case "materialgroupbegins": {
                this.setSameValue(this.getModel(), M_MATERIALGROUPEND, (DynamicObjectCollection)this.getModel().getValue(M_MATERIALGROUPBEGIN));
                break;
            }
            case "materialbegins": {
                this.setSameValue(this.getModel(), M_MATERIALEND, (DynamicObjectCollection)this.getModel().getValue(M_MATERIALBEGIN));
                break;
            }
            case "showkeycols": {
                for (ChangeData changeData : changeDatas) {
                    DynamicObject propertyValueCDDE = changeData.getDataEntity();
                    Object newValue = changeData.getNewValue();
                    Object oldValue = changeData.getOldValue();
                    if (newValue == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u7269\u6599\u3001\u4e1a\u52a1\u7ec4\u7ec7\u3001\u7269\u6599\u5c5e\u6027\u3001\u8ba1\u5212\u8303\u56f4\u56db\u4e2a\u6c47\u603b\u7ef4\u5ea6\u3002", (String)"SummaryListRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
                        this.getModel().beginInit();
                        if (propertyValueCDDE != null) {
                            propertyValueCDDE.beginInit();
                            propertyValueCDDE.set(SHOWKEYCOLS, (Object)"material,materialattr,org,planscope");
                            propertyValueCDDE.endInit();
                        }
                        this.getModel().endInit();
                        this.getView().updateView(SHOWKEYCOLS);
                        continue;
                    }
                    if (this.checkShowkeycols(newValue.toString())) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u7269\u6599\u3001\u4e1a\u52a1\u7ec4\u7ec7\u3001\u7269\u6599\u5c5e\u6027\u3001\u8ba1\u5212\u8303\u56f4\u56db\u4e2a\u6c47\u603b\u7ef4\u5ea6\u3002", (String)"SummaryListRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)SHOWKEYCOLS, (Object)oldValue);
                }
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Boolean calshowtotal;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if ("exportexcel".equals(operateKey) && (calshowtotal = (Boolean)this.getModel().getValue("calshowtotal")).booleanValue()) {
            args.setCancel(Boolean.TRUE.booleanValue());
            ReportList list = (ReportList)this.getControl("reportlistap");
            try {
                this.exportList(list);
            }
            catch (IOException e) {
                logger.error("\u5bfc\u51faMRP\u6c47\u603b\u6e05\u5355\u62a5\u9519\uff1a", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportList(ReportList reportList) throws IOException {
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"GrossDemandRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
        ReportListProxy reportListProxy = reportList.getReportListProxy();
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook();
            SXSSFSheet sheet = workbook.createSheet();
            SummaryListExporter summaryListExporter = new SummaryListExporter();
            summaryListExporter.export(workbook, sheet, reportList, reportListProxy, this.getPageCache());
            outStream = new ByteArrayOutputStream();
            workbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            Date now = new Date();
            String nowStr = DateUtils.formatExportDate((Date)now);
            String userName = RequestContext.get().getUserName();
            String tempUrl = cache.saveAsUrl(String.format(ResManager.loadKDString((String)"MRP\u6c47\u603b\u6e05\u5355-%1$s-%2$s.xlsx", (String)"SummaryListRptPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]), nowStr, userName), (InputStream)inStream, timeout);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
            outStream.close();
            inStream.close();
            workbook.close();
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
            if (workbook != null) {
                workbook.close();
            }
        }
        this.getView().hideLoading();
    }

    public void afterSetModelValue(DynamicObject scheme) {
        if (scheme != null) {
            DynamicObjectCollection materiaNumFrom;
            DynamicObject dataEntity = this.getModel().getDataEntity();
            DynamicObjectCollection materialGrpFrom = dataEntity.getDynamicObjectCollection(M_MATERIALGROUPBEGIN);
            if (materialGrpFrom.size() > 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{M_MATERIALGROUPEND});
            }
            if ((materiaNumFrom = dataEntity.getDynamicObjectCollection(M_MATERIALBEGIN)).size() > 1) {
                this.getView().setEnable(Boolean.FALSE, new String[]{M_MATERIALEND});
            }
        }
    }

    @Override
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.handleResetButtonEvent();
    }

    protected void handleResetButtonEvent() {
        this.getView().setEnable(Boolean.TRUE, new String[]{M_MATERIALGROUPEND, M_MATERIALEND});
    }
}

