/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.productlineschedule;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.dataset.AbstractRow;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.report.ReportList;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mmc.mrp.pls.model.OrderMaterialMananger;
import kd.mmc.mrp.pls.model.PLSOrder;
import kd.mmc.mrp.pls.model.WorkCenter;
import kd.mmc.mrp.pls.model.WorkCenterManager;
import kd.mmc.mrp.report.productlineschedule.PLSResultSheetHandle;
import kd.mmc.mrp.rpt.entity.PlsResultEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class PLSResultRptImportPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(PLSResultRptImportPlugin.class);
    private static final String algoKey = "PLSResultRptImportPlugin";
    private static final int MAX_COLWIDTH = 11663;
    private Map<Object, Map<String, Object>> materials;
    private Map<Object, Map<String, Object>> workcenters;
    private Map<Object, Map<String, Object>> orderTypes;
    private Map<Object, Map<String, Object>> orgs;
    private List<List<Object>> dataSourceConfigs;
    private String materialEntityName = "bd_material";
    private String workcentreEntityName = "mpdm_workcentre";
    private String entityobjectEntityName = "bos_entityobject";
    private String orgEntityName = "bos_org";
    private long createorg;
    private boolean isClassSystem;
    private long classSystemId;
    private long workShiftId;
    private long orderModelId;
    private String schemeNumber;
    private Map<Object, List<Map<String, Object>>> fieldMappings = new HashMap<Object, List<Map<String, Object>>>(4);
    private Map<Object, String> selectFieldMappings = new HashMap<Object, String>(4);
    private Map<String, PLSOrder> plsOrderMap = new HashMap<String, PLSOrder>(16);
    private Map<String, Boolean> workcenterContainMaterielMap = new HashMap<String, Boolean>(16);
    private Map<String, DynamicObjectCollection> materialInfoMap = new HashMap<String, DynamicObjectCollection>(16);
    private static ThreadPool plsResultImport = ThreadPools.newFixedThreadPool((String)"PLSResultImport", (int)6);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", "btndetail", "btndownload"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndetail", "progressbarap"});
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = this.getProgress();
        ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
        if (progress == 0) {
            this.setProgress(1);
            this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"PLSResultRptImportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            plsResultImport.execute(() -> this.dealImport());
            return;
        }
        boolean completed = this.isCompleted();
        boolean error = this.isError();
        String errorMsgs = this.getPageCache().get("errorMsgs");
        if (error) {
            progressBar.stop();
            String errorMsg = this.getErrorMsg();
            this.getView().hideLoading();
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.getView().showErrorNotification(errorMsg);
                if (errorMsg.contains(ResManager.loadKDString((String)"\u8be6\u60c5", (String)"PLSResultRptImportPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]))) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"btndetail"});
                }
            }
            if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)errorMsgs)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38", (String)"PLSResultRptImportPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]), errorMsgs, null);
            }
        } else if (completed) {
            progressBar.stop();
            this.getView().hideLoading();
            this.getView().returnDataToParent((Object)"success");
            String msg = this.getPageCache().get("completeMsg");
            this.getView().showMessage(msg, MessageTypes.Default, new ConfirmCallBackListener("completed"));
        } else {
            String tip = this.getTip();
            this.getView().showProgressLoading(new LocaleString(tip), progress);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        String callbackid = event.getCallBackId();
        if (kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"completed", (CharSequence)callbackid) && event.getResult().equals((Object)MessageBoxResult.Cancel)) {
            ReportList reportlistap = (ReportList)this.getView().getParentView().getControl("reportlistap");
            reportlistap.refresh();
            this.getView().close();
        }
    }

    private void setCompleted(int addSize, int updateSize) {
        this.getPageCache().put("complete", String.valueOf(true));
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff1a", (String)"PLSResultRptImportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
        if (addSize > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u65b0\u589e%s\u6761\u6570\u636e\u3002", (String)"PLSResultRptImportPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]), addSize));
        }
        if (updateSize > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u66f4\u65b0%s\u6761\u6570\u636e\u3002", (String)"PLSResultRptImportPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]), updateSize));
        }
        this.getPageCache().put("completeMsg", msg.toString());
    }

    private String getTip() {
        return this.getPageCache().get("tip");
    }

    private String getErrorMsg() {
        return this.getPageCache().get("errorMsg");
    }

    private boolean isCompleted() {
        String finish = this.getPageCache().get("complete");
        return !kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)finish) && Boolean.parseBoolean(finish);
    }

    private boolean isError() {
        String error = this.getPageCache().get("error");
        return !kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)error) && Boolean.parseBoolean(error);
    }

    private void dealImport() {
        try (InputStream inputStream = this.getInputStream();){
            PlsResultEntity entity;
            int index;
            ExcelReader excelReader = new ExcelReader();
            PLSResultSheetHandle handle = new PLSResultSheetHandle();
            excelReader.read(inputStream, (SheetHandler)handle);
            ArrayList<PlsResultEntity> resultList = handle.getResult();
            resultList = resultList == null ? new ArrayList<PlsResultEntity>(0) : resultList;
            Map<Integer, Object[]> errorMsgs = handle.getErrorMsgs();
            if (resultList.isEmpty() && errorMsgs.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u89e3\u6790\u5230\u6570\u636e\u3002", (String)"PLSResultRptImportPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
            if (resultList.size() > 50000) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6761\u6570\u5fc5\u987b\u5c0f\u4e8e50000\u6761\u3002", (String)"PLSResultRptImportPlugin_7", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
            long plsSchemeId = this.getPlsScheme();
            DynamicObjectCollection workshifts = this.getWorkShifts();
            Set<String> workShiftNumbers = workshifts.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
            for (PlsResultEntity entity2 : resultList) {
                int index2 = entity2.getRowNum();
                this.checkBaseDate(entity2, errorMsgs, index2, workshifts, workShiftNumbers, handle);
            }
            this.throwErrorMsg(errorMsgs);
            this.setProgress(20);
            this.checkImportDataRepeat(resultList, errorMsgs);
            this.throwErrorMsg(errorMsgs);
            this.setProgress(50);
            ArrayList<PlsResultEntity> sysResultList = new ArrayList<PlsResultEntity>();
            LinkedList<Object[]> updateDatas = new LinkedList<Object[]>();
            LinkedList<Object[]> addDatas = new LinkedList<Object[]>();
            String plsLogNo = (String)this.getView().getParentView().getModel().getValue("plsoperationno");
            int resultSize = resultList.size();
            ORM orm = ORM.create();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            for (int i = 0; i < resultSize && !this.ignoreError(errorMsgs, index = (entity = (PlsResultEntity)resultList.get(i)).getRowNum().intValue()); ++i) {
                Long materielid = entity.getMaterielId();
                String sourceorderbillno = entity.getSourceOrderBillNo() == null ? "" : entity.getSourceOrderBillNo();
                String sourceordertype = entity.getSourceOrderType() == null ? "" : entity.getSourceOrderType();
                Long workcentre = entity.getWorkcentreId();
                Date plsDate = entity.getPlsdate();
                Long worktimeid = entity.getWorkShiftId();
                Integer order = entity.getProductionOrder();
                if (workcentre == null || plsDate == null || worktimeid == null || materielid == null || order == null) continue;
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)sourceorderbillno) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sourceordertype) || kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)sourceorderbillno) && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)sourceordertype)) {
                    this.fillErrorMsg(errorMsgs, index, ResManager.loadKDString((String)"\u6e90\u8ba2\u5355\u7f16\u53f7\u548c\u6765\u6e90\u8ba2\u5355\u7c7b\u578b\u7f16\u7801\u5e94\u4e3a\u7a7a\u6216\u540c\u65f6\u6709\u503c\u3002", (String)"PLSResultRptImportPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    continue;
                }
                this.getAllResultByLogNo(sysResultList);
                if (!CollectionUtils.isEmpty(sysResultList)) {
                    int plsLength = sysResultList.size();
                    for (int j = 0; j < plsLength; ++j) {
                        PlsResultEntity sysEntity = (PlsResultEntity)sysResultList.get(j);
                        String status1 = sysEntity.getStatus();
                        boolean isSameData = kd.bos.dataentity.utils.StringUtils.equals((CharSequence)"B", (CharSequence)status1) ? false : entity.equals((Object)sysEntity);
                        boolean isSameOrderData = entity.equalsOrder((Object)sysEntity);
                        if (!isSameData && isSameOrderData) {
                            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801\uff1a%1$s\u3001\u8ba1\u5212\u751f\u4ea7\u65e5\u671f\uff1a%2$s\u3001\u5f00\u59cb\u65f6\u95f4\uff1a%3$s\u3001\u7ed3\u675f\u65f6\u95f4\uff1a%4$s\u7ec4\u5408\u5728\u7cfb\u7edf\u6570\u636e\u4e2d\u5b58\u5728\u91cd\u590d\u751f\u4ea7\u987a\u5e8f\u3002", (String)"PLSResultRptImportPlugin_12", (String)"mmc-mrp-report", (Object[])new Object[0]), sysEntity.getWorkcentre(), sdf.format(plsDate), this.secondToTime(sysEntity.getWorkStartTime()), this.secondToTime(sysEntity.getWorkEndTime())));
                        }
                        if (!isSameData) continue;
                        entity.setId(sysEntity.getId());
                        break;
                    }
                }
                if (entity.getId() == null) {
                    boolean rightData = this.checkNewData(entity, index, errorMsgs);
                    if (!rightData || errorMsgs.get(index) != null) continue;
                    Object[] addData = this.createAddData(entity, plsSchemeId, plsLogNo, orm);
                    addDatas.add(addData);
                    continue;
                }
                if (errorMsgs.get(index) != null) continue;
                Object[] updateData = this.createUpdateData(entity);
                updateDatas.add(updateData);
            }
            this.throwErrorMsg(errorMsgs);
            this.setProgress(80);
            this.saveToDB(addDatas, updateDatas);
            this.updateOrderRemainQty(plsLogNo, plsSchemeId);
            this.setCompleted(addDatas.size(), updateDatas.size());
            logger.info("prase the import excel finish");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u5165\u5931\u8d25" + e);
            this.setError(e.getMessage());
        }
    }

    private void checkImportDataRepeat(List<PlsResultEntity> resultList, Map<Integer, Object[]> errorMsgs) {
        Map<String, List<PlsResultEntity>> orderMap;
        StringBuilder sameDataErrorMsg = null;
        StringBuilder sameOrderErrorMsg = null;
        Map<String, List<PlsResultEntity>> collect = resultList.stream().collect(Collectors.groupingBy(x -> x.getSourceOrderBillNo() + x.getSourceOrderType() + x.getMaterielId() + x.getWorkcentreId() + x.getPlsdate() + x.getWorkStartTime() + x.getWorkEndTime()));
        if (collect.size() != resultList.size()) {
            for (List<PlsResultEntity> value : collect.values()) {
                if (value.size() <= 1) continue;
                if (sameDataErrorMsg == null) {
                    sameDataErrorMsg = new StringBuilder(ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u201c\u6765\u6e90\u5355\u636e\u7f16\u7801+\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7f16\u7801+\u7269\u6599\u7f16\u7801+\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801+\u8ba1\u5212\u751f\u4ea7\u65e5\u671f+\u73ed\u6b21\u5f00\u59cb\u65f6\u95f4+\u73ed\u6b21\u7ed3\u675f\u65f6\u95f4+\u63a8\u5355\u72b6\u6001-\u672a\u63a8\u5355\u201d\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u6570\u636e,\u884c\u53f7\u4e3a", (String)"PLSResultRptImportPlugin_43", (String)"mmc-mrp-report", (Object[])new Object[0]));
                }
                List repeatRowNum = value.stream().map(x -> x.getRowNum() + 1).collect(Collectors.toList());
                sameDataErrorMsg.append(StringUtils.join(repeatRowNum, (String)",")).append('\n');
            }
        }
        if ((orderMap = resultList.stream().collect(Collectors.groupingBy(x -> Integer.toString(x.getProductionOrder()) + x.getWorkcentreId() + x.getPlsdate() + x.getWorkShiftId() + x.getWorkStartTime() + x.getWorkEndTime()))).size() != resultList.size()) {
            for (List<PlsResultEntity> value : orderMap.values()) {
                if (value.size() <= 1) continue;
                if (sameOrderErrorMsg == null) {
                    sameOrderErrorMsg = new StringBuilder(ResManager.loadKDString((String)"\u6587\u4ef6\u4e2d\u201c\u6765\u6e90\u5355\u636e\u7f16\u7801+\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7f16\u7801+\u7269\u6599\u7f16\u7801+\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801+\u8ba1\u5212\u751f\u4ea7\u65e5\u671f+\u73ed\u6b21\u5f00\u59cb\u65f6\u95f4+\u73ed\u6b21\u7ed3\u675f\u65f6\u95f4+\u63a8\u5355\u72b6\u6001-\u672a\u63a8\u5355\u201d\u7ec4\u5408\u5b58\u5728\u91cd\u590d\u6570\u636e,\u884c\u53f7\u4e3a", (String)"PLSResultRptImportPlugin_43", (String)"mmc-mrp-report", (Object[])new Object[0]));
                }
                List repeatRowNum = value.stream().map(x -> x.getRowNum() + 1).collect(Collectors.toList());
                sameOrderErrorMsg.append(StringUtils.join(repeatRowNum, (String)",")).append('\n');
            }
        }
        if (sameDataErrorMsg != null) {
            this.fillRepeatErrorMsg(errorMsgs, 2, sameDataErrorMsg);
        }
        if (sameOrderErrorMsg != null) {
            this.fillRepeatErrorMsg(errorMsgs, 3, sameOrderErrorMsg);
        }
    }

    private DynamicObjectCollection getWorkShifts() {
        QFilter[] filters;
        String selectFields;
        ArrayList<Long> workShiftIdList = new ArrayList<Long>();
        if (this.classSystemId != 0L) {
            selectFields = "entryentity.workshift";
            filters = new QFilter[]{new QFilter("id", "in", (Object)this.classSystemId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1"), BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_classsystem", (Long)this.createorg)};
            try (DataSet dataSet = ORM.create().queryDataSet("queryWorkShift", "mpdm_classsystem", selectFields, filters);){
                for (Row row : dataSet) {
                    workShiftIdList.add(row.getLong(0));
                }
            }
        } else {
            workShiftIdList.add(this.workShiftId);
        }
        selectFields = "id, number, entryentity.workstarttime workstarttime, entryentity.workendtime workendtime";
        filters = new QFilter[]{new QFilter("id", "in", workShiftIdList), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1"), BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workshifts", (Long)this.createorg)};
        String orderBy = "entryentity.workstarttime asc";
        DynamicObjectCollection workshifts = QueryServiceHelper.query((String)"mpdm_workshifts", (String)selectFields, (QFilter[])filters, (String)orderBy);
        return workshifts;
    }

    private void updateOrderRemainQty(String plsLogNo, long plsSchemeId) {
        HashMap<String, BigDecimal> sourceNoToQtyMap = new HashMap<String, BigDecimal>();
        QFilter detailQFilter = new QFilter("pls_operationno", "=", (Object)plsLogNo);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"query_pls_detail", (String)"mrp_pls_detail", (String)"entryentity.source_order_billno, entryentity.source_order_type, entryentity.order_initial_qty", (QFilter[])detailQFilter.toArray(), null);){
            for (Row row : dataSet) {
                sourceNoToQtyMap.computeIfAbsent(row.getString(0) + "_" + row.getString(1), key -> row.getBigDecimal(2));
            }
        }
        QFilter resultQFilter = new QFilter("pls_operationno", "=", (Object)plsLogNo);
        String orderBy = "pls_date, workstarttime";
        DynamicObject[] plsResults = BusinessDataServiceHelper.load((String)"mrp_pls_result", (String)"work_pls_qty, source_order_billno, source_order_type, order_initial_qty, order_remaining_qty, materiel_code, workcentre, production_org, pls_date, workstarttime, id", (QFilter[])resultQFilter.toArray(), (String)orderBy);
        Map<String, List<DynamicObject>> billNoToResultList = Arrays.stream(plsResults).collect(Collectors.groupingBy(plsResult -> plsResult.getString("source_order_billno") + "_" + plsResult.getString("source_order_type")));
        WorkCenterManager workCenterManager = new WorkCenterManager();
        this.initWorkCenterCalcResult(plsSchemeId, workCenterManager);
        OrderMaterialMananger orderMaterialMananger = new OrderMaterialMananger();
        String selectFields = "matcategoryentry.category category, matcategoryentry.materialgroup materialgroup_id, matcategoryentry.material material_id, matcategoryentry.material.masterid masterid, matcategoryentry.createorg_1 createorg_1_id, matcategoryentry.workcentersubentry.workcenter workcenter_id, matcategoryentry.workcentersubentry.priority priority";
        orderBy = "matcategoryentry.workcentersubentry.priority desc";
        HashSet groupIdSet = new HashSet();
        StringBuilder sb = new StringBuilder(50);
        QFilter schemeQFilter = new QFilter("id", "=", (Object)plsSchemeId);
        Throwable object = null;
        try (DataSet dataSet = ORM.create().queryDataSet("import_getMidAndWorkCenter", "mrp_pls_scheme", selectFields, schemeQFilter.toArray(), orderBy);){
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                orderMaterialMananger.init(row, workCenterManager);
                workCenterManager.initMaterial(groupIdSet, row, sb);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            throw throwable;
        }
        workCenterManager.initMaterialGroup(groupIdSet);
        for (Map.Entry entry : billNoToResultList.entrySet()) {
            List list = (List)entry.getValue();
            long workcentreNum = list.stream().map(x -> x.getLong("workcentre_id")).count();
            if (workcentreNum == 1L) continue;
            Map<Long, List<DynamicObject>> workcentreToResultMap = list.stream().collect(Collectors.groupingBy(x -> x.getLong("workcentre_id")));
            DynamicObject dynamicObject = (DynamicObject)list.get(0);
            String midAndProdOrgId = Long.toString(dynamicObject.getLong("materiel_code_id")).concat("_").concat(Long.toString(dynamicObject.getLong("production_org_id")));
            Long orderModelKey = orderMaterialMananger.getOrderModelKey(workCenterManager, midAndProdOrgId, dynamicObject.getLong("materiel_code_id"));
            List workCenters = orderMaterialMananger.get(orderModelKey);
            ArrayList<DynamicObject> resultListSort = new ArrayList<DynamicObject>(list.size());
            for (WorkCenter workCenter : workCenters) {
                List<DynamicObject> workCenterResultList = workcentreToResultMap.get(workCenter.getId());
                if (CollectionUtils.isEmpty(workCenterResultList)) continue;
                resultListSort.addAll(workCenterResultList);
            }
            billNoToResultList.put((String)entry.getKey(), (List<DynamicObject>)resultListSort);
        }
        ArrayList<DynamicObject> updatePlsResultList = new ArrayList<DynamicObject>(plsResults.length);
        for (Map.Entry<String, List<DynamicObject>> entry : billNoToResultList.entrySet()) {
            List<DynamicObject> resultList = entry.getValue();
            BigDecimal remainQty = BigDecimal.ZERO;
            for (int i = 0; i < resultList.size(); ++i) {
                DynamicObject plsResult2 = resultList.get(i);
                if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)plsResult2.getString("source_order_billno")) || kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)plsResult2.getString("source_order_type_id"))) continue;
                String billNoAndTypeString = plsResult2.getString("source_order_billno") + "_" + plsResult2.getString("source_order_type_id");
                BigDecimal orderQty = (BigDecimal)sourceNoToQtyMap.get(billNoAndTypeString);
                if (orderQty == null) {
                    logger.info("\u672a\u83b7\u53d6\u5230" + billNoAndTypeString + "\u7684\u521d\u59cb\u6570\u91cf");
                    return;
                }
                plsResult2.set("order_initial_qty", (Object)orderQty);
                remainQty = i == 0 ? orderQty.subtract(plsResult2.getBigDecimal("work_pls_qty")) : remainQty.subtract(plsResult2.getBigDecimal("work_pls_qty"));
                plsResult2.set("order_remaining_qty", (Object)remainQty);
                updatePlsResultList.add(plsResult2);
            }
        }
        SaveServiceHelper.update((DynamicObject[])updatePlsResultList.toArray(new DynamicObject[updatePlsResultList.size()]));
    }

    private void initWorkCenterCalcResult(long plsSchemeId, WorkCenterManager workCenterManager) {
        String selectFields = "workcenterentry.workcenter_number workcenter_number_id, workcenterentry.workcenter_number.workshop workshop, workcenterentry.calcresultsubentry.ispartincalc_1 ispartincalc_1, workcenterentry.calcresultsubentry.materialgroup_2 materialgroup_2_id, workcenterentry.calcresultsubentry.material_2 material_2_id, workcenterentry.calcresultsubentry.workstype workstype, workcenterentry.calcresultsubentry.workunits workunits, workcenterentry.calcresultsubentry.precision precision, workcenterentry.calcresultsubentry.completeresult completeresult, workcenterentry.calcresultsubentry.category_2 category_2";
        QFilter schemeQFilter = new QFilter("id", "=", (Object)plsSchemeId);
        try (DataSet dataSet = ORM.create().queryDataSet("import_getCalcResult", "mrp_pls_scheme", selectFields, schemeQFilter.toArray(), null);){
            for (Row row : dataSet) {
                long workCenterId = row.getLong("workcenter_number_id");
                long workShopId = row.getLong("workshop");
                workCenterManager.computeIfAbsent(Long.valueOf(workCenterId), k -> new WorkCenter(workCenterId, workShopId));
            }
        }
    }

    private boolean ignoreError(Map<Integer, Object[]> errorMsgs, int index) {
        return errorMsgs != null && !errorMsgs.containsKey(index) && errorMsgs.size() > 100;
    }

    private void checkBaseDate(PlsResultEntity entity, Map<Integer, Object[]> errorMsgs, int index, DynamicObjectCollection workshifts, Set<String> workShiftNumbers, PLSResultSheetHandle handle) {
        this.checkExisOrg(entity, errorMsgs, index, handle.getOrgNumbers());
        if (this.isClassSystem) {
            this.checkWorkShift(entity, errorMsgs, index, workShiftNumbers);
        }
        this.checkWorkTime(entity, workshifts, errorMsgs, index);
        this.checkExistMateriel(entity, errorMsgs, index, handle);
        this.checkExistOrderType(entity, errorMsgs, index, handle.getSourceOrderTypeNumbers());
        this.checkExistWorkcenter(entity, errorMsgs, index, handle);
    }

    private void checkWorkShift(PlsResultEntity entity, Map<Integer, Object[]> errorMsgs, int index, Set<String> workShiftNumbers) {
        String workshift = entity.getWorkShift();
        if (!workShiftNumbers.contains(workshift)) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u73ed\u6b21\u7f16\u7801\u201c%s\u201d\u672a\u5728\u6392\u7a0b\u65b9\u6848\u4e2d\u7ef4\u62a4\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_44", (String)"mmc-mrp-report", (Object[])new Object[0]), workshift));
        }
    }

    private String secondToTime(int second) {
        if (second < 0) {
            return "00:00:00";
        }
        String hour = String.format("%02d", second / 60 / 60);
        String minute = String.format("%02d", second / 60 % 60);
        String remainingSeconds = String.format("%02d", second % 60);
        return hour + ":" + minute + ":" + remainingSeconds;
    }

    private void saveToDB(List<Object[]> addDatas, List<Object[]> updateDatas) {
        int toIndex;
        int fromIndex;
        int i;
        DBRoute dbRoute = DBRoute.of((String)EntityMetadataCache.getDataEntityType((String)"mrp_pls_result").getDBRouteKey());
        int addSize = addDatas.size();
        int updateSize = updateDatas.size();
        BigDecimal total = new BigDecimal(addSize + updateSize);
        int batchSize = 100;
        int loopTimes = addSize / batchSize;
        if (loopTimes * batchSize < addSize) {
            ++loopTimes;
        }
        List<Object[]> batchList = null;
        for (i = 0; i < loopTimes; ++i) {
            fromIndex = i * batchSize;
            toIndex = Math.min((i + 1) * batchSize, addSize);
            batchList = fromIndex == 0 && toIndex == addSize ? addDatas : addDatas.subList(fromIndex, toIndex);
            this.insertNewDatas(batchList, dbRoute);
        }
        loopTimes = updateSize / batchSize;
        if (loopTimes * batchSize < updateSize) {
            ++loopTimes;
        }
        this.setProgress(80);
        for (i = 0; i < loopTimes; ++i) {
            fromIndex = i * batchSize;
            toIndex = Math.min((i + 1) * batchSize, updateSize);
            batchList = fromIndex == 0 && toIndex == addSize ? updateDatas : updateDatas.subList(fromIndex, toIndex);
            this.updateDatas(batchList, dbRoute);
        }
    }

    private Object[] createUpdateData(PlsResultEntity entity) {
        Object[] updateData = new Object[]{entity.getWorkPlsQty(), entity.getProductionOrder(), RequestContext.get().getCurrUserId(), new Date(), entity.getId()};
        return updateData;
    }

    private Long getWorktimeId(DynamicObjectCollection workshifts, int workstarttime, int workendtime) {
        Long id = null;
        boolean rightTime = false;
        for (DynamicObject workTime : workshifts) {
            int starttime = workTime.getInt("workstarttime");
            int endtime = workTime.getInt("workendtime");
            if (workendtime < workstarttime) {
                workendtime = 86400 + workendtime;
            }
            if (endtime < starttime) {
                endtime = 86400 + endtime;
            }
            if (workstarttime < starttime || workendtime > endtime) continue;
            rightTime = true;
            id = workTime.getLong("id");
            break;
        }
        return id;
    }

    private boolean checkWorkTime(PlsResultEntity entity, DynamicObjectCollection workshifts, Map<Integer, Object[]> errorMsgs, int index) {
        if (entity.getWorkStartTime() == null || entity.getWorkEndTime() == null) {
            return false;
        }
        Integer workstarttime = entity.getWorkStartTime();
        Integer workendtime = entity.getWorkEndTime();
        if (workendtime < workstarttime) {
            workendtime = 86400 + workendtime;
        }
        if (workshifts == null || workshifts.isEmpty()) {
            this.fillErrorMsg(errorMsgs, index, ResManager.loadKDString((String)"\u6392\u7a0b\u65b9\u6848\u73ed\u6b21\u65e0\u73ed\u6b21\u65f6\u95f4\u3002", (String)"PLSResultRptImportPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        boolean rightTime = false;
        for (DynamicObject workTime : workshifts) {
            int starttime = workTime.getInt("workstarttime");
            int endtime = workTime.getInt("workendtime");
            if (endtime < starttime) {
                endtime = 86400 + endtime;
            }
            if (workstarttime < starttime || workendtime > endtime) continue;
            rightTime = true;
            entity.setWorkShiftId(Long.valueOf(workTime.getLong("id")));
            break;
        }
        if (!rightTime) {
            this.fillErrorMsg(errorMsgs, index, ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u7ed3\u675f\u65f6\u95f4\u4e0d\u5728\u73ed\u6b21\u65f6\u95f4\u8303\u56f4\u5185\u3002", (String)"PLSResultRptImportPlugin_14", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        return rightTime;
    }

    private boolean checkExisOrg(PlsResultEntity entity, Map<Integer, Object[]> errorMsgs, int index, Set<String> orgNumbers) {
        String orgNumber = entity.getProductionOrg();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)orgNumber)) {
            return false;
        }
        Map<Object, Map<String, Object>> orgs = this.geOrgByNumbers(orgNumbers);
        if (orgs == null) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0]), orgNumber));
            return false;
        }
        boolean exist = false;
        Map<String, Object> value = orgs.get(orgNumber);
        if (value != null) {
            exist = true;
            entity.setProductionOrgId((Long)value.get("id"));
            entity.setProductionOrgName((String)value.get("name"));
        }
        if (!exist) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0]), orgNumber));
        }
        return exist;
    }

    private boolean checkExistWorkcenter(PlsResultEntity entity, Map<Integer, Object[]> errorMsgs, int index, PLSResultSheetHandle handle) {
        String workcentercode = entity.getWorkcentre();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)workcentercode)) {
            return false;
        }
        Map<Object, Map<String, Object>> workcenters = this.getWorkcenterByNumbers(handle);
        if (workcenters == null) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_16", (String)"mmc-mrp-report", (Object[])new Object[0]), workcentercode));
            return false;
        }
        boolean exist = false;
        Map<String, Object> value = workcenters.get(workcentercode);
        if (value != null) {
            exist = true;
            entity.setWorkcentreId((Long)value.get("id"));
            entity.setWorkcentreName((String)value.get("name"));
            entity.setWorkShopId((Long)value.get("workshop"));
        }
        if (!exist) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_16", (String)"mmc-mrp-report", (Object[])new Object[0]), workcentercode));
        }
        return exist;
    }

    private boolean checkExistOrderType(PlsResultEntity entity, Map<Integer, Object[]> errorMsgs, int index, Set<String> materielNumbers) {
        String orderType = entity.getSourceOrderType();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)orderType)) {
            return false;
        }
        Map<Object, Map<String, Object>> orderTypes = this.getOrderTypesByNumbers(materielNumbers);
        if (orderTypes == null) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_17", (String)"mmc-mrp-report", (Object[])new Object[0]), orderType));
            return false;
        }
        boolean exist = false;
        Map<String, Object> value = orderTypes.get(orderType);
        if (value != null) {
            exist = true;
        }
        if (!exist) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_17", (String)"mmc-mrp-report", (Object[])new Object[0]), orderType));
        }
        return exist;
    }

    private boolean checkExistMateriel(PlsResultEntity entity, Map<Integer, Object[]> errorMsgs, int index, PLSResultSheetHandle handle) {
        String materialCode = entity.getMaterielCode();
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)materialCode)) {
            return false;
        }
        Map<Object, Map<String, Object>> materials = this.getMaterialsByNumbers(handle);
        if (materials == null) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_18", (String)"mmc-mrp-report", (Object[])new Object[0]), materialCode));
            return false;
        }
        boolean exist = false;
        Map<String, Object> value = materials.get(materialCode);
        if (value != null) {
            entity.setMaterielId((Long)value.get("id"));
            entity.setUnitId((Long)value.get("baseunit"));
            entity.setMaterielName((String)value.get("name"));
            exist = true;
        }
        if (!exist) {
            this.fillErrorMsg(errorMsgs, index, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_18", (String)"mmc-mrp-report", (Object[])new Object[0]), materialCode));
        }
        return false;
    }

    private Map<Object, Map<String, Object>> geOrgByNumbers(Set<String> orgNumbers) {
        if (this.orgs != null) {
            return this.orgs;
        }
        HashMap<Object, Map<String, Object>> resultDatas = null;
        QFilter qFilter = new QFilter("number", "in", orgNumbers);
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        try (DataSet result = ORM.create().queryDataSet(algoKey, this.orgEntityName, "id,number,name", qFilter.toArray());){
            if (result != null && !result.isEmpty()) {
                resultDatas = new HashMap<Object, Map<String, Object>>();
                for (Row row : result) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("id", row.get(0));
                    data.put("number", row.get(1));
                    data.put("name", row.get(2));
                    resultDatas.put(row.get(1), data);
                }
            }
        }
        this.orgs = resultDatas != null && !resultDatas.isEmpty() ? resultDatas : Maps.newHashMapWithExpectedSize((int)0);
        return this.orgs;
    }

    private Map<Object, Map<String, Object>> getWorkcenterByNumbers(PLSResultSheetHandle handle) {
        if (this.workcenters != null) {
            return this.workcenters;
        }
        HashMap<Object, Map<String, Object>> resultDatas = null;
        Map<String, Set<String>> orgToWorkcentreNumberMap = handle.getOrgToWorkcentreNumberMap();
        Set<String> orgNumbers = handle.getOrgNumbers();
        Map<Object, Map<String, Object>> orgs = this.geOrgByNumbers(orgNumbers);
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        int i = 0;
        for (Map.Entry<String, Set<String>> orgToWorkcenterNumberEntry : orgToWorkcentreNumberMap.entrySet()) {
            String org = orgToWorkcenterNumberEntry.getKey();
            Set<String> workcenterNumbers = orgToWorkcenterNumberEntry.getValue();
            QFilter qFilterNumber = new QFilter("number", "in", workcenterNumbers);
            if (orgs == null || orgs.get(org) == null) continue;
            qFilterNumber.and(BaseDataServiceHelper.getBaseDataFilter((String)this.workcentreEntityName, (Long)((Long)orgs.get(org).get("id"))));
            if (i == 0) {
                qFilter.and(qFilterNumber);
            } else {
                qFilter.or(qFilterNumber);
            }
            ++i;
        }
        try (DataSet result = ORM.create().queryDataSet(algoKey, this.workcentreEntityName, "id,number,name,workshop", qFilter.toArray());){
            if (result != null && !result.isEmpty()) {
                resultDatas = new HashMap<Object, Map<String, Object>>();
                for (Row row : result) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("id", row.get(0));
                    data.put("number", row.get(1));
                    data.put("name", row.get(2));
                    data.put("workshop", row.get(3));
                    resultDatas.put(row.get(1), data);
                }
            }
        }
        this.workcenters = resultDatas != null && !resultDatas.isEmpty() ? resultDatas : Maps.newHashMapWithExpectedSize((int)0);
        return this.workcenters;
    }

    private Map<Object, Map<String, Object>> getOrderTypesByNumbers(Set<String> orderTypeNumbers) {
        if (this.orderTypes != null) {
            return this.orderTypes;
        }
        HashMap<Object, Map<String, Object>> resultDatas = null;
        QFilter qFilter = new QFilter("id", "in", orderTypeNumbers);
        try (DataSet result = ORM.create().queryDataSet(algoKey, this.entityobjectEntityName, "id,number", qFilter.toArray());){
            if (result != null && !result.isEmpty()) {
                resultDatas = new HashMap<Object, Map<String, Object>>();
                for (Row row : result) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("id", row.get(0));
                    data.put("number", row.get(1));
                    resultDatas.put(row.get(1), data);
                }
            }
        }
        this.orderTypes = resultDatas != null && !resultDatas.isEmpty() ? resultDatas : Maps.newHashMapWithExpectedSize((int)0);
        return this.orderTypes;
    }

    private Map<Object, Map<String, Object>> getMaterialsByNumbers(PLSResultSheetHandle handle) {
        if (this.materials != null) {
            return this.materials;
        }
        Map<String, Set<String>> orgToMaterielNumberMap = handle.getOrgToMaterielNumberMap();
        Set<String> orgNumbers = handle.getOrgNumbers();
        Map<Object, Map<String, Object>> orgs = this.geOrgByNumbers(orgNumbers);
        HashMap<Object, Map<String, Object>> resultDatas = null;
        QFilter qFilter = new QFilter("enable", "=", (Object)"1");
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        int i = 0;
        for (Map.Entry<String, Set<String>> orgToMaterielNumberEntry : orgToMaterielNumberMap.entrySet()) {
            String org = orgToMaterielNumberEntry.getKey();
            Set<String> materielNumbers = orgToMaterielNumberEntry.getValue();
            QFilter qFilterNumber = new QFilter("number", "in", materielNumbers);
            if (orgs == null || orgs.get(org) == null) continue;
            qFilterNumber.and(BaseDataServiceHelper.getBaseDataFilter((String)this.materialEntityName, (Long)((Long)orgs.get(org).get("id"))));
            if (i == 0) {
                qFilter.and(qFilterNumber);
            } else {
                qFilter.or(qFilterNumber);
            }
            ++i;
        }
        try (DataSet result = ORM.create().queryDataSet(algoKey, this.materialEntityName, "id,number,baseunit,name", qFilter.toArray());){
            if (result != null && !result.isEmpty()) {
                resultDatas = new HashMap<Object, Map<String, Object>>();
                for (Row row : result) {
                    HashMap<String, Object> data = new HashMap<String, Object>(4);
                    data.put("id", row.getLong(0));
                    data.put("number", row.getString(1));
                    data.put("baseunit", row.getLong(2));
                    data.put("name", row.getString(3));
                    resultDatas.put(row.get(1), data);
                }
            }
        }
        this.materials = resultDatas != null && !resultDatas.isEmpty() ? resultDatas : Maps.newHashMapWithExpectedSize((int)0);
        return this.materials;
    }

    private void throwErrorMsg(Map<Integer, Object[]> errorMsgs) {
        if (!errorMsgs.isEmpty()) {
            int errorCount;
            Set<Integer> indexKey = errorMsgs.keySet();
            List indexs = indexKey.stream().sorted().collect(Collectors.toList());
            Object[] errorMsgInfo = errorMsgs.get(indexs.get(0));
            int n = errorCount = errorMsgInfo == null ? 0 : (Integer)errorMsgInfo[1];
            if (indexs.size() == 1 && errorCount == 1) {
                StringBuilder msg = (StringBuilder)errorMsgs.get(indexs.get(0))[0];
                throw new KDBizException(msg.toString());
            }
            ArrayList<String> errMsgs = new ArrayList<String>(indexs.size());
            for (Integer index : indexs) {
                Object[] errorMsgInfos = errorMsgs.get(index);
                StringBuilder errorMsg = (StringBuilder)errorMsgInfos[0];
                if (errorMsg.length() > Short.MAX_VALUE) {
                    errorMsg.delete(32764, errorMsg.length()).append("...");
                }
                errMsgs.add(errorMsg.toString());
            }
            this.exportErrorInfo(errMsgs);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef\u65e5\u5fd7\u3002", (String)"PLSResultRptImportPlugin_19", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
    }

    private Object[] createAddData(PlsResultEntity entity, long plsSchemeId, String pslLogNo, ORM orm) {
        Object[] newData = new Object[]{orm.genLongId("mrp_pls_result"), plsSchemeId, pslLogNo, kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)entity.getSourceOrderBillNo()) ? "" : entity.getSourceOrderBillNo(), kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)entity.getSourceOrderType()) ? "" : entity.getSourceOrderType(), entity.getMaterielId(), Objects.isNull(entity.getUnitId()) ? 0L : entity.getUnitId(), entity.getWorkcentreId(), entity.getPlsdate(), entity.getWorkStartTime(), entity.getWorkEndTime(), entity.getWorkPlsQty(), entity.getProductionOrder(), entity.getStatus(), Objects.isNull(entity.getProductionOrgId()) ? 0L : entity.getProductionOrgId(), Objects.isNull(entity.getPlanner()) ? 0L : entity.getPlanner(), RequestContext.get().getCurrUserId(), new Date(), Objects.isNull(entity.getEcnVersion()) ? 0L : entity.getEcnVersion(), entity.getPlanPrepareDate(), Objects.isNull(entity.getBom()) ? 0L : entity.getBom(), Objects.isNull(entity.getYieldRate()) ? BigDecimal.ZERO : entity.getYieldRate(), Objects.isNull(entity.getYieldQty()) ? BigDecimal.ZERO : entity.getYieldQty(), Objects.isNull(entity.getWorkShopId()) ? 0L : entity.getWorkShopId(), entity.getWorkShiftId()};
        return newData;
    }

    private void insertNewDatas(List<Object[]> newDatas, DBRoute dbRoute) {
        StringBuilder insertSql = new StringBuilder("insert into t_mrp_pls_result (");
        insertSql.append("fid,");
        insertSql.append("fplsschemeid,");
        insertSql.append("fplsoperationno,");
        insertSql.append("fsourceorderbillno,");
        insertSql.append("fsourceordertype,");
        insertSql.append("fmaterielcode,");
        insertSql.append("funit,");
        insertSql.append("fworkcentre,");
        insertSql.append("fplsdate,");
        insertSql.append("fworkstarttime,");
        insertSql.append("fworkendtime,");
        insertSql.append("fworkplsqty,");
        insertSql.append("fproductionorder,");
        insertSql.append("fstatus,");
        insertSql.append("fproductionorgid,");
        insertSql.append("fplsplannerid,");
        insertSql.append("fcreater,");
        insertSql.append("fcreatetime,");
        insertSql.append("fecnversion,");
        insertSql.append("fplanpreparedate,");
        insertSql.append("fbom,");
        insertSql.append("fyieldrate,");
        insertSql.append("fyieldqty,");
        insertSql.append("fworkshopid,");
        insertSql.append("fworkshiftid");
        insertSql.append(") values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        if (newDatas != null && !newDatas.isEmpty()) {
            DB.executeBatch((DBRoute)dbRoute, (String)insertSql.toString(), newDatas);
        }
    }

    private long getPlsScheme() {
        long plsSchemeId;
        DynamicObject plsschemeno = (DynamicObject)this.getView().getParentView().getModel().getValue("pls_scheme");
        if (plsschemeno == null) {
            String plsoperationno = (String)this.getView().getParentView().getModel().getValue("plsoperationno");
            if (plsoperationno == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6392\u7a0b\u8fd0\u7b97\u53f7\u4e3a\u7a7a\u3002", (String)"PLSResultRptImportPlugin_20", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
            plsSchemeId = this.getPLSSchemeByLogNo(plsoperationno);
        } else {
            plsSchemeId = (Long)plsschemeno.getPkValue();
        }
        if (plsSchemeId == 0L) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6392\u7a0b\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"PLSResultRptImportPlugin_21", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        QFilter qFilter = new QFilter("id", "=", (Object)plsSchemeId);
        DynamicObject plsScheme = QueryServiceHelper.queryOne((String)"mrp_pls_scheme", (String)"id, number, createorg, isclasssystem, classsystem, workshift, ordermodel", (QFilter[])qFilter.toArray());
        if (plsScheme == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u9009\u62e9\u6709\u6548\u7684\u6392\u7a0b\u65b9\u6848\u3002", (String)"PLSResultRptImportPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        this.createorg = plsScheme.getLong("createorg");
        this.isClassSystem = plsScheme.getBoolean("isclasssystem");
        this.classSystemId = plsScheme.getLong("classsystem");
        this.workShiftId = plsScheme.getLong("workshift");
        this.orderModelId = plsScheme.getLong("ordermodel");
        this.schemeNumber = plsScheme.getString("number");
        return plsScheme.getLong("id");
    }

    private long getPLSSchemeByLogNo(String plsoperationno) {
        QFilter qFilter = new QFilter("number", "=", (Object)plsoperationno);
        Object[] logs = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id,plangram", (QFilter[])qFilter.toArray());
        if (ArrayUtils.isEmpty((Object[])logs)) {
            return 0L;
        }
        return logs[0].getLong("plangram");
    }

    private boolean checkSameData(String sourceorderbillno, String sourceorderbillno1, String sourceordertype, String sourceordertype1, Long materielid, Long materielid1, Long workcentre, Long workcentre1, Date plsDate, Date plsDate1, Integer workstarttime, Integer workstarttime1, Integer workendtime, Integer workendtime1) {
        return kd.bos.dataentity.utils.StringUtils.equals((CharSequence)sourceorderbillno, (CharSequence)sourceorderbillno1) && kd.bos.dataentity.utils.StringUtils.equals((CharSequence)sourceordertype, (CharSequence)sourceordertype1) && materielid.longValue() == materielid1.longValue() && workcentre.longValue() == workcentre1.longValue() && DateUtils.isSameDay((Date)plsDate, (Date)plsDate1) && workstarttime.intValue() == workstarttime1.intValue() && workendtime.intValue() == workendtime1.intValue();
    }

    private boolean checkSameOrderData(Long workcentre, Long workcentre1, Date plsDate, Date plsDate1, Long worktimeid, Long worktimeid1, int order, int order1, Integer workstarttime, Integer workstarttime1, Integer workendtime, Integer workendtime1) {
        if (order == 0 || order1 == 0) {
            return false;
        }
        return workcentre.longValue() == workcentre1.longValue() && DateUtils.isSameDay((Date)plsDate, (Date)plsDate1) && worktimeid.longValue() == worktimeid1.longValue() && order == order1 && workstarttime.intValue() == workstarttime1.intValue() && workendtime.intValue() == workendtime1.intValue();
    }

    /*
     * Exception decompiling
     */
    private void fillErrorMsg(Map<Integer, Object[]> errorMsgs, int index, CharSequence detailMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void fillRepeatErrorMsg(Map<Integer, Object[]> errorMsgs, int index, CharSequence detailMsg) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void getAllResultByLogNo(List<PlsResultEntity> sysResultList) {
        if (!CollectionUtils.isEmpty(sysResultList)) {
            return;
        }
        String plsoperationno = (String)this.getView().getParentView().getModel().getValue("plsoperationno");
        QFilter plsresultFilter = new QFilter("pls_operationno", "=", (Object)plsoperationno);
        String selectFields = "id,source_order_billno,source_order_type,materiel_code,workcentre,pls_date,workstarttime,workendtime,production_order,status";
        try (DataSet ds = ORM.create().queryDataSet(algoKey, "mrp_pls_result", selectFields, plsresultFilter.toArray());){
            if (ds != null && !ds.isEmpty()) {
                for (Row row : ds) {
                    PlsResultEntity entity = new PlsResultEntity();
                    entity.setId(row.getLong("id"));
                    entity.setSourceOrderBillNo(row.getString("source_order_billno"));
                    entity.setSourceOrderType(row.getString("source_order_type"));
                    entity.setMaterielId(row.getLong("materiel_code"));
                    entity.setWorkcentreId(row.getLong("workcentre"));
                    entity.setPlsdate(row.getDate("pls_date"));
                    entity.setWorkStartTime(row.getInteger("workstarttime"));
                    entity.setWorkEndTime(row.getInteger("workendtime"));
                    entity.setProductionOrder(row.getInteger("production_order"));
                    entity.setStatus(row.getString("status"));
                    sysResultList.add(entity);
                }
            }
        }
    }

    private List<List<Object>> getDataSourceConfigs(Object resourceRegisterId) {
        if (this.dataSourceConfigs != null) {
            return this.dataSourceConfigs;
        }
        String selectFields = "id,billfieldtransfer.id, billfieldtransfer.srcbill";
        QFilter filter1 = new QFilter("cgnumber", "=", resourceRegisterId);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter1, filter2};
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mrp_resource_dataconfig", selectFields, filters);){
            for (Row row : dataSet) {
                ArrayList<Object> values = new ArrayList<Object>(3);
                values.add(row.get(0));
                values.add(row.get(1));
                values.add(row.get(2));
                result.add(values);
            }
        }
        this.dataSourceConfigs = result;
        return this.dataSourceConfigs;
    }

    private int[] updateDatas(List<Object[]> updateDatas, DBRoute dbRoute) {
        StringBuilder updateSql = new StringBuilder("update t_mrp_pls_result set ");
        updateSql.append(" fworkplsqty = ? , ");
        updateSql.append(" fproductionorder = ?, ");
        updateSql.append(" fmodifier = ? ,");
        updateSql.append(" fmodifydate = ? ");
        updateSql.append(" where fid = ?");
        return DB.executeBatch((DBRoute)dbRoute, (String)updateSql.toString(), updateDatas);
    }

    private boolean checkNewData(PlsResultEntity entity, int index, Map<Integer, Object[]> errormsg) {
        DynamicObjectCollection mterialInfos;
        String sourceorderbillno = entity.getSourceOrderBillNo();
        String sourceOrderType = entity.getSourceOrderType();
        Long materielCode = entity.getMaterielId();
        Long orgid = entity.getProductionOrgId();
        String workcentreno = entity.getWorkcentre();
        String productionorg = entity.getProductionOrg();
        String plsschemeno = this.schemeNumber;
        String materiel_code = entity.getMaterielCode();
        boolean result = true;
        Long workcenterid = entity.getWorkcentreId();
        if (workcenterid != null && materielCode != null && !this.checkAvailableWorkcenterAndMateriel(entity)) {
            this.fillErrorMsg(errormsg, index, String.format(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u201c%1$s\u201d\u4e0d\u80fd\u751f\u4ea7\u7269\u6599\u201c%2$s\u201d\u3002", (String)"PLSResultRptImportPlugin_24", (String)"mmc-mrp-report", (Object[])new Object[0]), workcentreno, materiel_code));
            result = false;
        }
        if (orgid != null && materielCode != null && ((mterialInfos = this.getMaterialInfo4Org(materielCode, orgid, "bd_materialmftinfo", "id,masterid")) == null || mterialInfos.isEmpty())) {
            this.fillErrorMsg(errormsg, index, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u4e0e\u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801\u201c%2$s\u201d\u7ec4\u5408\u4e0d\u5b58\u5728\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PLSResultRptImportPlugin_25", (String)"mmc-mrp-report", (Object[])new Object[0]), materiel_code, productionorg));
            result = false;
        }
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)sourceorderbillno) && kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)sourceOrderType)) {
            return result;
        }
        List<List<Object>> dataSourceConfigs = this.getDataSourceConfigs(this.orderModelId);
        if (CollectionUtils.isEmpty(dataSourceConfigs)) {
            this.fillErrorMsg(errormsg, index, String.format(ResManager.loadKDString((String)"%s:\u6392\u7a0b\u65b9\u6848\u4e2d\u8ba2\u5355\u6a21\u578b\u7684\u6570\u636e\u6e90\u914d\u7f6e\u9519\u8bef\u3002", (String)"PLSResultRptImportPlugin_26", (String)"mmc-mrp-report", (Object[])new Object[0]), plsschemeno));
            return false;
        }
        Object fieldMappingId = null;
        List<Map<String, Object>> fieldMappingEntrys = null;
        for (List<Object> config : dataSourceConfigs) {
            String srcbill = (String)config.get(2);
            fieldMappingId = config.get(1);
            if (!sourceOrderType.equals(srcbill)) continue;
            fieldMappingEntrys = this.getFieldMappingEntrys(fieldMappingId);
            break;
        }
        if (fieldMappingEntrys == null) {
            this.fillErrorMsg(errormsg, index, ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u6765\u6e90\u8ba2\u5355\u7c7b\u578b\u8d85\u51fa\u6392\u7a0b\u8303\u56f4\uff0c\u4e14\u6392\u7a0b\u65b9\u6848\u7684\u8ba2\u5355\u6a21\u578b\u4e2d\u65e0\u6cd5\u627e\u5230\u4ee5\u8be5\u884c\u6765\u6e90\u8ba2\u5355\u7c7b\u578b\u4e3a\u6e90\u5b9e\u4f53\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\uff0c\u4e0d\u652f\u6301\u5bfc\u5165\uff0c\u9700\u7ef4\u62a4\u8ba2\u5355\u6a21\u578b\u3002", (String)"PLSResultRptImportPlugin_27", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        String selectField = this.getSelectField(fieldMappingId);
        if (selectField == null || selectField.isEmpty()) {
            this.fillErrorMsg(errormsg, index, ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7c7b\u578b\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u7f3a\u5c11\u5fc5\u987b\u8981\u6620\u5c04\u7684\u5b57\u6bb5\u3002", (String)"PLSResultRptImportPlugin_28", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        PLSOrder formOrder = this.getFromOrder(sourceOrderType, selectField, sourceorderbillno, fieldMappingId);
        if (formOrder == null) {
            this.fillErrorMsg(errormsg, index, String.format(ResManager.loadKDString((String)"%s\uff1a\u6765\u6e90\u5355\u636e\u7f16\u53f7\u4e0d\u5b58\u5728\u6216\u4e3a\u975e\u5df2\u5ba1\u6838\u3001\u53ef\u7528\u72b6\u6001\u3002", (String)"PLSResultRptImportPlugin_29", (String)"mmc-mrp-report", (Object[])new Object[0]), sourceorderbillno));
            return false;
        }
        Long materielid = formOrder.getMaterielId();
        Long unitid = formOrder.getUnit();
        if (materielCode.longValue() != materielid.longValue()) {
            this.fillErrorMsg(errormsg, index, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u4e0e\u6765\u6e90\u5355\u636e\u201c%2$s\u201d\u7269\u6599\u7f16\u7801\u4e0d\u7b26\u3002", (String)"PLSResultRptImportPlugin_30", (String)"mmc-mrp-report", (Object[])new Object[0]), materiel_code, sourceorderbillno));
            result = false;
        }
        entity.setUnitId(unitid == null ? Long.valueOf(0L) : unitid);
        entity.setEcnVersion(formOrder.getEcnVersion() == null ? Long.valueOf(0L) : formOrder.getEcnVersion());
        entity.setPlanPrepareDate(formOrder.getPlanPrepareDate());
        entity.setBom(formOrder.getBom() == null ? Long.valueOf(0L) : formOrder.getBom());
        entity.setYieldRate(formOrder.getProductYieldRate() == null ? BigDecimal.ZERO : formOrder.getProductYieldRate());
        entity.setYieldQty(formOrder.getProductYieldNum() == null ? BigDecimal.ZERO : formOrder.getProductYieldNum());
        entity.setPlanner(formOrder.getPlanner());
        return result;
    }

    private boolean checkAvailableWorkcenterAndMateriel(PlsResultEntity entity) {
        Long workcenterid = entity.getWorkcentreId();
        Long materielid = entity.getMaterielId();
        String key = Long.toString(workcenterid).concat(Long.toString(materielid));
        Boolean contain = this.workcenterContainMaterielMap.get(key);
        if (contain != null) {
            return contain;
        }
        QFilter qFilter = new QFilter("id", "=", (Object)workcenterid);
        qFilter.and(new QFilter("entryproduct.materielf7.masterid", "=", (Object)materielid));
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(algoKey, this.workcentreEntityName, "id", qFilter.toArray());){
            if (!ds.isEmpty()) {
                this.workcenterContainMaterielMap.put(key, Boolean.TRUE);
                boolean bl = true;
                return bl;
            }
        }
        qFilter = new QFilter("id", "=", (Object)workcenterid);
        qFilter.and("entryproduct.producttype", "=", (Object)"C");
        ArrayList<Long> materialgroups = null;
        try (DataSet ds = orm.queryDataSet(algoKey, this.workcentreEntityName, "id,entryproduct.materialgroup", qFilter.toArray());){
            if (ds.isEmpty()) {
                this.workcenterContainMaterielMap.put(key, Boolean.FALSE);
                boolean bl = false;
                return bl;
            }
            materialgroups = new ArrayList<Long>();
            for (Row row : ds) {
                materialgroups.add(row.getLong(1));
            }
        }
        qFilter = new QFilter("mftcontrolentry.materialcontrol", "in", materialgroups);
        qFilter.and("masterid", "=", (Object)materielid);
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        ds = orm.queryDataSet(algoKey, "bd_materialmftinfo", "id", qFilter.toArray());
        var10_13 = null;
        try {
            if (!ds.isEmpty()) {
                this.workcenterContainMaterielMap.put(key, Boolean.TRUE);
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable) {
            var10_13 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var10_13 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var10_13.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        this.workcenterContainMaterielMap.put(key, Boolean.FALSE);
        return false;
    }

    private PLSOrder getFromOrder(String sourceOrderType, String selectField, String sourceorderbillno, Object fieldMappingId) {
        String ploOrderMapKey = sourceOrderType.concat(sourceorderbillno).concat(fieldMappingId.toString());
        PLSOrder plsOrder = this.plsOrderMap.get(ploOrderMapKey);
        if (plsOrder != null) {
            return plsOrder;
        }
        QFilter qFilter = new QFilter("billno", "=", (Object)sourceorderbillno);
        qFilter.and(new QFilter("billstatus", "=", (Object)"C"));
        try (DataSet result = ORM.create().queryDataSet(algoKey, sourceOrderType, selectField, qFilter.toArray());){
            if (result != null && !result.isEmpty()) {
                AbstractRow data = (AbstractRow)result.next();
                plsOrder = new PLSOrder();
                if (data.getRowMeta().getFieldIndex("plan_order_billno", false) > -1) {
                    plsOrder.setPlanOrderNo(data.getString("plan_order_billno"));
                }
                if (data.getRowMeta().getFieldIndex("production_org", false) > -1) {
                    plsOrder.setProductionOrgId(data.getLong("production_org"));
                }
                if (data.getRowMeta().getFieldIndex("materiel_code", false) > -1) {
                    plsOrder.setMaterielId(data.getLong("materiel_code"));
                }
                if (data.getRowMeta().getFieldIndex("order_num", false) > -1) {
                    plsOrder.setOrderNum(data.getBigDecimal("order_num"));
                }
                if (data.getRowMeta().getFieldIndex("unit", false) > -1) {
                    plsOrder.setUnit(data.getLong("unit"));
                }
                if (data.getRowMeta().getFieldIndex("product_yield_rate", false) > -1) {
                    plsOrder.setProductYieldRate(data.getBigDecimal("product_yield_rate"));
                }
                if (data.getRowMeta().getFieldIndex("product_yield_num", false) > -1) {
                    plsOrder.setProductYieldNum(data.getBigDecimal("product_yield_num"));
                }
                if (data.getRowMeta().getFieldIndex("bom", false) > -1) {
                    plsOrder.setBom(data.getLong("bom"));
                }
                if (data.getRowMeta().getFieldIndex("bom_datetime", false) > -1) {
                    plsOrder.setBomDatetime(data.getDate("bom_datetime"));
                }
                if (data.getRowMeta().getFieldIndex("ecn_version", false) > -1) {
                    plsOrder.setEcnVersion(data.getLong("ecn_version"));
                }
                if (data.getRowMeta().getFieldIndex("planner", false) > -1) {
                    plsOrder.setPlanner(data.getLong("planner"));
                }
                if (data.getRowMeta().getFieldIndex("plan_prepare_date", false) > -1) {
                    plsOrder.setPlanPrepareDate(data.getDate("plan_prepare_date"));
                }
                if (data.getRowMeta().getFieldIndex("plan_start_date", false) > -1) {
                    plsOrder.setPlanStartDate(data.getDate("plan_start_date"));
                }
                if (data.getRowMeta().getFieldIndex("plan_finish_date", false) > -1) {
                    plsOrder.setPlanFinishDate(data.getDate("plan_finish_date"));
                }
                if (data.getRowMeta().getFieldIndex("available_date", false) > -1) {
                    plsOrder.setAvailableDate(data.getDate("available_date"));
                }
            }
        }
        this.plsOrderMap.put(ploOrderMapKey, plsOrder);
        return plsOrder;
    }

    private String getSelectField(Object fieldMappingId) {
        String selectField = this.selectFieldMappings.get(fieldMappingId);
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)selectField)) {
            return selectField;
        }
        List<Map<String, Object>> fieldMappingEntrys = this.fieldMappings.get(fieldMappingId);
        if (fieldMappingEntrys == null || fieldMappingEntrys.isEmpty()) {
            return null;
        }
        StringBuilder selectFields = new StringBuilder();
        for (Map<String, Object> fieldMappingEntry : fieldMappingEntrys) {
            String toField = (String)fieldMappingEntry.get("destfieldflag");
            String srcField = (String)fieldMappingEntry.get("sourcefieldflag");
            selectFields.append(srcField).append(' ').append(toField).append(',');
        }
        selectField = selectFields.length() == 0 ? "" : selectFields.deleteCharAt(selectFields.length() - 1).toString();
        this.selectFieldMappings.put(fieldMappingId, selectField);
        return selectField;
    }

    private List<Map<String, Object>> getFieldMappingEntrys(Object fieldMappingId) {
        ArrayList fieldMappingEntrys = this.fieldMappings.get(fieldMappingId);
        if (fieldMappingEntrys != null) {
            return fieldMappingEntrys;
        }
        String selectFields = "entryentity.destfieldflag,entryentity.sourcefieldflag";
        QFilter qFilter = new QFilter("id", "=", fieldMappingId);
        fieldMappingEntrys = Lists.newArrayListWithExpectedSize((int)6);
        try (DataSet result = ORM.create().queryDataSet(algoKey, "mrp_billfieldtransfer", selectFields, qFilter.toArray());){
            if (result.isEmpty()) {
                List<Map<String, Object>> list = null;
                return list;
            }
            while (result.hasNext()) {
                Row row = result.next();
                HashMap<String, Object> data = new HashMap<String, Object>(2);
                data.put("destfieldflag", row.get(0));
                data.put("sourcefieldflag", row.get(1));
                fieldMappingEntrys.add(data);
            }
        }
        this.fieldMappings.put(fieldMappingId, fieldMappingEntrys);
        return fieldMappingEntrys;
    }

    private DynamicObjectCollection getMaterialInfo4Org(Long materialId, Long orgId, String materialInfoEntityKey, String selectFields) {
        String key = Long.toString(materialId).concat(Long.toString(orgId));
        DynamicObjectCollection dynamicObjects = this.materialInfoMap.get(key);
        if (!CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return dynamicObjects;
        }
        QFilter orgIdFilter = BaseDataServiceHelper.getBaseDataProFilter((String)materialInfoEntityKey, (Long)orgId, (String)"id");
        QFilter qFilterMater = new QFilter("masterid", "=", (Object)materialId);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        dynamicObjects = QueryServiceHelper.query((String)materialInfoEntityKey, (String)selectFields, (QFilter[])new QFilter[]{qFilterMater, orgIdFilter, qFilterStatus, qFilterEnable});
        this.materialInfoMap.put(key, dynamicObjects);
        return dynamicObjects;
    }

    private void setError(String errorMsg) {
        this.getPageCache().put("error", String.valueOf(true));
        this.getPageCache().put("errorMsg", errorMsg);
    }

    private InputStream getInputStream() {
        List attachmentDataList = ((AttachmentPanel)this.getControl("attachmentpanelap")).getAttachmentData();
        if (attachmentDataList.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"PLSResultRptImportPlugin_31", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        if (attachmentDataList.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u5904\u7406\u591a\u4e2aExcle\u6587\u4ef6\u3002", (String)"PLSResultRptImportPlugin_32", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        Map attachmentData = (Map)attachmentDataList.get(0);
        String fileUrl = (String)attachmentData.get("url");
        if (kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)fileUrl)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"PLSResultRptImportPlugin_31", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        boolean exists = service.exists(fileUrl);
        if (exists) {
            return service.getInputStream(fileUrl);
        }
        Map<String, String> parseUrl = this.parseUrl(fileUrl);
        TempFileCacheDownloadable downLoadCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content content = downLoadCache.get(parseUrl.get("configKey"), parseUrl.get("id"));
        return content.getInputStream();
    }

    private Map<String, String> parseUrl(String url) {
        String[] pairStr = url.split("\\?");
        String[] pairs = pairStr[1].split("&");
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        int index0 = 0;
        int index1 = 1;
        for (String pair : pairs) {
            String[] p = pair.split("=");
            result.put(p[index0], p[index1]);
        }
        return result;
    }

    private int getProgress() {
        String str = this.getPageCache().get("progress");
        return kd.bos.dataentity.utils.StringUtils.isBlank((CharSequence)str) ? 0 : Integer.parseInt(str);
    }

    private void setProgress(int progress) {
        this.getPageCache().put("progress", String.valueOf(progress));
    }

    private void setTip(String tip) {
        this.getPageCache().put("tip", tip);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if ("btnok".equals(key)) {
            this.startImportExcel();
        } else if ("btndetail".equals(key)) {
            this.downloadErrorFile();
        }
    }

    private void downloadErrorFile() {
        String errorFileUrl = this.getPageCache().get("errorFileUrl");
        this.getView().download(errorFileUrl);
    }

    private void startImportExcel() {
        List attachmentDataList = ((AttachmentPanel)this.getControl("attachmentpanelap")).getAttachmentData();
        if (attachmentDataList.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"PLSResultRptImportPlugin_31", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        this.reset();
        this.getView().showProgressLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"PLSResultRptImportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0])), 0);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.start();
    }

    private void reset() {
        this.setProgress(0);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btndetail"});
        this.getPageCache().remove("error");
        this.getPageCache().remove("errorMsgs");
        this.getPageCache().remove("errorMsg");
        this.getPageCache().remove("complete");
        this.getPageCache().remove("completeMsg");
    }

    private void exportErrorInfo(List<String> errorInfoList) {
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        SXSSFSheet sheet = sxssfWorkbook.createSheet();
        SXSSFRow headRow = sheet.createRow(0);
        SXSSFCell cell = headRow.createCell(0, CellType.STRING);
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        Font font = sxssfWorkbook.createFont();
        font.setColor((short)10);
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"PLSResultRptImportPlugin_33", (String)"mmc-mrp-report", (Object[])new Object[0]));
        int errorInfoListSize = errorInfoList.size();
        for (int i = 0; i < errorInfoListSize; ++i) {
            String errorInfo = errorInfoList.get(i);
            SXSSFRow row = sheet.createRow(i + 1);
            row.createCell(0, CellType.STRING).setCellValue(errorInfo);
        }
        sheet.setColumnWidth(0, 11663);
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            sxssfWorkbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u9519\u8bef\u65e5\u5fd7\u8be6\u60c5.xlsx", (String)"PLSResultRptImportPlugin_34", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            this.getPageCache().put("errorFileUrl", tempUrl);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException("export failed:" + e.getMessage());
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                sxssfWorkbook.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }
}

