/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.productlineschedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertBill;
import kd.bos.entity.botp.ConvertOpType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.runtime.ConvertOpParameter;
import kd.bos.entity.botp.runtime.ConvertOpRule;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.mrp.report.operate.ReportTrackDown;

public class PLSResultRptPlugin
extends AbstractReportFormPlugin
implements AfterF7SelectListener {
    private String entityId = "mrp_pls_result";
    public static final String PLS_LOG_NO = "plsoperationno";
    public static final String MRP_CACULATE_LOG = "mrp_caculate_log";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addClickListeners(new String[]{PLS_LOG_NO, "plsplanbillno"});
        BasedataEdit plscheme = (BasedataEdit)this.getControl("pls_scheme");
        plscheme.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        QFilter qf1 = new QFilter("plangram", "!=", (Object)0);
        qf1.and("calculatestatus", "=", (Object)"A");
        qf1.and("plangramentity", "=", (Object)"mrp_pls_scheme");
        DynamicObject[] arr = BusinessDataServiceHelper.load((String)MRP_CACULATE_LOG, (String)"id,number,plangram", (QFilter[])new QFilter[]{qf1}, (String)"startdate desc", (int)1);
        if (arr != null && arr.length != 0) {
            this.getModel().setValue(PLS_LOG_NO, (Object)arr[0].getString("number"));
            this.getModel().setValue("pls_scheme", (Object)arr[0].getLong("plangram"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        FormOperate operate = (FormOperate)args.getSource();
        switch (key = operate.getOperateKey()) {
            case "import": {
                this.showImportForm();
                break;
            }
            case "push": {
                this.push();
                break;
            }
            case "delete": {
                this.showDeleteConfirmMsg();
                break;
            }
            case "linkquery": {
                this.linkQuery();
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (StringUtils.equals((CharSequence)"selectall", (CharSequence)operateKey)) {
            this.selectAll();
        }
    }

    private void selectAll() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        int rowCount = reportModel.getRowCount();
        if (rowCount <= 0) {
            return;
        }
        AbstractGrid.GridState entryState = reportList.getEntryState();
        int selectedRowCount = entryState.getSelectedRows().length;
        if (rowCount == selectedRowCount) {
            reportList.clearEntryState();
        } else {
            int[] allSelectRows = new int[rowCount];
            for (int i = 1; i <= rowCount; ++i) {
                allSelectRows[i - 1] = i;
            }
            reportList.selectRows(allSelectRows, 1);
        }
    }

    private void linkQuery() {
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        int[] selectIndexs = reportlistap.getEntryState().getSelectedRows();
        if (null == selectIndexs || selectIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u8054\u67e5\u7684\u6570\u636e\u3002", (String)"PLSResultRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        for (int i : selectIndexs) {
            DynamicObject selectRow = reportlistap.getReportModel().getRowData(i);
            Long id = selectRow.getLong("id");
            ListSelectedRow selectRow1 = new ListSelectedRow((Object)id);
            selectedRows.add((Object)selectRow1);
        }
        ReportTrackDown operate = new ReportTrackDown();
        HashMap map = new HashMap(2);
        HashMap<String, String> operateMap = new HashMap<String, String>(2);
        operateMap.put("trackdown", "trackdown");
        map.put("name", operateMap);
        operate.initialize(map);
        operate.setEntityId(this.entityId);
        operate.setOperateKey("trackdown");
        operate.setPageId(this.getView().getPageId());
        operate.setView((IFormView)this.getView());
        operate.setListSelectedData(selectedRows);
        operate.setListFocusRow(selectedRows.get(0));
        OperateOption operateOption = OperateOption.create();
        operate.setOption(operateOption);
        OperationResult result = operate.execute();
    }

    private void showDeleteConfirmMsg() {
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        int[] selectIndexs = reportlistap.getEntryState().getSelectedRows();
        if (null == selectIndexs || selectIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PLSResultRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%s\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"PLSResultRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]), selectIndexs.length), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("delete"));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String id = e.getCallBackId();
        if (StringUtils.equals((CharSequence)"delete", (CharSequence)id) && e.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.deletPLSResult();
        }
    }

    private void deletPLSResult() {
        Long plsschemeid;
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        int[] selectIndexs = reportlistap.getEntryState().getSelectedRows();
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        DynamicObject row = reportlistap.getReportModel().getRowData(selectIndexs[0]);
        String plslogno = row.getString("plslogno");
        if (!this.isLatestEffectiveResult(plslogno, plsschemeid = Long.valueOf(row.getLong("plsschemeid")), 2)) {
            return;
        }
        ArrayList<Long> deleteIds = new ArrayList<Long>(selectIndexs.length);
        HashMap<Long, Integer> deletes = new HashMap<Long, Integer>(selectIndexs.length);
        for (int i : selectIndexs) {
            DynamicObject selectRow = reportlistap.getReportModel().getRowData(i);
            Long id = selectRow.getLong("id");
            deleteIds.add(id);
            deletes.put(id, i);
        }
        QFilter qFilter = new QFilter("id", "in", deletes.keySet());
        QFilter statusFilter = new QFilter("status", "=", (Object)"B");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"mrp_pls_result", (String)"id,status", (QFilter[])new QFilter[]{qFilter, statusFilter});
        qFilter.and(new QFilter("status", "=", (Object)"A"));
        int num = DeleteServiceHelper.delete((String)"mrp_pls_result", (QFilter[])qFilter.toArray());
        String tips = null;
        int total = deleteIds.size();
        HashSet errorIndex = new HashSet(selectIndexs.length);
        if (num < total) {
            tips = String.format(ResManager.loadKDString((String)"\u5171%1$s\u6761\u6570\u636e\uff0c\u5220\u9664\u6210\u529f%2$s\u6761,\u5931\u8d25%3$s\u6761\u3002", (String)"PLSResultRptPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]), total, num, total - num);
            for (DynamicObject dynamicObjects : dynamicObjectCollection) {
                errorIndex.add(deletes.get(dynamicObjects.getLong("id")));
            }
            StringBuilder errorMsg = new StringBuilder();
            List error = errorIndex.stream().sorted().collect(Collectors.toList());
            for (Integer i : error) {
                errorMsg.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c:\u53ea\u80fd\u5220\u9664\u672a\u63a8\u5355\u7684\u6570\u636e\u3002", (String)"PLSResultRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]), i));
            }
            this.getView().showMessage(tips, errorMsg.toString(), MessageTypes.Commit);
        } else {
            tips = String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e\u3002", (String)"PLSResultRptPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]), num);
            this.getView().showTipNotification(tips);
        }
        if (num > 0) {
            reportlistap.refresh();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if (StringUtils.equals((CharSequence)PLS_LOG_NO, (CharSequence)key)) {
            this.showPLSLogListForm();
        }
    }

    private void showPLSLogListForm() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"mrp_pls_log", (boolean)false, (int)0);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, PLS_LOG_NO));
        listShowParameter.getListFilterParameter().setOrderBy("startdate desc");
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        DynamicObject plssheme = (DynamicObject)this.getModel().getValue("pls_scheme");
        filters.add(new QFilter("calculatestatus", "=", (Object)"A"));
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("isResultPage", "1");
        listShowParameter.setCustomParams(params);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    private void push() {
        Long plsschemeid;
        ReportList reportlistap = (ReportList)this.getView().getControl("reportlistap");
        int[] selectIndexs = reportlistap.getEntryState().getSelectedRows();
        if (null == selectIndexs || selectIndexs.length == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PLSResultRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        DynamicObject selectRow = reportlistap.getReportModel().getRowData(selectIndexs[0]);
        String plslogno = selectRow.getString("plslogno");
        if (!this.isLatestEffectiveResult(plslogno, plsschemeid = Long.valueOf(selectRow.getLong("plsschemeid")), 1)) {
            return;
        }
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        for (int i : selectIndexs) {
            selectRow = reportlistap.getReportModel().getRowData(i);
            Long id = selectRow.getLong("id");
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)id);
            selectedRows.add((Object)row);
        }
        ConvertOpParameter opParameter = this.buildParameter();
        opParameter.setSelectedRows(selectedRows);
        this.showPushForm(opParameter);
    }

    protected ConvertOpParameter buildParameter() {
        ConvertOpParameter opParameter = new ConvertOpParameter();
        opParameter.setOpType(ConvertOpType.Push);
        opParameter.setEntityNumber("mrp_pls_result");
        ConvertBill targetBill = new ConvertBill();
        opParameter.getBills().addAll(this.loadTargetBills());
        targetBill.setEntityName(ResManager.loadKDString((String)"\u6392\u7a0b\u7ed3\u679c\u8868", (String)"PLSResultRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
        opParameter.setAppId("mrp");
        opParameter.setDefSourceBill("mrp_pls_result");
        opParameter.setDefTargetBill("pom_mftorder");
        opParameter.setHasRight(false);
        opParameter.setMustSelectRule(false);
        return opParameter;
    }

    private List<ConvertBill> loadTargetBills() {
        ArrayList<ConvertBill> list = new ArrayList<ConvertBill>(4);
        String sourceEntityNumber = this.entityId;
        List bills = ConvertMetaServiceHelper.loadConvertBills((String)sourceEntityNumber, (ConvertOpType)ConvertOpType.Push);
        for (ConvertBill bill : bills) {
            List<ConvertOpRule> opRules = this.filterRules(bill);
            if (opRules.isEmpty()) continue;
            bill.getRules().addAll(opRules);
            list.add(bill);
        }
        return list;
    }

    private List<ConvertOpRule> filterRules(ConvertBill bill) {
        ArrayList<ConvertOpRule> opRules = new ArrayList<ConvertOpRule>(4);
        List<ConvertRuleElement> rules = this.loadRules(this.entityId, bill.getEntityNumber());
        if (rules.isEmpty()) {
            return opRules;
        }
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            ConvertOpRule opRule = new ConvertOpRule(rule.getId(), rule.getName().toString());
            opRule.setVisibled(rule.isVisibled());
            opRules.add(opRule);
        }
        return opRules;
    }

    private List<ConvertRuleElement> loadRules(String sourceEntityNumber, String targetEntityNumber) {
        List rules = ConvertRuleCache.loadRules((String)sourceEntityNumber, (String)targetEntityNumber);
        ArrayList<ConvertRuleElement> enableRules = new ArrayList<ConvertRuleElement>();
        for (ConvertRuleElement rule : rules) {
            if (!rule.isEnabled()) continue;
            enableRules.add(rule);
        }
        return enableRules;
    }

    private void showPushForm(ConvertOpParameter opParameter) {
        String opParameterJson = SerializationUtils.toJsonString((Object)opParameter);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_convertop");
        showParameter.getCustomParams().put("opparam", opParameterJson);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCaption(ResManager.loadKDString((String)"\u4e0b\u63a8", (String)"PLSResultRptPlugin_7", (String)"bos-form-business", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        if (e.getReturnData() == null) {
            return;
        }
        String actionId = e.getActionId();
        if (StringUtils.equals((CharSequence)actionId, (CharSequence)"import")) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)actionId, (CharSequence)PLS_LOG_NO)) {
            ListSelectedRowCollection data = (ListSelectedRowCollection)e.getReturnData();
            String plsoperationno = data.get(0).getNumber();
            this.getModel().setValue(PLS_LOG_NO, (Object)plsoperationno);
            this.checkIsRightOperationno(plsoperationno);
        }
    }

    private void setPLSSchemeSelectValue(AfterF7SelectEvent e) {
        DynamicObject plsScheme = (DynamicObject)this.getModel().getValue("pls_scheme");
        if (Objects.nonNull(plsScheme)) {
            Long id = plsScheme.getLong("id");
            String number = plsScheme.getString("number");
            DynamicObject plslog = this.getLatestPLSLog(id);
            if (plslog == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u8be5\u6392\u7a0b\u65b9\u6848\u4e0b\u65e0\u201c\u6b63\u5e38\u7ed3\u675f\u201d\u7684\u8fd0\u7b97\u65e5\u5fd7\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PLSResultRptPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0]), number));
                this.getModel().setValue(PLS_LOG_NO, null);
                return;
            }
            this.getModel().setValue(PLS_LOG_NO, plslog.get("number"));
        }
    }

    private DynamicObject getLatestPLSLog(Long plsSchemeId) {
        QFilter filter = new QFilter("plangram", "=", (Object)plsSchemeId);
        QFilter statusFilter = new QFilter("calculatestatus", "=", (Object)"A");
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)MRP_CACULATE_LOG, (String)"id,number", (QFilter[])new QFilter[]{filter, statusFilter}, (String)"startdate desc", (int)1);
        if (logs == null || logs.length == 0) {
            return null;
        }
        return logs[0];
    }

    private void showImportForm() {
        Long plsschemeid;
        Object plsscheme = this.getModel().getValue("pls_scheme");
        String plsoperationno = (String)this.getModel().getValue(PLS_LOG_NO);
        Long l = plsschemeid = plsscheme == null ? null : Long.valueOf(((DynamicObject)plsscheme).getLong("id"));
        if (!this.isLatestEffectiveResult(plsoperationno, plsschemeid, 0)) {
            return;
        }
        DynamicObject scheme = (DynamicObject)this.getModel().getValue("pls_scheme");
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "mrp_pls_result_import");
        para.put("importType", "importType");
        para.put("BillFormId", "mrp_pls_result");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
        this.getView().showForm(showParameter);
    }

    private boolean isLatestEffectiveResult(String plsoperationno, Long plsschemeid, int type) {
        String operate;
        String string = type == 0 ? ResManager.loadKDString((String)"\u5bfc\u5165", (String)"PLSResultRptPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]) : (type == 1 ? ResManager.loadKDString((String)"\u5173\u8054\u751f\u6210", (String)"PLSResultRptPlugin_10", (String)"mmc-mrp-report", (Object[])new Object[0]) : (operate = type == 2 ? ResManager.loadKDString((String)"\u5220\u9664", (String)"PLSResultRptPlugin_11", (String)"mmc-mrp-report", (Object[])new Object[0]) : ""));
        if (StringUtils.isBlank((CharSequence)plsoperationno)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u7a0b\u8fd0\u7b97\u53f7\u672a\u586b\u5199\u3002", (String)"PLSResultRptPlugin_12", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        if (plsschemeid == null && ((plsschemeid = this.getPLSScheme(plsoperationno)) == null || plsschemeid == 0L)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u7a0b\u8fd0\u7b97\u53f7\u6216\u6392\u7a0b\u65b9\u6848\u7f16\u7801\u9519\u8bef\u3002", (String)"PLSResultRptPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject latestLog = this.getLatestPLSLog(plsschemeid);
        if (latestLog == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6392\u7a0b\u8fd0\u7b97\u53f7\u6216\u6392\u7a0b\u65b9\u6848\u7f16\u7801\u9519\u8bef\u3002", (String)"PLSResultRptPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.equals((CharSequence)latestLog.getString("number"), (CharSequence)plsoperationno)) {
            return true;
        }
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s:\u4e0d\u662f\u8be5\u6392\u7a0b\u65b9\u6848\u6700\u65b0\u7684\u6392\u7a0b\u8fd0\u7b97\u53f7\uff0c\u4e0d\u652f\u6301%2$s\u3002", (String)"PLSResultRptPlugin_14", (String)"mmc-mrp-report", (Object[])new Object[0]), plsoperationno, operate));
        return false;
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        BasedataEdit source = (BasedataEdit)afterF7SelectEvent.getSource();
        String key = source.getFieldKey();
        if (StringUtils.equals((CharSequence)"pls_scheme", (CharSequence)key)) {
            this.setPLSSchemeSelectValue(afterF7SelectEvent);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        String errorMsg = null;
        String plsoperationno = filter.getString(PLS_LOG_NO);
        if (StringUtils.isBlank((CharSequence)plsoperationno)) {
            errorMsg = ResManager.loadKDString((String)"\u6392\u7a0b\u8fd0\u7b97\u53f7\u672a\u586b\u5199,\u8bf7\u5b8c\u5584\u67e5\u8be2\u6761\u4ef6\u3002", (String)"PLSResultRptPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0]);
        }
        if (StringUtils.isNotBlank(errorMsg)) {
            this.getView().showTipNotification(errorMsg);
            return false;
        }
        return true;
    }

    private void checkIsRightOperationno(String plsoperationno) {
        Long log = this.getPLSScheme(plsoperationno);
        if (log == null || log == 0L) {
            this.getModel().setValue("pls_scheme", null);
            return;
        }
        this.getModel().setValue("pls_scheme", (Object)log);
    }

    private Long getPLSScheme(String plsoperationno) {
        QFilter qFilter = new QFilter("number", "=", (Object)plsoperationno);
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)MRP_CACULATE_LOG, (String)"id,plangram", (QFilter[])qFilter.toArray());
        if (null == logs || logs.length == 0) {
            return null;
        }
        return logs[0].getLong("plangram");
    }
}

