/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.productlineschedule;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.impt.SheetHandler;
import kd.mmc.mrp.report.productlineschedule.FieldProperty;
import kd.mmc.mrp.rpt.entity.PlsResultEntity;

public class PLSResultSheetHandle
extends SheetHandler {
    private static String[] FIELDS = new String[]{"source_order_billno", "source_order_type", "materiel_code", "workcentre", "pls_date", "workshift", "workstarttime", "workendtime", "work_pls_qty", "production_order", "status", "production_org"};
    private List<PlsResultEntity> result = new LinkedList<PlsResultEntity>();
    private Map<Integer, Object[]> errorMsgs = new HashMap<Integer, Object[]>();
    private List<FieldProperty> fieldPropertys;
    private boolean hasMustCloumn = true;
    private Set<String> sourceOrderTypeNumbers = new HashSet<String>(4);
    private Map<String, Set<String>> orgToMaterielNumberMap = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> orgToWorkcentreNumberMap = new HashMap<String, Set<String>>();
    private Set<String> orgNumbers = new HashSet<String>();

    public void handleRow(SheetHandler.ParsedRow parsedRow) {
        if (parsedRow.getRowNum() == 2) {
            this.checkIsTempField(parsedRow);
        }
        if (!this.hasMustCloumn) {
            return;
        }
        if (parsedRow.getRowNum() > 2) {
            this.checkData(parsedRow);
        }
    }

    /*
     * Exception decompiling
     */
    private void checkData(SheetHandler.ParsedRow parsedRow) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setEntityProperties(PlsResultEntity entity, String number, String value) {
        switch (number) {
            case "source_order_billno": {
                entity.setSourceOrderBillNo(value);
                break;
            }
            case "source_order_type": {
                entity.setSourceOrderType(value);
                break;
            }
            case "materiel_code": {
                entity.setMaterielCode(value);
                break;
            }
            case "workcentre": {
                entity.setWorkcentre(value);
                break;
            }
            case "workshift": {
                entity.setWorkShift(value);
                break;
            }
            case "production_org": {
                entity.setProductionOrg(value);
                break;
            }
        }
    }

    private void setMetaDataNumber(PlsResultEntity entity) {
        String productionOrg = entity.getProductionOrg();
        if (StringUtils.isNotBlank((CharSequence)productionOrg)) {
            this.orgNumbers.add(productionOrg);
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getMaterielCode())) {
            Set meterielCodeSet = this.orgToMaterielNumberMap.getOrDefault(productionOrg, new HashSet());
            meterielCodeSet.add(entity.getMaterielCode());
            this.orgToMaterielNumberMap.put(productionOrg, meterielCodeSet);
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getSourceOrderType())) {
            this.sourceOrderTypeNumbers.add(entity.getSourceOrderType());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getWorkcentre())) {
            Set workcentreCodeSet = this.orgToWorkcentreNumberMap.getOrDefault(productionOrg, new HashSet());
            workcentreCodeSet.add(entity.getWorkcentre());
            this.orgToWorkcentreNumberMap.put(productionOrg, workcentreCodeSet);
        }
    }

    private boolean isEmptyRow(SheetHandler.ParsedRow parsedRow) {
        Map row = parsedRow.getData();
        if (row == null || row.isEmpty()) {
            return true;
        }
        boolean isEmptyRow = true;
        Collection values = row.values();
        for (String value : values) {
            if (!StringUtils.isNotBlank((CharSequence)value)) continue;
            isEmptyRow = false;
        }
        return isEmptyRow;
    }

    private String stringToStatus(String value) {
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u672a\u63a8\u5355", (String)"PLSResultSheetHandle_5", (String)"mmc-mrp-report", (Object[])new Object[0]), (CharSequence)value)) {
            return "A";
        }
        if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u5df2\u63a8\u5355", (String)"PLSResultSheetHandle_6", (String)"mmc-mrp-report", (Object[])new Object[0]), (CharSequence)value)) {
            return "B";
        }
        return "A";
    }

    private Integer stringToInt(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u503c\u683c\u5f0f\u9519\u8bef\u3002", (String)"PLSResultSheetHandle_7", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
    }

    private BigDecimal stringToBigDecimal(String value) {
        try {
            return new BigDecimal(value);
        }
        catch (NumberFormatException e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u503c\u683c\u5f0f\u9519\u8bef\u3002", (String)"PLSResultSheetHandle_7", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
    }

    public static Integer stringToTime(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"PLSResultSheetHandle_8", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        boolean isMatch = Pattern.matches("^(?:[01]{0,1}\\d|2[0-3])(?::[0-5]{0,1}\\d){1,2}$", value);
        if (!isMatch) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"PLSResultSheetHandle_8", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        Integer second = null;
        String[] times = value.split(":");
        if (times.length == 2) {
            second = Integer.parseInt(times[0]) * 3600 + Integer.parseInt(times[1]) * 60;
        }
        if (times.length == 3) {
            second = Integer.parseInt(times[0]) * 3600 + Integer.parseInt(times[1]) * 60 + Integer.parseInt(times[2]);
        }
        return second;
    }

    private Date stringToDate(String v, String[] formats) {
        if (v == null) {
            return null;
        }
        SimpleDateFormat[] dateFormats = this.getDateFormats(formats);
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                return dateFormats[i].parse(v);
            }
            catch (ParseException e) {
                continue;
            }
        }
        return null;
    }

    private SimpleDateFormat[] getDateFormats(String[] formats) {
        SimpleDateFormat[] simpleDateFormats = null;
        if (formats == null || formats.length == 0) {
            simpleDateFormats = new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd")};
        } else {
            simpleDateFormats = new SimpleDateFormat[formats.length];
            for (int i = 0; i < formats.length; ++i) {
                simpleDateFormats[i] = new SimpleDateFormat(formats[i]);
            }
        }
        return simpleDateFormats;
    }

    private void checkIsTempField(SheetHandler.ParsedRow parsedRow) {
        StringBuilder errorMsg = null;
        List<FieldProperty> propertys = this.getFieldPropertys();
        for (FieldProperty item : propertys) {
            Map data = parsedRow.getData();
            for (Map.Entry entry : data.entrySet()) {
                String v = (String)entry.getValue();
                Integer index = (Integer)entry.getKey();
                String name = StringUtils.isBlank((CharSequence)v) ? "" : v.trim();
                if (!StringUtils.equals((CharSequence)name, (CharSequence)item.getName())) continue;
                item.setIndex(index);
                break;
            }
            if (!item.getMustInput() || item.getIndex() != null) continue;
            if (errorMsg == null) {
                errorMsg = new StringBuilder(ResManager.loadKDString((String)"\u8bf7\u6309\u5bfc\u51fa\u6a21\u677f\u5bfc\u5165,\u7f3a\u5c11\u5fc5\u5f55\u5b57\u6bb5:", (String)"PLSResultSheetHandle_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
            errorMsg.append(item.getName()).append("\u3001\n");
        }
        if (errorMsg != null) {
            errorMsg.replace(errorMsg.length() - 2, errorMsg.length() - 1, "\u3002");
            Object[] errorMsgInfo = new Object[]{errorMsg, 1};
            this.errorMsgs.put(parsedRow.getRowNum(), errorMsgInfo);
            this.hasMustCloumn = false;
        }
    }

    private List<FieldProperty> getFieldPropertys() {
        if (this.fieldPropertys != null && !this.fieldPropertys.isEmpty()) {
            return this.fieldPropertys;
        }
        BillEntityType type = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"mrp_pls_result");
        ArrayList<FieldProperty> lfieldPropertys = new ArrayList<FieldProperty>(FIELDS.length);
        for (String field : FIELDS) {
            FieldProperty property = new FieldProperty();
            DynamicProperty dynamicProperty = type.getProperty(field);
            property.setNumber(field);
            property.setName(dynamicProperty.getDisplayName().getLocaleValue());
            property.setAlias(dynamicProperty.getAlias());
            boolean mustInput = this.isMustInput(dynamicProperty);
            property.setMustInput(mustInput);
            lfieldPropertys.add(property);
        }
        this.fieldPropertys = lfieldPropertys;
        return this.fieldPropertys;
    }

    public boolean isMustInput(DynamicProperty dynamicProperty) {
        boolean mustInput = false;
        if (dynamicProperty instanceof BasedataProp) {
            mustInput = ((BasedataProp)dynamicProperty).isMustInput();
        } else if (dynamicProperty instanceof FieldProp) {
            mustInput = ((FieldProp)dynamicProperty).isMustInput();
        } else if (dynamicProperty instanceof MulBasedataProp) {
            mustInput = ((MulBasedataProp)dynamicProperty).isMustInput();
        }
        return mustInput;
    }

    public List<PlsResultEntity> getResult() {
        return this.result;
    }

    public void setResult(List<PlsResultEntity> result) {
        this.result = result;
    }

    public void setFieldPropertys(List<FieldProperty> fieldPropertys) {
        this.fieldPropertys = fieldPropertys;
    }

    public Map<Integer, Object[]> getErrorMsgs() {
        return this.errorMsgs;
    }

    public Map<String, Set<String>> getOrgToMaterielNumberMap() {
        return this.orgToMaterielNumberMap;
    }

    public Map<String, Set<String>> getOrgToWorkcentreNumberMap() {
        return this.orgToWorkcentreNumberMap;
    }

    public Set<String> getOrgNumbers() {
        return this.orgNumbers;
    }

    public Set<String> getSourceOrderTypeNumbers() {
        return this.sourceOrderTypeNumbers;
    }
}

