/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.rpt.impt.DocumentsPlanImportPlugin;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.util.CalcDocumentsPlanUtils;
import kd.mmc.mrp.rpt.util.CalcProductionForecastUtils;
import kd.mmc.mrp.rpt.util.RptUtils;

public class DocumentsPlanRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    protected static final String FORM_IMPORT = "mrp_prod_fctimport";
    private static final String HEAD_PLAN = "head_plan";
    public static final Log logger = LogFactory.getLog(DocumentsPlanRptPlugin.class);
    private static final String[] FILTER_AND_SORT_FILEDS = new String[]{"plannumber", "material", "materialname", "modelnum", "supplyorg", "supplyorgname", "demandmodel", "operator", "releasestatus", "releaseuser", "releasetime", "iscommitment", "modifier", "modifytime", "goodprodinvqty", "defprodinvqty", "nonstandardqty", "remark", "totalqty"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit planEdit = (BasedataEdit)this.getControl(HEAD_PLAN);
        planEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean isSuccess;
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"cal", (CharSequence)operateKey)) {
            DynamicObject plan = (DynamicObject)this.getModel().getValue(HEAD_PLAN);
            if (plan == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"DocumentsPlanRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String planNo = plan.getString("number");
            boolean isExists = QueryServiceHelper.exists((String)"mrp_rpt_decuments_datas", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)planNo)});
            if (isExists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8fd0\u7b97\u53f7\u5bf9\u5e94\u7684\u4ea4\u5355\u8ba1\u5212\u7ed3\u679c\u8868\u5df2\u5b58\u5728\uff0c\u8bf7\u901a\u8fc7\u67e5\u8be2\u67e5\u770b\u3002", (String)"DocumentsPlanRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)"importplan", (CharSequence)operateKey) && !(isSuccess = this.checkImportPlan())) {
            args.setCancel(true);
            return;
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs agrs) {
        super.afterDoOperation(agrs);
        String operateKey = agrs.getOperateKey();
        if (StringUtils.equals((CharSequence)"cal", (CharSequence)operateKey)) {
            DynamicObject plan = (DynamicObject)this.getModel().getValue(HEAD_PLAN);
            String planNo = plan.getString("number");
            long planId = plan.getLong("plangram");
            this.calcDocumentsPlan(((Object)((Object)this)).getClass().getName(), planId, planNo);
            ReportFilter filter = (ReportFilter)this.getView().getControl("reportfilterap");
            filter.search();
        } else if (StringUtils.equals((CharSequence)"publish", (CharSequence)operateKey)) {
            this.changeReleaseStatus("B", RequestContext.get().getCurrUserId(), new Date());
        } else if (StringUtils.equals((CharSequence)"unpublish", (CharSequence)operateKey)) {
            this.changeReleaseStatus("A", 0L, null);
        } else if (StringUtils.equals((CharSequence)"importplan", (CharSequence)operateKey)) {
            this.showImportForm();
        } else if (StringUtils.equals((CharSequence)"selectall", (CharSequence)operateKey)) {
            this.setSelectAll();
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((Control)e.getSource()).getKey();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)HEAD_PLAN, (CharSequence)key)) {
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("runtype", "=", (Object)"A"));
            filters.add(new QFilter("calculatestatus", "=", (Object)"A"));
            filters.add(new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')));
            filters.add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
            filterParameter.setQFilters(filters);
            formShowParameter.setShowUsed(false);
            formShowParameter.setShowApproved(false);
        }
    }

    protected void calcDocumentsPlan(String algoKey, long planId, String planNo) {
        RptSchemeInfo rptSchemeInfo = RptUtils.getRptSchemeInfo((long)planId, (String)RptTypeEnum.DOCUMENTS_PLAN.getValue());
        if (rptSchemeInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u62a5\u8868\u65b9\u6848\u3002", (String)"DocumentsPlanRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        try {
            DataSet detailDataSet = CalcDocumentsPlanUtils.queryMrpCalcDetail((String)algoKey, (String)planNo, (RptSchemeInfo)rptSchemeInfo);
            HashSet<Long> materialIds = new HashSet<Long>(8);
            HashSet<Long> supplyorgIds = new HashSet<Long>(8);
            DataSet calDetailDataSet = CalcDocumentsPlanUtils.dealDatasWithResource((DataSet)detailDataSet);
            Date historyEarlyDate = null;
            Date lastestDate = null;
            for (Row row : calDetailDataSet.copy()) {
                long material = row.getLong("supmaterial");
                long supplyorg = row.getLong("supplyorg");
                Date date = row.getDate("demanddate");
                if (historyEarlyDate == null) {
                    historyEarlyDate = date;
                }
                if (lastestDate == null) {
                    lastestDate = date;
                }
                if (date != null && date.compareTo(historyEarlyDate) <= 0) {
                    historyEarlyDate = date;
                }
                if (date != null && date.compareTo(lastestDate) > 0) {
                    lastestDate = date;
                }
                materialIds.add(material);
                supplyorgIds.add(supplyorg);
            }
            Map planInfo = CalcProductionForecastUtils.getPlanInfos(null, (long)planId);
            DataSet materialInvDataSet = CalcDocumentsPlanUtils.queryMaterialInvQty((String)algoKey, materialIds, (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("warehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet materialGoodDataSet = CalcDocumentsPlanUtils.queryMaterialGoodInvQty((String)algoKey, materialIds, (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("goodwarehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet materialNoStandardDataSet = CalcDocumentsPlanUtils.queryMaterialNoStandardQty((String)algoKey, (long)0L, materialIds);
            DataSet materialPlanDataSet = CalcDocumentsPlanUtils.queryMaterialPlanInfo((String)algoKey, materialIds, supplyorgIds);
            DataSet dataSet = CalcDocumentsPlanUtils.relateDataSet((DataSet)calDetailDataSet, (DataSet)materialPlanDataSet, (DataSet)materialInvDataSet, (DataSet)materialGoodDataSet, (DataSet)materialNoStandardDataSet);
            Map params = RptUtils.createParams((RptSchemeInfo)rptSchemeInfo, (Date)historyEarlyDate, (Date)lastestDate);
            dataSet = CalcDocumentsPlanUtils.createNewDataSet((String)algoKey, (Map)params, (DataSet)dataSet);
            CalcDocumentsPlanUtils.createDocumentsDatas((DataSet)dataSet, (String)planNo, (Map)params);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("mrp-DocumnetsPlan", ResManager.loadKDString((String)"\u62a5\u8868\u751f\u6210\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"DocumentsPlanRptPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    public void changeReleaseStatus(String releaseStatus, long releaseUser, Date releaseTime) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        AbstractGrid.GridState entryState = reportList.getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        ArrayList<Long> entryList = new ArrayList<Long>(8);
        for (int selectedRow : selectedRows) {
            DynamicObject rowData = reportModel.getRowData(selectedRow);
            String status = (String)rowData.get("releasestatus");
            if (StringUtils.equals((CharSequence)releaseStatus, (CharSequence)status)) continue;
            long entryid = (Long)rowData.get("entryid");
            entryList.add(entryid);
        }
        if (entryList.size() > 0) {
            entryList.forEach(entryId -> DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"UPDATE t_mrp_decuments_datafix SET freleasestatus = ?,freleaseuser = ?,freleasetime = ? WHERE fentryid = ?", (Object[])new Object[]{releaseStatus, releaseUser, releaseTime, entryId}));
            reportList.refresh();
        }
    }

    private void showImportForm() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        if (reportModel.getRowCount() <= 0) {
            return;
        }
        DynamicObject fristRowData = reportModel.getRowData(1);
        if (fristRowData == null) {
            return;
        }
        String planNumber = fristRowData.getString("plannumber");
        if (StringUtils.isEmpty((CharSequence)planNumber)) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setHasRight(true);
        formShowParameter.setFormId(FORM_IMPORT);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
        formShowParameter.addCustPlugin(this.getImportPluginName());
        formShowParameter.setCustomParam("calcNo", (Object)planNumber);
        this.getView().showForm(formShowParameter);
    }

    private String getImportPluginName() {
        return DocumentsPlanImportPlugin.class.getName();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.equals((CharSequence)"import", (CharSequence)actionId) && returnData instanceof String) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"DocumentsPlanRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        if (StringUtils.isBlank((CharSequence)filter.getString(HEAD_PLAN))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DocumentsPlanRptPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        long planId = RptUtils.getLatestPlanId((String)((Object)((Object)this)).getClass().getName(), (String)RptTypeEnum.DOCUMENTS_PLAN.getValue());
        this.getModel().setValue(HEAD_PLAN, (Object)planId);
    }

    private boolean checkImportPlan() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        String planNumber = null;
        if (reportModel.getRowCount() <= 0) {
            DynamicObject plan = (DynamicObject)this.getModel().getValue(HEAD_PLAN);
            if (plan == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5217\u8868\u6ca1\u6709\u6570\u636e\uff0c\u5e76\u4e14\u8fc7\u6ee4\u6761\u4ef6\u4e2d\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u67e5\u8be2\u6570\u636e\u518d\u5bfc\u5165\u3002", (String)"DocumentsPlanRptPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
                return false;
            }
            planNumber = plan.getString("number");
        } else {
            DynamicObject fristRowData = reportModel.getRowData(1);
            if (fristRowData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5217\u8868\u6ca1\u6709\u6570\u636e\uff0c\u8bf7\u5148\u67e5\u8be2\u6570\u636e\u518d\u5bfc\u5165\u3002", (String)"DocumentsPlanRptPlugin_7", (String)"mmc-mrp-report", (Object[])new Object[0]));
                return false;
            }
            planNumber = fristRowData.getString("plannumber");
            if (StringUtils.isEmpty((CharSequence)planNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u5217\u8868\u7b2c\u4e00\u884c\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u5bfc\u5165\u3002", (String)"DocumentsPlanRptPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0]));
                return false;
            }
        }
        QFilter[] filters = new QFilter("planid", "=", (Object)planNumber).toArray();
        if (!QueryServiceHelper.exists((String)"mrp_rpt_decuments_datas", (QFilter[])filters)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%s\u201d\u6ca1\u6709\u751f\u6210\u4ea4\u5355\u8ba1\u5212\u62a5\u8868\uff0c\u8bf7\u5148\u624b\u5de5\u751f\u6210\u62a5\u8868\u3002", (String)"DocumentsPlanRptPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]), planNumber));
            return false;
        }
        QFilter logFilter = new QFilter("number", "=", (Object)planNumber);
        DynamicObject mrpPlan = QueryServiceHelper.queryOne((String)"mrp_caculate_log", (String)"plangram,programnumber", (QFilter[])logFilter.toArray());
        if (mrpPlan == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%s\u201d\u6ca1\u6709\u5bf9\u5e94\u7684\u8ba1\u5212\u65b9\u6848\u3002", (String)"DocumentsPlanRptPlugin_10", (String)"mmc-mrp-report", (Object[])new Object[0]), planNumber));
            return false;
        }
        String mrpPlanNumber = mrpPlan.getString("programnumber");
        String caculateLogNo = this.getLatestCaculateLog(mrpPlanNumber);
        if (!StringUtils.equals((CharSequence)caculateLogNo, (CharSequence)planNumber)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%1$s\u201d\u5728\u8ba1\u5212\u65b9\u6848\u201c%2$s\u201d\u4e0b\u4e0d\u662f\u6700\u65b0\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"DocumentsPlanRptPlugin_11", (String)"mmc-mrp-report", (Object[])new Object[0]), planNumber, mrpPlanNumber));
            return false;
        }
        return true;
    }

    private String getLatestCaculateLog(String programnumber) {
        QFilter statusFilter = new QFilter("calculatestatus", "=", (Object)"A");
        QFilter typeFilter = new QFilter("runtype", "=", (Object)"A");
        QFilter filter = new QFilter("programnumber", "=", (Object)programnumber);
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id,number", (QFilter[])new QFilter[]{statusFilter, typeFilter, filter}, (String)"startdate desc", (int)1);
        if (logs == null || logs.length == 0) {
            return null;
        }
        return logs[0].getString("number");
    }

    private void setSelectAll() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        int rowCount = reportModel.getRowCount();
        if (rowCount <= 0) {
            return;
        }
        AbstractGrid.GridState entryState = reportList.getEntryState();
        int selectedRowCount = entryState.getSelectedRows().length;
        if (rowCount == selectedRowCount) {
            reportList.clearEntryState();
        } else {
            int[] allSelectRows = new int[rowCount];
            for (int i = 1; i <= rowCount; ++i) {
                allSelectRows[i - 1] = i;
            }
            reportList.selectRows(allSelectRows, 1);
        }
    }
}

