/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.rpt.util.RptUtils;

public class StockForecastQueryPlugin
extends AbstractReportListDataPlugin {
    public static final Log logger = LogFactory.getLog(StockForecastQueryPlugin.class);
    protected Map<String, String> COLUMNMAP;
    protected static String[] FIXFIELDS = new String[]{"entryid", "planno", "material", "unit", "materialname", "modelnum", "materialgroup", "isserviceuse", "supplyorgno", "supplyorg", "demandmodel", "operatorno", "operator", "releasestatus", "releaser", "releasetime", "firstreleaser", "firstreleasetime", "modifier", "modifytime", "remark", "weekqty", "invqty", "monthqty", "threeqty", "dullqty"};
    protected static DataType[] FIXFIELDSTYPE = new DataType[]{DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.StringType, DataType.DateType, DataType.StringType, DataType.DateType, DataType.StringType, DataType.DateType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        Date head_releasetime_enddate;
        Date head_releasetime_startdate;
        DynamicObject head_releaser;
        String head_releasestatus;
        DynamicObject head_operator;
        String head_demandmodel;
        DynamicObject head_supplyorg;
        String head_model;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(8);
        DynamicObject head_plan = filterInfo.getDynamicObject("head_plan");
        if (head_plan == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"StockForecastQueryPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        qFilterList.add(new QFilter("billno", "=", (Object)head_plan.getString("number")));
        DynamicObject head_material = filterInfo.getDynamicObject("head_material");
        if (head_material != null) {
            qFilterList.add(new QFilter("entryentity.material", "=", (Object)head_material.getLong("id")));
        }
        if (StringUtils.isNotBlank((CharSequence)(head_model = filterInfo.getString("head_model")))) {
            qFilterList.add(new QFilter("entryentity.material.modelnum", "=", (Object)head_model));
        }
        if ((head_supplyorg = filterInfo.getDynamicObject("head_supplyorg")) != null) {
            qFilterList.add(new QFilter("entryentity.supplyorg", "=", (Object)head_supplyorg.getLong("id")));
        }
        if (StringUtils.isNotBlank((CharSequence)(head_demandmodel = filterInfo.getString("head_demandmodel")))) {
            qFilterList.add(new QFilter("entryentity.demandmodel", "=", (Object)head_demandmodel));
        }
        if ((head_operator = filterInfo.getDynamicObject("head_operator")) != null) {
            qFilterList.add(new QFilter("entryentity.operator", "=", (Object)head_operator.getLong("id")));
        }
        if (StringUtils.isNotBlank((CharSequence)(head_releasestatus = filterInfo.getString("head_releasestatus")))) {
            qFilterList.add(new QFilter("entryentity.releasestatus", "=", (Object)head_releasestatus));
        }
        if ((head_releaser = filterInfo.getDynamicObject("head_releaser")) != null) {
            qFilterList.add(new QFilter("entryentity.releaser", "=", (Object)head_releaser.getLong("id")));
        }
        if ((head_releasetime_startdate = filterInfo.getDate("head_releasetime_startdate")) != null) {
            qFilterList.add(new QFilter("entryentity.releasetime", ">=", (Object)head_releasetime_startdate));
        }
        if ((head_releasetime_enddate = filterInfo.getDate("head_releasetime_enddate")) != null) {
            qFilterList.add(new QFilter("entryentity.releasetime", "<=", (Object)head_releasetime_enddate));
        }
        this.COLUMNMAP = new LinkedHashMap<String, String>(8);
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        String selectStr = "id,billno planno,entryentity.id entryid,entryentity.material.number material,entryentity.material.baseunit unit,entryentity.material.name materialname,entryentity.material.modelnum modelnum,entryentity.material.group.name materialgroup,entryentity.isserviceuse isserviceuse,entryentity.supplyorg.number supplyorgno,entryentity.supplyorg.name supplyorg,entryentity.demandmodel demandmodel,entryentity.operator.number operatorno,entryentity.operator.name operator,entryentity.releasestatus releasestatus,entryentity.releaser.name releaser,entryentity.releasetime releasetime,entryentity.firstreleaser.name firstreleaser,entryentity.firstreleasetime firstreleasetime,entryentity.modifierfield.name modifier,entryentity.entry_modifytime modifytime,entryentity.remark remark,entryentity.weekqty weekqty,entryentity.invqty invqty,entryentity.monthqty monthqty,entryentity.threeqty threeqty,entryentity.dullqty dullqty,entryentity.subentryentity.fieldkey,entryentity.subentryentity.fieldcaption,entryentity.subentryentity.fieldvalue,entryentity.subentryentity.sequence";
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_rpt_stock_datas", (String)selectStr, (QFilter[])qFilters, (String)"entryentity.id,entryentity.subentryentity.sequence,entryentity.subentryentity.fieldcaption");
        DataSet resultDataSet = RptUtils.getNewDataSet((String)((Object)((Object)this)).getClass().getName(), (DataSet)dataSet, (String[])FIXFIELDS, (DataType[])FIXFIELDSTYPE, this.COLUMNMAP);
        DataSet sumDataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_rpt_stock_datas", (String)"id,entryentity.id,entryentity.subentryentity.fieldvalue", (QFilter[])qFilters, null);
        sumDataSet = sumDataSet.groupBy(new String[]{"entryentity.id"}).sum("entryentity.subentryentity.fieldvalue", "sumqty").finish();
        resultDataSet = resultDataSet.leftJoin(sumDataSet).on("entryid", "entryentity.id").select((String[])ArrayUtils.addAll((Object[])resultDataSet.getRowMeta().getFieldNames(), (Object[])new String[]{"sumqty"})).finish();
        String sort = reportQueryParam.getSortInfo();
        resultDataSet = StringUtils.isNotEmpty((CharSequence)sort) ? resultDataSet.orderBy(new String[]{sort}) : resultDataSet.orderBy(new String[]{"material"});
        try {
            List<String> filters = this.getFilters(filterInfo);
            for (String filter : filters) {
                resultDataSet = resultDataSet.filter(filter);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u8868\u67e5\u8be2\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"StockForecastQueryPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        return resultDataSet.filter("material != '' and material != null");
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List cols = super.getColumns(columns);
        for (AbstractReportColumn reportColumn : cols) {
            ReportColumn col = (ReportColumn)reportColumn;
            String fieldKey = col.getFieldKey();
            if (!StringUtils.equals((CharSequence)"material", (CharSequence)fieldKey) && !StringUtils.equals((CharSequence)"materialname", (CharSequence)fieldKey) && !StringUtils.equals((CharSequence)"supplyorgno", (CharSequence)fieldKey) && !StringUtils.equals((CharSequence)"supplyorg", (CharSequence)fieldKey) && !StringUtils.equals((CharSequence)"planno", (CharSequence)fieldKey)) continue;
            col.setFreeze(true);
        }
        ReportColumn sumCol = new ReportColumn();
        sumCol.setFieldKey("sumqty");
        sumCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5408\u8ba1", (String)"StockForecastQueryPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0])));
        sumCol.setFieldType("qty");
        sumCol.setMeasureUnitField("unit");
        sumCol.setZeroShow(true);
        cols.add(sumCol);
        for (Map.Entry<String, String> next : this.COLUMNMAP.entrySet()) {
            String key = next.getKey();
            String caption = next.getValue();
            ReportColumn newColmun = new ReportColumn();
            newColmun.setFieldKey(key);
            newColmun.setCaption(new LocaleString(caption));
            newColmun.setFieldType("qty");
            newColmun.setMeasureUnitField("unit");
            newColmun.setZeroShow(true);
            cols.add(newColmun);
        }
        return cols;
    }

    private List<String> getFilters(FilterInfo filterInfo) throws ParseException {
        ArrayList<String> filters = new ArrayList<String>(8);
        List filterItems = filterInfo.getTableHeadFilterItems();
        for (FilterItemInfo item : filterItems) {
            String propName = item.getPropName();
            if (StringUtils.equals((CharSequence)"releasetime", (CharSequence)propName) || StringUtils.equals((CharSequence)"firstreleasetime", (CharSequence)propName) || StringUtils.equals((CharSequence)"modifytime", (CharSequence)propName)) {
                filters.addAll(RptUtils.transformTimeFilters((FilterItemInfo)item));
                continue;
            }
            if (StringUtils.equals((CharSequence)"weekqty", (CharSequence)propName) || StringUtils.equals((CharSequence)"invqty", (CharSequence)propName) || StringUtils.equals((CharSequence)"monthqty", (CharSequence)propName) || StringUtils.equals((CharSequence)"threeqty", (CharSequence)propName) || StringUtils.equals((CharSequence)"dullqty", (CharSequence)propName)) {
                filters.add(propName + " " + item.getCompareType() + " " + item.getValue());
                continue;
            }
            filters.addAll(RptUtils.transformTextFilters((FilterItemInfo)item));
        }
        return filters;
    }
}

