/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportCache;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportCacheManager;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.util.CalcProductionForecastUtils;
import kd.mmc.mrp.rpt.util.CalcStockForecastUtils;
import kd.mmc.mrp.rpt.util.RptUtils;

public class StockForecastRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public static final Log logger = LogFactory.getLog(StockForecastRptPlugin.class);
    protected static final String[] fixFields = new String[]{"material", "isserviceuse", "supplyorg", "demandmodel", "operator", "weekqty", "invqty", "monthqty", "threeqty", "dullqty"};
    protected static final DataType[] fixTypes = new DataType[]{DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType};
    private static final String IMPORT = "import";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit planEdit = (BasedataEdit)this.getControl("head_plan");
        planEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long planId = RptUtils.getLatestPlanId((String)((Object)((Object)this)).getClass().getName(), (String)RptTypeEnum.STOCK_FORECAST.getValue());
        this.getModel().setValue("head_plan", (Object)planId);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((FormOperate)args.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"cal", (CharSequence)operateKey)) {
            DynamicObject plan = (DynamicObject)this.getModel().getValue("head_plan");
            if (plan == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"StockForecastRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            String planNo = plan.getString("number");
            boolean isExists = QueryServiceHelper.exists((String)"mrp_rpt_stock_datas", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)planNo)});
            if (isExists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8fd0\u7b97\u53f7\u5bf9\u5e94\u7684\u5907\u6599\u9884\u6d4b\u7ed3\u679c\u8868\u5df2\u5b58\u5728\uff0c\u8bf7\u901a\u8fc7\u67e5\u8be2\u67e5\u770b\u3002", (String)"StockForecastRptPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        } else if (StringUtils.equals((CharSequence)IMPORT, (CharSequence)operateKey)) {
            this.openImportForm(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs agrs) {
        super.afterDoOperation(agrs);
        String operateKey = agrs.getOperateKey();
        if (StringUtils.equals((CharSequence)"cal", (CharSequence)operateKey)) {
            DynamicObject plan = (DynamicObject)this.getModel().getValue("head_plan");
            String planNo = plan.getString("number");
            long planId = plan.getLong("plangram");
            this.calcStockForecast(((Object)((Object)this)).getClass().getName(), planId, planNo);
            ReportFilter filter = (ReportFilter)this.getView().getControl("reportfilterap");
            filter.search();
        } else if (StringUtils.equals((CharSequence)"release", (CharSequence)operateKey)) {
            this.changeReleasStatus("B", RequestContext.get().getCurrUserId(), new Date());
        } else if (StringUtils.equals((CharSequence)"unrelease", (CharSequence)operateKey)) {
            this.changeReleasStatus("A", 0L, null);
        } else if (StringUtils.equals((CharSequence)"selectall", (CharSequence)operateKey)) {
            this.selectAll();
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        if (StringUtils.isBlank((Object)filter.getValue("head_plan"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"StockForecastRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((Control)e.getSource()).getKey();
        ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (StringUtils.equals((CharSequence)"head_plan", (CharSequence)key)) {
            ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("runtype", "=", (Object)"A"));
            filters.add(new QFilter("calculatestatus", "=", (Object)"A"));
            filters.add(new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')));
            filters.add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
            filterParameter.setQFilters(filters);
            formShowParameter.setShowUsed(false);
            formShowParameter.setShowApproved(false);
        }
    }

    public void changeReleasStatus(String releaseStatus, long releaseUser, Date releaseTime) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        AbstractGrid.GridState entryState = reportList.getEntryState();
        int[] selectedRows = entryState.getSelectedRows();
        if (selectedRows == null || selectedRows.length == 0) {
            return;
        }
        ArrayList<Long> entryList = new ArrayList<Long>(8);
        for (int selectedRow : selectedRows) {
            DynamicObject rowData = reportModel.getRowData(selectedRow);
            String status = (String)rowData.get("releasestatus");
            if (StringUtils.equals((CharSequence)releaseStatus, (CharSequence)status)) continue;
            long entryid = (Long)rowData.get("entryid");
            entryList.add(entryid);
        }
        entryList.forEach(entryId -> DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"UPDATE t_mrp_stock_datafix SET freleasestatus = ?,freleaser = ?,freleasetime = ? WHERE fentryid = ?", (Object[])new Object[]{releaseStatus, releaseUser, releaseTime, entryId}));
        if ("B".equals(releaseStatus)) {
            entryList.forEach(entryId -> DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)"UPDATE t_mrp_stock_datafix SET ffirstreleaser = ?,ffirstreleasetime = ? WHERE fentryid = ? and ffirstreleaser = 0 ", (Object[])new Object[]{releaseUser, releaseTime, entryId}));
        }
        reportList.refresh();
    }

    private void openImportForm(BeforeDoOperationEventArgs args) {
        String planNofilter;
        IReportCache reportCache = ReportCacheManager.getInstance().getCache();
        ReportQueryParam reportQueryParam = reportCache.getReportQueryParam(this.getView().getPageId());
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject headPlan = filterInfo.getDynamicObject("head_plan");
        String planNo = headPlan == null ? null : headPlan.getString("number");
        long planId = headPlan == null ? 0L : headPlan.getLong("id");
        DynamicObject head_plan = (DynamicObject)this.getModel().getValue("head_plan");
        String string = planNofilter = head_plan == null ? null : head_plan.getString("number");
        if (planNofilter == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212\u8fd0\u7b97\u53f7\u3002", (String)"StockForecastRptPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (planNo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u67e5\u8be2\u62a5\u8868\u540e\u518d\u5bfc\u5165\u3002", (String)"StockForecastRptPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        DynamicObject plan = QueryServiceHelper.queryOne((String)"mrp_caculate_log", (String)"programnumber", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)planId)});
        String programnumber = plan == null ? null : plan.getString("programnumber");
        String caculateLogNo = this.getLatestCaculateLog(programnumber);
        if (!StringUtils.equals((CharSequence)caculateLogNo, (CharSequence)planNo)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u4e0d\u662f\u6700\u65b0\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"StockForecastRptPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]), planNo));
            args.setCancel(true);
            return;
        }
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "mrp_stock_forecast_import");
        para.put("importType", "importType");
        para.put("BillFormId", "mrp_stock_forecast_import");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORT));
        showParameter.setCustomParam("calcNo", (Object)planNo);
        showParameter.setCustomParam("calcId", (Object)planId);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returndata = e.getReturnData();
        if (returndata != null && StringUtils.equals((CharSequence)actionId, (CharSequence)IMPORT)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private String getLatestCaculateLog(String programnumber) {
        QFilter statusFilter = new QFilter("calculatestatus", "=", (Object)"A");
        QFilter typeFilter = new QFilter("runtype", "=", (Object)"A");
        QFilter filter = new QFilter("programnumber", "=", (Object)programnumber);
        DynamicObject[] logs = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id,number", (QFilter[])new QFilter[]{statusFilter, typeFilter, filter}, (String)"startdate desc", (int)1);
        if (logs == null || logs.length == 0) {
            return null;
        }
        return logs[0].getString("number");
    }

    protected void calcStockForecast(String algoKey, long planId, String planNo) {
        RptSchemeInfo rptSchemeInfo = RptUtils.getRptSchemeInfo((long)planId, (String)RptTypeEnum.STOCK_FORECAST.getValue());
        if (rptSchemeInfo == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5ba1\u6838\u4e14\u53ef\u7528\u7684\u62a5\u8868\u65b9\u6848\u3002", (String)"StockForecastRptPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        try {
            DataSet detailDataSet = CalcStockForecastUtils.queryMrpCalcDetail((String)algoKey, (String)planNo, (RptSchemeInfo)rptSchemeInfo);
            HashSet<Long> materialIds = new HashSet<Long>(8);
            HashSet<Long> supplyorgIds = new HashSet<Long>(8);
            DataSet calDetailDataSet = CalcStockForecastUtils.dealDatasWithResource((DataSet)detailDataSet);
            Date historyEarlyDate = null;
            Date lastestDate = null;
            for (Row row : calDetailDataSet.copy()) {
                long material = row.getLong("entryentity.material");
                long supplyorg = row.getLong("entryentity.supplyorg");
                Date date = row.getDate("entryentity.demanddate");
                if (historyEarlyDate == null) {
                    historyEarlyDate = date;
                }
                if (lastestDate == null) {
                    lastestDate = date;
                }
                if (date != null && date.compareTo(historyEarlyDate) <= 0) {
                    historyEarlyDate = date;
                }
                if (date != null && date.compareTo(lastestDate) > 0) {
                    lastestDate = date;
                }
                materialIds.add(material);
                supplyorgIds.add(supplyorg);
            }
            Map planInfo = CalcProductionForecastUtils.getPlanInfos(null, (long)planId);
            DataSet materialInvDataSet = CalcStockForecastUtils.queryMaterialInventory((String)algoKey, materialIds, (Set)((Set)planInfo.get("storageorg")), (Set)((Set)planInfo.get("warehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet invQtyDataSet = CalcStockForecastUtils.getInvQtyDataSet((DataSet)detailDataSet);
            DataSet dullQtyDataSet = CalcStockForecastUtils.getDullQtyDataSet((DataSet)detailDataSet);
            DataSet materialBaseDataSet = CalcStockForecastUtils.queryMaterialBaseInfo((String)algoKey, materialIds);
            DataSet materialPlanDataSet = CalcStockForecastUtils.queryMaterialPlanInfo((String)algoKey, materialIds, supplyorgIds);
            DataSet weekQtyDataSet = CalcStockForecastUtils.queryWeekQty((String)algoKey, (RptSchemeInfo)rptSchemeInfo);
            DataSet monthQtyDataSet = CalcStockForecastUtils.queryMonthQty((String)algoKey, (RptSchemeInfo)rptSchemeInfo);
            DataSet dataSet = CalcStockForecastUtils.relateDataSet((DataSet)calDetailDataSet, (DataSet)materialBaseDataSet, (DataSet)materialPlanDataSet, (DataSet)materialInvDataSet, (DataSet)invQtyDataSet, (DataSet)weekQtyDataSet, (DataSet)monthQtyDataSet, (DataSet)dullQtyDataSet);
            LinkedHashMap pbomDatas = new LinkedHashMap(8);
            dataSet = CalcStockForecastUtils.dealPbomDatas((String)algoKey, (DataSet)dataSet, supplyorgIds, pbomDatas);
            Map params = RptUtils.createParams((RptSchemeInfo)rptSchemeInfo, (Date)historyEarlyDate, (Date)lastestDate);
            dataSet = CalcStockForecastUtils.createNewDataSet((String)algoKey, (Map)params, (DataSet)dataSet, pbomDatas);
            CalcStockForecastUtils.createStockDatas((DataSet)dataSet, (String)planNo, (Map)params);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("mrp-StockForecast", ResManager.loadKDString((String)"\u62a5\u8868\u751f\u6210\u51fa\u9519\uff0c\u8bf7\u67e5\u770b\u7cfb\u7edf\u65e5\u5fd7\u3002", (String)"StockForecastRptPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0])), new Object[0]);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private void selectAll() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        IReportListModel reportModel = reportList.getReportModel();
        int rowCount = reportModel.getRowCount();
        if (rowCount <= 0) {
            return;
        }
        AbstractGrid.GridState entryState = reportList.getEntryState();
        int selectedRowCount = entryState.getSelectedRows().length;
        if (rowCount == selectedRowCount) {
            reportList.clearEntryState();
        } else {
            int[] allSelectRows = new int[rowCount];
            for (int i = 1; i <= rowCount; ++i) {
                allSelectRows[i - 1] = i;
            }
            reportList.selectRows(allSelectRows, 1);
        }
    }
}

