/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.rpt.impt.util.AbstractForecastImportPlugin;
import kd.mmc.mrp.report.rpt.impt.util.ExcelEventParser;
import kd.mmc.mrp.report.rpt.impt.util.FctSheetContentHandler;
import kd.mmc.mrp.rpt.util.DecumentsPlanUtils;

public class DocumentsPlanImportPlugin
extends AbstractForecastImportPlugin {
    private static final int BATCH_SIZE = 5000;
    private final String algoKey = ((Object)((Object)this)).getClass().getSimpleName();
    private static final Log log = LogFactory.getLog(DocumentsPlanImportPlugin.class);
    private static final BigDecimal MAX_QTY = new BigDecimal("1E+13");
    private static final String ENTITYID = "mrp_rpt_decuments_datas";
    private static final String CAL_DETAIL_ENTITYID = "mrp_calcdetail";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dealData(InputStream excelInputStream, final long userId, final List<String> validateErrors, final String calculatelog) {
        try {
            String updateSql;
            final ORM orm = ORM.create();
            final StringBuilder sb = new StringBuilder();
            final Date now = new Date(new java.util.Date().getTime());
            final ArrayList<Object[]> entryValues = new ArrayList<Object[]>();
            final ArrayList<Object[]> subentryValues = new ArrayList<Object[]>();
            final HashMap<String, Map<String, Object>> newDataMap = new HashMap<String, Map<String, Object>>(16);
            final HashMap<String, List<Map<String, Object>>> newEntryDataMap = new HashMap<String, List<Map<String, Object>>>(16);
            final HashMap documnetsPlanData = new HashMap(3);
            new ExcelEventParser(excelInputStream).setHandler(new FctSheetContentHandler(123){
                private int materialIndex;
                private int supplyOrgIndex;
                private List<String> dateCols;
                private List<Map<String, Object>> dateColsList;
                private final Set<String> validateNumberSet;
                private Map<String, List<Map<String, Object>>> materialListMap;
                private DataSet documentsPlan;
                {
                    super(expectedSize);
                    this.materialIndex = -1;
                    this.supplyOrgIndex = -1;
                    this.validateNumberSet = new HashSet<String>();
                    this.documentsPlan = null;
                }

                @Override
                public void endRow(int rowNum) {
                    if (rowNum == 0) {
                        return;
                    }
                    if (rowNum == 1) {
                        return;
                    }
                    if (rowNum == 2) {
                        this.initFirstRowInfo();
                        return;
                    }
                    if (this.rows.isEmpty()) {
                        return;
                    }
                    if (this.isError) {
                        return;
                    }
                    if (rowNum == 3) {
                        this.initData(rowNum + 1, calculatelog);
                    }
                    if (this.materialListMap == null) {
                        return;
                    }
                    String materialNumber = (String)this.rows.get(this.materialIndex);
                    if (StringUtils.isBlank((CharSequence)materialNumber)) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u7269\u6599\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"DocumentsPlanImportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum + 1));
                        return;
                    }
                    QFilter materialFilter = new QFilter("number", "=", (Object)materialNumber);
                    DynamicObject materialDo = QueryServiceHelper.queryOne((String)"bd_material", (String)"baseunit.precision as precision,baseunit.precisionaccount as precisionaccount", (QFilter[])materialFilter.toArray());
                    if (materialDo == null) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"DocumentsPlanImportPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum + 1, materialNumber));
                        return;
                    }
                    int precision = materialDo.getInt("precision") == 0 ? 2 : materialDo.getInt("precision");
                    String precisionaccount = StringUtils.isEmpty((CharSequence)materialDo.getString("precisionaccount")) ? "1" : materialDo.getString("precisionaccount");
                    int precisionRound = DecumentsPlanUtils.getRoundValue((String)precisionaccount);
                    String supplyOrg = (String)this.rows.get(this.supplyOrgIndex);
                    if (StringUtils.isBlank((CharSequence)supplyOrg)) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\u3002", (String)"DocumentsPlanImportPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum + 1));
                        return;
                    }
                    QFilter orgFilter = new QFilter("number", "=", (Object)supplyOrg);
                    if (!QueryServiceHelper.exists((String)"bos_org", (QFilter[])orgFilter.toArray())) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u4f9b\u5e94\u7ec4\u7ec7\u201c%2$s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"DocumentsPlanImportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum + 1, supplyOrg));
                        return;
                    }
                    sb.append(materialNumber).append('_').append(supplyOrg);
                    String numberType = sb.toString();
                    sb.setLength(0);
                    List<Map<String, Object>> list = this.materialListMap.get(numberType);
                    if (list != null) {
                        if (!this.validateNumberSet.add(numberType)) {
                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u548c\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"DocumentsPlanImportPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]), materialNumber, supplyOrg));
                            return;
                        }
                        String remarks = (String)this.rows.get(this.remarksIndex);
                        BigDecimal totalQty = BigDecimal.ZERO;
                        HashMap<String, Object> dateMap = new HashMap<String, Object>();
                        boolean isEntryUpdate = false;
                        for (int j = this.qtyStartIndex; j < this.colNames.size(); ++j) {
                            Object qty;
                            String colName = (String)this.colNames.get(j);
                            try {
                                qty = DocumentsPlanImportPlugin.this.convertNumberValueByF((String)this.rows.get(j));
                            }
                            catch (Exception e) {
                                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u65f6\u95f4\u5217\u201c%3$s\u201d\u503c\u7c7b\u578b\u4e0d\u4e3a\u6570\u503c\u3002", (String)"DocumentsPlanImportPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum + 1, materialNumber, colName));
                                continue;
                            }
                            Map<String, Object> colMap = this.dateColsList.get(j - this.qtyStartIndex);
                            totalQty = totalQty.add((BigDecimal)qty);
                            qty = DecumentsPlanUtils.getScaleBigdecimal((BigDecimal)qty, (Integer)precision, (int)precisionRound);
                            dateMap.put(colMap.get("fieldkey").toString(), qty);
                        }
                        Object[] entryValue = new Object[5];
                        boolean isNoSapleEntry = true;
                        for (Map<String, Object> row : list) {
                            BigDecimal qty;
                            if (isNoSapleEntry) {
                                BigDecimal oldTotalQty = DocumentsPlanImportPlugin.this.convertNumberValueByF(row.get("totalqty").toString());
                                String oldRemark = row.get("remark").toString();
                                if (!StringUtils.equals((CharSequence)oldRemark, (CharSequence)remarks)) {
                                    isEntryUpdate = true;
                                }
                                if (oldTotalQty.compareTo(totalQty) != 0) {
                                    isEntryUpdate = true;
                                }
                                if (isEntryUpdate) {
                                    entryValue[0] = remarks;
                                    totalQty = DecumentsPlanUtils.getScaleBigdecimal((BigDecimal)totalQty, (Integer)precision, (int)precisionRound);
                                    entryValue[1] = totalQty;
                                    entryValue[2] = userId;
                                    entryValue[3] = now;
                                    entryValue[4] = row.get("entryId");
                                    entryValues.add(entryValue);
                                    isNoSapleEntry = false;
                                }
                            }
                            Object[] subentryValue = new Object[2];
                            String fieldkey = row.get("fieldkey").toString();
                            BigDecimal oldQty = DocumentsPlanImportPlugin.this.convertNumberValueByF(row.get("fieldvalue").toString());
                            if (oldQty.compareTo(qty = DocumentsPlanImportPlugin.this.convertNumberValueByF(((BigDecimal)dateMap.get(fieldkey)).toString())) == 0) continue;
                            subentryValue[0] = dateMap.get(fieldkey);
                            subentryValue[1] = row.get("subEntrityId");
                            subentryValues.add(subentryValue);
                        }
                    } else {
                        if (!this.validateNumberSet.add(numberType)) {
                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u7269\u6599\u7f16\u7801\u201c%1$s\u201d\u548c\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u201c%2$s\u201d\u3002", (String)"DocumentsPlanImportPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]), materialNumber, supplyOrg));
                            return;
                        }
                        Map data = newDataMap.computeIfAbsent(numberType, k -> Maps.newHashMapWithExpectedSize((int)3));
                        String remarks = (String)this.rows.get(this.remarksIndex);
                        data.put("remark", remarks);
                        data.put("materialNumber", materialNumber);
                        data.put("supplyOrgNumber", supplyOrg);
                        data.put("caculatelog", calculatelog);
                        BigDecimal totalQty = BigDecimal.ZERO;
                        ArrayList<Map<Object, Object>> dateList = new ArrayList<Map<Object, Object>>();
                        for (int j = this.qtyStartIndex; j < this.colNames.size(); ++j) {
                            BigDecimal qty;
                            Map<Object, Object> dateMap = new HashMap<String, String>();
                            String colName = (String)this.colNames.get(j);
                            try {
                                qty = DocumentsPlanImportPlugin.this.convertNumberValueByF((String)this.rows.get(j));
                            }
                            catch (Exception e) {
                                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u65f6\u95f4\u5217\u201c%3$s\u201d\u503c\u7c7b\u578b\u4e0d\u4e3a\u6570\u503c\u3002", (String)"DocumentsPlanImportPlugin_5", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum + 1, materialNumber, colName));
                                continue;
                            }
                            totalQty = totalQty.add(qty);
                            qty = DecumentsPlanUtils.getScaleBigdecimal((BigDecimal)qty, (Integer)precision, (int)precisionRound);
                            if (StringUtils.equals((CharSequence)ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f", (String)"DocumentsPlanImportPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]), (CharSequence)colName)) {
                                dateMap.put("fieldkey", "pasedate");
                                dateMap.put("fieldcaption", colName);
                                dateMap.put("fieldvalue", qty);
                                dateMap.put("sequence", 0);
                            } else {
                                dateMap = this.dateColsList.get(j - this.qtyStartIndex);
                                dateMap.put("fieldvalue", qty);
                            }
                            dateList.add(dateMap);
                        }
                        newEntryDataMap.put(numberType, dateList);
                        totalQty = DecumentsPlanUtils.getScaleBigdecimal((BigDecimal)totalQty, (Integer)precision, (int)precisionRound);
                        data.put("totalqty", totalQty);
                    }
                    if ((rowNum & 0x3FF) == 0) {
                        this.progress += 2;
                        if (this.progress >= 100) {
                            this.progress = 99;
                        }
                        DocumentsPlanImportPlugin.this.setProgress(this.progress);
                        DocumentsPlanImportPlugin.this.setTip(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790%d\u6761", (String)"DocumentsPlanImportPlugin_7", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum));
                    }
                }

                private void initData(int rowNum, String calculatelog2) {
                    Row fisrtRow;
                    Long entryId;
                    DataSet dateSet;
                    Map decumentsPlanInfo = DocumentsPlanImportPlugin.this.getDecumentsPlanInfo(orm, calculatelog2);
                    if (decumentsPlanInfo == null || decumentsPlanInfo.size() == 0) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%s\u201d \u5c1a\u672a\u751f\u6210\u4ea4\u5355\u8ba1\u5212\u3002", (String)"DocumentsPlanImportPlugin_8", (String)"mmc-mrp-report", (Object[])new Object[0]), rowNum, calculatelog2));
                        return;
                    }
                    QFilter filter = new QFilter("number", "=", (Object)calculatelog2);
                    DynamicObject mrpPlan = QueryServiceHelper.queryOne((String)"mrp_caculate_log", (String)"plangram", (QFilter[])filter.toArray());
                    if (mrpPlan == null) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8fd0\u7b97\u53f7\u5bf9\u5e94\u7684\u8ba1\u5212\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"DocumentsPlanImportPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                    this.documentsPlan = DocumentsPlanImportPlugin.this.getFilterData(orm, calculatelog2);
                    this.dateCols = new ArrayList<String>();
                    if (!this.documentsPlan.isEmpty() && !(dateSet = DocumentsPlanImportPlugin.this.getDateData(calculatelog2, entryId = (fisrtRow = this.documentsPlan.copy().next()).getLong("entryId"))).isEmpty()) {
                        RowMeta dateRowMeta = dateSet.getRowMeta();
                        this.dateColsList = new ArrayList<Map<String, Object>>();
                        for (Row row1 : dateSet) {
                            this.dateCols.add(row1.getString("fieldcaption"));
                            HashMap dateMap = new HashMap();
                            this.dateColsList.add(dateMap);
                            dateRowMeta.toMap(row1, dateMap);
                        }
                    }
                    this.validateDateCol();
                    if (!validateErrors.isEmpty()) {
                        return;
                    }
                    documnetsPlanData.put("logNumber", calculatelog2);
                    documnetsPlanData.put("id", Long.parseLong(decumentsPlanInfo.get("id").toString()));
                    if (!this.documentsPlan.isEmpty()) {
                        RowMeta rowMeta = this.documentsPlan.getRowMeta();
                        this.materialListMap = new HashMap<String, List<Map<String, Object>>>(16);
                        for (Row row : this.documentsPlan) {
                            String materialNumber = row.getString("materialNumber");
                            String supplyOrg = row.getString("supplyorgNumber");
                            HashMap lastmap = Maps.newHashMapWithExpectedSize((int)7);
                            List list = this.materialListMap.computeIfAbsent(materialNumber + "_" + supplyOrg, k -> Lists.newArrayListWithExpectedSize((int)2));
                            rowMeta.toMap(row, (Map)lastmap);
                            list.add(lastmap);
                        }
                    }
                }

                private void validateDateCol() {
                    for (int i = 0; i < this.colNames.size(); ++i) {
                        String colName = (String)this.colNames.get(i);
                        if (!StringUtils.contains((CharSequence)colName, (CharSequence)"/") && !StringUtils.equals((CharSequence)colName, (CharSequence)ResManager.loadKDString((String)"\u8fc7\u53bb\u65e5\u671f", (String)"DocumentsPlanImportPlugin_6", (String)"mmc-mrp-report", (Object[])new Object[0]))) continue;
                        if (this.qtyStartIndex == -1) {
                            this.qtyStartIndex = i;
                        }
                        if (StringUtils.equals((CharSequence)colName, (CharSequence)this.dateCols.get(i - this.qtyStartIndex))) continue;
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c[%s]\u5217\u4e0d\u5b58\u5728\u3002", (String)"DocumentsPlanImportPlugin_10", (String)"mmc-mrp-report", (Object[])new Object[0]), this.dateCols.get(i - this.qtyStartIndex)));
                    }
                    int dateLenght = this.colNames.size() - this.qtyStartIndex;
                    if (this.dateCols.size() != dateLenght) {
                        StringBuilder sb2 = new StringBuilder();
                        int startSize = this.dateCols.size() - dateLenght;
                        if (startSize > 0) {
                            for (int i = dateLenght; i < this.dateCols.size(); ++i) {
                                if (sb2.length() == 0) {
                                    sb2.append(this.dateCols.get(i));
                                    continue;
                                }
                                sb2.append(",").append(this.dateCols.get(i));
                            }
                        }
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u65f6\u95f4\u5217\u7f3a\u5c11%d\u5217,\u5217\u540d\u662f[%s]", (String)"DocumentsPlanImportPlugin_11", (String)"mmc-mrp-report", (Object[])new Object[0]), this.dateCols.size() - dateLenght, sb2.toString()));
                    }
                }

                private void initFirstRowInfo() {
                    if (this.rows.isEmpty()) {
                        validateErrors.add(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u4e2d\u6682\u65e0\u6570\u636e\uff0c\u6216\u7b2c\u4e00\u884c\u4e3a\u7a7a\u884c\u3002", (String)"DocumentsPlanImportPlugin_12", (String)"mmc-mrp-report", (Object[])new Object[0]));
                        this.isError = true;
                        return;
                    }
                    this.colNames = new ArrayList(this.rows);
                    for (int i = 0; i < this.colNames.size(); ++i) {
                        String colName = (String)this.colNames.get(i);
                        if (ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"DocumentsPlanImportPlugin_13", (String)"mmc-mrp-report", (Object[])new Object[0]).equals(colName)) {
                            this.materialIndex = i;
                            continue;
                        }
                        if (ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"DocumentsPlanImportPlugin_14", (String)"mmc-mrp-report", (Object[])new Object[0]).equals(colName)) {
                            this.supplyOrgIndex = i;
                            continue;
                        }
                        if (!ResManager.loadKDString((String)"\u5907\u6ce8", (String)"DocumentsPlanImportPlugin_15", (String)"mmc-mrp-report", (Object[])new Object[0]).equals(colName)) continue;
                        this.remarksIndex = i;
                    }
                    if (this.materialIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"\u201c\u7269\u6599\u7f16\u7801\u201d\u5217\u4e0d\u5b58\u5728\u3002", (String)"DocumentsPlanImportPlugin_16", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                    if (this.supplyOrgIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"\u201c\u4f9b\u5e94\u7ec4\u7ec7\u201d\u5217\u4e0d\u5b58\u5728\u3002", (String)"DocumentsPlanImportPlugin_17", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                    if (this.remarksIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"[\u5907\u6ce8]\u5217\u4e0d\u5b58\u5728\u3002", (String)"DocumentsPlanImportPlugin_18", (String)"mmc-mrp-report", (Object[])new Object[0]));
                    }
                    if (!validateErrors.isEmpty()) {
                        this.isError = true;
                    }
                }
            }).parse();
            if (!validateErrors.isEmpty()) {
                return;
            }
            if (!entryValues.isEmpty()) {
                updateSql = this.updateEntrySql();
                this.batchUpdateSql(updateSql, entryValues);
            }
            if (!subentryValues.isEmpty()) {
                updateSql = this.updateSubEntrySql();
                this.batchUpdateSql(updateSql, subentryValues);
            }
            if (!newDataMap.isEmpty()) {
                this.setTip(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u51fa%d\u6761\u65b0\u589e\u8bb0\u5f55, \u6b63\u5728\u5904\u7406...", (String)"DocumentsPlanImportPlugin_19", (String)"mmc-mrp-report", (Object[])new Object[0]), newDataMap.size()));
                String planId = documnetsPlanData.get("logNumber").toString();
                Long id = Long.parseLong(documnetsPlanData.get("id").toString());
                DataSet newData = DecumentsPlanUtils.importSaveData((String)planId, newDataMap, newEntryDataMap, (java.util.Date)now, (long)userId);
                if (newData != null) {
                    this.addNewData(id, newData, newDataMap, newEntryDataMap, now, userId);
                }
            }
            this.setCompleted();
        }
        catch (Exception e) {
            this.setExceptionStack(e);
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    private void executeBatch(DBRoute dbRoute, String updateSql, List<Object[]> values, int startIndex, int endIndex) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, values.subList(startIndex, endIndex));
    }

    private Map<String, Object> getDecumentsPlanInfo(ORM orm, String caclulatelog) {
        QFilter[] filters = new QFilter("planid", "=", (Object)caclulatelog).toArray();
        try (DataSet dataSet = orm.queryDataSet(this.algoKey, ENTITYID, "id", filters, null, 1);){
            if (dataSet.hasNext()) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)5);
                RowMeta rowMeta = dataSet.getRowMeta();
                rowMeta.toMap(dataSet.next(), (Map)map);
                HashMap hashMap = map;
                return hashMap;
            }
            Map<String, Object> map = null;
            return map;
        }
    }

    private DataSet getFilterData(ORM orm, String caclulatelog) {
        QFilter filter = new QFilter("planid", "=", (Object)caclulatelog);
        QFilter[] filters = filter.toArray();
        String selectFields = "entryentity.id as entryId,entryentity.material.number as materialNumber, entryentity.supplyorg.number as supplyorgNumber,entryentity.remark as remark,entryentity.totalqty as totalqty,entryentity.subentryentity.id as subEntrityId,entryentity.subentryentity.fieldkey as fieldkey,entryentity.subentryentity.fieldcaption as fieldcaption,entryentity.subentryentity.fieldvalue as fieldvalue,entryentity.subentryentity.sequence as sequence";
        return orm.queryDataSet(this.algoKey, ENTITYID, selectFields, filters);
    }

    private DataSet getDateData(String caclulatelog, Long entryId) {
        QFilter filter = new QFilter("planid", "=", (Object)caclulatelog);
        filter.and("entryentity.id", "=", (Object)entryId);
        QFilter[] filters = filter.toArray();
        String selectFields = "entryentity.subentryentity.id as subEntrityId,entryentity.subentryentity.fieldkey as fieldkey,entryentity.subentryentity.fieldcaption as fieldcaption,entryentity.subentryentity.fieldvalue as fieldvalue,entryentity.subentryentity.sequence as sequence";
        return QueryServiceHelper.queryDataSet((String)this.algoKey, (String)ENTITYID, (String)selectFields, (QFilter[])filters, (String)"entryentity.id,entryentity.subentryentity.sequence,entryentity.subentryentity.fieldcaption");
    }

    private void batchUpdateSql(String updateSql, List<Object[]> values) {
        int totalCount = values.size();
        this.setProgress(1);
        this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406...", (String)"DocumentsPlanImportPlugin_20", (String)"mmc-mrp-report", (Object[])new Object[0]));
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITYID);
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        if (totalCount > 5000) {
            int times = DocumentsPlanImportPlugin.calationBatchTimes(totalCount, 5000);
            int finishCount = 0;
            for (int seq = 0; seq < times; ++seq) {
                int startIndex = seq * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                this.executeBatch(dbRoute, updateSql, values, startIndex, endIndex);
                this.setProgress((finishCount += endIndex - startIndex) * 100 / totalCount);
                this.setTip(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406%1$d/%2$d\u6761", (String)"DocumentsPlanImportPlugin_21", (String)"mmc-mrp-report", (Object[])new Object[0]), finishCount, totalCount));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)updateSql, values);
        }
    }

    public static int calationBatchTimes(int count, int batchSize) {
        int times = count / batchSize;
        return count % batchSize != 0 ? times + 1 : times;
    }

    private String updateEntrySql() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE t_mrp_decuments_datafix SET ");
        sb.append("fremark = ?, ");
        sb.append("ftotalqty = ?, ");
        sb.append("fmodifierfield = ?, ");
        sb.append("fentry_modifytime = ? ");
        sb.append("WHERE FEntryId = ?");
        return sb.toString();
    }

    private String updateSubEntrySql() {
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE t_mrp_decuments_datasub SET ");
        sb.append("ffieldvalue = ? ");
        sb.append("WHERE FDetailID = ?");
        return sb.toString();
    }

    private String saveEntrySql() {
        StringBuilder sb = new StringBuilder();
        sb.append("insert  into  t_mrp_decuments_datafix ( ");
        sb.append("fmaterial,").append("fmaterialname,").append("fmodelnum,").append("fsupplyorg,").append("fdemandmodel,").append("foperator,").append("fgoodprodinvqty,");
        sb.append("fdefprodinvqty,").append("fnonstandardqty,").append("fremark,").append("fmodifierfield,").append("fentry_modifytime,").append("freleasestatus,");
        sb.append("fid , ").append("FEntryID,ftotalqty )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        return sb.toString();
    }

    private String saveSubEntrySql() {
        StringBuilder sb = new StringBuilder();
        sb.append("insert  into  t_mrp_decuments_datasub ( ");
        sb.append("ffieldkey,").append("ffieldcaption,").append("ffieldvalue,").append("fsequence,");
        sb.append("FEntryID,").append("FDetailID )").append("  values (?,?,?,?,?,?)");
        return sb.toString();
    }

    protected BigDecimal convertNumberValueByF(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return BigDecimal.ZERO;
        }
        BigDecimal qty = new BigDecimal(value = value.replace(",", ""));
        return qty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qty;
    }

    private void addNewData(Long id, DataSet entity1Set, Map<String, Map<String, Object>> newDataMap, Map<String, List<Map<String, Object>>> newEntryDataMap, Date now, long userId) {
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)ENTITYID);
        int totalSize = newDataMap.size() << 1;
        ORM orm = ORM.create();
        long[] entryIds = orm.genLongIds((IDataEntityType)dt, totalSize);
        int entrySize = 0;
        for (List<Map<String, Object>> list : newEntryDataMap.values()) {
            entrySize += list.size();
        }
        entrySize *= newDataMap.size();
        long[] subEntryIds = orm.genLongIds((IDataEntityType)dt, entrySize <<= 1);
        int count = 0;
        int subCount = 0;
        ArrayList<Object[]> entryData = new ArrayList<Object[]>(newDataMap.size());
        ArrayList<Object[]> subEntryData = new ArrayList<Object[]>(entrySize);
        while (entity1Set.hasNext()) {
            Object[] entryObject = new Object[16];
            Row row = entity1Set.next();
            Long materialId = row.getLong("supmaterial");
            Long supplyorg = row.getLong("supplyorg");
            entryObject[0] = materialId;
            entryObject[1] = row.getString("name");
            entryObject[2] = row.getString("modelnum");
            entryObject[3] = supplyorg;
            entryObject[4] = StringUtils.isBlank((CharSequence)row.getString("demandmodel")) ? "" : row.getString("demandmodel");
            entryObject[5] = row.getLong("operator");
            entryObject[6] = row.getBigDecimal("baseqty1") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty1");
            entryObject[7] = row.getBigDecimal("baseqty2") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty2");
            entryObject[8] = row.getBigDecimal("baseqty3") == null ? BigDecimal.ZERO : row.getBigDecimal("baseqty3");
            String numberType = row.getString("materialNumber") + "_" + row.getString("supplyOrgNumber");
            Map<String, Object> entryMap = newDataMap.get(numberType);
            entryObject[9] = entryMap.get("remark");
            entryObject[10] = userId;
            entryObject[11] = now;
            entryObject[12] = "A";
            entryObject[13] = id;
            Long entryId = entryIds[count++];
            entryObject[14] = entryId;
            entryObject[15] = entryMap.get("totalqty");
            List<Map<String, Object>> dateList = newEntryDataMap.get(numberType);
            for (Map<String, Object> dateMap : dateList) {
                Object[] sunEntryObject = new Object[]{dateMap.get("fieldkey"), dateMap.get("fieldcaption"), dateMap.get("fieldvalue"), dateMap.get("sequence"), entryId, subEntryIds[subCount++]};
                subEntryData.add(sunEntryObject);
            }
            entryData.add(entryObject);
        }
        if (entryData.size() > 0) {
            String saveEntrySql = this.saveEntrySql();
            this.batchUpdateSql(saveEntrySql, entryData);
        }
        if (subEntryData.size() > 0) {
            String saveSubEntrySql = this.saveSubEntrySql();
            this.batchUpdateSql(saveSubEntrySql, subEntryData);
        }
    }
}

