/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.impt.ExcelReader;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.rpt.impt.ForecastSheetHandle;
import kd.mmc.mrp.rpt.entity.BaseDataEntity;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ForcastImportService<T>
extends ExcelReader {
    private static final Log logger = LogFactory.getLog(ForcastImportService.class);
    private static final int MAX_COLWIDTH = 11663;
    private AbstractFormPlugin formPlugin;
    private ForecastSheetHandle<T> sheetHandler;

    public ForcastImportService() {
    }

    public ForcastImportService(AbstractFormPlugin formPlugin, ForecastSheetHandle<T> sheetHandler) {
        this.formPlugin = formPlugin;
        this.sheetHandler = sheetHandler;
    }

    public void handleExcel(InputStream inputStream) throws Exception {
        this.sheetHandler.setDbData(this.seletReportData());
        this.read(inputStream, this.sheetHandler);
        List<T> datas = this.sheetHandler.getDatas();
        Map<String, Set<String>> baseDatas = this.sheetHandler.getBaseDatas();
        Map<String, Map<String, BaseDataEntity>> daseDataDynamicObjects = this.getBaseDataDetails(baseDatas);
        for (T data : datas) {
            this.checkBaseData(data, daseDataDynamicObjects);
            this.checkBusinessData(data);
        }
        Map<Integer, StringJoiner[]> errorMsgs = this.getErrorMsgs();
        if (errorMsgs != null && !errorMsgs.isEmpty()) {
            this.exportErrorMsg(errorMsgs);
        }
        this.saveOrUpdateData();
    }

    public void checkBusinessData(T data) {
    }

    public void saveOrUpdateData() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private void exportErrorMsg(Map<Integer, StringJoiner[]> errorMsgs) {
        if (errorMsgs == null) return;
        if (errorMsgs.isEmpty()) {
            return;
        }
        int size = errorMsgs.size();
        List<Integer> indexs = errorMsgs.keySet().stream().sorted().collect(Collectors.toList());
        if (size != 1) {
            this.createErrorDetail(indexs, errorMsgs);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef\u65e5\u5fd7\u3002", (String)"ForcastImportService_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        Integer index = (Integer)indexs.get(0);
        StringJoiner[] errMsgs = errorMsgs.get(index);
        StringJoiner error1 = errMsgs[0];
        StringJoiner error2 = errMsgs[1];
        if (error1 != null && error2 != null) {
            this.createErrorDetail(indexs, errorMsgs);
            throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef\u65e5\u5fd7\u3002", (String)"ForcastImportService_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        StringBuilder error = new StringBuilder(ResManager.loadKDString((String)"\u7b2c", (String)"ForcastImportService_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
        error.append(index + 1).append(ResManager.loadKDString((String)"\u884c\u5f02\u5e38\u4fe1\u606f:", (String)"ForcastImportService_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
        if (error1 != null) {
            error.append(error1);
        }
        if (error2 == null) throw new KDBizException(error.toString());
        error.append(error2);
        throw new KDBizException(error.toString());
    }

    private void createErrorDetail(List<Integer> indexs, Map<Integer, StringJoiner[]> errorMsgs) {
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        SXSSFSheet sheet = sxssfWorkbook.createSheet();
        SXSSFRow headRow = sheet.createRow(0);
        SXSSFCell cell = headRow.createCell(0, CellType.STRING);
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        Font font = sxssfWorkbook.createFont();
        font.setColor((short)10);
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"ForcastImportService_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
        int i = 0;
        for (Integer index : indexs) {
            StringJoiner[] errorMsgInfos = errorMsgs.get(index);
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u7b2c", (String)"ForcastImportService_0", (String)"mmc-mrp-report", (Object[])new Object[0])).append(index + 1).append(ResManager.loadKDString((String)"\u884c\u5f02\u5e38\u4fe1\u606f\uff1a", (String)"ForcastImportService_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            for (StringJoiner errorMsgInfo : errorMsgInfos) {
                if (errorMsgInfo == null) continue;
                stringBuilder.append(errorMsgInfo);
            }
            SXSSFRow row = sheet.createRow(i + 1);
            ++i;
            row.createCell(0, CellType.STRING).setCellValue(stringBuilder.toString());
        }
        sheet.setColumnWidth(0, 11663);
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            sxssfWorkbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u9519\u8bef\u65e5\u5fd7\u8be6\u60c5.xlsx", (String)"ForcastImportService_5", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, timeout);
            this.formPlugin.getPageCache().put("errorFileUrl", tempUrl);
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException("export failed:" + e.getMessage());
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                sxssfWorkbook.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    public void checkBaseData(T data, Map<String, Map<String, BaseDataEntity>> daseDataDynamicObjects) {
    }

    public Map<String, Map<String, BaseDataEntity>> getBaseDataDetails(Map<String, Set<String>> baseDatas) {
        if (CollectionUtils.isEmpty(baseDatas)) {
            return null;
        }
        HashMap<String, Map<String, BaseDataEntity>> baseDataDetails = new HashMap<String, Map<String, BaseDataEntity>>(baseDatas.size());
        baseDatas.forEach((k, v) -> {
            QFilter qFilter = new QFilter("number", "in", v);
            qFilter.and(new QFilter("enable", "=", (Object)"1"));
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)k);
            if (entityType.getProperty("status") != null) {
                qFilter.and(new QFilter("status", "=", (Object)"C"));
            }
            HashMap<String, BaseDataEntity> baseDataEntityMap = new HashMap<String, BaseDataEntity>(16);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"ForcastImportService", (String)k, (String)"id,number,name", (QFilter[])qFilter.toArray(), null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    String number = row.getString(1);
                    baseDataEntityMap.put(number, new BaseDataEntity(row.get(0), row.getString(2)));
                }
            }
            baseDataDetails.put((String)k, (Map<String, BaseDataEntity>)baseDataEntityMap);
        });
        return baseDataDetails;
    }

    public Map<T, T> seletReportData() {
        return null;
    }

    public ForecastSheetHandle<T> getSheetHandler() {
        return this.sheetHandler;
    }

    public Map<Integer, StringJoiner[]> getErrorMsgs() {
        return this.getSheetHandler() == null ? null : this.getSheetHandler().getErrorMsgs();
    }

    public void setCompleted(int addSize, int updateSize) {
        this.formPlugin.getPageCache().put("complete", String.valueOf(true));
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\uff1a", (String)"ForcastImportService_6", (String)"mmc-mrp-report", (Object[])new Object[0]));
        if (addSize > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u65b0\u589e%s\u6761\u6570\u636e\u3002", (String)"ForcastImportService_7", (String)"mmc-mrp-report", (Object[])new Object[0]), addSize));
        }
        if (updateSize > 0) {
            msg.append(String.format(ResManager.loadKDString((String)"\u66f4\u65b0%s\u6761\u6570\u636e\u3002", (String)"ForcastImportService_8", (String)"mmc-mrp-report", (Object[])new Object[0]), updateSize));
        }
        this.formPlugin.getPageCache().put("completeMsg", msg.toString());
    }

    public void executeSql(String sql, List<Object[]> params, DBRoute dbRoute) {
        if (params == null || params.isEmpty()) {
            return;
        }
        DB.executeBatch((DBRoute)dbRoute, (String)sql, params);
    }
}

