/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import com.google.common.collect.Sets;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.report.rpt.impt.ForcastImportService;
import kd.mmc.mrp.report.rpt.impt.ForecastSheetHandle;
import kd.mmc.mrp.rpt.enmus.RptTypeEnum;
import kd.mmc.mrp.rpt.entity.BaseDataEntity;
import kd.mmc.mrp.rpt.entity.RptSchemeInfo;
import kd.mmc.mrp.rpt.entity.StockForeCastEntity;
import kd.mmc.mrp.rpt.util.CalcProductionForecastUtils;
import kd.mmc.mrp.rpt.util.CalcStockForecastUtils;
import kd.mmc.mrp.rpt.util.RptUtils;

public class StockForecastImportService
extends ForcastImportService<StockForeCastEntity> {
    private final String planNo;
    private final long planId;
    private static final String ENTITY_NAME = "mrp_rpt_stock_datas";
    private long entityId;
    private static final Set<String> MUST_INPUT_COLUMNS = Sets.newHashSet((Object[])new String[]{"material", "supplyorgno"});

    public StockForecastImportService(AbstractFormPlugin formPlugin, ForecastSheetHandle<StockForeCastEntity> sheetHandler, String planNo, long planId) {
        super(formPlugin, sheetHandler);
        this.planNo = planNo;
        this.planId = planId;
    }

    @Override
    public void handleExcel(InputStream inputStream) throws Exception {
        this.getSheetHandler().setMustInputColumns(MUST_INPUT_COLUMNS);
        super.handleExcel(inputStream);
    }

    @Override
    public Map<StockForeCastEntity, StockForeCastEntity> seletReportData() {
        QFilter qFilter = new QFilter("planid", "=", (Object)this.planNo);
        StringJoiner selectProperties = new StringJoiner(",");
        selectProperties.add("id");
        selectProperties.add("entryentity.id");
        selectProperties.add("entryentity.material");
        selectProperties.add("entryentity.supplyorg");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)selectProperties.toString(), (QFilter[])qFilter.toArray());
        if (dynamicObject == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\uff1a\u672a\u751f\u6210\u9884\u6d4b\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"StockForecastImportService_0", (String)"mmc-mrp-report", (Object[])new Object[0]), this.planNo));
        }
        this.entityId = dynamicObject.getLong("id");
        HashMap<StockForeCastEntity, StockForeCastEntity> dbDatas = new HashMap<StockForeCastEntity, StockForeCastEntity>(16);
        DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            DynamicObject org;
            StockForeCastEntity entity = new StockForeCastEntity();
            entity.setId(Long.valueOf(entry.getLong("id")));
            DynamicObject material = entry.getDynamicObject("material");
            if (material != null) {
                entity.setMaterialId(Long.valueOf(material.getLong("id")));
                entity.setMaterialNo(material.getString("number"));
            }
            if ((org = entry.getDynamicObject("supplyorg")) != null) {
                entity.setOrgId(Long.valueOf(org.getLong("id")));
                entity.setOrgNo(org.getString("number"));
            }
            dbDatas.put(entity, entity);
        }
        return dbDatas;
    }

    @Override
    public void checkBaseData(StockForeCastEntity data, Map<String, Map<String, BaseDataEntity>> daseDataDynamicObjects) {
        String orgNo;
        if (daseDataDynamicObjects == null) {
            return;
        }
        if (data.getId() != null && data.getId() != 0L) {
            return;
        }
        String materialNo = data.getMaterialNo();
        if (StringUtils.isNotEmpty((CharSequence)materialNo)) {
            BaseDataEntity material;
            Map<String, BaseDataEntity> materials = daseDataDynamicObjects.get("bd_material");
            BaseDataEntity baseDataEntity = material = materials == null ? null : materials.get(materialNo);
            if (material == null) {
                this.getSheetHandler().fillErrorMsg(data.getRow(), 1, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"StockForecastImportService_1", (String)"mmc-mrp-report", (Object[])new Object[0]), materialNo));
            } else {
                data.setMaterialId((Long)material.getId());
                data.setMaterialNo(material.getName());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(orgNo = data.getOrgNo()))) {
            BaseDataEntity org;
            Map<String, BaseDataEntity> orgs = daseDataDynamicObjects.get("bos_org");
            BaseDataEntity baseDataEntity = org = orgs == null ? null : orgs.get(orgNo);
            if (org == null) {
                this.getSheetHandler().fillErrorMsg(data.getRow(), 1, String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u6216\u4e3a\u4e0d\u53ef\u7528\u3001\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"StockForecastImportService_2", (String)"mmc-mrp-report", (Object[])new Object[0]), orgNo));
            } else {
                data.setOrgId((Long)org.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkBusinessData(StockForeCastEntity data) {
        if (data.getId() != null) {
            return;
        }
        Long materialId = data.getMaterialId();
        Long orgId = data.getOrgId();
        if (materialId == null || orgId == null) {
            return;
        }
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialId);
        QFilter qFilter1 = new QFilter("createorg", "=", (Object)orgId);
        DynamicObject materialplan = QueryServiceHelper.queryOne((String)"mpdm_materialplan", (String)"manufacturegroup", (QFilter[])new QFilter[]{qFilter, qFilter1});
        if (materialplan == null) {
            this.getSheetHandler().fillErrorMsg(data.getRow(), 1, ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u548c\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u7ec4\u5408\u4e0d\u5b58\u5728\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"StockForecastImportService_3", (String)"mmc-mrp-report", (Object[])new Object[0]));
            return;
        }
        long manufacturegroupId = materialplan.getLong("manufacturegroup");
        QFilter qFilter2 = new QFilter("id", "=", (Object)manufacturegroupId);
        DynamicObjectCollection manufacturegroup = QueryServiceHelper.query((String)"mpdm_manustrategy_group", (String)"entryentity.strategynumber", (QFilter[])qFilter2.toArray(), (String)"entryentity.priority desc");
        if (manufacturegroup == null || manufacturegroup.isEmpty()) {
            data.setDemandmodel("");
        } else {
            DynamicObject manufacturegroupmax = (DynamicObject)manufacturegroup.get(0);
            QFilter qFilter3 = new QFilter("id", "=", manufacturegroupmax.get("entryentity.strategynumber"));
            DynamicObject manustrategy = QueryServiceHelper.queryOne((String)"mpdm_manustrategy", (String)"demandmodel", (QFilter[])qFilter3.toArray());
            data.setDemandmodel(manustrategy.getString("demandmodel"));
        }
        QFilter qFilter4 = new QFilter("id", "=", (Object)data.getMaterialId());
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_material", (String)"materialtype", (QFilter[])qFilter4.toArray());
        String materialtype = material.getString("materialtype");
        if ("9".equals(materialtype)) {
            data.setServiceuse("Y");
        } else {
            data.setServiceuse("N");
        }
        RptSchemeInfo rptSchemeInfo = RptUtils.getRptSchemeInfo((long)this.planId, (String)RptTypeEnum.STOCK_FORECAST.getValue());
        Map planInfo = CalcProductionForecastUtils.getPlanInfos(null, (long)this.planId);
        HashSet materialIds = Sets.newHashSet((Object[])new Long[]{materialId});
        HashSet storageOrgs = Sets.newHashSet((Object[])new Long[]{orgId});
        try {
            DataSet mbomCopy;
            String algoKey = StockForecastImportService.class.getName();
            RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"materialId", "orgId"}, (DataType[])new DataType[]{DataType.LongType, DataType.LongType});
            Algo algo = Algo.create((String)algoKey);
            DataSetBuilder dataSetBuilder = algo.createDataSetBuilder(rowMeta);
            dataSetBuilder.append(new Object[]{materialId, orgId});
            DataSet dataSet = dataSetBuilder.build();
            DataSet mboms = null;
            if (!StringUtils.equals((CharSequence)"MTS", (CharSequence)data.getDemandmodel()) && !StringUtils.equals((CharSequence)"STO", (CharSequence)data.getDemandmodel()) && (mbomCopy = (mboms = this.getPbomItem(materialId)).copy()).hasNext()) {
                materialIds.clear();
                while (mbomCopy.hasNext()) {
                    Row row = mbomCopy.next();
                    materialIds.add(row.getLong("materielitem"));
                }
            }
            Object[] selectFields = new String[]{"materialId"};
            String leftmaterialId = "materialId";
            if (mboms != null) {
                selectFields = (String[])ArrayUtils.add((Object[])selectFields, (Object)"materielitem");
                leftmaterialId = "materielitem";
                dataSet = dataSet.leftJoin(mboms).on("materialId", "materielpbom").select((String[])selectFields).finish();
            }
            DataSet threeQty = CalcStockForecastUtils.queryMaterialInventory((String)algoKey, (Set)materialIds, (Set)storageOrgs, (Set)((Set)planInfo.get("warehouse")), (Set)((Set)planInfo.get("location")), (RptSchemeInfo)rptSchemeInfo);
            DataSet weekQtyDataSet = this.queryWeekQty(algoKey, this.planNo, materialIds);
            DataSet monthQtyDataSet = this.queryMonthQty(algoKey, this.planNo, materialIds);
            selectFields = (String[])ArrayUtils.add((Object[])selectFields, (Object)"threeqty");
            dataSet = dataSet.leftJoin(threeQty).on(leftmaterialId, "material").select((String[])selectFields).finish();
            selectFields = (String[])ArrayUtils.add((Object[])selectFields, (Object)"weekqty");
            dataSet = dataSet.leftJoin(weekQtyDataSet).on(leftmaterialId, "entryentity.material").select((String[])selectFields).finish();
            selectFields = (String[])ArrayUtils.add((Object[])selectFields, (Object)"monthqty");
            Row row = (dataSet = dataSet.leftJoin(monthQtyDataSet).on(leftmaterialId, "entryentity.material").select((String[])selectFields).finish()).next();
            data.setThreeqty(row.getBigDecimal("threeqty") == null ? BigDecimal.ZERO : row.getBigDecimal("threeqty"));
            data.setWeekqty(row.getBigDecimal("weekqty") == null ? BigDecimal.ZERO : row.getBigDecimal("weekqty"));
            data.setMonthqty(row.getBigDecimal("monthqty") == null ? BigDecimal.ZERO : row.getBigDecimal("monthqty"));
        }
        finally {
            Algo.closeAllDataSet();
        }
    }

    public DataSet getPbomItem(Long materialId) {
        QFilter qFilter = new QFilter("materielpbom", "=", (Object)materialId);
        String selectStr = "materielitem,materielpbom";
        return QueryServiceHelper.queryDataSet((String)StockForecastImportService.class.getName(), (String)"mds_productfamily", (String)selectStr, (QFilter[])qFilter.toArray(), null);
    }

    public DataSet queryWeekQty(String algoKey, String planNo, Set<Long> materialIds) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_weeksendorder", (String)"id,entryentity.material,entryentity.qty weekqty", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)planNo), new QFilter("entryentity.material", "in", materialIds)}, null);
    }

    public DataSet queryMonthQty(String algoKey, String planNo, Set<Long> materialIds) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"mrp_monthsendorder", (String)"id,entryentity.material,entryentity.qty monthqty", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)planNo), new QFilter("entryentity.material", "in", materialIds)}, null);
    }

    @Override
    public void saveOrUpdateData() {
        List datas = this.getSheetHandler().getDatas();
        int batchSize = 100;
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)ENTITY_NAME);
        DBRoute dbRoute = new DBRoute(entityType.getDBRouteKey());
        ArrayList<Object[]> addEntrys = new ArrayList<Object[]>();
        ArrayList<Object[]> addSubEntrys = new ArrayList<Object[]>();
        ArrayList<Object[]> updateEntrys = new ArrayList<Object[]>();
        ArrayList<Object[]> updateSubEntrys = new ArrayList<Object[]>();
        List<AbstractReportColumn> columns = this.getSheetHandler().getCloumns();
        int fixCloumnsEndIndex = this.getSheetHandler().getFixCloumnsEndIndex() + 1;
        Iterator iterator = datas.iterator();
        long userId = RequestContext.get().getCurrUserId();
        Date time = new Date();
        int updateSize = 0;
        int addSize = 0;
        int updateNum = this.getSheetHandler().getUpdateNum();
        int idSize = updateNum + updateNum * (columns.size() - fixCloumnsEndIndex);
        long[] ids = ID.genLongIds((int)idSize);
        while (iterator.hasNext()) {
            StockForeCastEntity item = (StockForeCastEntity)iterator.next();
            Long id = item.getId();
            if (id == null || id == 0L) {
                ++addSize;
                Object[] saveEntryParams = new Object[18];
                long entryId = ids[--updateNum];
                saveEntryParams[0] = this.entityId;
                saveEntryParams[1] = entryId;
                saveEntryParams[2] = item.getMaterialId();
                saveEntryParams[3] = item.getServiceuse();
                saveEntryParams[4] = item.getOrgId();
                saveEntryParams[5] = item.getDemandmodel();
                saveEntryParams[6] = item.getOperatorId();
                saveEntryParams[7] = 0L;
                saveEntryParams[8] = 0L;
                saveEntryParams[9] = 0L;
                saveEntryParams[10] = userId;
                saveEntryParams[11] = time;
                saveEntryParams[12] = item.getRemark();
                saveEntryParams[13] = item.getWeekqty();
                saveEntryParams[14] = BigDecimal.ZERO;
                saveEntryParams[15] = item.getMonthqty();
                saveEntryParams[16] = item.getMonthqty();
                saveEntryParams[17] = BigDecimal.ZERO;
                addEntrys.add(saveEntryParams);
                for (int i = fixCloumnsEndIndex; i < columns.size(); ++i) {
                    ReportColumn reportColumn = (ReportColumn)columns.get(i);
                    String fieldKey = reportColumn.getFieldKey();
                    String fieldName = reportColumn.getCaption().getLocaleValue();
                    List dynamicData = item.getDynamicData();
                    int index = i - fixCloumnsEndIndex;
                    BigDecimal value = (BigDecimal)dynamicData.get(index);
                    Object[] saveSubEntryParams = new Object[]{entryId, ids[--idSize], fieldKey, fieldName, value, index};
                    addSubEntrys.add(saveSubEntryParams);
                }
            } else {
                ++updateSize;
                Object[] entryParams = new Object[]{userId, time, item.getRemark(), id};
                updateEntrys.add(entryParams);
                for (int i = fixCloumnsEndIndex; i < columns.size(); ++i) {
                    Object[] objects = new Object[3];
                    ReportColumn reportColumn = (ReportColumn)columns.get(i);
                    String fieldKey = reportColumn.getFieldKey();
                    List dynamicData = item.getDynamicData();
                    int index = i - fixCloumnsEndIndex;
                    BigDecimal value = (BigDecimal)dynamicData.get(index);
                    objects[0] = value;
                    objects[1] = item.getId();
                    objects[2] = fieldKey;
                    updateSubEntrys.add(objects);
                }
            }
            if (updateEntrys.size() == batchSize || !iterator.hasNext()) {
                this.updateEntry(updateEntrys, dbRoute);
                updateEntrys.clear();
            }
            if (updateSubEntrys.size() <= batchSize && iterator.hasNext()) continue;
            this.updateSubEntry(updateSubEntrys, dbRoute);
            updateSubEntrys.clear();
        }
        int addEntrysSize = addEntrys.size();
        int fromIndex = 0;
        if (addEntrysSize > 0) {
            while (fromIndex < addEntrysSize) {
                int toIndex = fromIndex + batchSize;
                if (toIndex > addEntrysSize) {
                    toIndex = addEntrysSize;
                }
                this.saveEntry(addEntrys.subList(fromIndex, toIndex), dbRoute);
                fromIndex = toIndex;
            }
        }
        int addSubEntrySize = addSubEntrys.size();
        fromIndex = 0;
        if (addEntrysSize > 0) {
            while (fromIndex < addSubEntrySize) {
                int toIndex = fromIndex + batchSize;
                if (toIndex > addSubEntrySize) {
                    toIndex = addSubEntrySize;
                }
                this.saveSubEntry(addSubEntrys.subList(fromIndex, toIndex), dbRoute);
                fromIndex = toIndex;
            }
        }
        this.setCompleted(addSize, updateSize);
    }

    private void updateEntry(List<Object[]> updateEntrys, DBRoute dbRoute) {
        String sql = "update t_mrp_stock_datafix set fmodifierfield = ?,fmodifytime = ?,fremark = ? where FEntryID = ?";
        this.executeSql(sql, updateEntrys, dbRoute);
    }

    private void saveEntry(List<Object[]> objects, DBRoute dbRoute) {
        String sql = "insert  into t_mrp_stock_datafix (fid,fentryid,fmaterial,fisserviceuse,fsupplyorg,fdemandmodel,foperator,freleaser,freleasestatus,ffirstreleaser,fmodifierfield,fmodifytime,fremark,fweekqty,finvqty,fmonthqty,fthreeqty,fdullqty) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        this.executeSql(sql, objects, dbRoute);
    }

    private void saveSubEntry(List<Object[]> objects, DBRoute dbRoute) {
        String sql = "insert  into t_mrp_stock_datasub (fentryid,fdetailid,ffieldkey,ffieldcaption,ffieldvalue,fsequence) values (?,?,?,?,?,?)";
        this.executeSql(sql, objects, dbRoute);
    }

    private void updateSubEntry(List<Object[]> objects, DBRoute dbRoute) {
        String sql = "update t_mrp_stock_datasub set ffieldvalue = ? where FEntryID = ? and ffieldkey = ? ";
        this.executeSql(sql, objects, dbRoute);
    }
}

