/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.impt.SheetHandler;
import kd.mmc.mrp.report.rpt.impt.ForecastSheetHandle;
import kd.mmc.mrp.rpt.entity.StockForeCastEntity;

public class StockForecastSheetHandle
extends ForecastSheetHandle<StockForeCastEntity> {
    public StockForecastSheetHandle(List<AbstractReportColumn> cloumns, int fixCloumnsEndIndex) {
        super(cloumns, fixCloumnsEndIndex);
    }

    @Override
    public void parsedRowData(SheetHandler.ParsedRow parsedRow) {
        List<AbstractReportColumn> cloumns = this.getCloumns();
        Set<String> mustInputColumns = this.getMustInputColumns();
        Integer rowNum = parsedRow.getRowNum();
        StockForeCastEntity entity = new StockForeCastEntity();
        int fixColumnEndIndex = this.getFixCloumnsEndIndex();
        ArrayList<BigDecimal> dynamicDatas = new ArrayList<BigDecimal>(cloumns.size() - fixColumnEndIndex);
        entity.setDynamicData(dynamicDatas);
        entity.setRow(rowNum);
        for (int i = 0; i < cloumns.size(); ++i) {
            ReportColumn reportColumn = (ReportColumn)cloumns.get(i);
            String columnKey = reportColumn.getFieldKey();
            if ("sumqty".equals(columnKey)) continue;
            String cellValue = parsedRow.get(Integer.valueOf(i));
            String columnName = reportColumn.getCaption().getLocaleValue();
            if (StringUtils.isEmpty((CharSequence)cellValue) && mustInputColumns.contains(columnKey)) {
                this.fillErrorMsg(rowNum, 1, String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u672a\u586b\u5199\u3002", (String)"StockForecastSheetHandle_0", (String)"mmc-mrp-report", (Object[])new Object[0]), columnName));
            }
            String fieldType = StringUtils.isEmpty((CharSequence)reportColumn.getFieldType()) ? "text" : reportColumn.getFieldType();
            try {
                Object value = this.convertValue(fieldType, cellValue);
                if (i > fixColumnEndIndex) {
                    BigDecimal val = (BigDecimal)value;
                    if (val.compareTo(BigDecimal.ZERO) < 0) {
                        this.fillErrorMsg(rowNum, 1, String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u4e0d\u80fd\u5c0f\u4e8e0\u3002", (String)"StockForecastSheetHandle_1", (String)"mmc-mrp-report", (Object[])new Object[0]), columnName));
                        continue;
                    }
                    if (!this.checkBigdecimalFormat(cellValue)) {
                        this.fillErrorMsg(rowNum, 1, String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u4e0d\u80fd\u8d85\u8fc730\u4f4d\uff0c\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc720\u4f4d\u3002", (String)"StockForecastSheetHandle_2", (String)"mmc-mrp-report", (Object[])new Object[0]), columnName));
                        continue;
                    }
                    dynamicDatas.add(val);
                    continue;
                }
                this.setEntityValue(entity, columnKey, value);
                continue;
            }
            catch (Exception e) {
                this.fillErrorMsg(rowNum, 1, String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u7c7b\u578b\u9519\u8bef\u3002", (String)"StockForecastSheetHandle_3", (String)"mmc-mrp-report", (Object[])new Object[0]), columnName));
            }
        }
        if ("B".equals(entity.getReleasestatus())) {
            return;
        }
        Map matchDatas = this.getMatchDatas();
        StockForeCastEntity repeatData = (StockForeCastEntity)matchDatas.get(entity);
        if (repeatData != null) {
            this.fillErrorMsg(repeatData.getRow(), 0, entity.getRow() + 1 + "");
        } else {
            matchDatas.put(entity, entity);
        }
        this.getDatas().add(entity);
        Map dbDatas = this.getDbData();
        StockForeCastEntity dbData = (StockForeCastEntity)dbDatas.get(entity);
        if (dbData != null) {
            entity.setId(dbData.getId());
            entity.setOperatorId(dbData.getOperatorId());
            entity.setOrgId(dbData.getOrgId());
            entity.setMaterialId(dbData.getMaterialId());
        } else {
            this.addBaseData(entity);
            this.addUpdateNum();
        }
    }

    @Override
    public void addBaseData(StockForeCastEntity stockForeCastEntity) {
        String orgNo;
        String materialNo = stockForeCastEntity.getMaterialNo();
        Map<String, Set<String>> baseDatas = this.getBaseDatas();
        if (StringUtils.isNotEmpty((CharSequence)materialNo)) {
            Set materials = baseDatas.computeIfAbsent("bd_material", x -> new HashSet());
            materials.add(materialNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)(orgNo = stockForeCastEntity.getOrgNo()))) {
            Set orgs = baseDatas.computeIfAbsent("bos_org", x -> new HashSet());
            orgs.add(orgNo);
        }
    }

    private void setEntityValue(StockForeCastEntity entity, String columnKey, Object value) {
        switch (columnKey) {
            case "material": {
                entity.setMaterialNo((String)value);
                break;
            }
            case "supplyorgno": {
                entity.setOrgNo((String)value);
                break;
            }
            case "remark": {
                entity.setRemark((String)value);
                break;
            }
            case "releasestatus": {
                value = ResManager.loadKDString((String)"\u5df2\u53d1\u5e03", (String)"StockForecastSheetHandle_4", (String)"mmc-mrp-report", (Object[])new Object[0]).equals(value) ? "B" : "A";
                entity.setReleasestatus((String)value);
                break;
            }
        }
    }
}

