/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.rpt.impt.util;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class AbstractForecastImportPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    private static final Log logger = LogFactory.getLog(AbstractForecastImportPlugin.class);
    private static final String ATTACHMENTPANEL = "attachmentpanelap";
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BTN_OK = "btn_ok";
    private static final String BTN_VIEW = "btn_view";
    private static final String CACHEKEY_URL = "errorFileUrl";
    private static final String CACHEKEY_TIP = "tip";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static final String CACHEKEY_COMPLETE = "complete";
    private static final String CACHEKEY_EXCEPTION = "exception";
    private static final String CACHEKEY_VALIDATE_ERROR = "validate_error";
    private static final int MAX_COLWIDTH = 18215;
    protected static final int DEFAULT_BATCHSIZE = 100;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK, BTN_VIEW});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENTPANEL);
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        progressBar.addProgressListener((ProgresssListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_VIEW});
    }

    public void beforeClick(BeforeClickEvent evt) {
        List<Map<String, Object>> attachmentDataList;
        super.beforeClick(evt);
        Control control = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)BTN_OK, (CharSequence)control.getKey()) && (attachmentDataList = this.getAttachmentData()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20\u6587\u4ef6", (String)"AbstractForecastImportPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTN_OK.equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"AbstractForecastImportPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0])));
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.start();
        } else if (BTN_VIEW.equals(key)) {
            String tempUrl = this.getPageCache().get(CACHEKEY_URL);
            IFormView view = this.getView();
            view.download(tempUrl);
            view.setVisible(Boolean.FALSE, new String[]{BTN_VIEW});
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        int progress = this.getProgress();
        if (progress == 0) {
            this.setProgress(1);
            this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790...", (String)"AbstractForecastImportPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0]));
            RequestContext rc = RequestContextCreator.createForThreadPool();
            long userId = rc.getCurrUserId();
            String calcNo = (String)this.getView().getFormShowParameter().getCustomParam("calcNo");
            Object runnable = new RequestContextRunnable(() -> this.execute(userId, calcNo), rc);
            runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
            new Thread((Runnable)runnable).start();
            return;
        }
        IFormView view = this.getView();
        IPageCache pageCache = this.getPageCache();
        String exceptionStack = pageCache.get(CACHEKEY_EXCEPTION);
        String validateError = pageCache.get(CACHEKEY_VALIDATE_ERROR);
        String completed = pageCache.get(CACHEKEY_COMPLETE);
        if (exceptionStack != null) {
            ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
            progressBar.stop();
            this.removeCache();
            view.hideLoading();
            view.showErrorNotification(exceptionStack);
        } else if (validateError != null) {
            List validateErrors = (List)SerializationUtils.fromJsonString((String)validateError, List.class);
            ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
            progressBar.stop();
            this.removeCache();
            view.hideLoading();
            if (validateErrors.size() == 1) {
                view.showErrorNotification((String)validateErrors.get(0));
            } else {
                this.exportErrorInfo(validateErrors);
            }
        } else if (completed != null) {
            ProgressBar progressBar = (ProgressBar)progressEvent.getSource();
            progressBar.stop();
            view.returnDataToParent((Object)completed);
            view.close();
        } else {
            String tip = this.getTip();
            view.showProgressLoading(new LocaleString(tip), progress);
        }
    }

    protected void setProgress(int progress) {
        this.getPageCache().put(CACHEKEY_PROGRESS, String.valueOf(progress));
    }

    private int getProgress() {
        String str = this.getPageCache().get(CACHEKEY_PROGRESS);
        return StringUtils.isBlank((CharSequence)str) ? 0 : Integer.parseInt(str);
    }

    protected void setTip(String tip) {
        this.getPageCache().put(CACHEKEY_TIP, tip);
    }

    private String getTip() {
        return this.getPageCache().get(CACHEKEY_TIP);
    }

    protected void setCompleted() {
        this.getPageCache().put(CACHEKEY_COMPLETE, String.valueOf(true));
    }

    protected void setExceptionStack(Exception exception) {
        this.getPageCache().put(CACHEKEY_EXCEPTION, exception.toString());
    }

    private void execute(long userId, String calcNo) {
        try (InputStream inputStream = this.getInputStream();){
            ArrayList<String> validateErrors = new ArrayList<String>();
            this.dealData(inputStream, userId, validateErrors, calcNo);
            if (!validateErrors.isEmpty()) {
                this.getPageCache().put(CACHEKEY_VALIDATE_ERROR, SerializationUtils.toJsonString(validateErrors));
            }
        }
        catch (IOException e) {
            logger.error((Throwable)e);
        }
    }

    private void removeCache() {
        this.getPageCache().remove(CACHEKEY_PROGRESS);
        this.getPageCache().remove(CACHEKEY_EXCEPTION);
        this.getPageCache().remove(CACHEKEY_VALIDATE_ERROR);
    }

    private InputStream getInputStream() {
        List<Map<String, Object>> attachmentDataList = this.getAttachmentData();
        Map<String, Object> attachmentData = attachmentDataList.get(0);
        String fileUrl = (String)attachmentData.get("url");
        Map<String, String> parseUrl = this.parseUrl(fileUrl);
        TempFileCacheDownloadable downLoadCache = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        TempFileCacheDownloadable.Content content = downLoadCache.get(parseUrl.get("configKey"), parseUrl.get("id"));
        return content.getInputStream();
    }

    private List<Map<String, Object>> getAttachmentData() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl(ATTACHMENTPANEL);
        return attachmentPanel.getAttachmentData();
    }

    private void exportErrorInfo(List<String> validateErrors) {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        SXSSFSheet sheet = sxssfWorkbook.createSheet();
        SXSSFRow headRow = sheet.createRow(0);
        SXSSFCell cell = headRow.createCell(0, CellType.STRING);
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        Font font = sxssfWorkbook.createFont();
        font.setColor((short)10);
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cell.setCellStyle(cellStyle);
        cell.setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u539f\u56e0", (String)"AbstractForecastImportPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
        int errorInfoListSize = validateErrors.size();
        for (int i = 0; i < errorInfoListSize; ++i) {
            String errorInfo = validateErrors.get(i);
            SXSSFRow row = sheet.createRow(i + 1);
            row.createCell(0, CellType.STRING).setCellValue(errorInfo);
        }
        sheet.setColumnWidth(0, 18215);
        try {
            outStream = new ByteArrayOutputStream();
            sxssfWorkbook.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u65e5\u5fd7\u8be6\u60c5.xlsx", (String)"AbstractForecastImportPlugin_3", (String)"mmc-mrp-report", (Object[])new Object[0]), (InputStream)inStream, 7200);
            this.getPageCache().put(CACHEKEY_URL, tempUrl);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u70b9\u51fb\u67e5\u770b\u8be6\u60c5\u67e5\u8be2\u9519\u8bef\u65e5\u5fd7", (String)"AbstractForecastImportPlugin_4", (String)"mmc-mrp-report", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.TRUE, new String[]{BTN_VIEW});
        }
        catch (IOException e) {
            logger.error((Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "export failed:" + e.getMessage()), new Object[0]);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                sxssfWorkbook.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
    }

    protected void dealData(InputStream excelInputStream, long userId, List<String> validateErrors, String calcNo) {
    }

    private Map<String, String> parseUrl(String url) {
        String[] pairStr = url.split("\\?");
        String[] pairs = pairStr[1].split("&");
        HashMap result = Maps.newHashMapWithExpectedSize((int)2);
        int index0 = 0;
        int index1 = 1;
        for (String pair : pairs) {
            String[] p = pair.split("=");
            result.put(p[index0], p[index1]);
        }
        return result;
    }
}

