/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.supdem;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mmc.mrp.calcnode.framework.mq.resolver.balance.MRPDataBalanceResolver4RealTimeRpt;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.KDCloudSysConfigProvider;
import kd.mmc.mrp.integrate.entity.PlanModel;
import kd.mmc.mrp.model.enums.DefaultField;
import kd.mmc.mrp.model.enums.EnvCfgItem;
import kd.mmc.mrp.model.table.DataBalanceTable;
import kd.mmc.mrp.model.table.RequireRowData;
import kd.mmc.mrp.model.table.RowData;
import kd.mmc.mrp.model.table.res.AbstractResModelDataTable;
import kd.mmc.mrp.model.table.res.RequirementDataTable;
import kd.mmc.mrp.model.table.res.SupplymentDataTable;
import kd.mmc.mrp.report.supdem.KDCloudRealTimeRptEnv;
import kd.mmc.mrp.report.supdem.RealTimeMRPRunner;
import kd.mmc.mrp.report.util.FilterDUtils;
import kd.mmc.mrp.utils.MRPUtil;

public class SupplyDemandByConditionListQueryPlugin
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(SupplyDemandByConditionListQueryPlugin.class);
    private static final String MT = "keymaterial";
    private static final String RANGE = "range";
    private static final String FILTER_PLANSCOPE = "filter_planscope";
    private static final String FILTER_ORG = "filter_org";
    private static final String TB_RANGE = "mrp_supdem_rangenew";
    private static String[] a = new String[]{"config_filter", "supplier_filter", "customer_filter", "material_filter", "unit_filter", "configuredcode_filter", "tracknumber_filter", "project_filter", "planscope_filter", "warehouse_filter", "useorg_filter"};
    private static String[] orderBys = new String[]{"isempty", "isinvrow", "invrowtype", "configuredcode", "project", "tracknumber", "billdate", "rowtype desc"};
    private String ROWTYPE_REQUIRE = ResManager.loadKDString((String)"\u9700\u6c42\u884c", (String)"MRPDataBalanceResolver4RealTimeRpt_2", (String)"mmc-mrp-mservice-calcnode", (Object[])new Object[0]);
    private long sumRowIdx = 10000000L;
    private int cnt;
    private int qtyIdx;
    private int onworkqtyIdx;
    private int pickedqtyIdx;
    private int remainqtyIdx;
    private int leftqtyIdx;
    private int reserveqtyIdx;
    private int pidIdx;
    private int isgroupnodeIdx;
    private int rowidIdx;
    private int billdateIdx;
    private int rowtypeIdx;
    private int rowSeq = 1;
    private static Map<String, String> requireDB2Memory = new HashMap<String, String>();
    private static Map<String, String> supplyDB2Memory = new HashMap<String, String>();

    public SupplyDemandByConditionListQueryPlugin() {
        requireDB2Memory.clear();
        requireDB2Memory.put("material", DefaultField.RequireField.MATERIAL.getName());
        requireDB2Memory.put("demandbilltype", DefaultField.CommonField.__MODEL_NUMBER__.name());
        requireDB2Memory.put("demandbillf7", DefaultField.RequireField.BILL_ENTITY.getName());
        requireDB2Memory.put("bomversion", DefaultField.RequireField.__BOM_VERSION__.getName());
        requireDB2Memory.put("demandqty", DefaultField.RequireField.QTY.getName());
        requireDB2Memory.put("billid", DefaultField.RequireField.BILLID.getName());
        requireDB2Memory.put("billno", DefaultField.RequireField.BILLNUMBER.getName());
        requireDB2Memory.put("demanddate", DefaultField.RequireField.DATE.getName());
        requireDB2Memory.put("billentryid", DefaultField.RequireField.BILLENTRYID.getName());
        requireDB2Memory.put("billentryseq", DefaultField.RequireField.BILLENTRYSEQ.getName());
        requireDB2Memory.put("srcdemandqty", DefaultField.RequireField.__MERGE_REQQTY_.getName());
        requireDB2Memory.put("requireorg", DefaultField.RequireField.PRODUCTIONORGUNIT.getName());
        requireDB2Memory.put("reqpriority", DefaultField.RequireField.__PRIORITY_LEVEL__.getName());
        requireDB2Memory.put("materialattr", DefaultField.RequireField.MATERIALATTR.getName());
        requireDB2Memory.put("orderdate", DefaultField.RequireField.__ORDER_DATE__.getName());
        requireDB2Memory.put("leadtime", DefaultField.RequireField.__LEADTIME__.getName());
        requireDB2Memory.put("entryqtytype", DefaultField.RequireField.__CHILDAMTTYPE__.getName());
        requireDB2Memory.put("entryqtynumerator", DefaultField.RequireField.__CHILDNUMERATOR__.getName());
        requireDB2Memory.put("entryqtydenominator", DefaultField.RequireField.__CHILDDENOMINATOR__.getName());
        requireDB2Memory.put("wastagerateformula", DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName());
        requireDB2Memory.put("exception", DefaultField.RequireField.EXCEPTIONMESSAGE.getName());
        requireDB2Memory.put("exceptionnumber", DefaultField.RequireField.EXCEPTIONNUMBER.getName());
        requireDB2Memory.put("reqsourcebillno", DefaultField.RequireField.__REQUIRE_SOURCE__.getName());
        requireDB2Memory.put("parentbomid", DefaultField.RequireField.__BOMID__.getName());
        requireDB2Memory.put("bomid", DefaultField.RequireField.__PARENT_BOMID__.getName());
        requireDB2Memory.put("yieldratio", DefaultField.RequireField.YIELD.getName());
        requireDB2Memory.put("scrapratio", DefaultField.RequireField.__SCRAPRATIO__.getName());
        requireDB2Memory.put("dynamicscrapratio", DefaultField.RequireField.__DYNAMICSCRAPRATIO__.getName());
        requireDB2Memory.put("fixscrap", DefaultField.RequireField.__FIXSCRAP__.getName());
        requireDB2Memory.put("dynamicscrapformula", DefaultField.RequireField.__DYNAMICSCRAPFORMULA__.getName());
        requireDB2Memory.put("origindemanddate", DefaultField.RequireField.__ORIGIN_DEMAND_DATE__.getName());
        requireDB2Memory.put("requireoperator", DefaultField.RequireField.REQUIREOPERAOTR.getName());
        requireDB2Memory.put("demandsourcetype", DefaultField.RequireField.REQUIRETYPE.getName());
        requireDB2Memory.put("configuredcode", DefaultField.RequireField.CONFIGUREDCODE.getName());
        requireDB2Memory.put("tracknumber", DefaultField.RequireField.TRACKNUMBER.getName());
        requireDB2Memory.put("demandstorage", DefaultField.RequireField.OWNER.getName());
        requireDB2Memory.put("demandauxpty", DefaultField.RequireField.MATERIALFLEXPROPS.getName());
        requireDB2Memory.put("reqflexmetricid", DefaultField.RequireField.FLEXMETRICID.getName());
        requireDB2Memory.put("reqflexmetricval", DefaultField.RequireField.FLEXMETRICVALUE.getName());
        requireDB2Memory.put("demandproject", DefaultField.RequireField.PROJECTNUMBER.getName());
        requireDB2Memory.put("demandsupplier", DefaultField.RequireField.SUPPLIER.getName());
        requireDB2Memory.put("demandplanscope", DefaultField.RequireField.PLANSCOPE.getName());
        requireDB2Memory.put("demandwarehouse", DefaultField.RequireField.WAREHOUSE.getName());
        requireDB2Memory.put("resourcetype", DefaultField.RequireField.RESOURCETYPE.getName());
        requireDB2Memory.put("coptype", DefaultField.RequireField.INTER_ASSIST_TYPE.getName());
        requireDB2Memory.put("manustrategy", DefaultField.RequireField.PLAN_STRATEGY.getName());
        requireDB2Memory.put("onworkqty4req", DefaultField.RequireField.ONWORKQTY.getName());
        requireDB2Memory.put("receiveqty4req", DefaultField.RequireField.PICKEDQTY.getName());
        supplyDB2Memory.clear();
        supplyDB2Memory.put("supplybilltype", DefaultField.CommonField.__MODEL_NUMBER__.name());
        supplyDB2Memory.put("supplybillf7", DefaultField.SupplyField.BILL_ENTITY.getName());
        supplyDB2Memory.put("supmaterial", DefaultField.SupplyField.MATERIAL.getName());
        supplyDB2Memory.put("suppriority", DefaultField.SupplyField.__PRIORITY_LEVEL__.getName());
        supplyDB2Memory.put("supplyqty", DefaultField.SupplyField.QTY.getName());
        supplyDB2Memory.put("originsupplyqty", DefaultField.SupplyField.ORIGINQTY.getName());
        supplyDB2Memory.put("supplybillid", DefaultField.SupplyField.BILLID.getName());
        supplyDB2Memory.put("supplybillno", DefaultField.SupplyField.BILLNUMBER.getName());
        supplyDB2Memory.put("supplydate", DefaultField.SupplyField.DATE.getName());
        supplyDB2Memory.put("supplybillentryid", DefaultField.SupplyField.BILLENTRYID.getName());
        supplyDB2Memory.put("adjustdate", DefaultField.SupplyField.__ADJUST_PLAN_DATE__.name());
        supplyDB2Memory.put("adjustsuggest", DefaultField.SupplyField.__ADJUST_FLAG__.name());
        supplyDB2Memory.put("adjustqty", DefaultField.SupplyField.__ADJUST_QTY__.name());
        supplyDB2Memory.put("supplybillentryseq", DefaultField.SupplyField.BILLENTRYSEQ.getName());
        supplyDB2Memory.put("sexpmsg", DefaultField.SupplyField.__EXCEPTIONMESSAGE__.getName());
        supplyDB2Memory.put("sexpnumber", DefaultField.SupplyField.__EXCEPTIONNUMBER__.getName());
        supplyDB2Memory.put("warehouse", DefaultField.SupplyField.WAREHOUSE.getName());
        supplyDB2Memory.put("location", DefaultField.SupplyField.STOCKLOT.getName());
        supplyDB2Memory.put("invpriority", DefaultField.SupplyField.__SUPPLY_PRIORITY__.getName());
        supplyDB2Memory.put("supplyorg", DefaultField.SupplyField.SUPPLYORGUNIT.getName());
        supplyDB2Memory.put("supplyoperator", DefaultField.SupplyField.SUPPLYOPERATOR.getName());
        supplyDB2Memory.put("supplantag", DefaultField.SupplyField.SUPPLANTAG.getName());
        supplyDB2Memory.put("suptracknumber", DefaultField.SupplyField.TRACKNUMBER.getName());
        supplyDB2Memory.put("supplystorage", DefaultField.SupplyField.OWNER.getName());
        supplyDB2Memory.put("supplyauxpty", DefaultField.SupplyField.MATERIALFLEXPROPS.getName());
        supplyDB2Memory.put("copsupply", DefaultField.SupplyField.COPSUPPLY.getName());
        supplyDB2Memory.put("supflexmetricid", DefaultField.SupplyField.FLEXMETRICID.getName());
        supplyDB2Memory.put("supflexmetricval", DefaultField.SupplyField.FLEXMETRICVALUE.getName());
        supplyDB2Memory.put("supplyproject", DefaultField.SupplyField.PROJECTNUMBER.getName());
        supplyDB2Memory.put("supplysupplier", DefaultField.SupplyField.SUPPLIER.getName());
        supplyDB2Memory.put("supplyplanscope", DefaultField.SupplyField.PLANSCOPE.getName());
        supplyDB2Memory.put("onworkqty4sup", DefaultField.SupplyField.ONWORKQTY.getName());
        supplyDB2Memory.put("receiveqty4sup", DefaultField.SupplyField.PICKEDQTY.getName());
    }

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        DataSet ds;
        Long planScopeId = 0L;
        FilterInfo filter = queryParam.getFilter();
        DynamicObject planscope = filter.getDynamicObject(FILTER_PLANSCOPE);
        if (planscope != null) {
            planScopeId = planscope.getLong("id");
        }
        DynamicObject org = filter.getDynamicObject(FILTER_ORG);
        Long orgId = org.getLong("id");
        FilterItemInfo mtItem = filter.getFilterItem(MT);
        List value = (List)mtItem.getValue();
        HashSet<Long> masterIdSet = new HashSet<Long>(value.size());
        for (DynamicObject dyn : value) {
            Long masterId = dyn.getLong("masterid");
            if (masterId == null || masterId == 0L) {
                logger.warn(String.format("mrprunner-realtimerpt-no-masterid orgId:%s, planScopeId: %s, masterId: 0", orgId, planScopeId));
                masterId = dyn.getLong("id");
            }
            masterIdSet.add(masterId);
        }
        FilterItemInfo rangeItem = filter.getFilterItem(RANGE);
        String range = rangeItem.getString();
        boolean showDem = "1".equals(range) || "2".equals(range);
        boolean showSup = "1".equals(range) || "3".equals(range);
        DynamicObject ctrlType = filter.getDynamicObject("innercoptype");
        String innercoptype = ctrlType == null ? "B" : ctrlType.getString("type");
        DynamicObject manustrategy = filter.getDynamicObject("manustrategy");
        if (manustrategy != null) {
            manustrategy = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_manustrategy", (String)"id,traceway,invisolation", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)manustrategy.getLong("id"))});
        }
        AppParam appParam = new AppParam("0MBBBZ1L5IAW", orgId);
        Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        Long supdem_range_id = (Long)mrpParam.get("supdem_range_id");
        DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)TB_RANGE, (String)"id, demandentry.demandconfig,supplyentry.supplyconfig,matchrule,mrpplan,bizplan", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)supdem_range_id)});
        DynamicObject mrpPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)dyn.getDynamicObject("mrpplan").get("id"), (String)"mrp_planprogram");
        DynamicObject bizPlan = BusinessDataServiceHelper.loadSingleFromCache((Object)dyn.getDynamicObject("bizplan").get("id"), (String)"mrp_businessplan");
        HashMap<String, Object> cParams = queryParam.getCustomParam();
        if (cParams == null) {
            cParams = new HashMap<String, Object>();
            queryParam.setCustomParam(cParams);
        }
        Boolean isStatic = (Boolean)cParams.get("isStatic");
        RowMeta meta = new RowMeta(new String[]{"org", "material", "unit", "billdate", "qty", "billid", "billnumber", "billentryseq", "configuredcode", "tracknumber", "auxproperty", "project", "planscope", "warehouse", "srctype", "config", "billtag", "rowtype", "useorg", "supplier", "customer", "matattr", "onworkqty", "pickedqty", "isinvrow", "config_txt", "billstatusfield", "preparedate", "reserveqty", "remainqty", "relevancebill", "leftqty"}, new DataType[]{DataType.LongType, DataType.LongType, DataType.LongType, DataType.TimestampType, DataType.BigDecimalType, DataType.LongType, DataType.StringType, DataType.IntegerType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.LongType, DataType.StringType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.IntegerType, DataType.StringType, DataType.StringType, DataType.TimestampType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.StringType, DataType.BigDecimalType});
        Object oldId = cParams.get("detail_dataset_id");
        Algo algo = Algo.create((String)"real_time_rpt");
        if (oldId != null) {
            Object val = cParams.get("isRefresh");
            boolean isRefresh = Boolean.parseBoolean(String.valueOf(val));
            if (isRefresh) {
                Algo.removeCacheDataSet((String)String.valueOf(oldId));
                ds = this.execute(algo, isStatic, cParams, meta, mrpPlan, bizPlan, orgId, masterIdSet, showDem, showSup, planScopeId, innercoptype, manustrategy);
            } else {
                CachedDataSet cds;
                try {
                    cds = Algo.getCacheDataSet((String)String.valueOf(oldId));
                }
                catch (Throwable error) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u62a5\u8868\u3002", (String)"SupplyDemandRptFormPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
                }
                ds = cds.toDataSet(algo, false);
            }
        } else {
            ds = this.execute(algo, isStatic, cParams, meta, mrpPlan, bizPlan, orgId, masterIdSet, showDem, showSup, planScopeId, innercoptype, manustrategy);
        }
        String str = this.setHeadFilter(queryParam.getFilter());
        ds = FilterDUtils.HeaderFilter(ds, queryParam.getFilter());
        List list = (List)SerializationUtils.deSerializeFromBase64((String)str);
        queryParam.getFilter().getTableHeadFilterItems().clear();
        queryParam.getFilter().getTableHeadFilterItems().addAll(list);
        ds = this.doFilter(algo, ds);
        ds = ds.addFields(new String[]{"case when leftqty is null then true else false end"}, new String[]{"iscolor"});
        return ds;
    }

    private String setHeadFilter(FilterInfo filterInfo) {
        List headFilters = filterInfo.getTableHeadFilterItems();
        String str = SerializationUtils.serializeToBase64((Object)headFilters);
        Iterator iterator = headFilters.iterator();
        Set set = Arrays.stream(a).collect(Collectors.toSet());
        while (iterator.hasNext()) {
            FilterItemInfo next = (FilterItemInfo)iterator.next();
            String propName = next.getPropName();
            if (!set.contains(propName)) continue;
            iterator.remove();
        }
        block27: for (int i = 0; i < headFilters.size(); ++i) {
            FilterItemInfo qFilter = (FilterItemInfo)headFilters.get(i);
            switch (qFilter.getPropName()) {
                case "config": {
                    qFilter.setPropName("config_filter");
                    continue block27;
                }
                case "supplier": {
                    qFilter.setPropName("supplier_filter");
                    continue block27;
                }
                case "customer": {
                    qFilter.setPropName("customer_filter");
                    continue block27;
                }
                case "material": {
                    qFilter.setPropName("material_filter");
                    continue block27;
                }
                case "unit": {
                    qFilter.setPropName("unit_filter");
                    continue block27;
                }
                case "configuredcode": {
                    qFilter.setPropName("configuredcode_filter");
                    continue block27;
                }
                case "tracknumber": {
                    qFilter.setPropName("tracknumber_filter");
                    continue block27;
                }
                case "project": {
                    qFilter.setPropName("project_filter");
                    continue block27;
                }
                case "planscope": {
                    qFilter.setPropName("planscope_filter");
                    continue block27;
                }
                case "warehouse": {
                    qFilter.setPropName("warehouse_filter");
                    continue block27;
                }
                case "useorg": {
                    qFilter.setPropName("useorg_filter");
                    continue block27;
                }
            }
        }
        return str;
    }

    private DataSet doFilter(Algo algo, DataSet ds) {
        RowMeta meta = ds.getRowMeta();
        StringBuilder fields = new StringBuilder();
        StringBuilder fields2 = new StringBuilder();
        int size = meta.getFieldCount();
        for (int i = 0; i < size; ++i) {
            String field = meta.getFieldAlias(i);
            if ("leftqty".equals(field)) {
                fields.append("(case when leftqty is null then null");
                fields.append(" when PreRowValue(tracknumber) = tracknumber and PreRowValue(project) = project then PreRowValue(leftqty) + qty");
                fields.append(" else qty end) as leftqty, ");
                fields.append("(case when leftqty is null then PreRowValue(leftqty2) + 0");
                fields.append(" when PreRowValue(tracknumber) = tracknumber and PreRowValue(project) = project then PreRowValue(leftqty2) + qty");
                fields.append(" else qty end) as leftqty2");
                fields2.append("(case when leftqty is null then null else leftqty2 end) as leftqty");
            } else {
                fields.append(field);
                fields2.append(field);
            }
            if (i >= size - 1) continue;
            fields.append(", ");
            fields2.append(", ");
        }
        KDCloudSysConfigProvider provider = new KDCloudSysConfigProvider();
        provider.load();
        String orderByFields = (String)provider.getCfgValue(EnvCfgItem.REALTIMERPT_ORDER_FIELDS);
        if (orderByFields != null && !orderByFields.trim().equalsIgnoreCase("NONE")) {
            orderBys = orderByFields.split(",");
        }
        ds = ds.addField("(case when leftqty is null then 1 else 0 end)", "isempty");
        ds = ds.addField("(case when isinvrow = 0 and qty > 0 then 0 else 1 end)", "invrowtype");
        ds = ds.orderBy(orderBys);
        ds = ds.select(fields.toString());
        fields2.append(", (0) as pid");
        fields2.append(", (0) as isgroupnode");
        fields2.append(", (billid) as rowid");
        ds = ds.select(fields2.toString());
        meta = ds.getRowMeta();
        this.cnt = meta.getFieldCount();
        Field[] copyFields = new Field[this.cnt + 1];
        System.arraycopy(meta.getFields(), 0, copyFields, 0, this.cnt);
        copyFields[this.cnt] = new Field("seq_", (DataType)DataType.IntegerType);
        meta = new RowMeta(copyFields);
        this.qtyIdx = meta.getFieldIndex("qty");
        this.onworkqtyIdx = meta.getFieldIndex("onworkqty");
        this.pickedqtyIdx = meta.getFieldIndex("pickedqty");
        this.remainqtyIdx = meta.getFieldIndex("remainqty");
        this.leftqtyIdx = meta.getFieldIndex("leftqty");
        this.reserveqtyIdx = meta.getFieldIndex("reserveqty");
        this.pidIdx = meta.getFieldIndex("pid");
        this.isgroupnodeIdx = meta.getFieldIndex("isgroupnode");
        this.rowidIdx = meta.getFieldIndex("rowid");
        this.billdateIdx = meta.getFieldIndex("billdate");
        this.rowtypeIdx = meta.getFieldIndex("rowtype");
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        Object[] row = null;
        block1: while (ds.hasNext()) {
            Row next = ds.next();
            row = this.copyRow(next, 0L, null);
            String rowType = next.getString("rowtype");
            if (!this.ROWTYPE_REQUIRE.equals(rowType)) {
                datas.add(row);
                row = null;
                continue;
            }
            Date billDate = next.getDate("billdate");
            boolean isSumRowAdded = false;
            Object[] sumRow = null;
            while (ds.hasNext()) {
                next = ds.next();
                rowType = next.getString("rowtype");
                if (this.ROWTYPE_REQUIRE.equals(rowType)) {
                    if (billDate.equals(next.getDate("billdate"))) {
                        if (!isSumRowAdded) {
                            sumRow = this.createSumRow(billDate);
                            datas.add(sumRow);
                            int tmp = (Integer)sumRow[this.cnt];
                            sumRow[this.cnt] = row[this.cnt];
                            row[this.cnt] = tmp;
                            row[this.pidIdx] = sumRow[this.rowidIdx];
                            row[this.rowtypeIdx] = "";
                            datas.add(row);
                            isSumRowAdded = true;
                            sumRow[this.qtyIdx] = ((BigDecimal)sumRow[this.qtyIdx]).add((BigDecimal)row[this.qtyIdx]);
                            sumRow[this.onworkqtyIdx] = ((BigDecimal)sumRow[this.onworkqtyIdx]).add((BigDecimal)row[this.onworkqtyIdx]);
                            sumRow[this.pickedqtyIdx] = ((BigDecimal)sumRow[this.pickedqtyIdx]).add((BigDecimal)row[this.pickedqtyIdx]);
                            sumRow[this.remainqtyIdx] = row[this.remainqtyIdx];
                            sumRow[this.leftqtyIdx] = row[this.leftqtyIdx];
                            sumRow[this.reserveqtyIdx] = ((BigDecimal)sumRow[this.reserveqtyIdx]).add((BigDecimal)row[this.reserveqtyIdx]);
                            row = null;
                        }
                        Object[] subRow = this.copyRow(next, (Long)sumRow[this.rowidIdx], "");
                        sumRow[this.qtyIdx] = ((BigDecimal)sumRow[this.qtyIdx]).add((BigDecimal)subRow[this.qtyIdx]);
                        sumRow[this.onworkqtyIdx] = ((BigDecimal)sumRow[this.onworkqtyIdx]).add((BigDecimal)subRow[this.onworkqtyIdx]);
                        sumRow[this.pickedqtyIdx] = ((BigDecimal)sumRow[this.pickedqtyIdx]).add((BigDecimal)subRow[this.pickedqtyIdx]);
                        sumRow[this.remainqtyIdx] = subRow[this.remainqtyIdx];
                        sumRow[this.leftqtyIdx] = subRow[this.leftqtyIdx];
                        sumRow[this.reserveqtyIdx] = ((BigDecimal)sumRow[this.reserveqtyIdx]).add((BigDecimal)subRow[this.reserveqtyIdx]);
                        datas.add(subRow);
                        continue;
                    }
                    billDate = next.getDate("billdate");
                    isSumRowAdded = false;
                    if (row != null) {
                        datas.add(row);
                    }
                    row = this.copyRow(next, 0L, null);
                    continue;
                }
                if (row != null) {
                    datas.add(row);
                    row = null;
                }
                datas.add(this.copyRow(next, 0L, null));
                continue block1;
            }
        }
        if (row != null) {
            datas.add(row);
        }
        ds = algo.createDataSet(datas, meta);
        return ds;
    }

    private Object[] copyRow(Row next, Long pid, String rowType) {
        Object[] row = new Object[this.cnt + 1];
        for (int i = 0; i < this.cnt; ++i) {
            row[i] = next.get(i);
        }
        row[this.pidIdx] = String.valueOf(pid);
        if (rowType != null) {
            row[this.rowtypeIdx] = rowType;
        }
        row[this.rowidIdx] = row[this.cnt] = Integer.valueOf(this.rowSeq++);
        return row;
    }

    private Object[] createSumRow(Date date) {
        Object[] sumRow = new Object[this.cnt + 1];
        sumRow[this.rowtypeIdx] = this.ROWTYPE_REQUIRE;
        sumRow[this.billdateIdx] = date;
        sumRow[this.qtyIdx] = BigDecimal.ZERO;
        sumRow[this.onworkqtyIdx] = BigDecimal.ZERO;
        sumRow[this.pickedqtyIdx] = BigDecimal.ZERO;
        sumRow[this.remainqtyIdx] = BigDecimal.ZERO;
        sumRow[this.leftqtyIdx] = BigDecimal.ZERO;
        sumRow[this.reserveqtyIdx] = BigDecimal.ZERO;
        sumRow[this.pidIdx] = 0;
        sumRow[this.isgroupnodeIdx] = 1;
        sumRow[this.rowidIdx] = this.sumRowIdx++;
        sumRow[this.cnt] = this.rowSeq++;
        return sumRow;
    }

    private DataSet execute(Algo algo, Boolean isStatic, Map<String, Object> cParams, RowMeta meta, DynamicObject mrpPlan, DynamicObject bizPlan, Long orgId, Set<Long> masterIdSet, boolean showDem, boolean showSup, Long planScopeId, String innercoptype, DynamicObject manustrategy) {
        Long mId = masterIdSet.iterator().next();
        DataSet ds = isStatic != null && isStatic != false ? this.restoreStaticDatas(algo, mrpPlan, meta, orgId, mId, manustrategy, planScopeId, innercoptype) : this.startMRPCalc(algo, meta, mrpPlan, bizPlan, orgId, mId, showDem, showSup, planScopeId, innercoptype, manustrategy);
        ds = this.createHeadDataSet(ds);
        CachedDataSet cached = ds.copy().cache(CacheHint.getDefault());
        cParams.put("detail_dataset_id", cached.getCacheId());
        DistributeSessionlessCache sumCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        sumCache.put("detail_dataset_id" + cParams.get("pageid"), (Object)cached.getCacheId());
        return ds;
    }

    private DataSet createHeadDataSet(DataSet ds) {
        DataSet dataSet;
        HashSet<Long> dataSourceSet = new HashSet<Long>();
        HashSet<Long> supplierSet = new HashSet<Long>();
        HashSet<Long> customerSet = new HashSet<Long>();
        HashSet<Long> materialSet = new HashSet<Long>();
        HashSet<Long> unitSet = new HashSet<Long>();
        HashSet<Long> configCodeSet = new HashSet<Long>();
        HashSet<Long> trackNumberSet = new HashSet<Long>();
        HashSet<Long> projectSet = new HashSet<Long>();
        HashSet<Long> planscopeSet = new HashSet<Long>();
        HashSet<Long> warehouseSet = new HashSet<Long>();
        HashSet<Long> useorgSet = new HashSet<Long>();
        DataSet copy = ds.copy();
        for (Row row : copy) {
            dataSourceSet.add(row.getLong("config"));
            supplierSet.add(row.getLong("supplier"));
            customerSet.add(row.getLong("customer"));
            materialSet.add(row.getLong("material"));
            unitSet.add(row.getLong("unit"));
            configCodeSet.add(row.getLong("configuredcode"));
            trackNumberSet.add(row.getLong("tracknumber"));
            projectSet.add(row.getLong("project"));
            planscopeSet.add(row.getLong("planscope"));
            warehouseSet.add(row.getLong("warehouse"));
            useorgSet.add(row.getLong("useorg"));
        }
        dataSourceSet.remove(0L);
        supplierSet.remove(0L);
        customerSet.remove(0L);
        materialSet.remove(0L);
        unitSet.remove(0L);
        configCodeSet.remove(0L);
        trackNumberSet.remove(0L);
        projectSet.remove(0L);
        planscopeSet.remove(0L);
        warehouseSet.remove(0L);
        if (dataSourceSet.isEmpty()) {
            ds = ds.addNullField("config_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mrp_resource_dataconfig", (String)"id,name config_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", dataSourceSet)}, null);
            ds = ds.leftJoin(dataSet).on("config", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"config_filter"}).finish();
        }
        if (supplierSet.isEmpty()) {
            ds = ds.addNullField("supplier_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_supplier", (String)"id,name supplier_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", supplierSet)}, null);
            ds = ds.leftJoin(dataSet).on("supplier", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"supplier_filter"}).finish();
        }
        if (customerSet.isEmpty()) {
            ds = ds.addNullField("customer_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_customer", (String)"id,name customer_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", customerSet)}, null);
            ds = ds.leftJoin(dataSet).on("customer", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"customer_filter"}).finish();
        }
        if (materialSet.isEmpty()) {
            ds = ds.addNullField("material_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_material", (String)"id,number material_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
            ds = ds.leftJoin(dataSet).on("material", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"material_filter"}).finish();
        }
        if (unitSet.isEmpty()) {
            ds = ds.addNullField("unit_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_measureunits", (String)"id,name unit_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", unitSet)}, null);
            ds = ds.leftJoin(dataSet).on("unit", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"unit_filter"}).finish();
        }
        if (configCodeSet.isEmpty()) {
            ds = ds.addNullField("configuredcode_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_configuredcode", (String)"id,number configuredcode_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", configCodeSet)}, null);
            ds = ds.leftJoin(dataSet).on("configuredcode", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"configuredcode_filter"}).finish();
        }
        if (trackNumberSet.isEmpty()) {
            ds = ds.addNullField("tracknumber_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_tracknumber", (String)"id,number tracknumber_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", trackNumberSet)}, null);
            ds = ds.leftJoin(dataSet).on("tracknumber", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"tracknumber_filter"}).finish();
        }
        if (projectSet.isEmpty()) {
            ds = ds.addNullField("project_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_project", (String)"id,number project_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", projectSet)}, null);
            ds = ds.leftJoin(dataSet).on("project", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"project_filter"}).finish();
        }
        if (planscopeSet.isEmpty()) {
            ds = ds.addNullField("planscope_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"msplan_planscope", (String)"id,name planscope_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", planscopeSet)}, null);
            ds = ds.leftJoin(dataSet).on("planscope", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"planscope_filter"}).finish();
        }
        if (warehouseSet.isEmpty()) {
            ds = ds.addNullField("warehouse_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warehouse", (String)"id,name warehouse_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", warehouseSet)}, null);
            ds = ds.leftJoin(dataSet).on("warehouse", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"warehouse_filter"}).finish();
        }
        if (useorgSet.isEmpty()) {
            ds = ds.addNullField("useorg_filter");
        } else {
            dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bos_org", (String)"id,name useorg_filter", (QFilter[])new QFilter[]{new QFilter("id", "in", useorgSet)}, null);
            ds = ds.leftJoin(dataSet).on("useorg", "id").select(ds.getRowMeta().getFieldNames(), new String[]{"useorg_filter"}).finish();
        }
        return ds;
    }

    private IMRPEnvProvider createEnv(DynamicObject mrpPlan, Long orgId) {
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)String.valueOf(orgId));
        String plantype = PlanModel.getPlanType((DynamicObject)mrpPlan);
        Long id = ORM.create().genLongId("mrp_caculate_log");
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)orgId);
        caculateLog.set("useorg", (Object)orgId);
        caculateLog.set("runtype", (Object)"A");
        caculateLog.set("plantype", (Object)plantype);
        caculateLog.set("clearstatus", (Object)Character.valueOf('A'));
        caculateLog.set("status", (Object)Character.valueOf('C'));
        caculateLog.set("enable", (Object)Character.valueOf('1'));
        caculateLog.set("isallowdateinpast", (Object)"1");
        caculateLog.set("plangram", (Object)mrpPlan.getLong("id"));
        caculateLog.set("programnumber", (Object)mrpPlan.getString("number"));
        caculateLog.set("programname", (Object)mrpPlan.getString("name"));
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("iscommon", mrpPlan.get("iscommon"));
        caculateLog.set("iscustomize", mrpPlan.get("iscustomize"));
        caculateLog.set("isselection", mrpPlan.get("isselection"));
        caculateLog.set("isnotsetup", mrpPlan.get("isnotsetup"));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("operatmode", (Object)ResManager.loadKDString((String)"\u7269\u6599\u4f9b\u9700\u67e5\u8be2", (String)"SupplyDemandByConditionListQueryPlugin_2", (String)"mmc-mrp-report", (Object[])new Object[0]));
        caculateLog.set("operatmodekey", (Object)"mrp_realtimemrprunner");
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)false);
        caculateLog.set("isbomcheck", (Object)false);
        caculateLog.set("isallowdateinpast", (Object)false);
        caculateLog.set("plangramentity", (Object)"mrp_planprogram");
        DynamicObject plan = BusinessDataServiceHelper.loadSingleFromCache((Object)mrpPlan.getLong("id"), (String)"mrp_planprogram", (String)"plantags");
        DynamicObjectCollection plantags = plan.getDynamicObjectCollection("plantags");
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set("fbasedataid", tag.get("fbasedataid"));
        }
        KDCloudRealTimeRptEnv env = new KDCloudRealTimeRptEnv(caculateLog);
        ORM.create().save(caculateLog);
        return env;
    }

    private DataSet restoreStaticDatas(Algo algo, DynamicObject mrpPlan, RowMeta meta, Long orgId, Long mId, DynamicObject manustrategy, Long planScopeId, String innercoptype) {
        DynamicObject caculateLog = this.getQueryParam().getFilter().getDynamicObject("filter_log");
        caculateLog = BusinessDataServiceHelper.loadSingle((String)"mrp_caculate_log", (QFilter[])new QFilter[]{new QFilter("id", "=", caculateLog.getPkValue())});
        KDCloudRealTimeRptEnv env = new KDCloudRealTimeRptEnv(caculateLog);
        env.initRuntimeEnv();
        RequirementDataTable requireTbl = env.requireDatas();
        SupplymentDataTable supplyTbl = env.supplyDatas();
        HashMap<String, DataBalanceTable.RSMapping> mappings = new HashMap<String, DataBalanceTable.RSMapping>();
        IDataEntityType dt = ORM.create().newDynamicObject("mrp_calcdetail.entryentity").getDataEntityType();
        DataEntityPropertyCollection c = dt.getProperties();
        StringBuilder fields = new StringBuilder("caculatelog");
        for (int i = 0; i < c.size(); ++i) {
            IDataEntityProperty prop = (IDataEntityProperty)c.get(i);
            fields.append(", entryentity.").append(prop.getName()).append(" as ").append(prop.getName());
        }
        QFilter filter = new QFilter("caculatelog", "=", (Object)caculateLog.getString("number"));
        filter.and("entryentity.material", "=", (Object)mId);
        try (DataSet detailDs = QueryServiceHelper.queryDataSet((String)"real_time_rpt", (String)"mrp_calcdetail", (String)fields.toString(), (QFilter[])new QFilter[]{filter}, null);){
            RowMeta detailMeta = detailDs.getRowMeta();
            while (detailDs.hasNext()) {
                Row next = detailDs.next();
                SupplyDemandByConditionListQueryPlugin.toMapping(mappings, requireTbl, supplyTbl, detailMeta, next);
            }
        }
        boolean[] splits = this.manustrategyResolve(manustrategy);
        List datas = MRPDataBalanceResolver4RealTimeRpt.resolveDatas((IMRPEnvProvider)env, (RequirementDataTable)requireTbl, (SupplymentDataTable)supplyTbl, mappings.values(), (boolean)true, (int)meta.getFieldCount(), (Long)planScopeId, (String)innercoptype, (Boolean)splits[1], (Boolean)splits[0], (Boolean)splits[2], (Long)orgId);
        DataSet ds = algo.createDataSet(datas.iterator(), meta);
        return ds;
    }

    private static Object[] toRequire(RequirementDataTable requireTbl, RowMeta meta, Row row) {
        Object[] values = SupplyDemandByConditionListQueryPlugin.fill((AbstractResModelDataTable)requireTbl, requireDB2Memory, meta, row);
        Map colIdx = requireTbl.getColIdx();
        Object rId = values[(Integer)colIdx.get(DefaultField.RequireField.BILLID.getName())];
        Object rEntryId = values[(Integer)colIdx.get(DefaultField.RequireField.BILLENTRYID.getName())];
        if ((rId == null || StringUtils.isEmpty((Object)rId.toString())) && (rEntryId == null || StringUtils.isEmpty((Object)rEntryId.toString()))) {
            return null;
        }
        return values;
    }

    private static RowData toSupply(SupplymentDataTable supplyTbl, RowMeta meta, Row row) {
        Object[] values = SupplyDemandByConditionListQueryPlugin.fill((AbstractResModelDataTable)supplyTbl, supplyDB2Memory, meta, row);
        Map colIdx = supplyTbl.getColIdx();
        Object sId = values[(Integer)colIdx.get(DefaultField.SupplyField.BILLID.getName())];
        Object sEntryId = values[(Integer)colIdx.get(DefaultField.SupplyField.BILLENTRYID.getName())];
        if ((sId == null || StringUtils.isEmpty((Object)sId.toString())) && (sEntryId == null || StringUtils.isEmpty((Object)sEntryId.toString()))) {
            return null;
        }
        values[((Integer)colIdx.get((Object)DefaultField.SupplyField.PRODUCTIONORGUNIT.getName())).intValue()] = values[(Integer)colIdx.get(DefaultField.SupplyField.SUPPLYORGUNIT.getName())];
        values[((Integer)colIdx.get((Object)DefaultField.SupplyField.__IS_OCCUPIED__.getName())).intValue()] = false;
        int rowIdx = supplyTbl.fill(values);
        return supplyTbl.fetchRow(rowIdx);
    }

    private static Object[] fill(AbstractResModelDataTable tbl, Map<String, String> fields, RowMeta meta, Row row) {
        Object[] values = new Object[tbl.getColIdx().size()];
        for (Map.Entry<String, String> e : fields.entrySet()) {
            if (meta.getFieldIndex(e.getKey(), false) < 0) continue;
            Object val = row.get(e.getKey());
            Integer colIdx = (Integer)tbl.getColIdx().get(e.getValue());
            if (colIdx == null) continue;
            if (val instanceof Timestamp) {
                val = ((Timestamp)val).getTime();
            } else if (val instanceof Date) {
                val = ((Date)val).getTime();
            }
            values[colIdx.intValue()] = val;
        }
        return values;
    }

    private static void toMapping(Map<String, DataBalanceTable.RSMapping> mappings, RequirementDataTable requireTbl, SupplymentDataTable supplyTbl, RowMeta meta, Row row) {
        Object[] tmpRequire = SupplyDemandByConditionListQueryPlugin.toRequire(requireTbl, meta, row);
        RowData supply = SupplyDemandByConditionListQueryPlugin.toSupply(supplyTbl, meta, row);
        if (tmpRequire != null) {
            RequireRowData require;
            Long rId = (Long)MRPUtil.convert((Object)tmpRequire[(Integer)requireTbl.getColIdx().get(DefaultField.RequireField.BILLID.getName())], (Object)0L);
            Long rEntryId = (Long)MRPUtil.convert((Object)tmpRequire[(Integer)requireTbl.getColIdx().get(DefaultField.RequireField.BILLENTRYID.getName())], (Object)0L);
            String key = rId + "-" + rEntryId;
            DataBalanceTable.RSMapping mapping = mappings.get(key);
            BigDecimal rQty = (BigDecimal)MRPUtil.convert((Object)tmpRequire[(Integer)requireTbl.getColIdx().get(DefaultField.RequireField.QTY.getName())], (Object)BigDecimal.ZERO);
            if (rQty == null) {
                rQty = BigDecimal.ZERO;
            }
            if (mapping == null) {
                int rowIdx = requireTbl.fill(tmpRequire);
                require = requireTbl.fetchRow(rowIdx);
                mapping = new DataBalanceTable.RSMapping();
                mappings.put(key, mapping);
                mapping.setRequire(require);
            } else {
                require = mapping.getRequire();
                rQty = rQty.add(require.getBigDecimal(DefaultField.RequireField.__SUPPLY_QTY__.getName()));
            }
            require.update(DefaultField.RequireField.__SUPPLY_QTY__.getName(), (Object)rQty);
            if (supply != null) {
                ArrayList<RowData> supplys = mapping.getSupplys();
                if (supplys == null) {
                    supplys = new ArrayList<RowData>(8);
                    mapping.setSupplys(supplys);
                }
                supply.update((Integer)supplyTbl.getColIdx().get(DefaultField.SupplyField.__IS_OCCUPIED__.getName()), (Object)true);
                supplys.add(supply);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet startMRPCalc(Algo algo, RowMeta meta, DynamicObject mrpPlan, DynamicObject bizPlan, Long orgId, Long mId, boolean showDem, boolean showSup, Long planScopeId, String innercoptype, DynamicObject manustrategy) {
        IMRPEnvProvider env = this.createEnv(mrpPlan, orgId);
        try {
            DataSet dataSet = this.startMRPCalcImpl(env, algo, meta, mrpPlan, bizPlan, orgId, mId, showDem, showSup, planScopeId, innercoptype, manustrategy);
            return dataSet;
        }
        finally {
            boolean isSaveDetails = (Boolean)env.getCfgValue(EnvCfgItem.IS_REALTIMERPT_SAVE_DETAILS);
            if (!isSaveDetails) {
                ORM.create().delete(env.getRunLog());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet startMRPCalcImpl(IMRPEnvProvider env, Algo algo, RowMeta meta, DynamicObject mrpPlan, DynamicObject bizPlan, Long orgId, Long mId, boolean showDem, boolean showSup, Long planScopeId, String innercoptype, DynamicObject manustrategy) {
        env.initRuntimeEnv();
        env.putLocalParam("real_time_rpt_bizplan", (Object)bizPlan);
        env.putLocalParam("real_time_rpt_material_id", (Object)mId.toString());
        env.putLocalParam("real_time_rpt_is_showdemand", (Object)showDem);
        env.putLocalParam("real_time_rpt_is_showsupply", (Object)showSup);
        env.putLocalParam("real_time_rpt_planscope_id", (Object)planScopeId);
        env.putLocalParam("real_time_rpt_innercoptype", (Object)innercoptype);
        env.putLocalParam("real_time_rpt_queryorgid", (Object)orgId);
        boolean[] splits = this.manustrategyResolve(manustrategy);
        env.putLocalParam("real_time_rpt_isshowtracknumber", (Object)splits[0]);
        env.putLocalParam("real_time_rpt_isshowproject", (Object)splits[1]);
        env.putLocalParam("real_time_rpt_isshowconfigrecode", (Object)splits[2]);
        env.putLocalParam("immediately_save_collaborate_bills", (Object)false);
        env.putLocalParam("real_time_rpt_dataset_header", (Object)meta);
        try {
            new RealTimeMRPRunner().run(env);
        }
        catch (Throwable e) {
            String msg = e.getMessage();
            logger.error(msg, e);
            if (msg != null && msg.endsWith("\u3002")) {
                msg = msg.substring(0, msg.length() - 1);
            }
            throw new KDBizException(e, new ErrorCode("", msg), new Object[0]);
        }
        logger.info("mrpfinished!!!");
        DynamicObject runLog = QueryServiceHelper.queryOne((String)"mrp_caculate_log", (String)"id, calculatestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)env.getRunLog().getLong("id"))});
        String status = runLog.getString("calculatestatus");
        if ("D".equals(status)) {
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            runLog = QueryServiceHelper.queryOne((String)"mrp_caculate_log", (String)"id, calculatestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)env.getRunLog().getLong("id"))});
            status = runLog.getString("calculatestatus");
            logger.info("requery mrpstatus!!!");
        }
        if (!"A".equals(status)) {
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u8fdb\u884c\u95ee\u9898\u6392\u67e5", (String)"SupplyDemandByConditionListQueryPlugin_1", (String)"mmc-mrp-report", (Object[])new Object[0])), new Object[0]);
        }
        ArrayList builder = (ArrayList)env.getLocalParams("real_time_rpt_result_ds");
        if (builder == null) {
            builder = new ArrayList(0);
            logger.warn(String.format("mrprunner-realtimerpt-empty-result orgId:%s, planScopeId: %s, planId: %s, bizPlanId: %s", orgId, planScopeId, mrpPlan.getLong("id"), bizPlan.getLong("id")));
        }
        try {
            DataSet dataSet = algo.createDataSet(builder.iterator(), meta);
            return dataSet;
        }
        finally {
            logger.info("recreate mrpdatas!!!");
        }
    }

    private boolean[] manustrategyResolve(DynamicObject manustrategy) {
        boolean isTrackMatch = false;
        boolean isProjectMatch = false;
        boolean isConfigureCodeMatch = false;
        if (manustrategy != null) {
            long traceDim = 1297144009797647360L;
            long projectDim = 1297144125837025280L;
            long configureCodeDim = 1721649779361985536L;
            DynamicObjectCollection traceway = manustrategy.getDynamicObjectCollection("traceway");
            for (DynamicObject trace : traceway) {
                Long id = trace.getLong("fbasedataid.id");
                if (id == traceDim) {
                    isTrackMatch = true;
                }
                if (id == projectDim) {
                    isProjectMatch = true;
                }
                if (id != configureCodeDim) continue;
                isConfigureCodeMatch = true;
            }
        }
        return new boolean[]{isTrackMatch, isProjectMatch, isConfigureCodeMatch};
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportQueryParam queryParam = this.getQueryParam();
        FilterInfo filter = queryParam.getFilter();
        DynamicObject ctrlType = filter.getDynamicObject("innercoptype");
        String innercoptype = ctrlType == null ? "B" : ctrlType.getString("type");
        HashMap cParams = queryParam.getCustomParam();
        if (cParams == null) {
            cParams = new HashMap();
            queryParam.setCustomParam(cParams);
        }
        Boolean isStatic = (Boolean)cParams.get("isStatic");
        for (AbstractReportColumn col : columns) {
            ReportColumn c = (ReportColumn)col;
            if ("useorg".equals(c.getFieldKey()) && "B".equals(innercoptype)) {
                c.setCaption(new LocaleString(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7", (String)"SupplyDemandByConditionListQueryPlugin_0", (String)"mmc-mrp-report", (Object[])new Object[0])));
                continue;
            }
            if ("config_txt".equals(c.getFieldKey())) {
                c.setHide(isStatic == null || isStatic == false);
            }
            if (!"config".equals(c.getFieldKey())) continue;
            c.setHide(isStatic != null && isStatic != false);
        }
        return columns;
    }
}

