/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.supdem;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.ReduceGroupFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;

public class SupplyDemandDayListQueryPlugin
extends AbstractReportListDataPlugin {
    private RowMeta meta = new RowMeta(new String[]{"day", "displayday", "dayproject", "daytrack", "dayreqqty", "daysupqty", "dayavqty", "dayunit", "rowid", "pid", "isgroupnode"}, new DataType[]{DataType.DateType, DataType.StringType, DataType.LongType, DataType.LongType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.BigDecimalType, DataType.LongType, DataType.StringType, DataType.StringType, DataType.IntegerType});
    private BigDecimal requireSum = BigDecimal.ZERO;
    private BigDecimal supplySum = BigDecimal.ZERO;
    private BigDecimal reduceSum = BigDecimal.ZERO;
    private int rowId = 0;

    public DataSet query(ReportQueryParam arg0, Object arg1) throws Throwable {
        CachedDataSet ds;
        Algo algo = Algo.create((String)"real_time_rpt_day");
        Object cacheId = arg0.getCustomParam().get("detail_dataset_id");
        try {
            ds = Algo.getCacheDataSet((String)String.valueOf(cacheId));
        }
        catch (Throwable error) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u67e5\u8be2\u5df2\u5931\u6548\uff0c\u8bf7\u5237\u65b0\u5f53\u524d\u62a5\u8868\u3002", (String)"SupplyDemandRptFormPlugin_9", (String)"mmc-mrp-report", (Object[])new Object[0]));
        }
        DataSet details = ds.toDataSet(algo, false);
        details = this.sum(details.where("isinvrow = 0"), true).union(this.sum(details.where("isinvrow = 1"), false));
        String fields = "day, displayday, daytrack, dayreqqty, daysupqty, dayunit, ";
        fields = fields + "(case when PreRowValue(daytrack) = daytrack then PreRowValue() + dayavqty else dayavqty end) as dayavqty";
        fields = fields + ", rowid, pid, isgroupnode";
        DataSet ret = details.select(fields);
        this.requireSum = this.requireSum.multiply(new BigDecimal(-1));
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.put(cacheId + "_requireSum", (Object)this.requireSum.toPlainString(), 60);
        cache.put(cacheId + "_supplySum", (Object)this.supplySum.toPlainString(), 60);
        cache.put(cacheId + "_reduceSum", (Object)this.reduceSum.toPlainString(), 60);
        return ret;
    }

    private DataSet sum(DataSet ds, final boolean isInv) {
        final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return ds.filter("leftqty is not null").groupBy(new String[]{"project", "tracknumber", "billdate"}).reduceGroup(new ReduceGroupFunction(){
            private static final long serialVersionUID = -3435285419165351382L;

            public RowMeta getResultRowMeta() {
                return SupplyDemandDayListQueryPlugin.this.meta;
            }

            public Iterator<Object[]> reduce(Iterator<Row> iter) {
                ArrayList<Object[]> sums = new ArrayList<Object[]>();
                Date date = null;
                Long unit = null;
                Long project = null;
                Long track = null;
                BigDecimal reqQty = BigDecimal.ZERO;
                BigDecimal avQty = BigDecimal.ZERO;
                BigDecimal supQty = BigDecimal.ZERO;
                while (iter.hasNext()) {
                    BigDecimal qty;
                    Row next = iter.next();
                    if (date == null) {
                        date = next.getDate("billdate");
                    }
                    if (unit == null) {
                        unit = next.getLong("unit");
                    }
                    if (track == null) {
                        track = next.getLong("tracknumber");
                    }
                    if (project == null) {
                        project = next.getLong("project");
                    }
                    if ((qty = next.getBigDecimal("qty")).compareTo(BigDecimal.ZERO) >= 0) {
                        supQty = supQty.add(qty);
                    } else {
                        reqQty = reqQty.add(qty);
                    }
                    avQty = avQty.add(qty);
                }
                if (date != null) {
                    sums.add(new Object[]{date, isInv ? "Stock" : format.format(date), project, track, reqQty, supQty, avQty, unit, ++SupplyDemandDayListQueryPlugin.this.rowId, 0, 0});
                }
                SupplyDemandDayListQueryPlugin.this.requireSum = SupplyDemandDayListQueryPlugin.this.requireSum.add(reqQty);
                if (!isInv) {
                    SupplyDemandDayListQueryPlugin.this.supplySum = SupplyDemandDayListQueryPlugin.this.supplySum.add(supQty);
                } else {
                    SupplyDemandDayListQueryPlugin.this.reduceSum = SupplyDemandDayListQueryPlugin.this.reduceSum.add(supQty);
                }
                return sums.iterator();
            }
        });
    }
}

