/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.supdem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.utils.DataSourceUtil;

public class SupplyDemandListQueryPlugin
extends AbstractReportListDataPlugin {
    private static final String MT = "keymaterial";
    private static final String RANGE = "range";
    private static final String TB_RANGE = "mrp_supdem_range";
    private static final String DEMAND_CONF = "demandconfig";
    private static final String SUPPLY_CONF = "supplyconfig";
    private static final String ENTRY_DEM = "demandentry";
    private static final String ENTRY_SUP = "supplyentry";
    private Set<Long> masterIdSet;
    private Set<Long> demConfig;
    private Set<Long> supConfig;
    private boolean showDem;
    private boolean showSup;

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo mtItem = filter.getFilterItem(MT);
        List value = (List)mtItem.getValue();
        this.masterIdSet = new HashSet<Long>(value.size());
        for (DynamicObject dyn : value) {
            this.masterIdSet.add(dyn.getLong("masterid"));
        }
        FilterItemInfo rangeItem = filter.getFilterItem(RANGE);
        String range = rangeItem.getString();
        this.showDem = "1".equals(range) || "2".equals(range);
        this.showSup = "1".equals(range) || "3".equals(range);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)TB_RANGE, (String)"demandentry.demandconfig,supplyentry.supplyconfig", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)"1", true)});
        DynamicObjectCollection dem = dyn.getDynamicObjectCollection(ENTRY_DEM);
        this.demConfig = new LinkedHashSet<Long>(dem.size());
        for (DynamicObject obj : dem) {
            this.demConfig.add(obj.getLong("demandconfig_id"));
        }
        DynamicObjectCollection sup = dyn.getDynamicObjectCollection(ENTRY_SUP);
        this.supConfig = new LinkedHashSet<Long>(sup.size());
        for (DynamicObject obj : sup) {
            this.supConfig.add(obj.getLong("supplyconfig_id"));
        }
        return this.queryHelper();
    }

    private DataSet queryHelper() {
        DataSet source;
        ArrayList<DataSet> ds = new ArrayList<DataSet>(8);
        if (this.showDem) {
            for (Long dem : this.demConfig) {
                source = this.getDemand(dem);
                ds.add(source);
            }
        }
        if (this.showSup) {
            for (Long sup : this.supConfig) {
                source = this.getSupply(sup);
                ds.add(source);
            }
        }
        int size = ds.size();
        DataSet first = (DataSet)ds.get(0);
        for (int i = 1; i < size; ++i) {
            DataSet next = (DataSet)ds.get(i);
            first = first.union(next);
        }
        return this.helper(first);
    }

    private DataSet helper(DataSet dataSet) {
        DataSet ds = dataSet.orderBy(new String[]{"material", "configuredcode", "auxproperty", "tracknumber", "project", "billdate"});
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        ArrayList<String> sels = new ArrayList<String>(fieldNames.length + 1);
        Collections.addAll(sels, fieldNames);
        StringBuilder leftqty = new StringBuilder();
        leftqty.append(" case when PreRowValue(material) = material and PreRowValue(configuredcode) = configuredcode and PreRowValue(auxproperty) = auxproperty and PreRowValue(tracknumber) = tracknumber and PreRowValue(project) = project then PreRowValue() + qty ");
        leftqty.append(" else qty end as leftqty ");
        sels.add(leftqty.toString());
        return ds.select(sels.toArray(new String[0]));
    }

    private DataSet getSupply(Long configId) {
        LinkedHashMap<String, String> supFieldMap = new LinkedHashMap<String, String>(8);
        supFieldMap.put("entryentity.supplyorgunit", "org");
        supFieldMap.put("entryentity.material", "material");
        supFieldMap.put("entryentity.baseunit", "unit");
        supFieldMap.put("entryentity.billdate", "billdate");
        supFieldMap.put("entryentity.qty", "qty");
        supFieldMap.put("entryentity.billid", "billid");
        supFieldMap.put("entryentity.billnumber", "billnumber");
        supFieldMap.put("entryentity.billentryseq", "billentryseq");
        supFieldMap.put("entryentity.configuredcode", "configuredcode");
        supFieldMap.put("entryentity.tracknumber", "tracknumber");
        supFieldMap.put("entryentity.materialflexprops", "auxproperty");
        supFieldMap.put("entryentity.projectnumber", "project");
        return this.getSource(configId, supFieldMap, false);
    }

    private DataSet getDemand(Long configId) {
        LinkedHashMap<String, String> demFieldMap = new LinkedHashMap<String, String>(8);
        demFieldMap.put("entryentity.productionorgunit", "org");
        demFieldMap.put("entryentity.material", "material");
        demFieldMap.put("entryentity.baseunit", "unit");
        demFieldMap.put("entryentity.billdate", "billdate");
        demFieldMap.put("entryentity.demandqty", "qty");
        demFieldMap.put("entryentity.billid", "billid");
        demFieldMap.put("entryentity.billnumber", "billnumber");
        demFieldMap.put("entryentity.billentryseq", "billentryseq");
        demFieldMap.put("entryentity.configuredcode", "configuredcode");
        demFieldMap.put("entryentity.tracknumber", "tracknumber");
        demFieldMap.put("entryentity.materialflexprops", "auxproperty");
        demFieldMap.put("entryentity.projectnumber", "project");
        return this.getSource(configId, demFieldMap, true);
    }

    private DataSet getSource(Long modelId, Map<String, String> fieldNeedMap, boolean isDemand) {
        String srcTypeName;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"MetaConsts.Metas.MRPResDataSource", (String)"mrp_resource_dataconfig", (String)"billfieldtransfer.srcbill", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)modelId)}, null);){
            srcTypeName = ((Row)ds.iterator().next()).getString(0);
        }
        ds = DataSourceUtil.getDataSetByModel((Long)modelId, this.masterIdSet);
        ArrayList<String> selFields = new ArrayList<String>(8);
        HashSet fields = new HashSet(8);
        Collections.addAll(fields, ds.getRowMeta().getFieldNames());
        Set<String> defaultZeroFields = this.getSetDefaultZeroCols();
        for (Map.Entry<String, String> entry : fieldNeedMap.entrySet()) {
            String destField = entry.getKey();
            String col = entry.getValue();
            if (!fields.contains(destField)) {
                if (defaultZeroFields.contains(col)) {
                    selFields.add("0L " + col);
                    continue;
                }
                selFields.add("null " + col);
                continue;
            }
            selFields.add(String.format("%s AS %s", destField, col));
        }
        DataSet select = ds.select(selFields.toArray(new String[0]));
        String[] fieldNames = select.getRowMeta().getFieldNames();
        ArrayList<String> sels = new ArrayList<String>(8);
        for (String fieldName : fieldNames) {
            if ("qty".equals(fieldName)) {
                if (isDemand) {
                    sels.add("-1*qty as qty");
                    continue;
                }
                sels.add("qty");
                continue;
            }
            sels.add(fieldName);
        }
        sels.add("'" + srcTypeName + "' srctype");
        sels.add(modelId + " config");
        sels.add("billnumber + '_' + cast(billentryseq as String) billtag");
        select = select.select(sels.toArray(new String[0]));
        return select;
    }

    private Set<String> getSetDefaultZeroCols() {
        HashSet<String> cols = new HashSet<String>(8);
        cols.add("material");
        cols.add("org");
        cols.add("configuredcode");
        cols.add("tracknumber");
        cols.add("auxproperty");
        cols.add("project");
        return cols;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        return columns;
    }
}

