/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.report.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;

public class FilterDUtils {
    public static DataSet HeaderFilter(DataSet resultDataSet, FilterInfo filterInfo) {
        List headFilters = filterInfo.getHeadFilters();
        List<String> cpList = Arrays.asList("is not null,is null".split(","));
        List<String> dataTypeList = Arrays.asList("BigDecimal,Timestamp,Date,Integer".split(","));
        if (headFilters != null && headFilters.size() > 0) {
            QFilter qFilter = new QFilter("1", "=", (Object)1);
            for (int i = 0; i < headFilters.size(); ++i) {
                QFilter filter = (QFilter)headFilters.get(i);
                String property = filter.getProperty();
                String cp = filter.getCP();
                Object value = filter.getValue();
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(resultDataSet.getRowMeta().getFieldNames()));
                for (String field : list) {
                    DataType dataType = resultDataSet.getRowMeta().getField(field).getDataType();
                    if (!property.equals(field)) continue;
                    if (cpList.contains(cp) || value != null && dataTypeList.contains(dataType.getName())) {
                        String val;
                        if ("is not null".equals(cp)) {
                            qFilter.and(new QFilter(property, "is not null", null)).and(new QFilter(property, "!=", (Object)""));
                        } else if (StringUtils.equals((CharSequence)"is null", (CharSequence)cp)) {
                            QFilter orQFilter = new QFilter(property, "is null", null).or(new QFilter(property, "=", (Object)""));
                            qFilter.and(orQFilter);
                        }
                        if (dataType.getName().equals("BigDecimal")) {
                            val = value.toString();
                            BigDecimal bigDecimal = new BigDecimal(val);
                            qFilter.and(new QFilter(property, cp, (Object)bigDecimal));
                        }
                        if (dataType.getName().equals("Integer")) {
                            val = value.toString();
                            Integer integer = Integer.valueOf(val);
                            qFilter.and(new QFilter(property, cp, (Object)integer));
                        }
                        if (!dataType.getName().equals("Timestamp") && !dataType.getName().equals("Date")) continue;
                        val = value.toString();
                        resultDataSet = FilterDUtils.changFiledDataType(resultDataSet, property, String.class);
                        if (cp.equals("=")) {
                            QFilter dateFilter = new QFilter(property, "like", (Object)("%" + val + "%"));
                            resultDataSet = resultDataSet.filter(dateFilter.toString());
                        } else {
                            String startStr = filter.toString().split(">=")[1].split("AND")[0];
                            String endStr = filter.toString().split("<")[1];
                            Date startDate = FilterDUtils.getDate(startStr);
                            Date endDate = FilterDUtils.getDate(endStr);
                            QFilter dateFilter = new QFilter(property, ">=", (Object)startDate).and(new QFilter(property, "<", (Object)endDate));
                            resultDataSet = resultDataSet.filter(dateFilter.toString());
                        }
                        resultDataSet = FilterDUtils.changFiledDataType(resultDataSet, property, Timestamp.class);
                        continue;
                    }
                    qFilter.and(filter);
                }
            }
            resultDataSet = resultDataSet.filter(qFilter.toString());
        }
        return resultDataSet;
    }

    public static Date getDate(String date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            if (date.contains("'")) {
                date = date.replaceAll("'", "").trim();
            }
            return simpleDateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u8f6c\u5316\u5f02\u5e38", (String)"FilterDUtils_0", (String)"mmc-mrp-report", (Object[])new Object[0])), new Object[0]);
        }
    }

    public static <T> DataSet changFiledDataType(DataSet dataSet, String filedName, Class<T> T) {
        dataSet = dataSet.select(FilterDUtils.arraysToString(FilterDUtils.addFileds(FilterDUtils.removeFiled(FilterDUtils.getDataSetFieldArray(dataSet), filedName), "cast(" + filedName + " as " + T.getSimpleName() + ")as " + filedName + "")));
        return dataSet;
    }

    public static String arraysToString(String[] sourceFileds) {
        String arrayS = Arrays.toString(sourceFileds);
        return arrayS.substring(1, arrayS.length() - 1);
    }

    public static String[] addFileds(String[] source, String ... addFiled) {
        return (String[])ArrayUtils.addAll((Object[])source, (Object[])addFiled);
    }

    public static String[] removeFiled(String[] source, String ... removeFileds) {
        HashSet<String> removeFiledSet = new HashSet<String>(removeFileds.length);
        for (String removeFiled : removeFileds) {
            removeFiledSet.add(removeFiled);
        }
        ArrayList<String> fileds = new ArrayList<String>(source.length);
        for (String string : source) {
            if (removeFiledSet.contains(string)) continue;
            fileds.add(string);
        }
        return fileds.toArray(new String[fileds.size()]);
    }

    public static String[] getDataSetFieldArray(DataSet dataSet) {
        Set<String> fileds = FilterDUtils.getDataSetField(dataSet);
        return fileds.toArray(new String[fileds.size()]);
    }

    public static Set<String> getDataSetField(DataSet dataSet) {
        return FilterDUtils.getDataSetField(dataSet, true);
    }

    public static Set<String> getDataSetField(DataSet dataSet, boolean isLinked) {
        Field[] fields = dataSet.getRowMeta().getFields();
        LinkedHashSet<String> fs = isLinked ? new LinkedHashSet(fields.length) : new TreeSet();
        for (int i = 0; i < fields.length; ++i) {
            String fieldName = fields[i].getName();
            fs.add(fieldName);
        }
        return fs;
    }
}

