/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class HomePageGuidePlugin
extends AbstractFormPlugin {
    private static final String TOPAGE = "toPage";

    public void afterCreateNewData(EventObject e) {
        CustomControl control = (CustomControl)this.getView().getControl("customcontrolap");
        if (control == null) {
            return;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("action", "init");
        paramsMap.put("isEnglish", false);
        if ("en-US".equals(Lang.get().getLangTag())) {
            paramsMap.put("isEnglish", true);
        }
        control.setData(paramsMap);
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (TOPAGE.equals(e.getEventName())) {
            String eventArgs = e.getEventArgs();
            if ("1".equals(eventArgs)) {
                this.openorgschemeview("mrp_orgschemeview");
            } else if ("2".equals(eventArgs)) {
                this.openBillPage("mpdm_demandgroup");
            } else if ("3".equals(eventArgs)) {
                this.openBillPage("mrp_multiorgsupdem");
            } else if ("4".equals(eventArgs)) {
                this.openBillPage("mrp_initdata");
            } else if ("5".equals(eventArgs)) {
                this.openorgschemeview("mrp_homebaseconfigure");
            } else if ("6".equals(eventArgs)) {
                this.openBillPage("mrp_billfieldtransfer");
            } else if ("7".equals(eventArgs)) {
                this.openresourceregister("mrp_resourceregister_cf_n", eventArgs);
            } else if ("8".equals(eventArgs)) {
                this.openresourceregister("mrp_resourceregister_cf_n", eventArgs);
            } else if ("9".equals(eventArgs)) {
                this.openresourceregister("mrp_resourceregister_cf_n", eventArgs);
            } else if ("10".equals(eventArgs)) {
                this.openBillPage("mrp_algoregister");
            } else if ("11".equals(eventArgs)) {
                this.openBillPage("mrp_businessplan");
            } else if ("12".equals(eventArgs)) {
                this.openBillPage("mrp_calplanconfig");
            } else if ("13".equals(eventArgs)) {
                this.openBillPage("mrp_planprogram");
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("home".equals(e.getActionId()) && e.getReturnData() != null) {
            Object returnData = e.getReturnData();
            if ("mrp_exceptionshow".equals(returnData.toString()) || "mrp_demandpriority".equals(returnData.toString()) || "mpdm_calendar_setting".equals(returnData.toString())) {
                this.openorgschemeview(returnData.toString());
            } else {
                this.openBillPage(returnData.toString());
            }
        }
    }

    private void openresourceregister(String name, String sign) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId(name);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List qFilters = formShowParameter.getListFilterParameter().getQFilters();
        if ("7".equals(sign)) {
            formShowParameter.setCustomParam("type", (Object)"02");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u9700\u6c42\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u5217\u8868", (String)"HomePageGuidePlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            QFilter qFilter = new QFilter("type", "=", (Object)"02");
            QFilter businesstypeqFilter = new QFilter("businesstype", "=", (Object)"01").or("businesstype", "=", (Object)"");
            qFilters.add(qFilter);
            qFilters.add(businesstypeqFilter);
        } else if ("8".equals(sign)) {
            formShowParameter.setCustomParam("type", (Object)"01");
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u5217\u8868", (String)"HomePageGuidePlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            QFilter qFilter = new QFilter("type", "=", (Object)"01");
            QFilter businesstypeqFilter = new QFilter("businesstype", "=", (Object)"01").or("businesstype", "=", (Object)"");
            qFilters.add(qFilter);
            qFilters.add(businesstypeqFilter);
        } else if ("9".equals(sign)) {
            formShowParameter.setCustomParam("type", (Object)"03");
            formShowParameter.setCaption(ResManager.loadKDString((String)"BOM\u8d44\u6e90\u6ce8\u518c\u6a21\u578b\u5217\u8868", (String)"HomePageGuidePlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            QFilter qFilter = new QFilter("type", "=", (Object)"03");
            QFilter businesstypeqFilter = new QFilter("businesstype", "=", (Object)"01").or("businesstype", "=", (Object)"");
            qFilters.add(qFilter);
            qFilters.add(businesstypeqFilter);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void openorgschemeview(String name) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(name);
        if ("mrp_homebaseconfigure".equals(name)) {
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "home"));
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        this.getView().showForm(formShowParameter);
    }

    private void openBillPage(String formId) {
        ListShowParameter formShowParameter = new ListShowParameter();
        formShowParameter.setBillFormId(formId);
        if ("mrp_billfieldtransfer".equals(formId) || "mrp_planprogram".equals(formId)) {
            formShowParameter.setCustomParam("isNew", (Object)true);
            if ("mrp_planprogram".equals(formId)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\uff08\u5411\u5bfc\uff09", (String)"HomePageGuidePlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        }
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            formShowParameter.setParentPageId(parentView.getPageId());
            String menuPageID = formId + parentView.getPageId();
            IFormView childFormView = parentView.getView(menuPageID);
            if (childFormView != null) {
                childFormView.activate();
                this.getView().sendFormAction(childFormView);
            } else {
                formShowParameter.setPageId(menuPageID);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        } else {
            this.getView().showForm((FormShowParameter)formShowParameter);
        }
    }
}

