/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.util.CalSetingUtils;

public class PlanDispatchListPlugin
extends AbstractListPlugin {
    private static final String C_BILLLISTAP = "billlistap";
    private static final String O_RUNNOW = "runnow";
    private static final String O_RELEASE = "release";
    private static final String O_UNRELEASE = "unrelease";
    private static final String MRP_PLANDISPATCH = "mrp_plandispatch";
    private static final String MRP_CALSETTING = "mrp_calsetting";
    private static final String ISRELEASE = "isrelease";
    private static final String STATUS = "status";
    private static final String ENABLE = "enable";
    private static final String STOP = "stop";

    public void registerListener(EventObject e) {
    }

    public void showErrorNotification(String tips, BeforeDoOperationEventArgs args) {
        this.getView().showErrorNotification(tips);
        args.setCancel(true);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        BillList billList = (BillList)this.getView().getControl(C_BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        StringBuilder error = new StringBuilder();
        if (O_RUNNOW.equals(operateKey)) {
            if (selects.size() > 1) {
                this.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u4e2d1\u6761\u9700\u8981\u8fd0\u884c\u7684\u6570\u636e\u3002", (String)"PlanDispatchListPlugin_22", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), args);
            } else {
                Map lockMap = MutexFactory.createDataMutex().getLockInfo(selects.get(0).getPrimaryKeyValue().toString(), "mmc.mrp", MRP_PLANDISPATCH);
                if (lockMap != null) {
                    this.showErrorNotification(ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u8c03\u5ea6\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"PlanDispatchListPlugin_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), args);
                    return;
                }
            }
        } else if (O_RELEASE.equals(operateKey)) {
            if (selects.size() > 1) {
                this.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u53ea\u9009\u4e2d1\u6761\u9700\u8981\u8fd0\u884c\u7684\u6570\u636e\u3002", (String)"PlanDispatchListPlugin_22", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), args);
            }
        } else if ("unlock".equals(operateKey)) {
            for (int i = 0; i < selects.size(); ++i) {
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)selects.get(i).getPrimaryKeyValue(), (String)MRP_PLANDISPATCH, (String)"id,number,runstatus");
                if ("A".equals(obj.getString("runstatus"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u201c%1$s\u201d\u72b6\u6001\u4e3a\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5148\u7ec8\u6b62\u8ba1\u5212\u3002%2$s", (String)"PlanDispatchListPlugin_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), obj.getString("number"), "\n"));
                    continue;
                }
                MutexFactory.createDataMutex().release(selects.get(i).getPrimaryKeyValue().toString(), MRP_PLANDISPATCH, "edit");
            }
            if (error.length() != 0) {
                this.getView().showMessage(error.toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91ca\u653e\u6210\u529f", (String)"PlanDispatchListPlugin_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        boolean isSuccess = result != null && result.isSuccess();
        BillList billList = (BillList)this.getView().getControl(C_BILLLISTAP);
        ListSelectedRowCollection selects = billList.getSelectedRows();
        StringBuilder error = new StringBuilder();
        if (isSuccess && O_RUNNOW.equals(key)) {
            this.afterDoRunNow(e, selects);
        } else if (O_RELEASE.equals(key) && isSuccess) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)selects.get(0).getPrimaryKeyValue(), (String)MRP_PLANDISPATCH);
            HashMap<String, Object> para = new HashMap<String, Object>();
            para.put("formId", MRP_CALSETTING);
            para.put("id", obj.getPkValue());
            para.put("bstatus", obj.getString(STATUS));
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, O_RELEASE));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        } else if (isSuccess && O_UNRELEASE.equals(key)) {
            int rowCount = 0;
            for (int i = 0; i < selects.size(); ++i) {
                ListSelectedRow row = selects.get(i);
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)MRP_PLANDISPATCH);
                String billno = obj.getString("number");
                if (obj.getBoolean(ISRELEASE)) {
                    obj.set(ISRELEASE, (Object)Boolean.FALSE);
                    CalSetingUtils.unrelease((DynamicObject)obj);
                    CalSetingUtils.clearLogAndStatus((DynamicObject)obj, (boolean)true);
                    SaveServiceHelper.update((DynamicObject)obj);
                    ++rowCount;
                    continue;
                }
                if (error.length() > 0) {
                    error.append("\r\n");
                }
                error.append(String.format(ResManager.loadKDString((String)"%s: \u672a\u53d1\u5e03\u6570\u636e\u4e0d\u5141\u8bb8\u53d6\u6d88\u53d1\u5e03\u3002", (String)"PlanDispatchListPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), billno));
            }
            this.getView().invokeOperation("refresh");
            if (error.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03\u5931\u8d25\u3002", (String)"PlanDispatchListPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03\u6210\u529f\u3002", (String)"PlanDispatchListPlugin_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        } else if (isSuccess && STOP.equals(key)) {
            int rowCount = 0;
            for (int i = 0; i < selects.size(); ++i) {
                ListSelectedRow row = selects.get(i);
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)MRP_PLANDISPATCH);
                if (!this.disableSingleJob(obj, error)) continue;
                ++rowCount;
            }
            this.getView().invokeOperation("refresh");
            if (error.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u7ec8\u6b62\u5b58\u5728\u5931\u8d25", (String)"PlanDispatchListPlugin_18", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"PlanDispatchListPlugin_23", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoRunNow(AfterDoOperationEventArgs e, ListSelectedRowCollection selects) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)selects.get(0).getPrimaryKeyValue(), (String)MRP_PLANDISPATCH);
        String jobId = obj.getString("jobid");
        if (!jobId.isEmpty()) {
            QFilter qf1 = new QFilter("job.id", "=", (Object)jobId);
            QFilter qf2 = new QFilter(STATUS, "=", (Object)"BEGIN");
            if (QueryServiceHelper.exists((String)"sch_task", (QFilter[])new QFilter[]{qf1, qf2}) && !this.checkRunCondition(obj)) {
                return;
            }
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.disableSchedule(jobId);
            DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)("update T_SCH_TASK set fstatus = 'COMPLETED' where fjobid = '" + jobId + "' and fstatus = 'BEGIN'"));
        }
        this.runImediatly(obj);
        this.getView().invokeOperation("refresh");
    }

    public boolean checkRunCondition(DynamicObject obj) {
        QFilter filter2;
        QFilter filter1;
        Object lstatus;
        String status;
        String[] arr;
        Map desc;
        DynamicObject version;
        Long versionId;
        Map ret;
        if (obj.getBoolean("isrunning") && (ret = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMMCDataSyncService", (String)"queryDataSyncActionStatus", (Object[])new Object[]{versionId = Long.valueOf((version = obj.getDynamicObject("dataversion")) == null ? 0L : version.getLong("id"))})).get("desc") != null && "A".equals((desc = (Map)ret.get("desc")).get(STATUS))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u7248\u672c\u6b63\u5728\u540c\u6b65\u4e2d\u3002", (String)"PlanDispatchListPlugin_19", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"".equals(obj.getString("forecastplanlogno"))) {
            boolean flag = false;
            arr = obj.getString("forecastplanlogno").split(",");
            for (int i = 0; i < arr.length; ++i) {
                status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsForecastCalService", (String)"getCalculatingStatus", (Object[])new Object[]{arr[i]});
                if (!"".equals(status)) continue;
                flag = true;
            }
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u5212\u8fd0\u7b97\u6b63\u5728\u6267\u884c\u4e2d\u3002", (String)"PlanDispatchListPlugin_24", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (!"".equals(obj.getString("forecastlogid")) && ((Long)(lstatus = (Long)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsFNSetoffService", (String)"getStatus", (Object[])new Object[]{obj.getLong("forecastlogid")}))).compareTo(2L) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u6d4b\u51b2\u51cf\u6b63\u5728\u6267\u884c\u4e2d\u3002", (String)"PlanDispatchListPlugin_25", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"".equals(obj.getString("dsplog")) && "B".equals(lstatus = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsDPSSiteService", (String)"getStatus", (Object[])new Object[]{obj.getString("dsplog")}))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"DPS Site\u6b63\u5728\u6267\u884c\u4e2d\u3002", (String)"PlanDispatchListPlugin_26", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (!"".equals(obj.getString("reqplanlog"))) {
            boolean flag = false;
            arr = obj.getString("reqplanlog").split(",");
            for (int i = 0; i < arr.length; ++i) {
                status = (String)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsCalculatingPlanService", (String)"getCalculatingStatus", (Object[])new Object[]{arr[i]});
                if (!"".equals(status)) continue;
                flag = true;
            }
            if (flag) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u8fd0\u7b97\u6b63\u5728\u6267\u884c\u4e2d\u3002", (String)"PlanDispatchListPlugin_27", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        if (!"".equals(obj.getString("mrplog")) && QueryServiceHelper.exists((String)"mrp_caculate_log", (QFilter[])new QFilter[]{filter1 = new QFilter("number", "=", (Object)obj.getString("mrplog")), filter2 = new QFilter("calculatestatus", "=", (Object)"D")})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"MRP\u8ba1\u7b97\u6b63\u5728\u6267\u884c\u4e2d\u3002", (String)"PlanDispatchListPlugin_28", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void runImediatly(DynamicObject obj) {
        CalSetingUtils.runImediatly((Object)obj.getPkValue(), (IFormView)this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent c) {
        if (O_RELEASE.equals(c.getActionId())) {
            Map csettings = (Map)c.getReturnData();
            if (null == csettings || csettings.isEmpty()) {
                return;
            }
            Integer action = (Integer)csettings.get("op");
            switch (action) {
                case 2: {
                    break;
                }
                case 0: {
                    this.getPageCache().put("op", "save");
                    this.save(csettings);
                    break;
                }
            }
        }
    }

    private void save(Map<String, Object> csetting) {
        DynamicObject[] selectedData;
        for (DynamicObject o : selectedData = CalSetingUtils.selectedData((IFormView)this.getView())) {
            this.saveAndRun(o, csetting);
            this.getView().invokeOperation("refresh");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d1\u5e03\u6210\u529f\u3002", (String)"PlanDispatchListPlugin_29", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    public void saveAndRun(DynamicObject o, Map<String, Object> csetting) {
        this.setCalSettings(o, csetting);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{o});
        this.runSgl(o);
    }

    public void setCalSettings(DynamicObject o, Map<String, Object> csetting) {
        o.set("runningtype", csetting.get("runningtype"));
        o.set("predtime", csetting.get("predtime"));
        o.set("losedate", csetting.get("losedate"));
        o.set("repeattype", csetting.get("repeattype"));
        o.set("repeat", csetting.get("repeat"));
        o.set("plan", csetting.get("plan"));
        if (CalSetingUtils.isWeek(csetting)) {
            o.set("daysofweek", (Object)CalSetingUtils.createExp((String)"daysofweek", csetting));
            o.set("daysofmon", (Object)"");
        } else {
            o.set("daysofmon", (Object)CalSetingUtils.createExp((String)"daysofmon", csetting));
            o.set("daysofweek", (Object)"");
        }
    }

    public void runSgl(DynamicObject o) {
        CalSetingUtils.runSgl((DynamicObject)o);
    }

    public boolean disableSingleJob(DynamicObject obj, StringBuilder error) {
        String jobId = obj.getString("jobid");
        String billno = obj.getString("number");
        String status = obj.getString("runstatus");
        if (!"A".equals(status)) {
            if (error.length() > 0) {
                error.append("\r\n");
            }
            String msg = ResManager.loadKDString((String)"\u8fd0\u884c\u72b6\u6001\u4e0d\u4e3a\u8fd0\u884c\u4e2d\uff0c\u4e0d\u5141\u8bb8\u7ec8\u6b62\u8fd0\u7b97\u3002", (String)"PlanDispatchListPlugin_20", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
            error.append(msg);
            return false;
        }
        if (jobId.isEmpty()) {
            if (error.length() > 0) {
                error.append("\r\n");
            }
            error.append(String.format(ResManager.loadKDString((String)"%s: \u672a\u627e\u5230\u540e\u53f0\u8c03\u5ea6\u4efb\u52a1\u3002", (String)"PlanDispatchListPlugin_21", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), billno));
            return false;
        }
        DB.execute((DBRoute)DBRoute.of((String)"sys"), (String)("update T_SCH_TASK set fstatus = 'COMPLETED' where fjobid = '" + jobId + "' and fstatus = 'BEGIN'"));
        obj.set("runstatus", (Object)"D");
        if ("A".equals(obj.getString("dataversionstatus"))) {
            obj.set("dataversionstatus", (Object)"D");
        }
        if ("A".equals(obj.getString("forecastplanstatus"))) {
            obj.set("forecastplanstatus", (Object)"D");
        }
        if ("A".equals(obj.getString("forecastrunstatus"))) {
            obj.set("forecastrunstatus", (Object)"D");
        }
        if ("A".equals(obj.getString("dpsrunstatus"))) {
            obj.set("dpsrunstatus", (Object)"D");
        }
        if ("A".equals(obj.getString("reqplanrunstatus"))) {
            obj.set("reqplanrunstatus", (Object)"D");
        }
        if ("A".equals(obj.getString("mrprunstatus"))) {
            obj.set("mrprunstatus", (Object)"D");
        }
        SaveServiceHelper.update((DynamicObject)obj);
        return true;
    }
}

