/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.adjust;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mrp.business.helper.AdjustImportHelper;
import kd.mmc.mrp.business.helper.AdjustSuggestHelper;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AdjustSuggestImportPlugin
extends AbstractFormPlugin
implements UploadListener,
ProgresssListener {
    private static final String DETAILMESSAGE = "detailmessage";
    private static final String COUNT = "count";
    private static final String EXECUTECOUNT = "executecount";
    private static final String FAILCOUNT = "failcount";
    private static final String PROGRESS = "progress";

    private String getModelError() {
        return ResManager.loadKDString((String)"\u6587\u4ef6\u5185\u5bb9\u9519\u8bef\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u7684\u6a21\u677f\u3002", (String)"AdjustSuggestImportPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
    }

    public void initialize() {
        super.initialize();
        String percent = this.getView().getPageCache().get(PROGRESS);
        if ("100".equals(percent)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"improcesspanel", "imbtndetail"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"improcesspanel", "imbtndetail"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"imbtnok", "imbtndetail"});
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getControl("fileimport");
        attachmentPanel.addUploadListener((UploadListener)this);
        ProgressBar importBar = (ProgressBar)this.getControl("improgressbar");
        importBar.addProgressListener((ProgresssListener)this);
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        List<Object> urlList = Arrays.asList(urls);
        String cachUrl = this.getView().getPageCache().get("url");
        if (StringUtils.isNotEmpty((CharSequence)cachUrl)) {
            List cachUrlList = (List)SerializationUtils.fromJsonString((String)cachUrl, List.class);
            cachUrlList.addAll(urlList);
            this.getView().getPageCache().put("url", SerializationUtils.toJsonString((Object)cachUrlList));
        } else {
            this.getView().getPageCache().put("url", SerializationUtils.toJsonString(urlList));
        }
    }

    public void afterRemove(UploadEvent evt) {
        Object[] delUrls = evt.getUrls();
        String cachUrl = this.getView().getPageCache().get("url");
        if (StringUtils.isNotEmpty((CharSequence)cachUrl)) {
            List cachUrlList = (List)SerializationUtils.fromJsonString((String)cachUrl, List.class);
            String delUrlUid = (String)((Map)delUrls[0]).get("uid");
            ArrayList<Map> delList = new ArrayList<Map>();
            for (int i = 0; i < cachUrlList.size(); ++i) {
                Map cachUrlMap = (Map)cachUrlList.get(i);
                String cachUrlUid = (String)cachUrlMap.get("uid");
                if (!StringUtils.equals((CharSequence)delUrlUid, (CharSequence)cachUrlUid)) continue;
                delList.add(cachUrlMap);
            }
            cachUrlList.removeAll(delList);
            this.getView().getPageCache().put("url", SerializationUtils.toJsonString((Object)cachUrlList));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if ("imbtnok".equals(key)) {
            String url = this.getView().getPageCache().get("url");
            if (StringUtils.isEmpty((CharSequence)url)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u4e0a\u4f20Excle\u6587\u4ef6\u3002", (String)"AdjustSuggestImportPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            List urlList = (List)SerializationUtils.fromJsonString((String)url, List.class);
            if (urlList.size() > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u540c\u65f6\u5904\u7406\u591a\u4e2aExcle\u6587\u4ef6\u3002", (String)"AdjustSuggestImportPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            Map urlMap = (Map)urlList.get(0);
            String fileUrl = (String)urlMap.get("url");
            TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
            try {
                String[] queryParams = new URL(fileUrl).getQuery().split("&");
                HashMap<String, String> downloadFileParams = new HashMap<String, String>(1);
                int int_0 = 0;
                int int_1 = 1;
                for (String queryParam : queryParams) {
                    String[] p = queryParam.split("=");
                    downloadFileParams.put(p[int_0], p[int_1]);
                }
                TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get("configKey"), (String)downloadFileParams.get("id"));
                InputStream inputStream = content.getInputStream();
                this.dealWorkbookDatas(inputStream);
                this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel", "exit", "imbtnok"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"improcesspanel"});
                ProgressBar importBar = (ProgressBar)this.getControl("improgressbar");
                importBar.setPercent(0, ResManager.loadKDString((String)"\u5bfc\u5165\u4e2d\uff0c\u8bf7\u52ff\u5173\u95ed\u754c\u9762", (String)"AdjustSuggestImportPlugin_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                importBar.start();
            }
            catch (Exception e) {
                throw new KDBizException(new ErrorCode(e.getMessage(), e.getMessage()), new Object[]{e});
            }
        } else if ("imbtndetail".equals(key)) {
            this.exportDetailData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportDetailData() {
        String errormessage = this.getView().getPageCache().get(DETAILMESSAGE);
        if (StringUtils.isEmpty((CharSequence)errormessage)) {
            return;
        }
        List errorList = (List)SerializationUtils.fromJsonString((String)errormessage, List.class);
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        try {
            SXSSFSheet sheet = workbook.createSheet();
            SXSSFRow firstrow = sheet.createRow(0);
            firstrow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u5bfc\u5165\u660e\u7ec6", (String)"AdjustSuggestImportPlugin_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            for (int i = 0; i < errorList.size(); ++i) {
                SXSSFRow row = sheet.createRow(i + 1);
                row.createCell(0).setCellValue((String)errorList.get(i));
            }
            ByteArrayOutputStream outStream = null;
            ByteArrayInputStream inStream = null;
            try {
                outStream = new ByteArrayOutputStream();
                workbook.write((OutputStream)outStream);
                inStream = new ByteArrayInputStream(outStream.toByteArray());
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                int timeout = 7200;
                String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u8c03\u6574\u5efa\u8bae\u5bfc\u5165\u65e5\u5fd7.xlsx", (String)"AdjustSuggestImportPlugin_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), (InputStream)inStream, timeout);
                this.getView().download(tempUrl);
                outStream.close();
                inStream.close();
            }
            catch (IOException e) {
                throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"AdjustSuggestImportPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), new Object[]{e});
            }
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"AdjustSuggestImportPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            }
        }
    }

    private Set<String> initColumnNames() {
        HashSet<String> leastAttr = new HashSet<String>();
        leastAttr.add(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"AdjustSuggestImportPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f", (String)"AdjustSuggestImportPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u884c\u53f7", (String)"AdjustSuggestImportPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"AdjustSuggestImportPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53", (String)"AdjustSuggestImportPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AdjustSuggestImportPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u5355\u636e\u884c\u53f7", (String)"AdjustSuggestImportPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        leastAttr.add(ResManager.loadKDString((String)"\u8ba1\u5212\u5458", (String)"AdjustSuggestImportPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        return leastAttr;
    }

    private void dealWorkbookDatas(InputStream inputStream) throws IOException {
        boolean hasOperator;
        XSSFWorkbook wb = (XSSFWorkbook)WorkbookFactory.create((InputStream)inputStream);
        XSSFSheet sheet = wb.getSheetAt(0);
        wb.close();
        if (sheet == null) {
            throw new KDBizException(this.getModelError());
        }
        XSSFRow firstRow = sheet.getRow(0);
        if (firstRow == null) {
            throw new KDBizException(this.getModelError());
        }
        XSSFRow secondRow = sheet.getRow(1);
        if (secondRow == null) {
            throw new KDBizException(this.getModelError());
        }
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>(8);
        Set<String> leastAttr = this.initColumnNames();
        for (int i = 0; i < firstRow.getLastCellNum(); ++i) {
            String columnName = firstRow.getCell(i).getStringCellValue();
            if (dataTypeMap.get(columnName) != null) {
                StringBuilder fields = new StringBuilder();
                fields.append(ResManager.loadKDString((String)"\u8868\u7ed3\u6784\u9519\u8bef\uff0c\u6570\u636e\u5217", (String)"AdjustSuggestImportPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(columnName).append(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"AdjustSuggestImportPlugin_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                throw new KDBizException(fields.toString());
            }
            if (!leastAttr.contains(columnName)) continue;
            dataTypeMap.put(columnName, i);
        }
        int sheetSize = sheet.getLastRowNum();
        ArrayList dataList = new ArrayList(sheetSize);
        boolean hasLineNo = dataTypeMap.get(ResManager.loadKDString((String)"\u884c\u53f7", (String)"AdjustSuggestImportPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean hasAdjustReason = dataTypeMap.get(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"AdjustSuggestImportPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean hasCalculateNum = dataTypeMap.get(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"AdjustSuggestImportPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean hasBillType = dataTypeMap.get(ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53", (String)"AdjustSuggestImportPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean hasBillNum = dataTypeMap.get(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AdjustSuggestImportPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean hasBillEntrySeq = dataTypeMap.get(ResManager.loadKDString((String)"\u5355\u636e\u884c\u53f7", (String)"AdjustSuggestImportPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean hasAdjustdate = dataTypeMap.get(ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f", (String)"AdjustSuggestImportPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        boolean bl = hasOperator = dataTypeMap.get(ResManager.loadKDString((String)"\u8ba1\u5212\u5458", (String)"AdjustSuggestImportPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0])) != null;
        if (!hasAdjustdate) {
            StringBuilder error = new StringBuilder();
            error.append(ResManager.loadKDString((String)"\u8868\u7ed3\u6784\u9519\u8bef\uff0c\u6570\u636e\u5217", (String)"AdjustSuggestImportPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f", (String)"AdjustSuggestImportPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u3002", (String)"AdjustSuggestImportPlugin_18", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            throw new KDBizException(error.toString());
        }
        for (int i = 1; i <= sheet.getLastRowNum(); ++i) {
            XSSFRow dataRow = sheet.getRow(i);
            if (dataRow == null) continue;
            Integer rowNum = dataRow.getRowNum();
            XSSFCell adjustdateCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u8c03\u6574\u53ef\u7528\u65e5\u671f", (String)"AdjustSuggestImportPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
            XSSFCell entrySeqCell = null;
            if (hasLineNo) {
                entrySeqCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u884c\u53f7", (String)"AdjustSuggestImportPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
            }
            String adjustDate = this.getCellDate((Cell)adjustdateCell);
            String entrySeq = this.getCellString((Cell)entrySeqCell);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("rowNo", rowNum.toString());
            map.put("adjustdate", adjustDate);
            if (hasAdjustReason) {
                XSSFCell adjustreasonCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"AdjustSuggestImportPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
                String adjustreason = this.getCellString((Cell)adjustreasonCell);
                map.put("adjustcause", adjustreason);
            } else {
                map.put("adjustcause", "");
            }
            if (hasCalculateNum) {
                XSSFCell caculateNumCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"AdjustSuggestImportPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
                String caculateNum = this.getCellString((Cell)caculateNumCell);
                map.put("plannum", caculateNum);
            } else {
                map.put("plannum", "");
            }
            if (hasBillType) {
                XSSFCell billTypeCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u4f9b\u5e94\u5355\u636e\u5b9e\u4f53", (String)"AdjustSuggestImportPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
                String billType = this.getCellString((Cell)billTypeCell);
                map.put("billtype", billType);
            } else {
                map.put("billtype", "");
            }
            if (hasBillNum) {
                XSSFCell billNumCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"AdjustSuggestImportPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
                String billNum = this.getCellString((Cell)billNumCell);
                map.put("billno", billNum);
            } else {
                map.put("billno", "");
            }
            if (hasBillEntrySeq) {
                XSSFCell billEntrySeqCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u5355\u636e\u884c\u53f7", (String)"AdjustSuggestImportPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
                String billEntrySeq = this.getCellString((Cell)billEntrySeqCell);
                map.put("lineno", billEntrySeq);
            } else {
                map.put("lineno", "");
            }
            if (hasOperator) {
                XSSFCell operatorCell = dataRow.getCell(((Integer)dataTypeMap.get(ResManager.loadKDString((String)"\u8ba1\u5212\u5458", (String)"AdjustSuggestImportPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))).intValue());
                String operatorNo = this.getCellString((Cell)operatorCell);
                map.put("schduler", operatorNo);
            } else {
                map.put("schduler", "");
            }
            map.put("entryseq", entrySeq);
            dataList.add(map);
        }
        this.getView().getPageCache().put(COUNT, Integer.toString(dataList.size()));
        this.getView().getPageCache().put(EXECUTECOUNT, "0");
        this.getView().getPageCache().put(FAILCOUNT, "0");
        String cacheKey = "mrp_adjustsuggest_cache" + UUID.randomUUID();
        this.getPageCache().put(PROGRESS, "0");
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        cache.put(cacheKey, (Object)SerializationUtils.toJsonString(dataList), 60, TimeUnit.MINUTES);
        this.getView().getPageCache().put("cacheKey", cacheKey);
    }

    private String getCellDate(Cell dateCell) {
        if (dateCell == null) {
            return "";
        }
        String dateNodeStr = this.getCellString(dateCell);
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        Date dateNode = null;
        String dateFormat = "";
        if (CellType.NUMERIC.equals((Object)dateCell.getCellType())) {
            Date date;
            dateNode = date = dateCell.getDateCellValue();
        } else if (CellType.FORMULA.equals((Object)dateCell.getCellType())) {
            String value = "";
            try {
                dateNode = dateCell.getDateCellValue();
            }
            catch (IllegalStateException e) {
                value = String.valueOf(dateCell.getRichStringCellValue());
                try {
                    dateNode = KDDateUtils.parseDate((String)value);
                }
                catch (KDBizException ex) {
                    dateNode = null;
                    return "error";
                }
            }
        } else {
            try {
                if (dateNodeStr.matches("[0-9]{4}[-][0-9]+[-][0-9]+")) {
                    dateNode = AdjustSuggestHelper.getFormDate((String)dateNodeStr, (String)"yyyy-MM-dd");
                } else if (dateNodeStr.matches("[0-9]{4}[/][0-9]+[/][0-9]+")) {
                    dateNode = AdjustSuggestHelper.getFormDate((String)dateNodeStr, (String)"yyyy/MM/dd");
                } else {
                    if (StringUtils.isNotBlank((CharSequence)dateNodeStr)) {
                        return "error";
                    }
                    dateNode = null;
                }
            }
            catch (KDBizException e) {
                dateNode = null;
                return "error";
            }
        }
        if (dateNode != null) {
            dateFormat = sim.format(dateNode);
        }
        return dateFormat;
    }

    private String getCellString(Cell xssfCell) {
        if (xssfCell == null) {
            return "";
        }
        if (xssfCell.getCellType() == CellType.NUMERIC) {
            NumberFormat n = NumberFormat.getInstance();
            double d = xssfCell.getNumericCellValue();
            return n.format(d).replace(",", "");
        }
        if (xssfCell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(xssfCell.getBooleanCellValue());
        }
        if (xssfCell.getCellType() == CellType.FORMULA) {
            String value = "";
            try {
                NumberFormat n = NumberFormat.getInstance();
                double d = xssfCell.getNumericCellValue();
                value = n.format(d).replace(",", "");
            }
            catch (IllegalStateException e) {
                value = String.valueOf(xssfCell.getRichStringCellValue());
            }
            return value;
        }
        return xssfCell.getStringCellValue();
    }

    public void onProgress(ProgressEvent progressEvent) {
        int percent = 0;
        if (this.getPageCache().get(PROGRESS) != null) {
            percent = Integer.parseInt(this.getPageCache().get(PROGRESS));
        }
        String countStr = this.getView().getPageCache().get(COUNT) == null ? "0" : this.getView().getPageCache().get(COUNT);
        String failCountStr = this.getView().getPageCache().get(FAILCOUNT) == null ? "0" : this.getView().getPageCache().get(FAILCOUNT);
        String excuteCountStr = this.getView().getPageCache().get(EXECUTECOUNT) == null ? "0" : this.getView().getPageCache().get(EXECUTECOUNT);
        int count = Integer.parseInt(countStr);
        int failcount = Integer.parseInt(failCountStr);
        int excutecount = Integer.parseInt(excuteCountStr);
        int successcount = excutecount - failcount;
        if (percent == 0) {
            RequestContext rc = RequestContextCreator.createForThreadPool();
            Object runnable = new RequestContextRunnable(new Runnable(){

                @Override
                public void run() {
                    AdjustSuggestImportPlugin.this.startImportDatas();
                }
            }, rc);
            runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
            Thread thread = new Thread((Runnable)runnable);
            thread.start();
        }
        if (excutecount < count) {
            Double calPrecent = (double)excutecount / (double)count * 100.0;
            percent = calPrecent.intValue();
            if (percent == 0) {
                percent = 1;
            }
            progressEvent.setProgress(percent);
            this.getPageCache().put(PROGRESS, Integer.toString(percent));
        } else if (count != 0 && excutecount == count) {
            progressEvent.setProgress(100);
            progressEvent.setText(this.getResult(successcount, failcount));
            this.getView().getPageCache().put(PROGRESS, "100");
            this.getView().setVisible(Boolean.TRUE, new String[]{"imbtndetail"});
        }
        String isfail = this.getPageCache().get("isfail");
        if ("true".equals(isfail)) {
            progressEvent.setProgress(100);
            progressEvent.setText(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"AdjustSuggestImportPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            this.getView().getPageCache().put(PROGRESS, "100");
            this.getView().setVisible(Boolean.TRUE, new String[]{"imbtndetail"});
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"improcesspanel"});
    }

    private String getResult(int successcount, int failcount) {
        StringBuilder result = new StringBuilder();
        result.append(ResManager.loadKDString((String)"\u6210\u529f", (String)"AdjustSuggestImportPlugin_19", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(successcount).append(ResManager.loadKDString((String)"\u6761\uff0c\u5931\u8d25", (String)"AdjustSuggestImportPlugin_20", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(failcount).append('\u6761');
        return result.toString();
    }

    private Map<String, DynamicObject> getAdjustSuggestCollection(DynamicObject calculateLog) {
        DynamicObject[] adjusts = BusinessDataServiceHelper.load((String)"mrp_adjustsuggest", (String)AdjustSuggestImportPlugin.getImportSelectFields(), (QFilter[])new QFilter[]{new QFilter("plannum", "=", (Object)calculateLog.getLong("id"))});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(adjusts.length);
        for (DynamicObject adjust : adjusts) {
            map.put(adjust.getString("entryseq"), adjust);
        }
        return map;
    }

    private static String getImportSelectFields() {
        StringBuilder fields = new StringBuilder();
        fields.append("id").append(',');
        fields.append("plannum.id").append(',');
        fields.append("entryseq").append(',');
        fields.append("origindate").append(',');
        fields.append("adjustdate").append(',');
        fields.append("adjustcause").append(',');
        fields.append("adjustsuggest").append(',');
        fields.append("billtype").append(',');
        fields.append("billno").append(',');
        fields.append("lineno").append(',');
        fields.append("schduler").append(',');
        fields.append("releasestatus").append(',');
        fields.append("dealer").append(',');
        fields.append("dealdate");
        return fields.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startImportDatas() {
        DLock lock = DLock.createReentrant((String)"adjust_import", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u529f\u80fd\u9501", (String)"AdjustSuggestImportPlugin_21", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        lock.lock();
        try {
            String cacheKey = this.getView().getPageCache().get("cacheKey");
            DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
            String dataStr = (String)cache.get(cacheKey);
            List dataList = (List)SerializationUtils.fromJsonString((String)dataStr, List.class);
            if (dataList.isEmpty()) {
                return;
            }
            long caculateLogId = (Long)this.getView().getFormShowParameter().getCustomParam("caculatelogid");
            if (caculateLogId == 0L) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u754c\u9762\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AdjustSuggestImportPlugin_22", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            DynamicObject calculateLog = AdjustSuggestHelper.getlastCaculateLogNum((long)caculateLogId);
            if (calculateLog == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u754c\u9762\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"AdjustSuggestImportPlugin_22", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            if (calculateLog != null && caculateLogId != 0L && caculateLogId != calculateLog.getLong("id")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f53\u524d\u754c\u9762\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\u5df2\u7ecf\u4e3a\u5386\u53f2\u8fd0\u7b97\u53f7\u3002", (String)"AdjustSuggestImportPlugin_23", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            HashMap<String, String> errMsgMap = new HashMap<String, String>(dataList.size());
            HashMap<String, String> successMsgMap = new HashMap<String, String>(dataList.size());
            ORM orm = ORM.create();
            QFilter filter = null;
            if (calculateLog != null) {
                filter = new QFilter("plannum", "=", (Object)calculateLog.getLong("id"));
            }
            int count = orm.count("AdjustImport", "mrp_adjustsuggest", new QFilter[]{filter}) + 1;
            HashMap<String, Integer> paramsMap = new HashMap<String, Integer>();
            paramsMap.put(COUNT, count);
            int patchSize = 1000;
            int index = 0;
            ArrayList<Map<String, String>> patchLs = new ArrayList<Map<String, String>>(patchSize);
            Map<String, DynamicObject> adjustMap = this.getAdjustSuggestCollection(calculateLog);
            Map<String, DynamicObject> unReleaseMap = this.getUnReleaseDatas(adjustMap);
            for (int i = 0; i < dataList.size(); ++i) {
                patchLs.add((Map<String, String>)dataList.get(i));
                if (i == 0 || (i + 1) % patchSize != 0) continue;
                this.importDatas(errMsgMap, successMsgMap, patchLs, String.valueOf(++index * patchSize), calculateLog, paramsMap, adjustMap, unReleaseMap);
            }
            if (patchLs.size() > 0) {
                this.importDatas(errMsgMap, successMsgMap, patchLs, String.valueOf(dataList.size()), calculateLog, paramsMap, adjustMap, unReleaseMap);
            }
            HashMap<String, String> msgMap = new HashMap<String, String>(dataList.size());
            ArrayList detailmessage = new ArrayList(dataList.size());
            msgMap.putAll(errMsgMap);
            msgMap.putAll(successMsgMap);
            msgMap.entrySet().stream().sorted(Map.Entry.comparingByKey((a1, a2) -> Integer.compare(Integer.parseInt(a1), Integer.parseInt(a2)))).forEachOrdered(a -> detailmessage.add(String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\uff1a%2$s", (String)"AdjustSuggestImportPlugin_24", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), a.getKey(), a.getValue())));
            this.getPageCache().put(DETAILMESSAGE, SerializationUtils.toJsonString(detailmessage));
            cache.remove(cacheKey);
        }
        finally {
            lock.unlock();
        }
    }

    public void importDatas(Map<String, String> errMsgMap, Map<String, String> successMsgMap, List<Map<String, String>> patchLs, String excutecount, DynamicObject calculateLog, Map<String, Integer> paramsMap, Map<String, DynamicObject> adjustMap, Map<String, DynamicObject> unReleaseMap) {
        try {
            Map importMsgMap = AdjustImportHelper.importData(patchLs, (DynamicObject)calculateLog, paramsMap, adjustMap, unReleaseMap);
            errMsgMap.putAll((Map)importMsgMap.get("errMsgMap"));
            successMsgMap.putAll((Map)importMsgMap.get("successMsgMap"));
            patchLs.clear();
            this.getPageCache().put(EXECUTECOUNT, excutecount);
            this.getPageCache().put(FAILCOUNT, String.valueOf(errMsgMap.size()));
        }
        catch (Exception e) {
            this.getPageCache().put("isfail", "true");
            ArrayList<String> ls = new ArrayList<String>();
            String stackTraceString = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            ls.add("INFO:" + stackTraceString);
            this.getPageCache().put(DETAILMESSAGE, SerializationUtils.toJsonString(ls));
            throw new KDBizException(new ErrorCode("", ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25", (String)"AdjustSuggestImportPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), new Object[]{e});
        }
    }

    private Map<String, DynamicObject> getUnReleaseDatas(Map<String, DynamicObject> adjustMap) {
        HashMap<String, DynamicObject> unReleaseMap = new HashMap<String, DynamicObject>();
        for (Map.Entry<String, DynamicObject> entry : adjustMap.entrySet()) {
            DynamicObject adjust = entry.getValue();
            if (adjust.getBoolean("releasestatus") || adjust.getDynamicObject("billtype") == null || !"pm_purorderbill".equals(adjust.getDynamicObject("billtype").getString("id"))) continue;
            StringBuilder key = new StringBuilder(adjust.getString("billno"));
            key.append('-').append(adjust.getString("lineno"));
            unReleaseMap.put(key.toString(), adjust);
        }
        return unReleaseMap;
    }
}

