/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.forecast;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.IntStream;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bill.BillShowParameter;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataPropEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.mmc.mrp.common.util.DateUtils;
import kd.mmc.mrp.common.util.FilePermissionUtil;
import kd.mmc.mrp.common.util.ForecastUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class AbstractForecastPlugin
extends AbstractReportFormPlugin {
    protected static final String PROGRESSBARAP = "progressbarap";
    protected static final String FORM_IMPORT = "mrp_prod_fctimport";
    private static final Log log = LogFactory.getLog(AbstractForecastPlugin.class);
    private final String algoKey = ((Object)((Object)this)).getClass().getSimpleName();

    protected abstract Set<String> getNotNeedColName();

    protected abstract void query();

    protected abstract void setFormId(FormShowParameter var1);

    protected abstract void showDateSetupForm();

    protected abstract String getImportPluginName();

    protected abstract QFilter[] getQFilter();

    protected abstract QFilter[] getQFilterByCache();

    protected abstract Tuple<List<String>, List<Map<String, Object>>> getData(List<Row> var1, RowMeta var2);

    protected abstract void operate(String var1, IFormView var2);

    protected abstract void batchOperate(String var1, IFormView var2);

    protected abstract String getSelectFields();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "release": 
            case "cancel": {
                IFormView entryView = this.getEntryView();
                EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length != 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AbstractForecastPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
            case "export": {
                if (!this.isEmptyEntryData()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"AbstractForecastPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    public void afterQuery(ReportQueryParam queryParam) {
        super.afterQuery(queryParam);
        this.query();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey;
            switch (operateKey = args.getOperateKey()) {
                case "dateset": {
                    this.showDateSetupForm();
                    break;
                }
                case "export": {
                    this.export();
                    break;
                }
                case "import": {
                    this.showImportForm();
                    break;
                }
                case "release": {
                    this.executeOperation("release");
                    break;
                }
                case "cancel": {
                    this.executeOperation("cancel");
                    break;
                }
                case "btn_selectall": {
                    this.selectAll();
                    break;
                }
                case "btn_cancalselect": {
                    this.cancelSelectAll();
                    break;
                }
            }
        }
    }

    private void executeOperation(String opKey) {
        boolean isSelectAll;
        IFormView entryView = this.getEntryView();
        IPageCache pageCache = entryView.getPageCache();
        boolean bl = isSelectAll = pageCache.get("selectAll") != null;
        if (isSelectAll) {
            this.batchOperate(opKey, entryView);
        } else {
            this.operate(opKey, entryView);
        }
    }

    private void showImportForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setHasRight(true);
        formShowParameter.setFormId(FORM_IMPORT);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "import"));
        formShowParameter.addCustPlugin(this.getImportPluginName());
        this.getView().showForm(formShowParameter);
    }

    private void cancelSelectAll() {
        IFormView entryView = this.getEntryView();
        EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
        entryGrid.selectRows(-1);
        entryView.setVisible(Boolean.FALSE, new String[]{"panel_selected"});
        this.getView().sendFormAction(entryView);
    }

    private void selectAll() {
        IFormView entryView = this.getEntryView();
        int entryRowCount = entryView.getModel().getEntryRowCount("entryentity");
        int[] selectRows = IntStream.range(0, entryRowCount).toArray();
        EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
        entryGrid.selectRows(selectRows, 0);
        IPageCache pageCache = entryView.getPageCache();
        String rowCount = pageCache.get("rowcount");
        if (rowCount != null) {
            Label label = (Label)entryView.getControl("selectedcount");
            label.setText(rowCount);
            entryView.setVisible(Boolean.TRUE, new String[]{"panel_selected"});
        }
        this.getView().sendFormAction(entryView);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        Object returnData = event.getReturnData();
        if (StringUtils.equals((CharSequence)"import", (CharSequence)actionId) && returnData instanceof String) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"AbstractForecastPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            this.query();
        }
    }

    private List<Control> getColControls(IFormView entryView) {
        EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
        List items = entryGrid.getItems();
        Set<String> notNeedColNames = this.getNotNeedColName();
        ArrayList colControls = Lists.newArrayListWithExpectedSize((int)(items.size() - notNeedColNames.size()));
        for (Control item : items) {
            if (notNeedColNames.contains(item.getKey())) continue;
            colControls.add(item);
        }
        return colControls;
    }

    private String convertValue(Map<String, Object> row, Control item) {
        String strValue;
        String key = item.getKey();
        if (item instanceof ComboEdit) {
            strValue = (String)row.get(key);
            ComboEdit comboEdit = (ComboEdit)item;
            ComboProp comboProp = (ComboProp)comboEdit.getProperty();
            List comboItems = comboProp.getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!StringUtils.equals((CharSequence)comboItem.getValue(), (CharSequence)strValue)) continue;
                strValue = comboItem.getName().getLocaleValue();
                break;
            }
        } else {
            Object value;
            Date date;
            strValue = item instanceof DateEdit ? ((date = (Date)row.get(key)) == null ? "" : DateUtils.formatDate((Date)date)) : (item instanceof DateTimeEdit ? ((date = (Date)row.get(key)) == null ? "" : DateUtils.formatDateTime((Date)date)) : ((value = row.get(key)) instanceof String ? (String)value : value.toString()));
        }
        return strValue;
    }

    private void export() {
        long startTime = System.currentTimeMillis();
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook();
        try {
            SXSSFSheet sheet = sxssfWorkbook.createSheet();
            IFormView entryView = this.getEntryView();
            List<Control> colControls = this.getColControls(entryView);
            long prepareTime = System.currentTimeMillis();
            log.info("[FCT-IMPORT] Preparing base data cost " + (prepareTime - startTime) + " ms");
            this.createHeadRow(sheet, colControls);
            long setHeadTime = System.currentTimeMillis();
            log.info("[FCT-IMPORT] Create head row cost " + (setHeadTime - prepareTime) + " ms");
            CellStyle cellStyle = this.getTextCellStyle(sxssfWorkbook);
            this.createBodyRow(sheet, entryView, colControls, cellStyle);
            long setBodyTime = System.currentTimeMillis();
            log.info("[FCT-IMPORT] Create body row cost " + (setBodyTime - setHeadTime) + " ms");
            this.setColWidth(sheet, colControls.size());
            outStream = new ByteArrayOutputStream();
            sxssfWorkbook.write((OutputStream)outStream);
            long finishTime = System.currentTimeMillis();
            log.info("[FCT-IMPORT] Write to outputstream cost " + (finishTime - setBodyTime) + " ms");
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            String fileName = this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue() + ".xlsx";
            String tempUrl = cache.saveAsUrl(fileName, (InputStream)inStream, 7200);
            FilePermissionUtil.addFilePermission((String)tempUrl, (String)this.getView().getFormShowParameter().getServiceAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"4730fc9f000004ae");
            this.getView().download(tempUrl);
            long endTime = System.currentTimeMillis();
            log.info("[FCT-IMPORT] Download file cost " + (endTime - finishTime) + " ms");
            log.info("[FCT-IMPORT] The whole task cost " + (endTime - startTime) + " ms");
        }
        catch (IOException e) {
            throw new KDBizException("export failed:" + e.getMessage());
        }
        finally {
            sxssfWorkbook.dispose();
            try {
                if (outStream != null) {
                    outStream.close();
                }
                if (inStream != null) {
                    inStream.close();
                }
                sxssfWorkbook.close();
            }
            catch (IOException e) {
                log.error("\u5bfc\u51faexcel\u6587\u4ef6\u5f02\u5e38, \u5931\u8d25\u539f\u56e0: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void createBodyRow(SXSSFSheet sheet, IFormView entryView, List<Control> colControls, CellStyle cellStyle) {
        CachedDataSet cachedDataSet;
        long startTime = System.currentTimeMillis();
        IPageCache pageCache = entryView.getPageCache();
        String algoCacheId = pageCache.get("algoCacheId");
        if (algoCacheId == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7f13\u5b58\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u518d\u8fdb\u884c\u5bfc\u51fa\u3002", (String)"AbstractForecastPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
        if (pageCache.get("isDirty") == null) {
            cachedDataSet = Algo.getCacheDataSet((String)algoCacheId);
        } else {
            cachedDataSet = ForecastUtils.getCachedDataSet((QFilter[])this.getQFilterByCache(), (IFormView)entryView, (String)this.getSelectFields());
            pageCache.remove("isDirty");
        }
        int rowCount = cachedDataSet.getRowCount();
        long getCacheTime = System.currentTimeMillis();
        log.info("[FCT-IMPORT] Get cache data cost " + (getCacheTime - startTime) + " ms");
        List rows = cachedDataSet.getList(0, rowCount);
        RowMeta rowMeta = cachedDataSet.getRowMeta();
        Tuple<List<String>, List<Map<String, Object>>> tuple = this.getData(rows, rowMeta);
        long getDataTime = System.currentTimeMillis();
        log.info("[FCT-IMPORT] Get data cost " + (getDataTime - startTime) + " ms");
        List dateCols = (List)tuple.item1;
        List datas = (List)tuple.item2;
        Set fieldNames = ((Map)datas.get(0)).keySet();
        ObjectMapper objectMapper = SerializationUtils.getObjectMapper2();
        try {
            int datasSize = datas.size();
            for (int i = 0; i < datasSize; ++i) {
                Map data = (Map)datas.get(i);
                SXSSFRow sheetRow = sheet.createRow(i + 1);
                String dateColJson = (String)data.get("date_qty_tag");
                Map date2Qty = (Map)objectMapper.readValue(dateColJson, HashMap.class);
                int colControlsSize = colControls.size();
                for (int j = 0; j < colControlsSize; ++j) {
                    SXSSFCell cell;
                    Control item = colControls.get(j);
                    String key = item.getKey();
                    if (fieldNames.contains(key)) {
                        if (item instanceof DecimalEdit) {
                            cell = sheetRow.createCell(j, CellType.NUMERIC);
                            BigDecimal qty = (BigDecimal)data.get(key);
                            qty = qty == null ? BigDecimal.ZERO : qty;
                            cell.setCellValue(qty.stripTrailingZeros().doubleValue());
                            continue;
                        }
                        cell = sheetRow.createCell(j, CellType.STRING);
                        String rowValue = this.convertValue(data, item);
                        cell.setCellStyle(cellStyle);
                        cell.setCellValue(rowValue);
                        continue;
                    }
                    if (dateCols.contains(key)) {
                        cell = sheetRow.createCell(j, CellType.NUMERIC);
                        Object qtyObj = date2Qty.get(key);
                        BigDecimal qty = BigDecimal.ZERO;
                        if (qtyObj != null) {
                            qty = new BigDecimal(qtyObj.toString());
                        }
                        cell.setCellValue(qty.stripTrailingZeros().doubleValue());
                        continue;
                    }
                    cell = sheetRow.createCell(j, CellType.STRING);
                    cell.setCellValue("");
                }
            }
        }
        catch (IOException e) {
            throw new KDException(new ErrorCode("mmc.mrp.fct", e.getMessage()), null, (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        log.info("[FCT-IMPORT] Loop create body row cost " + (endTime - getDataTime) + " ms");
    }

    private void createHeadRow(SXSSFSheet sheet, List<Control> colControls) {
        SXSSFRow headRow = sheet.createRow(0);
        int colControlsSize = colControls.size();
        for (int i = 0; i < colControlsSize; ++i) {
            String rowValue;
            Control item = colControls.get(i);
            SXSSFCell headRowCell = headRow.createCell(i, CellType.STRING);
            if (item instanceof BasedataPropEdit) {
                BasedataPropEdit basedataPropEdit = (BasedataPropEdit)item;
                rowValue = basedataPropEdit.getDisplayName().getLocaleValue();
            } else if (item instanceof FieldEdit) {
                FieldEdit fieldEdit = (FieldEdit)item;
                rowValue = fieldEdit.getProperty().getDisplayName().getLocaleValue();
            } else {
                rowValue = item.getKey();
            }
            headRowCell.setCellValue(rowValue);
        }
    }

    private CellStyle getTextCellStyle(SXSSFWorkbook sxssfWorkbook) {
        CellStyle cellStyle = sxssfWorkbook.createCellStyle();
        DataFormat dataFormat = sxssfWorkbook.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("@"));
        return cellStyle;
    }

    protected void showForm(Object pkId, String formId, Map<String, Object> customParams, CloseCallBack closeCallBack) {
        BillShowParameter formShowParameter = null;
        if (pkId != null) {
            formShowParameter = new BillShowParameter();
            formShowParameter.setPkId(pkId);
        } else {
            formShowParameter = new FormShowParameter();
        }
        formShowParameter.setHasRight(true);
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        if (Objects.nonNull(customParams)) {
            formShowParameter.setCustomParams(customParams);
        }
        if (Objects.nonNull(closeCallBack)) {
            formShowParameter.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void setColWidth(SXSSFSheet sheet, int colSize) {
        for (int i = 0; i < colSize; ++i) {
            sheet.setColumnWidth(i, 5111);
        }
    }

    protected IFormView getEntryView() {
        String entryPageId = this.getPageCache().get("entryPageId");
        return this.getView().getView(entryPageId);
    }

    private boolean isEmptyEntryData() {
        IFormView entryView = this.getEntryView();
        return entryView.getModel().getEntryEntity("entryentity").isEmpty();
    }

    protected void initEntryForm() {
        this.showEntryForm(null);
    }

    protected void showEntryForm(Map<String, Object> params) {
        FormShowParameter formShowParameter = new FormShowParameter();
        this.setFormId(formShowParameter);
        formShowParameter.setHasRight(true);
        OpenStyle openStyle = formShowParameter.getOpenStyle();
        openStyle.setShowType(ShowType.InContainer);
        openStyle.setTargetKey("flex_content");
        if (Objects.nonNull(params)) {
            formShowParameter.setCustomParams(params);
        }
        this.getView().showForm(formShowParameter);
        this.getPageCache().put("entryPageId", formShowParameter.getPageId());
    }
}

