/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.forecast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mrp.common.enums.DataType;
import kd.mmc.mrp.common.util.DateUtils;
import kd.mmc.mrp.common.util.ForecastUtils;
import kd.mmc.mrp.formplugin.forecast.AbstractForecastImportPlugin;
import kd.mmc.mrp.formplugin.forecast.excel.ExcelEventParser;
import kd.mmc.mrp.formplugin.forecast.excel.FctSheetContentHandler;
import kd.mpscmm.msplan.business.inventory.InvLevel;
import kd.mpscmm.msplan.business.inventory.InvLevelEntry;

public class PurForecastImportPlugin
extends AbstractForecastImportPlugin {
    private static final int BATCH_SIZE = 5000;
    private final String algoKey = ((Object)((Object)this)).getClass().getSimpleName();
    private static final Log log = LogFactory.getLog(PurForecastImportPlugin.class);
    private static final BigDecimal MAX_QTY = new BigDecimal("1E+13");

    @Override
    protected void dealData(InputStream excelInputStream, final long userId, final List<String> validateErrors) {
        try {
            final ORM orm = ORM.create();
            final StringBuilder sb = new StringBuilder();
            final Date now = new Date();
            final ArrayList<Object[]> values = new ArrayList<Object[]>();
            final HashMap<String, Map<String, Object>> newDataMap = new HashMap<String, Map<String, Object>>(16);
            final Object[] purFctData = new Object[3];
            String lastCalcLog = "";
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                lastCalcLog = (String)parentView.getModel().getValue("caculatelog");
            }
            if (!ForecastUtils.isLastRunLog((String)lastCalcLog)) {
                validateErrors.add(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%s\u201d\u4e0d\u662f\u6700\u65b0\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PurForecastImportPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), lastCalcLog));
                return;
            }
            final int[] allRow = new int[]{0};
            final int[] successRow = new int[]{0};
            final boolean[] isAllError = new boolean[]{false};
            new ExcelEventParser(excelInputStream).setHandler(new FctSheetContentHandler(123, lastCalcLog){
                private int materialIndex;
                private int caculatelogIndex;
                private int dataTypeIndex;
                private Set<String> dateCols;
                private final Set<String> validateNumberSet;
                private final Set<String> successNumberSet;
                private Map<String, List<Map<String, Object>>> materialListMap;
                private boolean isInit;
                {
                    super(expectedSize, lastCalcLog);
                    this.materialIndex = -1;
                    this.caculatelogIndex = -1;
                    this.dataTypeIndex = -1;
                    this.validateNumberSet = new HashSet<String>();
                    this.successNumberSet = new HashSet<String>();
                    this.isInit = false;
                }

                @Override
                public void endRow(int rowNum) {
                    if (rowNum == 0) {
                        this.initFirstRowInfo();
                        return;
                    }
                    if (this.rows.isEmpty()) {
                        return;
                    }
                    if (this.isError) {
                        return;
                    }
                    String materialNumber = (String)this.rows.get(this.materialIndex);
                    String caculatelog = (String)this.rows.get(this.caculatelogIndex);
                    if (!StringUtils.equalsIgnoreCase((CharSequence)this.lastCalcLog, (CharSequence)caculatelog)) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%s\u201d\u4e0d\u662f\u6700\u65b0\u7684\u8ba1\u5212\u8fd0\u7b97\u53f7\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PurForecastImportPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, caculatelog));
                        this.validateNumberSet.add(materialNumber + "\u0001@\u0001" + rowNum);
                        return;
                    }
                    if (!this.isInit) {
                        this.initData();
                        this.isInit = true;
                    }
                    if (this.materialListMap == null) {
                        return;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)this.rows.get(this.dataTypeIndex)))) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u7c7b\u578b\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PurForecastImportPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1));
                        this.validateNumberSet.add(materialNumber + "\u0001@\u0001");
                        return;
                    }
                    DataType type = DataType.fromName((String)((String)this.rows.get(this.dataTypeIndex)));
                    if (type == null) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u6570\u636e\u7c7b\u578b\u4e0d\u4e3a\u7cfb\u7edf\u8f93\u51fa\u6216\u53d1\u5e03\u6570\u91cf\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"PurForecastImportPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1));
                        this.validateNumberSet.add(materialNumber + "\u0001@\u0001");
                        return;
                    }
                    String dataType = type.getValue();
                    sb.append(materialNumber).append("\u0001@\u0001").append(dataType);
                    String numberType = sb.toString();
                    sb.setLength(0);
                    List<Map<String, Object>> list = this.materialListMap.get(materialNumber);
                    if (list != null) {
                        if ("B".equals(dataType)) {
                            if (!this.validateNumberSet.add(numberType)) {
                                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201c\u53d1\u5e03\u6570\u91cf\u201d\u7269\u6599\u7f16\u7801\u201c%s\u201d\u6570\u636e\u91cd\u590d\u3002", (String)"PurForecastImportPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber));
                                return;
                            }
                            boolean isValid = true;
                            ArrayList vs = Lists.newArrayListWithCapacity((int)list.size());
                            for (Map<String, Object> row : list) {
                                String isSpilted = (String)row.get("issplited");
                                if (!"N".equals(isSpilted)) {
                                    validateErrors.add(String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff1a\u7269\u6599\u7f16\u7801\u201c%s\u201d\u62c6\u5206\u72b6\u6001\u4e0d\u4e3a\u201c\u672a\u62c6\u5206\u201d\u3002", (String)"PurForecastImportPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), materialNumber));
                                    isValid = false;
                                    break;
                                }
                                String isPublished = (String)row.get("ispublished");
                                if (StringUtils.equals((CharSequence)isPublished, (CharSequence)"1")) {
                                    validateErrors.add(String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u201c%s\u201d\u5df2\u53d1\u5e03, \u5bfc\u5165\u5931\u8d25\u3002", (String)"PurForecastImportPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), materialNumber));
                                    isValid = false;
                                    break;
                                }
                                dataType = (String)row.get("datatype");
                                String oldRemarks = (String)row.get("remarks");
                                String oldDateQtyInfo = (String)row.get("date_qty_tag");
                                BigDecimal oldTotalQty = (BigDecimal)row.get("totalqty");
                                if ("B".equals(dataType)) {
                                    String remarks = (String)this.rows.get(this.remarksIndex);
                                    if (!StringUtils.equals((CharSequence)oldRemarks, (CharSequence)remarks)) {
                                        oldRemarks = remarks;
                                    }
                                    HashMap dateQtyMap = Maps.newHashMapWithExpectedSize((int)(this.colNames.size() - this.qtyStartIndex));
                                    BigDecimal totalQty = BigDecimal.ZERO;
                                    for (int j = this.qtyStartIndex; j < this.colNames.size(); ++j) {
                                        BigDecimal qty;
                                        String colName = (String)this.colNames.get(j);
                                        try {
                                            qty = this.convertNumberValue((String)this.rows.get(j));
                                        }
                                        catch (Exception e) {
                                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u65f6\u95f4\u5217\u201c%3$s\u201d\u503c\u7c7b\u578b\u4e0d\u4e3a\u6570\u503c\u3002", (String)"PurForecastImportPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber, colName));
                                            isValid = false;
                                            continue;
                                        }
                                        BigDecimal summary = dateQtyMap.computeIfAbsent(colName, k -> BigDecimal.ZERO);
                                        summary = summary.add(qty);
                                        if (summary.compareTo(MAX_QTY) >= 0) {
                                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u65f6\u95f4\u5217\u201c%3$s\u201d\u6570\u91cf\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc713\u3002", (String)"PurForecastImportPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber, colName));
                                            isValid = false;
                                            continue;
                                        }
                                        dateQtyMap.put(colName, summary);
                                        totalQty = totalQty.add(qty);
                                    }
                                    oldTotalQty = totalQty;
                                    oldDateQtyInfo = SerializationUtils.toJsonString((Object)dateQtyMap);
                                }
                                if (oldTotalQty.compareTo(MAX_QTY) >= 0) {
                                    validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u5408\u8ba1\u6570\u91cf\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc713\u3002", (String)"PurForecastImportPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber));
                                    isValid = false;
                                    break;
                                }
                                if (!isValid) break;
                                Object[] value = new Object[]{oldRemarks, oldDateQtyInfo, oldTotalQty, false, 0L, null, userId, now, row.get("id")};
                                vs.add(value);
                            }
                            if (isValid) {
                                values.addAll(vs);
                                this.successNumberSet.add(numberType);
                            }
                        }
                    } else if ("B".equals(dataType)) {
                        if (!this.validateNumberSet.add(numberType)) {
                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%d\u884c\u201c\u53d1\u5e03\u6570\u91cf\u201d\u7269\u6599\u7f16\u7801\u201c%s\u201d\u6570\u636e\u91cd\u590d\u3002", (String)"PurForecastImportPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber));
                            return;
                        }
                        boolean remove = false;
                        Map data = newDataMap.computeIfAbsent(materialNumber, k -> Maps.newHashMapWithExpectedSize((int)3));
                        String remarks = (String)this.rows.get(this.remarksIndex);
                        data.put("remarks", remarks);
                        data.put("rowNum", rowNum);
                        HashMap dateQtyMap = Maps.newHashMapWithExpectedSize((int)(this.colNames.size() - this.qtyStartIndex));
                        BigDecimal totalQty = BigDecimal.ZERO;
                        for (int j = this.qtyStartIndex; j < this.colNames.size(); ++j) {
                            BigDecimal qty;
                            String colName = (String)this.colNames.get(j);
                            try {
                                qty = this.convertNumberValue((String)this.rows.get(j));
                            }
                            catch (Exception e) {
                                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u65f6\u95f4\u5217\u201c%3$s\u201d\u503c\u7c7b\u578b\u4e0d\u4e3a\u6570\u503c\u3002", (String)"PurForecastImportPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber, colName));
                                remove = true;
                                continue;
                            }
                            BigDecimal summary = dateQtyMap.computeIfAbsent(colName, k -> BigDecimal.ZERO);
                            summary = summary.add(qty);
                            if (summary.compareTo(MAX_QTY) >= 0) {
                                validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u65f6\u95f4\u5217\u201c%3$s\u201d\u6570\u91cf\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc713\u3002", (String)"PurForecastImportPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber, colName));
                                remove = true;
                                continue;
                            }
                            dateQtyMap.put(colName, summary);
                            totalQty = totalQty.add(qty);
                        }
                        if (totalQty.compareTo(MAX_QTY) >= 0) {
                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\uff0c\u5408\u8ba1\u6570\u91cf\u6574\u6570\u4f4d\u4e0d\u80fd\u8d85\u8fc713\u3002", (String)"PurForecastImportPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, materialNumber));
                            remove = true;
                        }
                        data.put("totalqty", totalQty);
                        data.put("date_qty_tag", SerializationUtils.toJsonString((Object)dateQtyMap));
                        if (remove) {
                            newDataMap.remove(materialNumber);
                        } else {
                            this.successNumberSet.add(numberType);
                        }
                    }
                    if ((rowNum & 0x3FF) == 0) {
                        this.progress += 2;
                        if (this.progress >= 100) {
                            this.progress = 99;
                        }
                        PurForecastImportPlugin.this.setProgress(this.progress);
                        PurForecastImportPlugin.this.setTip(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u89e3\u6790%d\u6761", (String)"PurForecastImportPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum));
                    }
                }

                @Override
                protected void afterEndRow(int i) {
                    allRow[0] = this.validateNumberSet.size();
                    successRow[0] = this.successNumberSet.size();
                    isAllError[0] = this.isError;
                }

                private void initData() {
                    String calculatelog = (String)this.rows.get(this.caculatelogIndex);
                    Map purFctInfo = PurForecastImportPlugin.this.getPurFctInfo(orm, calculatelog);
                    if (purFctInfo == null) {
                        validateErrors.add(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u201c%s\u201d \u5c1a\u672a\u751f\u6210\u91c7\u8d2d\u9884\u6d4b\u5355\u3002", (String)"PurForecastImportPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), calculatelog));
                        this.isError = true;
                        return;
                    }
                    this.dateCols = (Set)SerializationUtils.fromJsonString((String)((String)purFctInfo.get("dateinfo_tag")), LinkedHashSet.class);
                    this.validateDateCol();
                    if (!validateErrors.isEmpty()) {
                        this.isError = true;
                        return;
                    }
                    purFctData[0] = calculatelog;
                    purFctData[1] = purFctInfo.get("id");
                    purFctData[2] = purFctInfo.get("sumdim");
                    try (DataSet dataSet = PurForecastImportPlugin.this.getFilterData(orm, calculatelog);){
                        RowMeta rowMeta = dataSet.getRowMeta();
                        this.materialListMap = new HashMap<String, List<Map<String, Object>>>(16);
                        for (Row row : dataSet) {
                            HashMap map = Maps.newHashMapWithExpectedSize((int)7);
                            String materialNumber = row.getString("materialNumber");
                            List list = this.materialListMap.computeIfAbsent(materialNumber, k -> Lists.newArrayListWithExpectedSize((int)2));
                            rowMeta.toMap(row, (Map)map);
                            list.add(map);
                        }
                    }
                }

                private void validateDateCol() {
                    for (int i = 0; i < this.colNames.size(); ++i) {
                        String colName = (String)this.colNames.get(i);
                        if (!StringUtils.contains((CharSequence)colName, (CharSequence)"/")) continue;
                        if (this.qtyStartIndex == -1) {
                            this.qtyStartIndex = i;
                        }
                        if (this.dateCols.remove(colName)) continue;
                        String dateCol = null;
                        String[] cols = colName.split("-");
                        try {
                            for (String col : cols) {
                                Date date = DateUtils.parseDate((String)col);
                                dateCol = dateCol == null ? DateUtils.formatDate((Date)date) : String.format("%s-%s", dateCol, DateUtils.formatDate((Date)date));
                            }
                            if (!this.dateCols.remove(dateCol)) {
                                validateErrors.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4f59\u201c%s\u201d\u5217\u3002", (String)"PurForecastImportPlugin_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), colName));
                                continue;
                            }
                            this.colNames.set(i, dateCol);
                            continue;
                        }
                        catch (Exception e) {
                            validateErrors.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u591a\u4f59\u201c%s\u201d\u5217\u3002", (String)"PurForecastImportPlugin_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), colName));
                        }
                    }
                    if (!this.dateCols.isEmpty()) {
                        for (String dateCol : this.dateCols) {
                            validateErrors.add(String.format(ResManager.loadKDString((String)"[%s]\u5217\u4e0d\u5b58\u5728\u3002", (String)"PurForecastImportPlugin_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), dateCol));
                        }
                    }
                }

                private void initFirstRowInfo() {
                    if (this.rows.isEmpty()) {
                        validateErrors.add(ResManager.loadKDString((String)"\u5bfc\u5165\u6587\u4ef6\u4e2d\u6682\u65e0\u6570\u636e\uff0c\u6216\u7b2c\u4e00\u884c\u4e3a\u7a7a\u884c\u3002", (String)"PurForecastImportPlugin_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                        this.isError = true;
                        return;
                    }
                    this.colNames = new ArrayList(this.rows);
                    for (int i = 0; i < this.colNames.size(); ++i) {
                        String colName = (String)this.colNames.get(i);
                        if (ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"PurForecastImportPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]).equals(colName)) {
                            this.materialIndex = i;
                            continue;
                        }
                        if (ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b", (String)"PurForecastImportPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]).equals(colName)) {
                            this.dataTypeIndex = i;
                            continue;
                        }
                        if (ResManager.loadKDString((String)"\u8c03\u6574\u539f\u56e0", (String)"PurForecastImportPlugin_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]).equals(colName)) {
                            this.remarksIndex = i;
                            continue;
                        }
                        if (!ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7", (String)"PurForecastImportPlugin_18", (String)"mmc-mrp-formplugin", (Object[])new Object[0]).equals(colName)) continue;
                        this.caculatelogIndex = i;
                    }
                    if (this.materialIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"\u201c\u7269\u6599\u7f16\u7801\u201d\u5217\u4e0d\u5b58\u5728\u3002", (String)"PurForecastImportPlugin_19", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    }
                    if (this.dataTypeIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"\u201c\u6570\u636e\u7c7b\u578b\u201d\u5217\u4e0d\u5b58\u5728\u3002", (String)"PurForecastImportPlugin_20", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    }
                    if (this.caculatelogIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"\u201c\u8ba1\u5212\u8fd0\u7b97\u53f7\u201d\u5217\u4e0d\u5b58\u5728\u3002", (String)"PurForecastImportPlugin_21", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    }
                    if (this.remarksIndex == -1) {
                        validateErrors.add(ResManager.loadKDString((String)"\u201c\u8c03\u6574\u539f\u56e0\u201d\u5217\u4e0d\u5b58\u5728\u3002", (String)"PurForecastImportPlugin_22", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    }
                    if (!validateErrors.isEmpty()) {
                        this.isError = true;
                    }
                }
            }).parse();
            if (isAllError[0]) {
                this.setAllError(isAllError[0]);
                return;
            }
            if (!values.isEmpty()) {
                sb.append("UPDATE t_mrp_pur_fctentry SET ");
                sb.append("fremarks = ?, ");
                sb.append("fdateqty_tag = ?, ");
                sb.append("ftotalqty = ?, ");
                sb.append("fpublished = ?, ");
                sb.append("fpublisher = ?, ");
                sb.append("fpublishtime = ?, ");
                sb.append("fmodifier = ?, ");
                sb.append("fmodifytime = ? ");
                sb.append("WHERE FEntryId = ?");
                String updateSql = sb.toString();
                sb.setLength(0);
                int totalCount = values.size();
                this.setProgress(1);
                this.setTip(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406...", (String)"PurForecastImportPlugin_23", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"mrp_pur_fctdata");
                EntryProp entryProp = (EntryProp)dt.getProperty("entryentity");
                DynamicObjectType entryDt = entryProp.getDynamicCollectionItemPropertyType();
                String entryTableNmae = entryDt.getAlias();
                DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
                if (totalCount > 5000) {
                    int times = totalCount / 5000 + 1;
                    int finishCount = 0;
                    for (int seq = 0; seq < times; ++seq) {
                        int startIndex = seq * 5000;
                        int endIndex = Math.min(startIndex + 5000, totalCount);
                        this.executeBatch(dbRoute, updateSql, values, startIndex, endIndex);
                        this.setProgress((finishCount += endIndex - startIndex) * 100 / totalCount);
                        this.setTip(String.format(ResManager.loadKDString((String)"\u6b63\u5728\u5904\u7406%1$d/%2$d\u6761", (String)"PurForecastImportPlugin_24", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), finishCount, totalCount));
                    }
                } else {
                    DB.executeBatch((DBRoute)dbRoute, (String)updateSql, values);
                }
            }
            if (!newDataMap.isEmpty()) {
                this.setTip(String.format(ResManager.loadKDString((String)"\u68c0\u6d4b\u51fa%d\u6761\u65b0\u589e\u8bb0\u5f55, \u6b63\u5728\u5904\u7406...", (String)"PurForecastImportPlugin_25", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), newDataMap.size()));
                this.saveNewLine(purFctData, newDataMap, validateErrors, successRow, now, userId);
            }
            this.setCompleted();
            this.setRowCache(allRow[0], successRow[0]);
        }
        catch (Exception e) {
            this.setExceptionStack(e);
        }
    }

    private void executeBatch(DBRoute dbRoute, String updateSql, List<Object[]> values, int startIndex, int endIndex) {
        DB.executeBatch((DBRoute)dbRoute, (String)updateSql, values.subList(startIndex, endIndex));
    }

    private void saveNewLine(Object[] purFctData, Map<String, Map<String, Object>> newDataMap, List<String> validateErrors, int[] successRow, Date now, long userId) {
        Object invLevel;
        Object row2;
        String caculatelog = (String)purFctData[0];
        Object id = purFctData[1];
        ORM orm = ORM.create();
        HashMap materialMap = Maps.newHashMapWithExpectedSize((int)newDataMap.size());
        HashSet<String> mNums = new HashSet<String>(newDataMap.keySet());
        QFilter[] filters = new QFilter("number", "in", mNums).toArray();
        HashMap midToNumber = Maps.newHashMapWithExpectedSize((int)newDataMap.size());
        try (DataSet dataSet = orm.queryDataSet(this.algoKey, "bd_material", "id material, number, baseunit unit", filters);){
            for (Object row2 : dataSet) {
                Iterator number = row2.getString("number");
                Map dataMap = materialMap.computeIfAbsent(number, k -> Maps.newHashMapWithExpectedSize((int)5));
                dataMap.put("material", row2.getLong("material"));
                dataMap.put("unit", row2.getLong("unit"));
                midToNumber.put(row2.getLong("material"), number);
                mNums.remove(number);
            }
        }
        Long org = ForecastUtils.getPlanOrgByRunLog((String)caculatelog);
        QFilter useOrg = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_materialplan", (Long)org);
        filters = new QFilter[]{new QFilter("masterid", "in", midToNumber.keySet()), useOrg};
        DataSet dataSet = orm.queryDataSet(this.algoKey, "mpdm_materialplan", "masterid material, operator, plantags", filters);
        row2 = null;
        try {
            for (Row row3 : dataSet) {
                String number = (String)midToNumber.remove(row3.getLong("material"));
                Map dataMap = materialMap.computeIfAbsent(number, k -> Maps.newHashMapWithExpectedSize((int)5));
                dataMap.put("operator", row3.getLong("operator"));
                dataMap.put("plantags", row3.getLong("plantags"));
            }
        }
        catch (Throwable number) {
            row2 = number;
            throw number;
        }
        finally {
            if (dataSet != null) {
                if (row2 != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable number) {
                        ((Throwable)row2).addSuppressed(number);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("type", "=", (Object)"A")};
        DynamicObjectCollection invLevelCollection = QueryServiceHelper.query((String)"msplan_invlevel", (String)"id,type", (QFilter[])qFilters);
        block38: for (Map.Entry entry : midToNumber.entrySet()) {
            Long mid = (Long)entry.getKey();
            String number = (String)entry.getValue();
            for (DynamicObject dynamicObject : invLevelCollection) {
                invLevel = new InvLevel(dynamicObject.get("id"), new Date());
                InvLevelEntry invLevelEntry = invLevel.getEntry((Object)org, (Object)mid);
                if (invLevelEntry == null || invLevelEntry.getEntry() == null) continue;
                Map dataMap = materialMap.computeIfAbsent(number, k -> Maps.newHashMapWithExpectedSize((int)5));
                dataMap.put("operator", invLevelEntry.getEntry().getLong("operator_id"));
                dataMap.put("plantags", invLevelEntry.getEntry().getLong("plantag_id"));
                continue block38;
            }
        }
        for (String mNum : mNums) {
            Map newData = newDataMap.getOrDefault(mNum, new HashMap());
            Integer rowNum = newData.getOrDefault("rowNum", 0);
            validateErrors.add(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\uff0c\u7269\u6599\u7f16\u7801\u201c%2$s\u201d\u4e0d\u5b58\u5728\uff0c\u5ffd\u7565\u8be5\u884c\u3002", (String)"PurForecastImportPlugin_26", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rowNum + 1, mNum));
            successRow[0] = successRow[0] - 1;
        }
        if (materialMap.isEmpty()) {
            return;
        }
        String selectFields = "mrpplan.orgentryentity.entryinvstrategy.stocksetupentry.stocknumber warehouseId, mrpplan.orgentryentity.entryinvstrategy.stocksetupentry.stockorg org";
        QFilter filter = new QFilter("caculatelog", "=", (Object)caculatelog);
        QFilter isWasteStockFilter = new QFilter("mrpplan.orgentryentity.entryinvstrategy.stocksetupentry.wastewarehouse", "=", (Object)true);
        HashSet<Long> warehouseIds = new HashSet<Long>();
        HashSet<Long> orgIds = new HashSet<Long>();
        DataSet dataSet2 = orm.queryDataSet(this.algoKey, "mrp_calcdetail", selectFields, new QFilter[]{filter, isWasteStockFilter});
        invLevel = null;
        try {
            for (Row row4 : dataSet2) {
                warehouseIds.add(row4.getLong("warehouseId"));
                orgIds.add(row4.getLong("org"));
            }
        }
        catch (Throwable invLevelEntry) {
            invLevel = invLevelEntry;
            throw invLevelEntry;
        }
        finally {
            if (dataSet2 != null) {
                if (invLevel != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable invLevelEntry) {
                        ((Throwable)invLevel).addSuppressed(invLevelEntry);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        QFilter materialFilter = new QFilter("material.number", "in", materialMap.keySet());
        QFilter warehouseFilter = new QFilter("warehouse", "in", warehouseIds);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        try (DataSet dataSet3 = orm.queryDataSet(this.algoKey, "im_inv_realbalance", "material.number number, baseqty", new QFilter[]{materialFilter, warehouseFilter, orgFilter});){
            for (Row row5 : dataSet3) {
                Map dataMap = materialMap.computeIfAbsent(row5.getString("number"), k -> Maps.newHashMapWithExpectedSize((int)4));
                BigDecimal summary = (BigDecimal)dataMap.computeIfAbsent("wasteqty", k -> BigDecimal.ZERO);
                dataMap.put("wasteqty", summary.add(row5.getBigDecimal("baseqty")));
            }
        }
        String insertSql = "insert into t_mrp_pur_fctentry (fmaterialid, funitid, foperator, fremarks, fpublished, fpublisher, fpublishtime, fsplited, fmodifier, fmodifytime, fwasteqty, ftotalqty, fdateqty_tag, fdatatype, fid, fentryid, fseq, fplantag) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)"mrp_pur_fctdata");
        EntryProp entryProp = (EntryProp)dt.getProperty("entryentity");
        DynamicObjectType entryDt = entryProp.getDynamicCollectionItemPropertyType();
        String entryTableNmae = entryDt.getAlias();
        DBRoute dbRoute = DBRoute.of((String)dt.getDBRouteKey());
        String emptyJson = SerializationUtils.toJsonString(Collections.emptyMap());
        int totalSize = materialMap.size() << 1;
        ArrayList values = Lists.newArrayListWithExpectedSize((int)totalSize);
        long[] entryIds = orm.genLongIds((IDataEntityType)dt, totalSize);
        int count = 0;
        String querySql = "select count(1) from t_mrp_pur_fctentry where fid = ?";
        int seq = (Integer)DB.query((DBRoute)dbRoute, (String)querySql, (Object[])new Object[]{id}, rs -> rs.next() ? rs.getInt(1) : 0);
        BigDecimal zero = BigDecimal.ZERO;
        for (Map.Entry entry : materialMap.entrySet()) {
            String k2 = (String)entry.getKey();
            Map v = (Map)entry.getValue();
            BigDecimal wasteqty = v.getOrDefault("wasteqty", BigDecimal.ZERO);
            Map<String, Object> newData = newDataMap.get(k2);
            BigDecimal totalQty = (BigDecimal)newData.getOrDefault("totalqty", BigDecimal.ZERO);
            String dateQtyJson = (String)newData.getOrDefault("date_qty_tag", emptyJson);
            for (DataType dataType : DataType.values()) {
                Object[] value = new Object[]{v.getOrDefault("material", 0L), v.getOrDefault("unit", 0L), v.getOrDefault("operator", 0L), newData.getOrDefault("remarks", ""), false, 0L, null, "N", userId, now, wasteqty, dataType == DataType.SYSOUTPUT ? zero : totalQty, dataType == DataType.SYSOUTPUT ? emptyJson : dateQtyJson, dataType.getValue(), id, entryIds[count++], ++seq, v.getOrDefault("plantags", 0L)};
                values.add(value);
            }
        }
        DB.executeBatch((DBRoute)dbRoute, (String)insertSql, (List)values);
    }

    private Map<String, Object> getPurFctInfo(ORM orm, String caclulatelog) {
        QFilter[] filters = new QFilter("caculatelog", "=", (Object)caclulatelog).toArray();
        try (DataSet dataSet = orm.queryDataSet(this.algoKey, "mrp_pur_fctdata", "id, sumdim, dateinfo_tag, is_latest_data", filters, null, 1);){
            if (dataSet.hasNext()) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)5);
                RowMeta rowMeta = dataSet.getRowMeta();
                rowMeta.toMap(dataSet.next(), (Map)map);
                HashMap hashMap = map;
                return hashMap;
            }
            Map<String, Object> map = null;
            return map;
        }
    }

    private DataSet getFilterData(ORM orm, String caclulatelog) {
        QFilter[] filters = new QFilter("caculatelog", "=", (Object)caclulatelog).toArray();
        String selectFields = "entryentity.id id, entryentity.material.number materialNumber, entryentity.remarks remarks, entryentity.date_qty_tag date_qty_tag, entryentity.totalqty totalqty, entryentity.datatype datatype, entryentity.issplited issplited, entryentity.ispublished ispublished";
        return orm.queryDataSet(this.algoKey, "mrp_pur_fctdata", selectFields, filters);
    }
}

