/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.forecast;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.business.helper.PlanOperatorGroupHelper;
import kd.mmc.mrp.common.operate.PurForecastOperate;
import kd.mmc.mrp.common.result.PurForecastOperationPram;
import kd.mmc.mrp.common.result.PurForecastOperationResult;
import kd.mmc.mrp.common.util.BaseDataUtils;
import kd.mmc.mrp.common.util.ForecastUtils;
import kd.mmc.mrp.formplugin.forecast.AbstractForecastPlugin;
import kd.mmc.mrp.formplugin.forecast.PurForecastImportPlugin;
import kd.mmc.mrp.mservice.api.fcast.PurForecastReleaseService;
import kd.mmc.mrp.mservice.fcast.IPurForecastExtField;
import kd.mmc.mrp.mservice.fcast.PurForecastExtFieldImpl;

public class PurForecastPlugin
extends AbstractForecastPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(PurForecastPlugin.class);
    private static final String FORM_ENTRY = "mrp_pur_fctentry";
    private final String algoKey = ((Object)((Object)this)).getClass().getSimpleName();

    @Override
    protected void setFormId(FormShowParameter formShowParameter) {
        formShowParameter.setFormId(FORM_ENTRY);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("release".equals(operateKey) || "cancel".equals(operateKey) || "import".equals(operateKey)) {
            String operateName = formOperate.getOperateName().getLocaleValue();
            String caculatelog = (String)this.getModel().getValue("caculatelog");
            if (!ForecastUtils.isLastRunLog((String)caculatelog)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u4e3a\u6700\u65b0\u7248\uff0c\u624d\u5141\u8bb8%s\u3002", (String)"PurForecastPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), operateName));
                args.setCancel(true);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filter = queryParam.getFilter();
        if (StringUtils.isBlank((CharSequence)filter.getString("caculatelog"))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8fd0\u7b97\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PurForecastPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected void query() {
        QFilter[] filters = this.getQFilter();
        try (DataSet dataSet = ORM.create().queryDataSet(this.algoKey, "mrp_pur_fctdata", "dateinfo_tag", filters, null, 1);){
            if (dataSet.hasNext()) {
                Row next = dataSet.next();
                HashMap params = Maps.newHashMapWithExpectedSize((int)4);
                ArrayList filterStrList = Lists.newArrayListWithExpectedSize((int)filters.length);
                for (QFilter filter : filters) {
                    filterStrList.add(filter.toSerializedString());
                }
                params.put("dateInfo", next.getString("dateinfo_tag"));
                params.put("filterData", filterStrList);
                params.put("fctEntityId", "mrp_pur_fctdata");
                this.showEntryForm(params);
            } else {
                this.initEntryForm();
            }
        }
        IDataModel model = this.getModel();
        IReportView fv = this.getView();
        String caculatelog = (String)model.getValue("caculatelog");
        String preFix = "btn_";
        if (!ForecastUtils.isLastRunLog((String)caculatelog)) {
            fv.setEnable(Boolean.FALSE, new String[]{preFix + "import", preFix + "cancel", preFix + "release"});
        } else {
            fv.setEnable(Boolean.TRUE, new String[]{preFix + "import", preFix + "cancel", preFix + "release"});
        }
    }

    @Override
    protected QFilter[] getQFilterByCache() {
        IFormView entryView = this.getEntryView();
        List filterStrList = (List)entryView.getFormShowParameter().getCustomParam("filterData");
        if (filterStrList == null) {
            return this.getQFilter();
        }
        return (QFilter[])filterStrList.stream().map(QFilter::fromSerializedString).toArray(QFilter[]::new);
    }

    @Override
    protected QFilter[] getQFilter() {
        String isSplited;
        String isPublished;
        DynamicObjectCollection operator;
        DynamicObjectCollection material;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        IDataModel model = this.getModel();
        String caculatelog = (String)model.getValue("caculatelog");
        filters.add(new QFilter("caculatelog", "=", (Object)caculatelog));
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            filters.add(new QFilter("entryentity.org", "=", org.getPkValue()));
        }
        if ((material = (DynamicObjectCollection)model.getValue("material")) != null && !material.isEmpty()) {
            filters.add(new QFilter("entryentity.material", "in", this.getPkValues(material)));
        }
        if ((operator = (DynamicObjectCollection)model.getValue("operator")) != null && !operator.isEmpty()) {
            filters.add(new QFilter("entryentity.operator", "in", this.getPkValues(operator)));
        }
        if (StringUtils.isNotBlank((CharSequence)(isPublished = (String)model.getValue("ispublished")))) {
            filters.add(new QFilter("entryentity.ispublished", "=", (Object)isPublished));
        }
        if (StringUtils.isNotBlank((CharSequence)(isSplited = (String)model.getValue("issplited")))) {
            filters.add(new QFilter("entryentity.issplited", "=", (Object)isSplited));
        }
        return filters.toArray(new QFilter[0]);
    }

    private Set<Object> getPkValues(DynamicObjectCollection collection) {
        HashSet<Object> ids = new HashSet<Object>(collection.size());
        for (DynamicObject object : collection) {
            ids.add(object.get("fbasedataid_id"));
        }
        return ids;
    }

    @Override
    protected Tuple<List<String>, List<Map<String, Object>>> getData(List<Row> rows, RowMeta rowMeta) {
        Long plangramId;
        List dateCols;
        ORM orm = ORM.create();
        try (DataSet dataSet = orm.queryDataSet(this.algoKey, "mrp_pur_fctdata", "dateinfo_tag, plangram", this.getQFilterByCache(), null, 1);){
            if (dataSet.hasNext()) {
                Row row = dataSet.next();
                dateCols = (List)SerializationUtils.fromJsonString((String)row.getString(0), List.class);
                plangramId = row.getLong(1);
            } else {
                dateCols = Collections.emptyList();
                plangramId = 0L;
            }
        }
        String planNumber = BaseDataUtils.getPlanId2Number((Long)plangramId);
        Map unitId2Name = BaseDataUtils.getUnitId2Name(null);
        ArrayList values = Lists.newArrayListWithExpectedSize((int)rows.size());
        int mapSize = rowMeta.getFieldCount();
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)(rows.size() >> 1));
        HashSet personIds = new HashSet(3);
        HashSet orgIds = new HashSet(2);
        HashSet supplierIds = new HashSet(2);
        for (Row row : rows) {
            HashMap value = Maps.newHashMapWithExpectedSize((int)mapSize);
            rowMeta.toMap(row, (Map)value);
            value.put("plangram", planNumber);
            materialIds.add(value.get("material"));
            value.put("unit", unitId2Name.getOrDefault(value.get("unit"), ""));
            personIds.add(value.get("publisher"));
            personIds.add(value.get("operator"));
            personIds.add(value.get("lastmodifier"));
            orgIds.add(value.get("org"));
            orgIds.add(value.get("purorg"));
            supplierIds.add(value.get("supplier"));
            values.add(value);
        }
        rows.clear();
        Map materialId2NumberAndName = BaseDataUtils.getMaterialId2NumberAndName((Set)materialIds);
        Map personId2Name = BaseDataUtils.getPersonId2Name(personIds);
        Map orgId2Name = BaseDataUtils.getOrgId2Name(orgIds);
        Map supplierId2Name = BaseDataUtils.getSupplierId2Name(supplierIds);
        for (Map value : values) {
            Object materialId = value.get("material");
            Tuple tuple = (Tuple)materialId2NumberAndName.get(materialId);
            value.put("material", tuple.item1);
            value.put("materialname", tuple.item2);
            value.put("publisher", personId2Name.getOrDefault(value.get("publisher"), ""));
            value.put("operator", personId2Name.getOrDefault(value.get("operator"), ""));
            value.put("lastmodifier", personId2Name.getOrDefault(value.get("lastmodifier"), ""));
            value.put("org", orgId2Name.getOrDefault(value.get("org"), ""));
            value.put("purorg", orgId2Name.getOrDefault(value.get("purorg"), ""));
            value.put("supplier", supplierId2Name.getOrDefault(value.get("supplier"), ""));
        }
        return Tuple.create((Object)dateCols, (Object)values);
    }

    @Override
    protected void operate(String opKey, IFormView entryView) {
        IDataModel entryModel = entryView.getModel();
        EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        Map<Object, String> billMap = this.getSelectedEntryData(entryModel, selectRows);
        this.executeOperate(opKey, billMap, new ArrayList<Object>(billMap.keySet()), entryView);
    }

    private void updateEntryViewData(List<Object> successIds, IFormView entryView, PurForecastOperationPram pram, boolean isRelease) {
        EntryGrid entryGrid = (EntryGrid)entryView.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        IDataModel entryModel = entryView.getModel();
        int size = entryModel.getEntryRowCount("entryentity");
        entryModel.beginInit();
        for (int index = 0; index < size; ++index) {
            Object entryId = entryModel.getValue("entryid", index);
            if (!successIds.contains(entryId)) continue;
            entryModel.setValue("lastmodifier_id", (Object)pram.getModifier(), index);
            entryModel.setValue("lastdatetime", (Object)pram.getModifyDateTime(), index);
            entryModel.setValue("publisher_id", (Object)pram.getPublisher(), index);
            entryModel.setValue("publish_time", (Object)pram.getPublishDateTime(), index);
            entryModel.setValue("ispublished", (Object)(isRelease ? "1" : "0"), index);
        }
        entryModel.endInit();
        entryView.updateView("entryentity");
        entryGrid.selectRows(selectRows, selectRows[0]);
    }

    @Override
    protected String getSelectFields() {
        PluginProxy<IPurForecastExtField> pluginProxy = this.getPluginProxy();
        List list = pluginProxy.callReplaceIfPresent(IPurForecastExtField::getSelectFields);
        return (String)list.get(0);
    }

    @Override
    protected void batchOperate(String opKey, IFormView entryView) {
        IPageCache pageCache = entryView.getPageCache();
        String rowCountStr = pageCache.get("rowcount");
        int size = Integer.parseInt(rowCountStr);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)size);
        HashMap billnoMap = Maps.newHashMapWithExpectedSize((int)size);
        try (DataSet dataSet = ORM.create().queryDataSet(this.algoKey, "mrp_pur_fctdata", "entryentity.id, entryentity.material.number", this.getQFilterByCache());){
            for (Row row : dataSet) {
                Object id = row.get(0);
                ids.add(id);
                billnoMap.put(id, row.getString(1));
            }
        }
        this.executeOperate(opKey, billnoMap, ids, entryView);
    }

    private void executeOperate(String opKey, Map<Object, String> billnoMap, List<Object> ids, IFormView entryView) {
        boolean isRelease = "release".equals(opKey);
        PurForecastOperationPram pram = PurForecastOperationPram.initPram((String)opKey);
        String operateName = StringUtils.equals((CharSequence)opKey, (CharSequence)"release") ? ResManager.loadKDString((String)"\u53d1\u5e03", (String)"PurForecastPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u53d1\u5e03", (String)"PurForecastPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
        PurForecastOperationResult result = PurForecastOperate.execute((String)opKey, billnoMap, ids, (PurForecastOperationPram)pram);
        OperationResult operationResult = result.getOperationResult();
        try {
            this.transferPurService(opKey, operationResult.getSuccessPkIds());
        }
        catch (Exception e) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u91c7\u8d2d\u7aef\u670d\u52a1\u5f02\u5e38\u3002", (String)"PurForecastPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), e.getMessage(), MessageTypes.Default);
            return;
        }
        if (operationResult.getAllErrorInfo().isEmpty()) {
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"%s\u6210\u529f\u3002", (String)"PurForecastPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), operateName));
        } else {
            this.getView().showOperationResult(operationResult, operateName);
        }
        entryView.getPageCache().put("isDirty", "1");
        this.updateEntryViewData(operationResult.getSuccessPkIds(), entryView, pram, isRelease);
        SaveServiceHelper.update((DynamicObject[])result.getData().toArray(new DynamicObject[0]));
        this.getView().sendFormAction(entryView);
    }

    private void transferPurService(String opKey, List<Object> successIds) {
        boolean isRelease = "release".equals(opKey);
        if (isRelease) {
            PluginProxy<IPurForecastExtField> pluginProxy = this.getPluginProxy();
            List purForecastReleaseServices = pluginProxy.callReplaceIfPresent(IPurForecastExtField::getPurForecastReleaseService);
            ((PurForecastReleaseService)purForecastReleaseServices.get(0)).releaseForecast2pm(successIds);
        }
    }

    private PluginProxy<IPurForecastExtField> getPluginProxy() {
        PurForecastExtFieldImpl iPurForecastExtField = new PurForecastExtFieldImpl();
        return PluginProxy.create((Object)iPurForecastExtField, IPurForecastExtField.class, (String)"MRP_PUR_FORECAST_EXT_FIELD", null);
    }

    @Override
    protected Set<String> getNotNeedColName() {
        HashSet<String> noCols = new HashSet<String>(2);
        noCols.add("count");
        noCols.add("auxpty");
        noCols.add("operator");
        noCols.add("issplited");
        noCols.add("split_time");
        return noCols;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl("caculatelogid");
        basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit operator = (BasedataEdit)this.getControl("operator");
        operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Object[] result = ForecastUtils.getLastRunNumber();
        this.getModel().setValue("caculatelog", result[0]);
        this.getModel().setValue("caculatelogid", result[1]);
    }

    @Override
    protected void showDateSetupForm() {
        this.showForm(ForecastUtils.getDateSetId(), "mrp_dateset", null, null);
    }

    @Override
    protected String getImportPluginName() {
        return PurForecastImportPlugin.class.getName();
    }

    private Map<Object, String> getSelectedEntryData(IDataModel entryModel, int[] selectRows) {
        HashSet materialIds = Sets.newHashSetWithExpectedSize((int)selectRows.length);
        for (int selectRow : selectRows) {
            materialIds.add((Long)entryModel.getValue("material_id", selectRow));
        }
        HashMap billnoMap = Maps.newHashMapWithExpectedSize((int)selectRows.length);
        QFilter[] filters = new QFilter[]{new QFilter("caculatelog", "=", this.getModel().getValue("caculatelog")), new QFilter("entryentity.material", "in", (Object)materialIds)};
        try (DataSet dataSet = ORM.create().queryDataSet(this.algoKey, "mrp_pur_fctdata", "entryentity.id, entryentity.material.number", filters);){
            for (Row row : dataSet) {
                Object id = row.get(0);
                billnoMap.put(id, row.getString(1));
            }
        }
        return billnoMap;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        BasedataEdit base = (BasedataEdit)beforeF7SelectEvent.getSource();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        ListFilterParameter filterParameter = formShowParameter.getListFilterParameter();
        if ("caculatelogid".equalsIgnoreCase(base.getKey())) {
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("runtype", "=", (Object)"A"));
            filters.add(new QFilter("calculatestatus", "=", (Object)"A"));
            filters.add(new QFilter("clearstatus", "!=", (Object)Character.valueOf('B')));
            filters.add(new QFilter("operatmodekey", "!=", (Object)"mrp_simulation"));
            filterParameter.setQFilters(filters);
            formShowParameter.setShowUsed(false);
            formShowParameter.setShowApproved(false);
        } else if ("operator".equalsIgnoreCase(base.getKey())) {
            Set ids = PlanOperatorGroupHelper.getOperatorUserByGroup();
            QFilter qFilter = new QFilter("id", "in", (Object)ids);
            filterParameter.setFilter(qFilter);
        }
    }
}

