/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.forecast.excel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.mmc.mrp.formplugin.forecast.excel.FctSheetHandler;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelEventParser {
    private String filePath;
    private FctSheetHandler.SheetContentsHandler handler;
    private InputStream in;

    public ExcelEventParser(String filePath) {
        this.filePath = filePath;
    }

    public ExcelEventParser(InputStream in) {
        this.in = in;
    }

    public ExcelEventParser setHandler(FctSheetHandler.SheetContentsHandler handler) {
        this.handler = handler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws Exception {
        OPCPackage pkg = null;
        InputStream sheetInputStream = null;
        try {
            pkg = this.filePath == null || this.filePath.trim().isEmpty() ? OPCPackage.open((InputStream)this.in) : OPCPackage.open((String)this.filePath, (PackageAccess)PackageAccess.READ);
            XSSFReader xssfReader = new XSSFReader(pkg);
            StylesTable styles = xssfReader.getStylesTable();
            ReadOnlySharedStringsTable strings = new ReadOnlySharedStringsTable(pkg);
            sheetInputStream = (InputStream)xssfReader.getSheetsData().next();
            this.processSheet(styles, strings, sheetInputStream);
        }
        finally {
            if (sheetInputStream != null) {
                sheetInputStream.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (pkg != null) {
                pkg.close();
            }
        }
    }

    private void processSheet(StylesTable styles, ReadOnlySharedStringsTable strings, InputStream sheetInputStream) throws SAXException, IOException {
        String className = "com.sun.org.apache.xerces.internal.parsers.SAXParser";
        XMLReader sheetParser = XMLReaderFactory.createXMLReader(className);
        sheetParser.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        sheetParser.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        if (this.handler != null) {
            sheetParser.setContentHandler(new FctSheetHandler(styles, strings, this.handler, false));
        } else {
            sheetParser.setContentHandler(new FctSheetHandler(styles, strings, new SimpleSheetContentsHandler(), false));
        }
        sheetParser.parse(new InputSource(sheetInputStream));
    }

    public static class SimpleSheetContentsHandler
    implements FctSheetHandler.SheetContentsHandler {
        protected List<String> row = new ArrayList<String>();

        @Override
        public void startRow(int rowNum, int maxColNumber) {
            this.row.clear();
        }

        @Override
        public void finishRow(int rowNum) {
        }

        @Override
        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            this.row.add(formattedValue);
        }

        @Override
        public void headerFooter(String text, boolean isHeader, String tagName) {
        }
    }
}

