/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.forecast.excel;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mrp.formplugin.forecast.excel.FctSheetHandler;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFComment;

public class FctSheetContentHandler
implements FctSheetHandler.SheetContentsHandler {
    private int preColNum = -1;
    protected List<String> colNames;
    protected boolean isError = false;
    protected int progress = 0;
    protected int remarksIndex = -1;
    protected int qtyStartIndex = -1;
    protected List<String> rows;
    protected int maxColNumber;
    protected String lastCalcLog;

    public FctSheetContentHandler(int expectedSize, String lastCalcLog) {
        this.rows = Lists.newArrayListWithExpectedSize((int)expectedSize);
        this.lastCalcLog = lastCalcLog;
    }

    @Override
    public void startRow(int i, int maxColNumber) {
        this.preColNum = -1;
        this.maxColNumber = maxColNumber;
        this.rows.clear();
    }

    @Override
    public void finishRow(int rowNumber) {
        int size = this.rows.size();
        if (size <= 0) {
            return;
        }
        if (size < this.maxColNumber) {
            for (int i = 0; i < this.maxColNumber - size; ++i) {
                this.rows.add("");
            }
        }
        this.endRow(rowNumber);
        this.afterEndRow(rowNumber);
    }

    protected void endRow(int i) {
    }

    protected void afterEndRow(int i) {
    }

    @Override
    public void cell(String cellReference, String formattedValue, XSSFComment xssfComment) {
        short currColNum = new CellReference(cellReference).getCol();
        int missColNum = currColNum - this.preColNum - 1;
        for (int i = 0; i < missColNum; ++i) {
            this.rows.add("");
        }
        this.preColNum = currColNum;
        this.rows.add(formattedValue);
    }

    @Override
    public void headerFooter(String s, boolean b, String s1) {
    }

    protected BigDecimal convertNumberValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return BigDecimal.ZERO;
        }
        BigDecimal qty = new BigDecimal(value);
        return qty.compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qty;
    }
}

