/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mrp.common.util.ControlUtil;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanScopeHelper;

public class CollaboPlanOrderEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String MPDM_MATERIAL_PLAN = "mpdm_materialplan";
    private static final String INWAREHOUSECONFIRMCALLBACK = "inwareHouseconfirmCallBack";
    private static final Log log = LogFactory.getLog(CollaboPlanOrderEdit.class);
    private static final String CACHE_ENABLE_PLAN_SCOPE = "cacheEnablePlanScope";
    private static final String BILL_STATUS_CLOSE = "D";
    private static final String BILL_STATUS_INVALID = "E";
    private static final String BILL_STATUS_EXPIRE = "F";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        this.setDefPlanscope(org);
    }

    private void setDefPlanscope(DynamicObject org) {
        boolean enablePlanScope = this.isEnablePlanScope();
        if (org == null || !enablePlanScope) {
            return;
        }
        Long orgId = org.getLong("id");
        Long planScopeId = PlanScopeHelper.getPlanScope((Long)orgId);
        this.getModel().setValue("planscope", (Object)planScopeId);
    }

    public void registerListener(EventObject e) {
        BasedataEdit supplyLocation;
        BasedataEdit supplyWareHouse;
        BasedataEdit inwarelocation;
        super.registerListener(e);
        if (this.getControl("materiel") != null) {
            BasedataEdit materiel = (BasedataEdit)this.getControl("materiel");
            materiel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        BasedataEdit configuredcode = (BasedataEdit)this.getControl("configuredcode");
        configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit materialplanid = (BasedataEdit)this.getControl("materialplanid");
        materialplanid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit planscope = (BasedataEdit)this.getControl("planscope");
        planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit inwarehouse = (BasedataEdit)this.getControl("inwarehouse");
        if (inwarehouse != null) {
            inwarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inwarelocation = (BasedataEdit)this.getControl("inwarelocation")) != null) {
            inwarelocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplyWareHouse = (BasedataEdit)this.getControl("supplywarehouse")) != null) {
            supplyWareHouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplyLocation = (BasedataEdit)this.getControl("supplylocation")) != null) {
            supplyLocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setTransferQtyVisible();
        this.setLockAndVisible();
    }

    private void setTransferQtyVisible() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        HashSet<String> showFieldStatus = new HashSet<String>(4);
        showFieldStatus.add("C");
        showFieldStatus.add(BILL_STATUS_CLOSE);
        showFieldStatus.add(BILL_STATUS_INVALID);
        boolean showField = showFieldStatus.contains(billStatus);
        this.getView().setVisible(Boolean.valueOf(showField), new String[]{"transferqty", "residualtransferqty"});
    }

    private void setLockAndVisible() {
        String billStatus = (String)this.getModel().getValue("billstatus");
        boolean isInvalidOrClose = BILL_STATUS_INVALID.equals(billStatus) || BILL_STATUS_CLOSE.equals(billStatus) || BILL_STATUS_EXPIRE.equals(billStatus);
        this.getView().setEnable(Boolean.valueOf(!isInvalidOrClose), new String[]{"contentpanelflex"});
        this.getView().setVisible(Boolean.valueOf(!isInvalidOrClose), new String[]{"bar_del", "bar_save", "bar_modify", "bar_submit", "bar_audit", "bar_submitandnew", "bar_invalid", "baritemap"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        if (key.equals("materiel")) {
            this.beforeMaterialSelect(e, qfilters);
        } else if (key.equals("configuredcode")) {
            this.beforeConfiguredcodeSelect(e, qfilters);
        } else if (!key.equals("materialplanid")) {
            if (key.equals("planscope")) {
                this.beforePlanScopeSelect(e, qfilters);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"inwarehouse")) {
                this.beforeInwareHouseSelect(e, qfilters);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"inwarelocation")) {
                this.beforeInwareLocationSelect(e, qfilters);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"supplywarehouse")) {
                this.beforeSupplyWarehouseSelect(e, qfilters);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"supplylocation")) {
                this.beforeSupplyLocationSelect(e, qfilters);
            }
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    private void beforeSupplyLocationSelect(BeforeF7SelectEvent evt, List<QFilter> filters) {
        DynamicObject supplyWarehouse = (DynamicObject)this.getModel().getValue("supplywarehouse");
        if (supplyWarehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u8d27\u4ed3\u5e93\u3002", (String)"CollaboPlanOrderEdit_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter warehouseFilter = new QFilter("id", "=", (Object)supplyWarehouse.getLong("id"));
        DynamicObjectCollection warehouseList = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.*,entryentity.location.*", (QFilter[])new QFilter[]{warehouseFilter});
        ArrayList<Long> locationIdList = new ArrayList<Long>();
        for (DynamicObject warehouse : warehouseList) {
            if (warehouse.get("entryentity.location.id") == null) continue;
            locationIdList.add(warehouse.getLong("entryentity.location.id"));
        }
        QFilter locationFilter = new QFilter("id", "in", locationIdList);
        filters.add(locationFilter);
    }

    private void beforeSupplyWarehouseSelect(BeforeF7SelectEvent evt, List<QFilter> filters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CollaboPlanOrderEdit_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("supplyorg");
        if (supplyOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"CollaboPlanOrderEdit_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject supplyOrgUnit = (DynamicObject)this.getModel().getValue("supplyorgunitid");
        long supplyOrgUnitId = supplyOrgUnit == null ? 0L : supplyOrgUnit.getLong("id");
        List supplyWarehouseIdList = PlanScopeHelper.getInwareHouses((Long)supplyOrgUnitId);
        ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
        lsp.getListFilterParameter().getQFilters().clear();
        lsp.setUseOrgId(supplyOrgUnitId);
        QFilter qFilter = new QFilter("id", "in", (Object)supplyWarehouseIdList);
        filters.add(qFilter);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)supplyOrgUnitId);
        filters.add(baseDataFilter);
    }

    private void beforeInwareHouseSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"CollaboPlanOrderEdit_14", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = Long.valueOf(org.getPkValue().toString());
        List inwareHouses = PlanScopeHelper.getInwareHouses((Long)orgId);
        ListShowParameter lsp = (ListShowParameter)evt.getFormShowParameter();
        lsp.getListFilterParameter().getQFilters().clear();
        lsp.setUseOrgId(orgId.longValue());
        QFilter qFilter = new QFilter("id", "in", (Object)inwareHouses);
        qfilters.add(qFilter);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)orgId);
        qfilters.add(baseDataFilter);
    }

    private void beforeInwareLocationSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject inwareHouse = (DynamicObject)this.getModel().getValue("inwarehouse");
        if (inwareHouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\u3002", (String)"CollaboPlanOrderEdit_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter stockfilter = new QFilter("id", "=", (Object)inwareHouse.getLong("id"));
        DynamicObjectCollection stocks = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.*,entryentity.location.*", (QFilter[])new QFilter[]{stockfilter});
        ArrayList<Long> idlists = new ArrayList<Long>();
        for (int i = 0; i < stocks.size(); ++i) {
            DynamicObject object = (DynamicObject)stocks.get(i);
            if (object.get("entryentity.location.id") == null) continue;
            idlists.add((Long)object.get("entryentity.location.id"));
        }
        QFilter indexfilter = new QFilter("id", "in", idlists);
        qfilters.add(indexfilter);
    }

    private void beforePlanScopeSelect(BeforeF7SelectEvent e, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"CollaboPlanOrderEdit_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(org.getLong("id"));
        if (material != null) {
            QFilter qFilterType = new QFilter("type", "=", (Object)"A");
            List planScopesByMaterial = PlanScopeHelper.getPlanScopes(orgIds, (Long)material.getLong("id"));
            qfilters.add(qFilterType.or("id", "in", (Object)planScopesByMaterial));
        }
        List defPlanScopeIds = PlanScopeHelper.getPlanScopes(orgIds, (QFilter)null);
        QFilter qFilter = new QFilter("id", "in", (Object)defPlanScopeIds);
        qfilters.add(qFilter);
    }

    private void beforeConfiguredcodeSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u7f16\u7801", (String)"CollaboPlanOrderEdit_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long materialId = material.getLong("id");
        qfilters.add(new QFilter("material.id", "=", (Object)materialId));
    }

    private void beforeMaterialSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"CollaboPlanOrderEdit_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("supplyorg");
        if (supplyOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"CollaboPlanOrderEdit_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private DynamicObject getMaterialPlan(Long orgId, Long materialId) {
        return PlanOrderHelper.getMaterialInfo((Long)materialId, (Long)orgId, (String)MPDM_MATERIAL_PLAN, (String)"masterid,id,createorg,plantags,materialattr,supplynetwork", (IPageCache)this.getPageCache(), null, (boolean)false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Save || e.getSource() instanceof Submit || e.getSource() instanceof Audit) {
            long supplyorgId;
            long orgId = this.getModel().getValue("org") == null ? 0L : ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            long l = supplyorgId = this.getModel().getValue("supplyorg") == null ? 0L : ((DynamicObject)this.getModel().getValue("supplyorg")).getLong("id");
            if (orgId != 0L && orgId == supplyorgId) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u4e0d\u5f97\u4e0e\u4f9b\u5e94\u7ec4\u7ec7\u76f8\u540c\u3002", (String)"CollaboPlanOrderEdit_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.setTransferQtyVisible();
        this.setLockAndVisible();
    }

    private void inwareHouseChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long orgId = org.getLong("id");
        Long planScopeId = PlanScopeHelper.getPlanScope((Long)orgId);
        DynamicObject nowPlanScope = (DynamicObject)this.getModel().getValue("planscope");
        boolean enablePlanScope = this.isEnablePlanScope();
        if (!(newObject instanceof DynamicObject)) {
            if (enablePlanScope) {
                this.getModel().setValue("planscope", (Object)planScopeId);
            }
            this.getModel().setValue("inwarorg", null);
            this.getModel().setValue("inwarelocation", null);
            return;
        }
        if (!enablePlanScope) {
            this.getModel().setValue("inwarorg", (Object)org);
            this.getModel().setValue("inwarelocation", null);
            return;
        }
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        DynamicObject inwareHouse = (DynamicObject)newObject;
        Long inwareHouseId = inwareHouse == null ? 0L : inwareHouse.getLong("id");
        Map inwareInfo = PlanScopeHelper.getInwareInfoByInwarehouse((Long)(inwareHouse == null ? 0L : inwareHouse.getLong("id")), (Long)orgId, (Boolean)true);
        if (inwareInfo == null) {
            Long inwareOrg = PlanScopeHelper.getInwareOrg((Long)orgId, (Long)inwareHouseId);
            this.getModel().beginInit();
            this.getModel().setValue("planscope", (Object)planScopeId);
            this.getModel().setValue("inwarorg", (Object)inwareOrg);
            this.getModel().setValue("inwarelocation", null);
            this.getModel().endInit();
            this.getView().updateView();
            return;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>(1);
        orgIds.add(org.getLong("id"));
        Long materialId = Long.valueOf(material.getPkValue().toString());
        List planScopeIds = PlanScopeHelper.getPlanScopes(orgIds, (Long)materialId);
        Long inwarOrg = (Long)inwareInfo.get("inwarorg");
        Long planScopeid = (Long)inwareInfo.get("planscope");
        Long nowPlanScopeId = 0L;
        if (nowPlanScope != null) {
            nowPlanScopeId = nowPlanScope.getLong("id");
        }
        if (!planScopeIds.contains(planScopeid)) {
            planScopeid = planScopeId;
        }
        if (nowPlanScopeId.equals(planScopeid)) {
            this.getModel().beginInit();
            this.getModel().setValue("planscope", (Object)planScopeid);
            this.getModel().setValue("inwarorg", (Object)inwarOrg);
            this.getModel().setValue("inwarelocation", null);
            this.getModel().endInit();
            this.getView().updateView();
            return;
        }
        DynamicObject planScope = BusinessDataServiceHelper.loadSingleFromCache((Object)planScopeid, (String)"msplan_planscope");
        this.getPageCache().put("inwarOrg", inwarOrg.toString());
        this.getPageCache().put("planScope", planScopeid.toString());
        this.getPageCache().put("inwareHouse", inwareHouse.getString("id"));
        this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5165\u5e93\u4ed3\u5e93[%1$s]\u5c5e\u4e8e[%2$s]\u8ba1\u5212\u8303\u56f4\uff0c\u5982\u4fee\u6539\u5165\u5e93\u4ed3\u5e93\uff0c\u8ba1\u5212\u8303\u56f4\u4e5f\u4f1a\u4fee\u6539\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fee\u6539\u5165\u5e93\u4ed3\u5e93\uff1f", (String)"CollaboPlanOrderEdit_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), inwareHouse.getLocaleString("name").getLocaleValue(), planScope.getLocaleString("name").getLocaleValue()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(INWAREHOUSECONFIRMCALLBACK, (IFormPlugin)this));
        ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"inwarehouse", (Object)oldObject);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        ChangeData[] changeDatas = e.getChangeSet();
        IDataEntityProperty dataEntityProperty = e.getProperty();
        String propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        for (ChangeData changeData : changeDatas) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private void propertyChanged(ChangeData changeData, String propertyName) {
        Object newObject = changeData.getNewValue();
        Object oldObject = changeData.getOldValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if ("materiel".equals(propertyName)) {
            this.handleMaterialChanged(oldObject, propertyValueCDDE);
        } else if ("demanddate".equals(propertyName)) {
            SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
            if (newObject == null) {
                return;
            }
            Date date = (Date)newObject;
            String dateStr = sim.format(date);
            Date workDate = this.getRecentWorkDate(date);
            try {
                date = sim.parse(dateStr);
                if (workDate != null) {
                    String workStr = sim.format(workDate);
                    workDate = sim.parse(workStr);
                }
            }
            catch (ParseException e) {
                log.info(e.getMessage());
            }
            if (workDate == null) {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"demanddate", (Object)(oldObject == null ? newObject : oldObject));
            } else {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"demanddate", (Object)workDate);
                if (workDate.compareTo(date) != 0) {
                    this.showDemandDate();
                }
            }
        } else if (!"materialplanid".equals(propertyName)) {
            if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"inwarehouse")) {
                this.inwareHouseChange(oldObject, newObject, propertyValueCDDE);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"planscope")) {
                this.handlePlanScopeChanged();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"supplyorg")) {
                this.handleSupplyOrgChanged();
            } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"supplywarehouse")) {
                this.handleSupplyWareHouseChanged();
            }
        }
    }

    private void handleSupplyWareHouseChanged() {
        this.getModel().setValue("supplylocation", null);
    }

    private void handleSupplyOrgChanged() {
        if (this.isEnablePlanScope()) {
            this.setSupplyInfoByPlanScope();
        }
    }

    private void handlePlanScopeChanged() {
        this.setInWareInfoByPlanScope();
    }

    private void handleMaterialChanged(Object oldObject, DynamicObject dataEntity) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        if (material == null) {
            this.getModel().beginInit();
            this.getModel().setValue("inwarorg", null);
            this.getModel().setValue("inwarehouse", null);
            this.getModel().setValue("inwarelocation", null);
            this.getModel().endInit();
            this.getView().updateView();
            return;
        }
        long materialId = material.getLong("id");
        String materialName = material.getString("name");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        String orgName = org.getString("name");
        DynamicObject materialPlan = this.getMaterialPlan(orgId, materialId);
        if (materialPlan == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u9700\u6c42\u7ec4\u7ec7\u4e0b\u5bf9\u5e94\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"CollaboPlanOrderEdit_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"materiel", (Object)oldObject);
            this.getView().updateView();
            return;
        }
        String materialAttr = materialPlan.getString("materialattr");
        if (!MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%2$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u5185\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"CollaboPlanOrderEdit_12", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), orgName, materialName));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"materiel", (Object)oldObject);
            this.getView().updateView();
            return;
        }
        DynamicObject supplyNetwork = materialPlan.getDynamicObject("supplynetwork");
        if (supplyNetwork != null) {
            supplyNetwork = BusinessDataServiceHelper.loadSingleFromCache((Object)supplyNetwork.getPkValue(), (String)"mrp_definitionsupply");
            long defSupplyTypeId = supplyNetwork.getLong("defsupplytype_id");
            DynamicObjectCollection orgEntry = supplyNetwork.getDynamicObjectCollection("orgentry");
            for (DynamicObject row : orgEntry) {
                long supplyOrgTypeId = row.getLong("supplyorgtype_id");
                if (supplyOrgTypeId != defSupplyTypeId) continue;
                String supplyRule = row.getString("supplyrule");
                this.getModel().setValue("supplyrule", (Object)supplyRule);
                break;
            }
        }
        if (this.isEnablePlanScope()) {
            this.handleMaterialChangedIfEnablePlanScope(oldObject, dataEntity);
        } else {
            this.handleMaterialChangedIfDisablePlanScope();
        }
        long baseUnitId = material.getLong("baseunit_id");
        this.getModel().setValue("baseunit", (Object)baseUnitId);
        boolean isAffectPlan = PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, null);
        ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"auxproperty", (String)"", (boolean)isAffectPlan);
    }

    private void handleMaterialChangedIfEnablePlanScope(Object oldObject, DynamicObject dataEntity) {
        List planScopesByMaterial;
        String planScopeType;
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        long materialId = material.getLong("id");
        String materialName = material.getString("name");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        String orgName = org.getString("name");
        DynamicObject planScope = (DynamicObject)this.getModel().getValue("planscope");
        if (planScope != null && !"A".equals(planScopeType = planScope.getString("type")) && !(planScopesByMaterial = PlanScopeHelper.getPlanScopes(Collections.singletonList(orgId), (Long)materialId)).contains(planScope.getLong("id"))) {
            String planScopeName = planScope.getString("name");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%2$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u672a\u5b9a\u4e49\u8ba1\u5212\u8303\u56f4%3$s\u3002", (String)"CollaboPlanOrderEdit_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), orgName, materialName, planScopeName));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"materiel", (Object)oldObject);
            this.getView().updateView();
            return;
        }
        this.setInWareInfoByPlanScope();
        this.setSupplyInfoByPlanScope();
    }

    private void handleMaterialChangedIfDisablePlanScope() {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        long materialId = material.getLong("id");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org.getLong("id");
        DynamicObject materialMftByOrg = PlanOrderHelper.getMaterialMftInfo((Long)materialId, (Long)orgId, (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), (IPageCache)this.getPageCache());
        if (materialMftByOrg == null) {
            this.getModel().setValue("inwarorg", (Object)orgId);
            this.getModel().setValue("inwarehouse", null);
            this.getModel().setValue("inwarelocation", null);
        } else {
            DynamicObject inWarOrg = materialMftByOrg.getDynamicObject("inwarorg");
            long inWarOrgId = inWarOrg == null ? orgId : inWarOrg.getLong("id");
            DynamicObject inWareHouse = materialMftByOrg.getDynamicObject("inwarehouse");
            long inWareHouseId = inWareHouse == null ? 0L : inWareHouse.getLong("id");
            DynamicObject inWareLocation = materialMftByOrg.getDynamicObject("inwarelocation");
            long inWareLocationId = inWareLocation == null ? 0L : inWareLocation.getLong("id");
            this.getModel().setValue("inwarorg", (Object)inWarOrgId);
            this.getModel().setValue("inwarehouse", (Object)inWareHouseId);
            this.getModel().setValue("inwarelocation", (Object)inWareLocationId);
        }
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("supplyorg");
        long supplyOrgId = supplyOrg.getLong("id");
        DynamicObject materialMftBySupplyOrg = PlanOrderHelper.getMaterialMftInfo((Long)materialId, (Long)supplyOrgId, (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), (IPageCache)this.getPageCache());
        if (materialMftBySupplyOrg == null) {
            this.getModel().setValue("supplyorgunitid", (Object)supplyOrgId);
            this.getModel().setValue("supplywarehouse", null);
            this.getModel().setValue("supplylocation", null);
        } else {
            DynamicObject supplyOrgUnit = materialMftBySupplyOrg.getDynamicObject("supplyorgunitid");
            long supplyOrgUnitId = supplyOrgUnit == null ? 0L : supplyOrgUnit.getLong("id");
            DynamicObject supplyWarehouse = materialMftBySupplyOrg.getDynamicObject("warehouse");
            long supplyWarehouseId = supplyWarehouse == null ? 0L : supplyWarehouse.getLong("id");
            DynamicObject supplyLocation = materialMftBySupplyOrg.getDynamicObject("location");
            long supplyLocationId = supplyLocation == null ? 0L : supplyLocation.getLong("id");
            this.getModel().setValue("supplyorgunitid", (Object)supplyOrgUnitId);
            this.getModel().setValue("supplywarehouse", (Object)supplyWarehouseId);
            this.getModel().setValue("supplylocation", (Object)supplyLocationId);
        }
    }

    private String getMaterialMftSelectFields() {
        return "id,createorg,masterid,inwarorg,inwarehouse,inwarelocation,supplyorgunitid,warehouse,location,isstockallot,invinfosrc";
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (INWAREHOUSECONFIRMCALLBACK.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String inwarOrgStr = this.getPageCache().get("inwarOrg");
            String planScopeStr = this.getPageCache().get("planScope");
            String inwareHouseStr = this.getPageCache().get("inwareHouse");
            this.getModel().beginInit();
            this.getModel().setValue("inwarehouse", (Object)Long.valueOf(inwareHouseStr));
            this.getModel().setValue("inwarorg", (Object)Long.valueOf(inwarOrgStr));
            this.getModel().setValue("planscope", (Object)Long.valueOf(planScopeStr));
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    private void setSupplyInfoByPlanScope() {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("supplyorg");
        if (material == null || supplyOrg == null) {
            log.info("\u542f\u7528\u8ba1\u5212\u8ba2\u5355\uff0c\u8bbe\u7f6e\u4f9b\u8d27\u76f8\u5173\u5b57\u6bb5\uff1a\u7269\u6599\u6216\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u8bbe\u7f6e");
            return;
        }
        long materialId = material.getLong("id");
        long supplyOrgId = supplyOrg.getLong("id");
        DynamicObject materialMftInfo = PlanOrderHelper.getMaterialMftInfo((Long)materialId, (Long)supplyOrgId, (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), (IPageCache)this.getPageCache());
        long supplyOrgUnitId = supplyOrgId;
        long supplyWarehouseId = 0L;
        long supplyLocationId = 0L;
        if (materialMftInfo != null) {
            Map supplierInfo;
            DynamicObject supplyOrgUnit = materialMftInfo.getDynamicObject("supplyorgunitid");
            supplyOrgUnitId = supplyOrgUnit == null ? 0L : supplyOrgUnit.getLong("id");
            DynamicObject supplyWarehouse = materialMftInfo.getDynamicObject("warehouse");
            supplyWarehouseId = supplyWarehouse == null ? 0L : supplyWarehouse.getLong("id");
            DynamicObject supplyLocation = materialMftInfo.getDynamicObject("location");
            long l = supplyLocationId = supplyLocation == null ? 0L : supplyLocation.getLong("id");
            if (supplyWarehouseId != 0L && (supplierInfo = PlanScopeHelper.getSupplierInfo((Long)supplyWarehouseId, (Long)supplyOrgId, (Long)materialId)) != null && !supplierInfo.isEmpty()) {
                supplyOrgUnitId = (Long)supplierInfo.get("entrysupplyorgunitid");
                supplyWarehouseId = (Long)supplierInfo.get("entrywarehouse");
                supplyLocationId = (Long)supplierInfo.get("entrylocation");
            }
        }
        this.getModel().setValue("supplyorgunitid", (Object)supplyOrgUnitId);
        this.getModel().setValue("supplywarehouse", (Object)supplyWarehouseId);
        this.getModel().setValue("supplylocation", (Object)supplyLocationId);
    }

    private void setInWareInfoByPlanScope() {
        DynamicObject material = (DynamicObject)this.getModel().getValue("materiel");
        DynamicObject planScope = (DynamicObject)this.getModel().getValue("planscope");
        if (material == null || planScope == null) {
            log.info("\u542f\u7528\u8ba1\u5212\u8ba2\u5355\uff0c\u8bbe\u7f6e\u5165\u5e93\u76f8\u5173\u5b57\u6bb5\uff1a\u7269\u6599\u6216\u8ba1\u5212\u8303\u56f4\u4e3a\u7a7a\uff0c\u4e0d\u8bbe\u7f6e");
            return;
        }
        DynamicObject org = planScope.getDynamicObject("createorg");
        if (org == null) {
            log.info("\u542f\u7528\u8ba1\u5212\u8ba2\u5355\uff0c\u8bbe\u7f6e\u5165\u5e93\u76f8\u5173\u5b57\u6bb5\uff1a\u8ba1\u5212\u8303\u56f4\u7684\u4e1a\u52a1\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u4e0d\u8bbe\u7f6e");
            return;
        }
        long planScopeId = planScope.getLong("id");
        long orgId = org.getLong("id");
        long materialId = material.getLong("id");
        String type = planScope.getString("type");
        DynamicObject materialMftInfo = PlanOrderHelper.getMaterialMftInfo((Long)materialId, (Long)orgId, (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), (IPageCache)this.getPageCache());
        this.getModel().beginInit();
        if ("A".equals(type)) {
            if (materialMftInfo != null) {
                DynamicObject inWareOrg = materialMftInfo.getDynamicObject("inwarorg");
                this.getModel().setValue("inwarorg", (Object)(inWareOrg == null ? org : inWareOrg));
                this.getModel().setValue("inwarehouse", (Object)materialMftInfo.getDynamicObject("inwarehouse"));
                this.getModel().setValue("inwarelocation", (Object)materialMftInfo.getDynamicObject("inwarelocation"));
            } else {
                this.getModel().setValue("inwarorg", (Object)org);
                this.getModel().setValue("inwarehouse", null);
                this.getModel().setValue("inwarelocation", null);
            }
            this.getModel().endInit();
            this.getView().updateView();
        } else if ("B".equals(type)) {
            Map inWareInfo = PlanScopeHelper.getInwareInfo((Long)planScopeId, (Long)orgId, (Long)materialId);
            if (inWareInfo == null || (Long)inWareInfo.get("inwarehouse") == 0L) {
                inWareInfo = PlanScopeHelper.getInwareInfoByPlanscope((Long)planScopeId, (Long)orgId, (Boolean)true);
            }
            if (inWareInfo == null) {
                this.getModel().setValue("inwarorg", null);
                this.getModel().setValue("inwarehouse", null);
                this.getModel().setValue("inwarelocation", null);
            } else {
                Long inWareOrgId = (Long)inWareInfo.get("inwarorg");
                Long inWareHouseId = (Long)inWareInfo.get("inwarehouse");
                Long inWareLocationId = (Long)inWareInfo.get("inwarelocation");
                this.getModel().setValue("inwarorg", (Object)(inWareOrgId == 0L ? null : inWareOrgId));
                this.getModel().setValue("inwarehouse", (Object)(inWareHouseId == 0L ? null : inWareHouseId));
                this.getModel().setValue("inwarelocation", (Object)(inWareLocationId == 0L ? null : inWareLocationId));
            }
            this.getModel().endInit();
            this.getView().updateView();
        }
    }

    public void showDemandDate() {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u65e5\u671f\u4e3a\u975e\u5de5\u4f5c\u65e5\uff0c\u81ea\u52a8\u5411\u540e\u5207\u6362\u81f3\u5de5\u4f5c\u65e5\u3002", (String)"CollaboPlanOrderEdit_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), dept.getString("name")));
    }

    private Date getRecentWorkDate(Date date) {
        DynamicObject dept = (DynamicObject)this.getModel().getValue("org");
        if (dept == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"CollaboPlanOrderEdit_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return null;
        }
        Set calendarIds = PlanOrderHelper.getCalendarIds((Long)dept.getLong("id"));
        if (calendarIds == null || calendarIds.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u3002", (String)"CollaboPlanOrderEdit_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), dept.getString("name")));
            return null;
        }
        Date workDate = PlanOrderHelper.getRecentWorkDate((Date)date, (Long)dept.getLong("id"));
        if (workDate == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u65e5\u671f\u8d85\u51fa\u9700\u6c42\u7ec4\u7ec7\u201c%s\u201d\u8bbe\u7f6e\u7684\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u7684\u65e5\u671f\u8303\u56f4\u3002", (String)"CollaboPlanOrderEdit_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), dept.getString("name")));
        }
        return workDate;
    }

    private boolean isEnablePlanScope() {
        String enablePlanScopeStr = this.getPageCache().get(CACHE_ENABLE_PLAN_SCOPE);
        if (StringUtils.isBlank((CharSequence)enablePlanScopeStr)) {
            boolean enablePlanScope = PlanScopeHelper.isEnablePlanScope();
            this.getPageCache().put(CACHE_ENABLE_PLAN_SCOPE, String.valueOf(enablePlanScope));
            return enablePlanScope;
        }
        return Boolean.parseBoolean(enablePlanScopeStr);
    }
}

