/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.planexecute;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.EntityOperate;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;

public class PlanOrderListPlugin
extends AbstractListPlugin {
    private static final String KEY_INVALID = "invalid";
    private static final String CACHE_SELECT_ROW = "cacheSelectRow";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (!(source instanceof EntityOperate)) {
            return;
        }
        EntityOperate operate = (EntityOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (KEY_INVALID.equals(operateKey)) {
            this.cacheSelectRowBeforeInvalid(args);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (KEY_INVALID.equals(operateKey)) {
            this.selectRowAfterInvalid();
        }
    }

    private void cacheSelectRowBeforeInvalid(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        List selectRowIdList = listSelectedData.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        String selectRowStr = SerializationUtils.toJsonString(selectRowIdList);
        this.getPageCache().put(CACHE_SELECT_ROW, selectRowStr);
    }

    private void selectRowAfterInvalid() {
        String cacheSelectRowStr = this.getPageCache().get(CACHE_SELECT_ROW);
        if (StringUtils.isBlank((CharSequence)cacheSelectRowStr)) {
            return;
        }
        List cacheSelectRowIdList = SerializationUtils.fromJsonStringToList((String)cacheSelectRowStr, Long.class);
        if (cacheSelectRowIdList == null || cacheSelectRowIdList.isEmpty()) {
            return;
        }
        ListSelectedRowCollection selectedRows = new ListSelectedRowCollection();
        for (Long selectRowId : cacheSelectRowIdList) {
            selectedRows.add((Object)new ListSelectedRow((Object)selectRowId));
        }
        BillList billListAp = (BillList)this.getControl("billlistap");
        billListAp.putSelectedRows(selectedRows);
        billListAp.refresh();
    }
}

