/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.pls;

import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4Pls;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.PLSEnv;

public class ProdLineShcedulingPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(ProdLineShcedulingPlugin.class);
    private static final String MRP_PLS = "mrp_pls";
    private static final String SCHEDULING_ORG = "scheduling_org";
    private static final String SCHEDULING_SCHEME = "scheduling_scheme";
    private static final String START_CAL = "calculate";
    private static final String MRP_CACULATE_lOG = "mrp_caculate_log";
    private static final String MRP_PLS_lOG = "mrp_pls_log";
    private static final String MRP_PLS_SCHEME = "mrp_pls_scheme";
    private static final String MRP_MUTEX_GROUP_ID = "mmc.mrp";
    private static final String CACULATELOG_CACHE = "caculateLog_cache";
    private static final String CONFIRM_EXEC = "confirm_exec";
    private static final String ID = "id";
    private static final String PLANDATE = "plandate";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"mrp"), (String)MRP_PLS, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        if (!orgIds.isEmpty()) {
            long orgid = RequestContext.get().getOrgId();
            if (orgIds.contains(orgid)) {
                this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
            } else {
                this.getModel().setValue(SCHEDULING_ORG, orgIds.get(0));
            }
        } else if (result.hasAllOrgPerm()) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit schedulingScheme = (BasedataEdit)this.getView().getControl(SCHEDULING_SCHEME);
        schedulingScheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(SCHEDULING_ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if (SCHEDULING_SCHEME.equals(key)) {
            Object org = this.getModel().getValue(SCHEDULING_ORG);
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u6392\u7a0b\u7ec4\u7ec7\u3002", (String)"ProdLineShcedulingPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            QFilter orgFilter = new QFilter("createorg.id", "=", (Object)orgId);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().getQFilters().add(orgFilter);
            param.getListFilterParameter().getQFilters().add(statusFilter);
            param.getListFilterParameter().getQFilters().add(enableFilter);
        } else if (SCHEDULING_ORG.equals(key)) {
            e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (SCHEDULING_ORG.equals(key)) {
            this.getModel().setValue(SCHEDULING_SCHEME, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (START_CAL.equals(key)) {
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49", (String)"ProdLineShcedulingPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
        String schedulingSchemeId = schedulingScheme.getPkValue().toString();
        Map lockMap = null;
        try (DataMutex mutex = MutexFactory.createDataMutex();){
            lockMap = mutex.getLockInfo(schedulingSchemeId, MRP_MUTEX_GROUP_ID, MRP_PLS_SCHEME);
        }
        catch (IOException ioException) {
            log.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5f02\u5e38");
        }
        if (lockMap != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6392\u7a0b\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"ProdLineShcedulingPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject caculateLog = this.createNewLog(null);
        String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_lOG, (DynamicObject)caculateLog, (String)((DynamicObject)this.getModel().getValue(SCHEDULING_ORG)).getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_EXEC, (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u672a\u627e\u5230\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u8fd0\u7b97\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u91c7\u7528\u7cfb\u7edf\u5185\u7801\u4f5c\u4e3a\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u3002", (String)"ProdLineShcedulingPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue(SCHEDULING_ORG)).getString("name"));
            this.getPageCache().put(CACULATELOG_CACHE, caculateLog.getPkValue().toString());
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBack);
        } else {
            this.execSchedulingScheme(number);
        }
    }

    private void execSchedulingScheme(String number) {
        DynamicObject caculateLog = this.createNewLog(number);
        new MRPRunner4Pls().run((IMRPEnvProvider)new PLSEnv(caculateLog));
        this.showLogForm((Long)caculateLog.getPkValue());
    }

    private DynamicObject createNewLog(String number) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_lOG);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        Long id = ORM.create().genLongId(MRP_CACULATE_lOG);
        caculateLog.set(ID, (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("plantype", (Object)"MRP/PLS");
        caculateLog.set("plangram", (Object)schedulingScheme.getLong(ID));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)MRP_PLS_SCHEME);
        caculateLog.set(PLANDATE, this.getModel().getValue(PLANDATE));
        caculateLog.set("creator", (Object)RequestContext.get().getUserId());
        caculateLog.set("operatmode", (Object)this.getView().getFormShowParameter().getFormName());
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)Boolean.FALSE);
        caculateLog.set("isbomcheck", (Object)Boolean.FALSE);
        caculateLog.set("isallowdateinpast", (Object)Boolean.FALSE);
        caculateLog.set("iscommon", (Object)Boolean.FALSE);
        caculateLog.set("iscustomize", (Object)Boolean.FALSE);
        caculateLog.set("isselection", (Object)Boolean.FALSE);
        caculateLog.set("isnotsetup", (Object)Boolean.FALSE);
        caculateLog.set("runtype", (Object)"P");
        if (number != null) {
            ORM.create().save(caculateLog);
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        return caculateLog;
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (MessageBoxResult.Yes.equals((Object)e.getResult()) && CONFIRM_EXEC.equals(e.getCallBackId())) {
            DynamicObject caculateLog = this.createNewLog(this.getPageCache().get(CACULATELOG_CACHE));
            DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
            Map lockMap = null;
            try (DataMutex mutex = MutexFactory.createDataMutex();){
                lockMap = mutex.getLockInfo(schedulingScheme.getPkValue().toString(), MRP_MUTEX_GROUP_ID, MRP_PLS_SCHEME);
            }
            catch (IOException ioException) {
                log.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5f02\u5e38");
            }
            if (lockMap != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6392\u7a0b\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"ProdLineShcedulingPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return;
            }
            caculateLog.set("plangram", (Object)schedulingScheme.getLong(ID));
            caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
            caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
            caculateLog.set("plangramentity", (Object)MRP_PLS_SCHEME);
            caculateLog.set("creator", (Object)RequestContext.get().getUserId());
            caculateLog.set("iscommon", (Object)Boolean.FALSE);
            caculateLog.set("iscustomize", (Object)Boolean.FALSE);
            caculateLog.set("isselection", (Object)Boolean.FALSE);
            caculateLog.set("isnotsetup", (Object)Boolean.FALSE);
            new MRPRunner4Pls().run((IMRPEnvProvider)new PLSEnv(caculateLog));
            this.showLogForm(caculateLog.getLong(ID));
        }
    }

    private void showLogForm(Long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(MRP_PLS_lOG);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam(ID, (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

