/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.pls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FieldTip;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.formula.FormulaEngine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mrp.common.util.DataConversionUtil;

public class SchemeEditPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String algoKey = "SchemeEditPlugin";
    private static final Log log = LogFactory.getLog(SchemeEditPlugin.class);
    private static final String CONFIRMKEY_CHANGEORDERMODEL = "changeOrderModel";
    private static final String CONFIRMKEY_SUPPLYORGMODEL = "supplyOrgModel";
    private static final String CONFIRMDELETE_SUPPLYORGMODEL = "deletesupplyOrg";
    private static final String CONFIRM_SUBMIT = "submit";
    private static final String CACHEID = "cacheId";
    private static final String SUPPLYORGID = "supplyOrgId";
    private static final String SUPPLYORGIDROW = "supplyOrgIdRow";
    private static final String[] FIELDS_MATERIALCATEGORY = new String[]{"category", "materialgroup_id", "material_id", "createorg_1"};
    private static final String[] FIELDS_FIXEDCAPACITY = new String[14];
    private static final String[] FIELDS_CALCRESULT = new String[12];
    private static final String[] FIELDS_WORKSHIFT = new String[6];
    private static final int CYCLE_MINVALUE = 1;
    private static final int CYCLE_MAXVALUE = 365;
    private static final String SCOPE_TIP = SchemeEditPlugin.getRange() + "[" + 1 + "," + 365 + "]";

    private static String getRange() {
        return ResManager.loadKDString((String)"\u8d85\u51fa\u6570\u503c\u8303\u56f4", (String)"SchemeEditPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit materialEdit = (BasedataEdit)this.getControl("material");
        materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        materialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit materialGroupEdit = (BasedataEdit)this.getControl("materialgroup");
        materialGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        materialGroupEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit supplyOrgEdit = (BasedataEdit)this.getControl("supplyorg");
        supplyOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        supplyOrgEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        OperateOption option;
        Map variables;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ("newentry".equals(formOperate.getOperateKey())) {
            Object orderModel = this.getModel().getValue("ordermodel");
            if (orderModel == null) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u5355\u6a21\u578b\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"SchemeEditPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        } else if (CONFIRM_SUBMIT.equals(formOperate.getOperateKey()) && !(variables = (option = formOperate.getOption()).getVariables()).containsKey("submitConfirm")) {
            DynamicObjectCollection materialEntry = this.getModel().getEntryEntity("matcategoryentry");
            HashSet<String> noCalcWorkCenterSet = new HashSet<String>(materialEntry.size());
            HashMap<String, Tuple> workCenterMap = new HashMap<String, Tuple>(materialEntry.size());
            for (Object material : materialEntry) {
                String category = material.getString("category");
                String key = "A".equals(category) ? "material_id" : "materialgroup_id";
                String keyNumber = "A".equals(category) ? "material.number" : "materialgroup.number";
                Long baseDataId = material.getLong(key);
                DynamicObjectCollection subWorkCenterEntry = material.getDynamicObjectCollection("workcentersubentry");
                for (DynamicObject workCenter : subWorkCenterEntry) {
                    if (workCenter.getInt("priority") == 0) continue;
                    long workCenterId = workCenter.getLong("workcenter_id");
                    String noCalcWorkKey = workCenterId + category + baseDataId;
                    noCalcWorkCenterSet.add(noCalcWorkKey);
                    workCenterMap.put(noCalcWorkKey, new Tuple((Object)material.getString(keyNumber), (Object)workCenter.getString("workcenter.number")));
                }
            }
            DynamicObjectCollection workCenterEntry = this.getModel().getEntryEntity("workcenterentry");
            for (Object workcenter : workCenterEntry) {
                long workCenterId = workcenter.getLong("workcenter_number_id");
                DynamicObjectCollection calcResultEntry = workcenter.getDynamicObjectCollection("calcresultsubentry");
                for (DynamicObject calcResult : calcResultEntry) {
                    if (!calcResult.getBoolean("ispartincalc_1")) continue;
                    String category = calcResult.getString("category_2");
                    String key = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
                    long baseDataId = calcResult.getLong(key);
                    noCalcWorkCenterSet.remove(workCenterId + category + baseDataId);
                }
            }
            if (noCalcWorkCenterSet.size() > 0) {
                StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u4ee5\u4e0b\u7269\u6599\\\u7269\u6599\u63a7\u5236\u7ec4\u5728\u5de5\u4f5c\u4e2d\u5fc3\u4e0b\u65e0\u53c2\u4e0e\u8ba1\u7b97\u80fd\u529b\u9879\uff1a", (String)"SchemeEditPlugin_13", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                for (String noCalcWorkKey : noCalcWorkCenterSet) {
                    Tuple tuple = (Tuple)workCenterMap.get(noCalcWorkKey);
                    msg.append((String)tuple.item1).append(',').append((String)tuple.item2).append("\r\n");
                }
                msg.deleteCharAt(msg.length() - 1);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONFIRM_SUBMIT, (IFormPlugin)this);
                String confirmMsg = ResManager.loadKDString((String)msg.toString(), (String)"SchemeEditPlugin_23", (String)"SchemeEditPlugin_14", (Object[])new Object[0]);
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
                this.getView().getPageCache().put("operateKey", formOperate.getOperateKey());
                args.setCancel(true);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String name = event.getProperty().getName();
        List customQFilters = event.getCustomQFilters();
        HashSet<Object> selectedIds = new HashSet<Object>();
        if ("supplyorg".equals(name)) {
            int row = event.getRow();
            Long supplyOrgId = (Long)this.getModel().getValue("supplyorg_id", row);
            this.getPageCache().put(SUPPLYORGID, supplyOrgId.equals(0L) ? null : Long.toString(supplyOrgId));
            this.getPageCache().put(SUPPLYORGIDROW, Integer.toString(row));
            DynamicObjectCollection collection = this.getModel().getEntryEntity("orgentryentity");
            for (DynamicObject dynamicObject : collection) {
                selectedIds.add(dynamicObject.get("supplyorg_id"));
            }
        } else {
            DynamicObjectCollection collection = this.getModel().getEntryEntity("matcategoryentry");
            for (DynamicObject dynamicObject : collection) {
                selectedIds.add(dynamicObject.get(name + "_id"));
            }
        }
        customQFilters.add(new QFilter("id", "not in", selectedIds));
    }

    public void afterF7Select(AfterF7SelectEvent event) {
        BasedataEdit basedataEdit = (BasedataEdit)event.getSource();
        String fieldkey = basedataEdit.getKey();
        if ("supplyorg".equals(fieldkey)) {
            ListSelectedRowCollection listSelectedRowCollection = event.getListSelectedRowCollection();
            Object[] primaryKeyValues = listSelectedRowCollection.getPrimaryKeyValues();
            this.supplyOrgChanged(primaryKeyValues);
        } else {
            Tuple tuple;
            int currentRowIndex;
            ListSelectedRowCollection listSelectedRowCollection = event.getListSelectedRowCollection();
            if (listSelectedRowCollection.isEmpty()) {
                return;
            }
            IDataModel model = this.getModel();
            Map<String, Integer> workCenterId2Count = this.getWorkCenterId2Count();
            int selectedRowIndex = currentRowIndex = event.getCurrentRowIndex();
            HashMap id2IndexAndNumber = Maps.newHashMapWithExpectedSize((int)listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                this.deleteWorkCenterRelationEntryRows(currentRowIndex, workCenterId2Count);
                model.setValue("createorg_1", (Object)listSelectedRow.getMainOrgId(), currentRowIndex);
                id2IndexAndNumber.put(listSelectedRow.getPrimaryKeyValue(), new Tuple((Object)currentRowIndex, (Object)listSelectedRow.getNumber()));
                ++currentRowIndex;
            }
            boolean isMaterial = "material".equals(fieldkey);
            String filterKey = isMaterial ? "entryproduct.materielf7" : "entryproduct.materialgroup";
            QFilter filter1 = new QFilter(filterKey, "in", id2IndexAndNumber.keySet());
            QFilter filter2 = new QFilter("status", "=", (Object)"C");
            QFilter filter3 = new QFilter("enable", "=", (Object)"1");
            QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
            try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mpdm_workcentre", "id, " + filterKey, filters, null, -1, (Distinctable)WithDistinctable.get());){
                if (dataSet.hasNext()) {
                    List entryValues;
                    List subEntryValues;
                    Tuple entryDataTuple;
                    HashMap<Object, Tuple> id2EntryDataTuple = new HashMap<Object, Tuple>();
                    for (Row row : dataSet) {
                        Object materialOrGroupId = row.get(1);
                        entryDataTuple = id2EntryDataTuple.computeIfAbsent(materialOrGroupId, k -> new Tuple(new ArrayList(), new ArrayList()));
                        subEntryValues = (List)entryDataTuple.item1;
                        entryValues = (List)entryDataTuple.item2;
                        Object workCenterId = row.get(0);
                        String workCenterIdStr = String.valueOf(workCenterId);
                        int count = workCenterId2Count.computeIfAbsent(workCenterIdStr, k -> 0);
                        workCenterId2Count.put(workCenterIdStr, count + 1);
                        subEntryValues.add(workCenterId);
                        if (count != 0) continue;
                        entryValues.add(workCenterId);
                    }
                    model.setValue("mapping_tag", (Object)SerializationUtils.toJsonString(workCenterId2Count));
                    for (Map.Entry entry : id2EntryDataTuple.entrySet()) {
                        tuple = (Tuple)id2IndexAndNumber.remove(entry.getKey());
                        if (tuple == null) continue;
                        model.setEntryCurrentRowIndex("matcategoryentry", ((Integer)tuple.item1).intValue());
                        entryDataTuple = (Tuple)entry.getValue();
                        subEntryValues = (List)entryDataTuple.item1;
                        entryValues = (List)entryDataTuple.item2;
                        this.batchCreateEntryRow("workcentersubentry", "workcenter_id", subEntryValues);
                        this.fillWorkCenterEntry(entryValues);
                    }
                }
            }
            if (!id2IndexAndNumber.isEmpty()) {
                String key = isMaterial ? ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"SchemeEditPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7269\u6599\u63a7\u5236\u7ec4", (String)"SchemeEditPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
                StringBuilder sb = new StringBuilder(100);
                ArrayList deletedIndex = Lists.newArrayListWithExpectedSize((int)id2IndexAndNumber.size());
                for (Map.Entry entry : id2IndexAndNumber.entrySet()) {
                    tuple = (Tuple)entry.getValue();
                    deletedIndex.add(tuple.item1);
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s, \u6ca1\u6709\u5bf9\u5e94\u5de5\u4f5c\u4e2d\u5fc3", (String)"SchemeEditPlugin_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), key, tuple.item2);
                    sb.append(msg).append("\r\n");
                }
                if (listSelectedRowCollection.size() == deletedIndex.size()) {
                    Integer remove = (Integer)deletedIndex.remove(0);
                    model.setValue(basedataEdit.getKey(), null, remove.intValue());
                }
                if (!CollectionUtils.isEmpty((Collection)deletedIndex)) {
                    model.deleteEntryRows("matcategoryentry", deletedIndex.stream().mapToInt(Integer::intValue).toArray());
                }
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u5de5\u4f5c\u4e2d\u5fc3\u3002", (String)"SchemeEditPlugin_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
            }
            EntryGrid entryGrid = (EntryGrid)this.getControl("matcategoryentry");
            entryGrid.selectRows(selectedRowIndex);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if ("matcategoryentry".equals(name)) {
            int[] rowIndexs = e.getRowIndexs();
            Map<String, Integer> workCenterId2Count = this.getWorkCenterId2Count();
            for (int rowIndex : rowIndexs) {
                this.updateCountByChangeMaterialCategory(workCenterId2Count, rowIndex);
            }
            this.deleteWorkCenterEntryRows(workCenterId2Count);
        } else if ("orgentryentity".equals(name)) {
            DynamicObject orderModel = (DynamicObject)this.getModel().getValue("ordermodel");
            if (Objects.isNull(orderModel)) {
                return;
            }
            String deleteConfirm = this.getPageCache().get("deleteConfirm");
            if (StringUtils.isBlank((CharSequence)deleteConfirm)) {
                int[] rowIndexs = e.getRowIndexs();
                boolean allEmpty = true;
                for (int rowIndex : rowIndexs) {
                    Object value = this.getModel().getValue("supplyorg", rowIndex);
                    if (!Objects.nonNull(value)) continue;
                    allEmpty = false;
                }
                if (allEmpty) {
                    return;
                }
                int[] deleteRowIndexs = e.getRowIndexs();
                ArrayList<Integer> deleteRowIndexList = new ArrayList<Integer>(deleteRowIndexs.length);
                for (int deleteRowIndex : deleteRowIndexs) {
                    deleteRowIndexList.add(deleteRowIndex);
                }
                if (!this.queryResultIsChange(deleteRowIndexList)) {
                    return;
                }
                String confirmMsg = ResManager.loadKDString((String)"\u5220\u9664\u4f9b\u5e94\u7ec4\u7ec7\u5c06\u4f1a\u91cd\u7f6e\u5de5\u4f5c\u4e2d\u5fc3\u548c\u80fd\u529b\u9879\u6570\u636e, \u662f\u5426\u7ee7\u7eed\u5220\u9664?", (String)"SchemeEditPlugin_15", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONFIRMDELETE_SUPPLYORGMODEL, (IFormPlugin)this);
                this.getView().showConfirm(confirmMsg, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener);
                e.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String name = e.getEntryProp().getName();
        if ("orgentryentity".equals(name)) {
            DynamicObject orderModel = (DynamicObject)this.getModel().getValue("ordermodel");
            this.getPageCache().put("deleteConfirm", null);
            this.changeEntryByOrderModel(orderModel, "deleteOrg");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        switch (name) {
            case "material": 
            case "materialgroup": {
                this.materialCategoryChanged(changeData);
                break;
            }
            case "ordermodel": {
                this.orderModelChanged(changeData);
                break;
            }
            case "ispartincalc_1": {
                this.isPartInCalcChanged(changeData);
                break;
            }
            case "cycle": {
                this.cycleChanged(changeData);
                break;
            }
            case "workshift": 
            case "classsystem": {
                this.fillWorkShiftAbility(changeData, name);
                break;
            }
            case "workstarttime": 
            case "workendtime": {
                this.calculateWorkTime(changeData);
                break;
            }
            case "priority": {
                this.changeCalcResult(changeData);
                break;
            }
            case "abilityvalue": {
                this.changeAbilityValue(changeData);
                break;
            }
            case "precision": {
                this.changePrecision(changeData);
                break;
            }
        }
    }

    private void changePrecision(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Long abilityGroupId = (Long)this.getModel().getValue("abilitygroup_2_id", rowIndex);
        String category = (String)this.getModel().getValue("category_2", rowIndex);
        String key = "A".equals(category) ? "material_1_id" : "materialgroup_1_id";
        String key2 = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
        Long baseId = (Long)this.getModel().getValue(key2, rowIndex);
        this.calculateAblityRuslut(abilityGroupId, category, key, key2, baseId);
    }

    private void changeAbilityValue(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        Long abilityGroupId = (Long)this.getModel().getValue("abilitygroup_1_id", rowIndex);
        String category = (String)this.getModel().getValue("category_1", rowIndex);
        String key = "A".equals(category) ? "material_1_id" : "materialgroup_1_id";
        String key2 = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
        Long baseId = (Long)this.getModel().getValue(key, rowIndex);
        this.calculateAblityRuslut(abilityGroupId, category, key, key2, baseId);
    }

    private void calculateAblityRuslut(Long abilityGroupId, String category, String key, String key2, Long baseId) {
        DynamicObjectCollection fixEntry = this.getModel().getEntryEntity("fixedcapacitysubentry");
        DynamicObjectCollection calcEntry = this.getModel().getEntryEntity("calcresultsubentry");
        for (int i = 0; i < calcEntry.size(); ++i) {
            String expression;
            DynamicObject calcObject = (DynamicObject)calcEntry.get(i);
            if (!category.equals(calcObject.getString("category_2")) || !abilityGroupId.equals(calcObject.getLong("abilitygroup_2_id")) || !baseId.equals(calcObject.getLong(key2)) || StringUtils.isBlank((CharSequence)(expression = calcObject.getString("capacitycalen")))) continue;
            String[] fixCapacitys = FormulaEngine.extractVariables((String)expression);
            HashMap<String, Object> valueMap = new HashMap<String, Object>(fixCapacitys.length);
            for (String fixCapacity : fixCapacitys) {
                Object fixCapacityQty = fixEntry.stream().filter(x -> fixCapacity.equals(x.get("abilitynumber_1")) && category.equals(x.getString("category_1")) && abilityGroupId.equals(x.getLong("abilitygroup_1_id")) && baseId.equals(x.getLong(key))).map(x -> x.get("abilityvalue")).findFirst().get();
                if (!Objects.nonNull(fixCapacityQty) || BigDecimal.ZERO.compareTo(new BigDecimal(fixCapacityQty.toString())) == 0) continue;
                valueMap.put(fixCapacity, fixCapacityQty);
            }
            this.getModel().setValue("completeresult", null, i);
            if (valueMap.size() != fixCapacitys.length) continue;
            String result = FormulaEngine.execExcelFormula((String)expression, valueMap).toString();
            this.getModel().setValue("completeresult", (Object)new BigDecimal(result).setScale(2, 1), i);
            int precision = calcObject.getInt("precision");
            if (precision == 0) continue;
            this.getModel().setValue("completeresult", (Object)new BigDecimal(result).setScale(precision, 1).toString(), i);
        }
    }

    private void changeCalcResult(ChangeData changeData) {
        boolean changeCalcResult;
        Integer newValue = (Integer)changeData.getNewValue();
        Integer oldValue = (Integer)changeData.getOldValue();
        if (newValue == null) {
            return;
        }
        boolean bl = changeCalcResult = oldValue == 0 && newValue != 0 || oldValue != 0 && newValue == 0;
        if (changeCalcResult) {
            boolean isChange = false;
            int workCenterRowIndex = this.getModel().getEntryCurrentRowIndex("workcenterentry");
            int calcRowIndex = this.getModel().getEntryCurrentRowIndex("calcresultsubentry");
            String isCalc = 0 == newValue ? "0" : "1";
            int rowIndex = changeData.getRowIndex();
            long workCenterId = (Long)this.getModel().getValue("workcenter_id", rowIndex);
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("matcategoryentry");
            String category = (String)this.getModel().getValue("category", entryCurrentRowIndex);
            String key = "A".equals(category) ? "material_id" : "materialgroup_id";
            String key2 = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
            long baseDataId = (Long)this.getModel().getValue(key, entryCurrentRowIndex);
            DynamicObjectCollection workCenterEntry = this.getModel().getEntryEntity("workcenterentry");
            this.getModel().beginInit();
            for (int i = 0; i < workCenterEntry.size(); ++i) {
                DynamicObject workcenter = (DynamicObject)workCenterEntry.get(i);
                if (workCenterId != workcenter.getLong("workcenter_number_id")) continue;
                DynamicObjectCollection calcResultColl = workcenter.getDynamicObjectCollection("calcresultsubentry");
                this.getModel().setEntryCurrentRowIndex("workcenterentry", i);
                for (int j = 0; j < calcResultColl.size(); ++j) {
                    DynamicObject calcResult = (DynamicObject)calcResultColl.get(j);
                    if (baseDataId != calcResult.getLong(key2)) continue;
                    this.getModel().setValue("ispartincalc_1", (Object)isCalc, j);
                    isChange = workCenterRowIndex == i && calcRowIndex == j;
                }
            }
            this.getModel().endInit();
            EntryGrid control = (EntryGrid)this.getControl("workcenterentry");
            control.selectRows(workCenterRowIndex);
            EntryGrid control1 = (EntryGrid)this.getControl("calcresultsubentry");
            control1.selectRows(calcRowIndex);
            if (isChange) {
                this.getView().updateView("ispartincalc_1", calcRowIndex);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        String callBackId = event.getCallBackId();
        if (CONFIRMKEY_CHANGEORDERMODEL.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.changeEntryByOrderModel((DynamicObject)this.getModel().getValue("ordermodel"), null);
            } else {
                IDataModel model = this.getModel();
                model.beginInit();
                model.setValue("ordermodel_id", (Object)Long.valueOf(event.getCustomVaule()));
                model.endInit();
                model.updateCache();
                this.getView().updateView();
            }
        } else if (CONFIRMKEY_SUPPLYORGMODEL.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.changeEntryByOrderModel((DynamicObject)this.getModel().getValue("ordermodel"), "changeOrg");
            } else {
                IDataModel model = this.getModel();
                model.beginInit();
                String supplyOrgIdStr = this.getPageCache().get(SUPPLYORGID);
                String supplyOrgIdRow = this.getPageCache().get(SUPPLYORGIDROW);
                String customVaule = event.getCustomVaule();
                Map customMap = (Map)SerializationUtils.fromJsonString((String)customVaule, Map.class);
                String primaryKeyStr = (String)customMap.get("primaryKeyValues");
                List primaryKeys = (List)SerializationUtils.fromJsonString((String)primaryKeyStr, List.class);
                List primaryKeyList = primaryKeys.stream().map(x -> Long.parseLong(x.toString())).collect(Collectors.toList());
                int rowIndex = Integer.parseInt(supplyOrgIdRow);
                model.setValue("supplyorg", (Object)(supplyOrgIdStr == null ? null : Long.valueOf(supplyOrgIdStr)), rowIndex);
                if (primaryKeyList.size() > 1) {
                    int[] deleteRows = new int[primaryKeyList.size() - 1];
                    int deleteIndex = 0;
                    DynamicObjectCollection entryEntity = model.getEntryEntity("orgentryentity");
                    for (int i = 0; i < entryEntity.size(); ++i) {
                        DynamicObject supplyOrg = (DynamicObject)entryEntity.get(i);
                        if (!primaryKeyList.contains(supplyOrg.getLong("supplyorg_id"))) continue;
                        deleteRows[deleteIndex++] = i;
                    }
                    model.deleteEntryRows("orgentryentity", deleteRows);
                }
                model.endInit();
                model.updateCache();
                this.getView().updateView();
            }
        } else if (CONFIRMDELETE_SUPPLYORGMODEL.equals(callBackId)) {
            if (event.getResult() == MessageBoxResult.Yes) {
                this.getPageCache().put("deleteConfirm", "deleteConfirm");
                this.getView().invokeOperation("deleteorgentry");
            }
        } else if (CONFIRM_SUBMIT.equals(callBackId) && event.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("submitConfirm", "submitConfirm");
            this.getView().invokeOperation(CONFIRM_SUBMIT, operateOption);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int ordinal = dataEntity.getDynamicObjectType().getProperty("mapping_tag").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(ordinal, false);
        int ordinal1 = dataEntity.getDynamicObjectType().getProperty("groupmapping_tag").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(ordinal1, false);
        int ordinal2 = dataEntity.getDynamicObjectType().getProperty("sourceConfigIds_tag").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(ordinal2, false);
        int ordinal3 = dataEntity.getDynamicObjectType().getProperty("allOrderNos_tag").getOrdinal();
        dataEntity.getDataEntityState().setBizChanged(ordinal3, false);
    }

    private void cycleChanged(ChangeData changeData) {
        Integer newValue = (Integer)changeData.getNewValue();
        if (newValue == null) {
            return;
        }
        boolean outOfRange = newValue < 1 || newValue > 365;
        this.hideCycleTip(!outOfRange);
        if (outOfRange) {
            this.getModel().setValue("cycle", null);
            DecimalEdit decimalEdit = (DecimalEdit)this.getControl("cycle");
            decimalEdit.setFocus(true);
        }
    }

    private void hideCycleTip(boolean hide) {
        FieldTip fieldTip = new FieldTip(FieldTip.FieldTipsLevel.Error, FieldTip.FieldTipsTypes.scope, "cycle", SCOPE_TIP);
        fieldTip.setSuccess(hide);
        this.getView().showFieldTip(fieldTip);
    }

    private void isPartInCalcChanged(ChangeData changeData) {
        boolean isPartInCalc = (Boolean)changeData.getNewValue();
        if (isPartInCalc) {
            int rowIndex;
            IDataModel model = this.getModel();
            String category = (String)model.getValue("category_2", rowIndex = changeData.getRowIndex());
            String key = "A".equals(category) ? "material_2_id" : "materialgroup_2_id";
            long currBaseDataId = (Long)model.getValue(key, rowIndex);
            DynamicObjectCollection collection = model.getEntryEntity("calcresultsubentry");
            for (int i = 0; i < collection.size(); ++i) {
                long baseDataId;
                if (i == rowIndex || currBaseDataId != (baseDataId = ((DynamicObject)collection.get(i)).getLong(key))) continue;
                model.setValue("ispartincalc_1", (Object)Boolean.FALSE, i);
            }
        }
    }

    private void updateCountByChangeMaterialCategory(Map<String, Integer> workCenterId2Count, int rowIndex) {
        IDataModel model = this.getModel();
        model.setEntryCurrentRowIndex("matcategoryentry", rowIndex);
        DynamicObjectCollection collection = model.getEntryEntity("workcentersubentry");
        for (DynamicObject dynamicObject : collection) {
            String workCenterId = dynamicObject.getString("workcenter_id");
            int count = workCenterId2Count.computeIfAbsent(workCenterId, k -> 0);
            workCenterId2Count.put(workCenterId, count - 1);
        }
    }

    private void deleteWorkCenterEntryRows(Map<String, Integer> workCenterId2Count) {
        IDataModel model = this.getModel();
        DynamicObjectCollection collection = model.getEntryEntity("workcenterentry");
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (DynamicObject dynamicObject : collection) {
            String workCenterId = dynamicObject.getString("workcenter_number_id");
            int count = workCenterId2Count.getOrDefault(workCenterId, 0);
            if (count > 0) continue;
            workCenterId2Count.remove(workCenterId);
            rows.add(dynamicObject.getInt("seq") - 1);
        }
        model.deleteEntryRows("workcenterentry", rows.stream().mapToInt(Integer::intValue).toArray());
        model.setValue("mapping_tag", (Object)SerializationUtils.toJsonString(workCenterId2Count));
    }

    private void materialCategoryChanged(ChangeData changeData) {
        if (changeData.getNewValue() == null) {
            Map<String, Integer> workCenterId2Count = this.getWorkCenterId2Count();
            this.getModel().setValue("createorg_1", null);
            this.deleteWorkCenterRelationEntryRows(changeData.getRowIndex(), workCenterId2Count);
        }
    }

    private void deleteWorkCenterRelationEntryRows(int rowIndex, Map<String, Integer> workCenterId2Count) {
        this.updateCountByChangeMaterialCategory(workCenterId2Count, rowIndex);
        this.getModel().deleteEntryData("workcentersubentry");
        this.deleteWorkCenterEntryRows(workCenterId2Count);
    }

    private Map<String, Integer> getWorkCenterId2Count() {
        String mappingStr = (String)this.getModel().getValue("mapping_tag");
        return StringUtils.isBlank((CharSequence)mappingStr) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)mappingStr, HashMap.class);
    }

    private void orderModelChanged(ChangeData changeData) {
        DynamicObject oldDynamicObject = (DynamicObject)changeData.getOldValue();
        if (oldDynamicObject == null) {
            this.changeEntryByOrderModel((DynamicObject)changeData.getNewValue(), null);
        } else {
            String confirmMsg = ResManager.loadKDString((String)"\u4fee\u6539\u8ba2\u5355\u6a21\u578b\u5c06\u4f1a\u91cd\u7f6e\u5de5\u4f5c\u4e2d\u5fc3\u548c\u80fd\u529b\u9879\u6570\u636e, \u662f\u5426\u7ee7\u7eed\u4fee\u6539?", (String)"SchemeEditPlugin_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONFIRMKEY_CHANGEORDERMODEL, (IFormPlugin)this);
            this.getView().showConfirm(confirmMsg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, oldDynamicObject.getPkValue().toString());
        }
    }

    private void supplyOrgChanged(Object[] primaryKeyValues) {
        DynamicObject orderModel = (DynamicObject)this.getModel().getValue("ordermodel");
        if (Objects.isNull(orderModel)) {
            return;
        }
        if (!this.queryResultIsChange(new ArrayList<Integer>(1))) {
            return;
        }
        String confirmMsg = ResManager.loadKDString((String)"\u4fee\u6539\u4f9b\u5e94\u7ec4\u7ec7\u5c06\u4f1a\u91cd\u7f6e\u5de5\u4f5c\u4e2d\u5fc3\u548c\u80fd\u529b\u9879\u6570\u636e, \u662f\u5426\u7ee7\u7eed\u4fee\u6539?", (String)"SchemeEditPlugin_16", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(CONFIRMKEY_SUPPLYORGMODEL, (IFormPlugin)this);
        HashMap<String, String> customMap = new HashMap<String, String>(2);
        customMap.put("primaryKeyValues", SerializationUtils.toJsonString((Object)primaryKeyValues));
        this.getView().showConfirm(confirmMsg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, null, SerializationUtils.toJsonString(customMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean queryResultIsChange(List<Integer> deleteRowIndexList) {
        String sourceConfigIdStr;
        DynamicObjectCollection orgEntity = this.getModel().getEntryEntity("orgentryentity");
        HashSet<Long> productionOrgIds = new HashSet<Long>(orgEntity.size());
        for (int i = 0; i < orgEntity.size(); ++i) {
            DynamicObject org = (DynamicObject)orgEntity.get(i);
            if (deleteRowIndexList.contains(i) || org.getLong("supplyorg_id") == 0L) continue;
            productionOrgIds.add(org.getLong("supplyorg_id"));
        }
        String orderQFilterStr = this.getPageCache().get("orderQFilterStr");
        QFilter orderQFilter = null;
        if (StringUtils.isNotBlank((CharSequence)orderQFilterStr)) {
            orderQFilter = QFilter.fromSerializedString((String)orderQFilterStr);
        }
        if (StringUtils.isBlank((CharSequence)(sourceConfigIdStr = (String)this.getModel().getValue("sourceConfigIds_tag")))) {
            return true;
        }
        Set sourceConfigIds = (Set)SerializationUtils.fromJsonString((String)sourceConfigIdStr, Set.class);
        try (DataSet plsOrderDataSet = DataConversionUtil.getPlsOrderDataSet((Set)sourceConfigIds, (Set)Sets.newHashSet((Object[])new String[]{"production_org", "materiel_code"}), (boolean)false, productionOrgIds, (QFilter)orderQFilter);){
            String allOrderNoStr = (String)this.getModel().getValue("allOrderNos_tag");
            if (StringUtils.isEmpty((CharSequence)allOrderNoStr) && !plsOrderDataSet.hasNext()) {
                boolean bl = false;
                return bl;
            }
            CacheHint cacheHint = new CacheHint();
            String cacheId = UUID.randomUUID().toString();
            cacheHint.setCacheId(cacheId);
            this.getPageCache().put(CACHEID, cacheId);
            cacheHint.setTimeout(30L, TimeUnit.MINUTES);
            CachedDataSet cachedDataSet = plsOrderDataSet.cache(cacheHint);
            int rowCount = cachedDataSet.getRowCount();
            if (!StringUtils.isEmpty((CharSequence)allOrderNoStr) && rowCount > 0) {
                Set allOrderNos = (Set)SerializationUtils.fromJsonString((String)allOrderNoStr, Set.class);
                boolean include = true;
                List list = cachedDataSet.getList(0, rowCount);
                for (Row row : list) {
                    boolean isInclude = allOrderNos.remove(row.getString("plan_order_billno"));
                    if (isInclude) continue;
                    include = false;
                    break;
                }
                if (include && CollectionUtils.isEmpty((Collection)allOrderNos)) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
    }

    private void changeEntryByOrderModel(DynamicObject resourceRegister, String type) {
        this.clearAllEntryData(type);
        if (resourceRegister == null) {
            return;
        }
        List<List<Object>> dataSourceConfigs = this.getDataSourceConfigs(resourceRegister.getPkValue());
        if (dataSourceConfigs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8ba2\u5355\u6a21\u578b\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u3002", (String)"SchemeEditPlugin_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (type == null) {
            this.fillDataSourceEntryData(dataSourceConfigs);
        } else {
            this.getPageCache().put(CACHEID, null);
        }
        StringBuilder sb = new StringBuilder(1000);
        ThreeTuple<Map<Long, String>, Map<Long, Set<Long>>, Map<Long, Long>> threeTuple = this.getMaterialId2Number(dataSourceConfigs, sb);
        if (threeTuple == null) {
            return;
        }
        this.fillOtherEntryData(threeTuple, sb);
        if (sb.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8ba2\u5355\u5305\u542b\u7684\u7269\u6599\u57fa\u7840\u8d44\u6599\u4e0d\u5168, \u8bf7\u68c0\u67e5\u5bf9\u5e94\u914d\u7f6e\u3002", (String)"SchemeEditPlugin_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), sb.toString(), MessageTypes.Default);
        }
    }

    private void fillOtherEntryData(ThreeTuple<Map<Long, String>, Map<Long, Set<Long>>, Map<Long, Long>> threeTuple, StringBuilder sb) {
        Map mid2Number = (Map)threeTuple.item1;
        Map groupId2Mids = (Map)threeTuple.item2;
        Map id2CreateOrg = (Map)threeTuple.item3;
        String selectFields = "id, entryproduct.materielf7, entryproduct.materialgroup, ctrlstrategy, createorg";
        QFilter filter1 = new QFilter("entryproduct.materielf7", "in", mid2Number.keySet());
        if (!groupId2Mids.isEmpty()) {
            filter1 = filter1.or(new QFilter("entryproduct.materialgroup", "in", groupId2Mids.keySet()));
        }
        QFilter filter2 = new QFilter("status", "=", (Object)"C");
        QFilter filter3 = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3};
        HashMap mid2WorkCenterIds = Maps.newHashMapWithExpectedSize((int)mid2Number.size());
        HashMap groupId2WorkCenterIds = Maps.newHashMapWithExpectedSize((int)groupId2Mids.size());
        Throwable throwable = null;
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mpdm_workcentre", selectFields, filters);){
            Iterator iterator = dataSet.iterator();
            while (iterator.hasNext()) {
                Long materialGroupId;
                Row row = (Row)iterator.next();
                Long workCenterId = row.getLong(0);
                Long materialId = row.getLong(1);
                if (materialId != 0L) {
                    mid2Number.remove(materialId);
                    Set workCenterIds = mid2WorkCenterIds.computeIfAbsent(materialId, k -> new HashSet());
                    workCenterIds.add(workCenterId);
                }
                if ((materialGroupId = row.getLong(2)) == 0L) continue;
                Set mids = (Set)groupId2Mids.remove(materialGroupId);
                if (mids != null) {
                    for (Long mid : mids) {
                        mid2Number.remove(mid);
                    }
                }
                Set workCenterIds = groupId2WorkCenterIds.computeIfAbsent(materialGroupId, k -> new HashSet());
                workCenterIds.add(workCenterId);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (!mid2Number.isEmpty()) {
            for (Map.Entry entry : mid2Number.entrySet()) {
                String msg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801: %1$s, \u6ca1\u6709\u5bf9\u5e94\u5de5\u4f5c\u4e2d\u5fc3\u3002", (String)"SchemeEditPlugin_9", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), entry.getValue());
                sb.append(msg).append("\r\n");
            }
        }
        this.fillMaterialCategoryEntry(mid2WorkCenterIds, groupId2WorkCenterIds, id2CreateOrg);
        Set<Object> workCenterIds = this.fillWorkCenterSubEntry(mid2WorkCenterIds, groupId2WorkCenterIds);
        this.fillWorkCenterEntry(Lists.newArrayList(workCenterIds));
    }

    private void fillCapacityGroupSubEntry(Map<Object, Integer> id2RowIndex) {
        Tuple tuple;
        HashMap id2Tuple = Maps.newHashMapWithExpectedSize((int)id2RowIndex.size());
        String selectFields = "id, entryproduct.subentryentityfix.id, entryproduct.subentryentitycal.id, entryproduct.producttype, entryproduct.materialgroup, entryproduct.materielf7, entryproduct.unit, entryproduct.capagroupnum, entryproduct.subentryentityfix.capacityname, entryproduct.subentryentityfix.capacitynumber, entryproduct.subentryentityfix.capacityqty, entryproduct.subentryentityfix.efficiencyqty, entryproduct.subentryentityfix.addefficiencyqty, entryproduct.subentryentityfix.createrfield1, entryproduct.subentryentityfix.createdatefield1, entryproduct.subentryentityfix.modifierfield1, entryproduct.subentryentityfix.modifydatefield1, entryproduct.subentryentitycal.capacityname1, entryproduct.subentryentitycal.capacitycal, entryproduct.subentryentitycal.workstype, entryproduct.subentryentitycal.workunits, entryproduct.subentryentitycal.precision, entryproduct.subentryentitycal.completeresult, entryproduct.subentryentitycal.capacitycalen";
        HashSet<Long> fixedValueIdUniqueSet = new HashSet<Long>();
        HashSet<Long> resultValueIdUniqueSet = new HashSet<Long>();
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mpdm_workcentre", selectFields, new QFilter("id", "in", id2RowIndex.keySet()).toArray());){
            for (Row row : dataSet) {
                Long resultValueId;
                tuple = id2Tuple.computeIfAbsent(row.get(0), k -> Tuple.create(new ArrayList(), new ArrayList()));
                List fixedValues = (List)tuple.item1;
                List resultValues = (List)tuple.item2;
                ArrayList fixedValue = Lists.newArrayListWithExpectedSize((int)14);
                ArrayList resultValue = Lists.newArrayListWithExpectedSize((int)12);
                for (int i = 3; i <= 7; ++i) {
                    Object value = row.get(i);
                    fixedValue.add(value);
                    resultValue.add(value);
                }
                Long fixedValueId = row.getLong(1);
                if (fixedValueIdUniqueSet.add(fixedValueId) && fixedValueId != 0L) {
                    for (int i = 8; i <= 16; ++i) {
                        fixedValue.add(row.get(i));
                    }
                    fixedValues.add(fixedValue);
                }
                if (!resultValueIdUniqueSet.add(resultValueId = row.getLong(2)) || resultValueId == 0L) continue;
                for (int i = 17; i <= 23; ++i) {
                    resultValue.add(row.get(i));
                }
                resultValues.add(resultValue);
            }
        }
        List<List<Object>> workShiftDatas = this.createWorkShiftDatas();
        IDataModel model = this.getModel();
        for (Map.Entry entry : id2Tuple.entrySet()) {
            model.setEntryCurrentRowIndex("workcenterentry", id2RowIndex.get(entry.getKey()).intValue());
            tuple = (Tuple)entry.getValue();
            this.batchCreateEntryRow("fixedcapacitysubentry", FIELDS_FIXEDCAPACITY, (List)tuple.item1);
            this.batchCreateEntryRow("calcresultsubentry", FIELDS_CALCRESULT, (List)tuple.item2);
            this.getModel().deleteEntryData("workshiftentry");
            this.batchCreateEntryRow("workshiftentry", FIELDS_WORKSHIFT, workShiftDatas);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("workcenterentry");
        entryGrid.selectRows(0);
    }

    private void fillMaterialCategoryEntry(Map<Long, Set<Long>> mid2WorkCenterIds, Map<Long, Set<Long>> groupId2WorkCenterIds, Map<Long, Long> id2CreateOrg) {
        ArrayList materialCategoryValues = Lists.newArrayListWithExpectedSize((int)(mid2WorkCenterIds.size() + groupId2WorkCenterIds.size()));
        for (Map.Entry<Long, Set<Long>> entry : mid2WorkCenterIds.entrySet()) {
            Long materialId = entry.getKey();
            materialCategoryValues.add(this.wrapMaterialCategoryValue("A", 0L, materialId, id2CreateOrg.getOrDefault(materialId, 0L)));
        }
        for (Map.Entry<Long, Set<Long>> entry : groupId2WorkCenterIds.entrySet()) {
            Long materialGroupId = entry.getKey();
            materialCategoryValues.add(this.wrapMaterialCategoryValue("C", materialGroupId, 0L, id2CreateOrg.getOrDefault(materialGroupId, 0L)));
        }
        this.batchCreateEntryRow("matcategoryentry", FIELDS_MATERIALCATEGORY, materialCategoryValues);
    }

    private Set<Object> fillWorkCenterSubEntry(Map<Long, Set<Long>> mid2WorkCenterIds, Map<Long, Set<Long>> groupId2WorkCenterIds) {
        int count;
        ArrayList workCenterValues;
        Set<Long> workCenterIds;
        IDataModel model = this.getModel();
        int index = 0;
        HashMap<Object, Integer> workCenterId2Count = new HashMap<Object, Integer>();
        for (Map.Entry<Long, Set<Long>> entry : mid2WorkCenterIds.entrySet()) {
            workCenterIds = entry.getValue();
            model.setEntryCurrentRowIndex("matcategoryentry", index++);
            workCenterValues = Lists.newArrayListWithExpectedSize((int)workCenterIds.size());
            for (Long workCenterId : workCenterIds) {
                count = workCenterId2Count.computeIfAbsent(workCenterId, k -> 0);
                workCenterId2Count.put(workCenterId, count + 1);
                workCenterValues.add(workCenterId);
            }
            this.batchCreateEntryRow("workcentersubentry", "workcenter_id", workCenterValues);
        }
        for (Map.Entry<Long, Set<Long>> entry : groupId2WorkCenterIds.entrySet()) {
            workCenterIds = entry.getValue();
            model.setEntryCurrentRowIndex("matcategoryentry", index++);
            workCenterValues = Lists.newArrayListWithExpectedSize((int)workCenterIds.size());
            for (Long workCenterId : workCenterIds) {
                count = workCenterId2Count.computeIfAbsent(workCenterId, k -> 0);
                workCenterId2Count.put(workCenterId, count + 1);
                workCenterValues.add(workCenterId);
            }
            this.batchCreateEntryRow("workcentersubentry", "workcenter_id", workCenterValues);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("matcategoryentry");
        entryGrid.selectRows(0);
        model.setValue("mapping_tag", (Object)SerializationUtils.toJsonString(workCenterId2Count));
        return workCenterId2Count.keySet();
    }

    private void fillWorkCenterEntry(List<Object> workCenterIds) {
        int[] rowIndexs = this.batchCreateEntryRow("workcenterentry", "workcenter_number_id", workCenterIds);
        HashMap id2RowIndex = Maps.newHashMapWithExpectedSize((int)workCenterIds.size());
        for (int i = 0; i < workCenterIds.size(); ++i) {
            id2RowIndex.put(workCenterIds.get(i), rowIndexs[i]);
        }
        this.fillCapacityGroupSubEntry(id2RowIndex);
    }

    private void addNonExistentDetailMessage(Map<Long, Set<Long>> id2Orgs, StringBuilder sb, Map<Long, List<Long>> mid2GroupIds, Map<Long, String> mid2Number, Map<Long, Set<Long>> groupId2Mids, Map<Long, Long> id2CreateOrg) {
        Iterator<Map.Entry<Long, Set<Long>>> dynamicObjects;
        ORM orm = ORM.create();
        HashMap<Long, String> mid2Numbers = new HashMap<Long, String>(8);
        ArrayList orgList = new ArrayList(8);
        for (Map.Entry<Long, Set<Long>> mapEntry : id2Orgs.entrySet()) {
            orgList.addAll(mapEntry.getValue());
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", orgList, (boolean)false);
        DynamicObjectCollection materialmftinfo = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id, masterid,enable,status,masterid.number number, createorg, mftcontrolentry.materialcontrol group, mftcontrolentry.materialcontrol.createorg groupCreateOrg", (QFilter[])new QFilter[]{baseDataFilter});
        HashMap<Long, List> materialmftinfoMap = new HashMap<Long, List>(8);
        for (Object dynamicObject : materialmftinfo) {
            if (!"1".equals(dynamicObject.getString("enable")) || !"C".equals(dynamicObject.getString("status"))) continue;
            List mids = materialmftinfoMap.computeIfAbsent(dynamicObject.getLong("masterid"), k -> new ArrayList());
            mids.add(dynamicObject);
        }
        ArrayList matidList = Lists.newArrayList(id2Orgs.keySet());
        for (Long matid : matidList) {
            if (!materialmftinfoMap.containsKey(matid)) continue;
            dynamicObjects = (List)materialmftinfoMap.get(matid);
            Iterator iterator = dynamicObjects.iterator();
            while (iterator.hasNext()) {
                DynamicObject dynamicObject = (DynamicObject)iterator.next();
                long groupId = dynamicObject.getLong("group");
                Long id = dynamicObject.getLong("id");
                Long createOrgId = dynamicObject.getLong("createorg");
                mid2Number.putIfAbsent(id, dynamicObject.getString("number"));
                id2CreateOrg.putIfAbsent(id, createOrgId);
                if (groupId == 0L) continue;
                Set mids = groupId2Mids.computeIfAbsent(groupId, k -> new HashSet());
                mids.add(id);
                id2CreateOrg.putIfAbsent(groupId, dynamicObject.getLong("groupCreateOrg"));
                List groupIds = mid2GroupIds.computeIfAbsent(matid, k -> new ArrayList());
                groupIds.add(groupId);
            }
            id2Orgs.remove(matid);
        }
        QFilter[] matFilters = new QFilter[]{new QFilter("id", "in", id2Orgs.keySet())};
        DataSet dataSet = orm.queryDataSet(algoKey, "bd_material", "id, number", matFilters);
        dynamicObjects = null;
        try {
            for (Row row : dataSet) {
                mid2Numbers.put(row.getLong(0), row.getString(1));
            }
        }
        catch (Throwable throwable) {
            dynamicObjects = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (dynamicObjects != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)((Object)dynamicObjects)).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashSet orgIds = new HashSet();
        for (Map.Entry<Long, Set<Long>> entry : id2Orgs.entrySet()) {
            orgIds.addAll(entry.getValue());
        }
        HashMap oid2Number = Maps.newHashMapWithExpectedSize((int)orgIds.size());
        QFilter[] orgFilters = new QFilter[]{new QFilter("id", "in", orgIds)};
        try (DataSet dataSet2 = orm.queryDataSet(algoKey, "bos_org", "id, number", orgFilters);){
            for (Row row : dataSet2) {
                oid2Number.put(row.get(0), row.getString(1));
            }
        }
        for (Map.Entry<Long, Set<Long>> entry : id2Orgs.entrySet()) {
            for (Long orgId : entry.getValue()) {
                String msg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801: %1$s, \u751f\u4ea7\u7ec4\u7ec7\u7f16\u7801: %2$s, \u6ca1\u6709\u7269\u6599\u751f\u4ea7\u4fe1\u606f", (String)"SchemeEditPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), mid2Numbers.get(entry.getKey()), oid2Number.get(orgId));
                sb.append(msg).append("\r\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreeTuple<Map<Long, String>, Map<Long, Set<Long>>, Map<Long, Long>> getMaterialId2Number(List<List<Object>> dataSourceConfigs, StringBuilder sb) {
        HashSet sourceConfigIds = Sets.newHashSetWithExpectedSize((int)dataSourceConfigs.size());
        for (List<Object> dataSourceConfig : dataSourceConfigs) {
            sourceConfigIds.add((Long)dataSourceConfig.get(0));
        }
        this.getModel().setValue("sourceConfigIds_tag", (Object)SerializationUtils.toJsonString((Object)sourceConfigIds));
        long startTime = System.currentTimeMillis();
        DataSet plsOrderDataSet = null;
        HashSet<Long> allOrgIds = new HashSet<Long>(10);
        HashSet<String> allOrderNos = new HashSet<String>(10);
        HashMap<Long, Set<Long>> id2Orgs = new HashMap<Long, Set<Long>>();
        try {
            Object orgEntity;
            String cacheId = this.getPageCache().get(CACHEID);
            if (StringUtils.isNotBlank((CharSequence)cacheId)) {
                CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
                plsOrderDataSet = cacheDataSet.toDataSet(Algo.create((String)"phm"), false);
            } else {
                orgEntity = this.getModel().getEntryEntity("orgentryentity");
                Set productionOrgIds = orgEntity.stream().filter(x -> x.getLong("supplyorg_id") != 0L).map(x -> x.getLong("supplyorg_id")).collect(Collectors.toSet());
                String orderQFilterStr = this.getPageCache().get("orderQFilterStr");
                QFilter orderQFilter = null;
                if (StringUtils.isNotBlank((CharSequence)orderQFilterStr)) {
                    orderQFilter = QFilter.fromSerializedString((String)orderQFilterStr);
                }
                plsOrderDataSet = DataConversionUtil.getPlsOrderDataSet((Set)sourceConfigIds, (Set)Sets.newHashSet((Object[])new String[]{"production_org", "materiel_code"}), (boolean)false, productionOrgIds, (QFilter)orderQFilter);
            }
            log.info("PLS-fetch-source-data cost {} ms, sourseConfigIds: {}", (Object)(System.currentTimeMillis() - startTime), (Object)sourceConfigIds);
            if (plsOrderDataSet == null || plsOrderDataSet.isEmpty()) {
                this.getModel().setValue("allOrderNos_tag", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65b9\u6848\u672a\u83b7\u53d6\u5230\u6765\u6e90\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u5b58\u5728\u6ee1\u8db3\u7ec4\u7ec7\u8fc7\u6ee4\u6761\u4ef6\u53ca\u8ba2\u5355\u6a21\u578b\u6e90\u5355\u8fc7\u6ee4\u6761\u4ef6\u7684\u6765\u6e90\u8ba2\u5355\u3002", (String)"SchemeEditPlugin_17", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                orgEntity = null;
                return orgEntity;
            }
            for (Row row : plsOrderDataSet) {
                Set orgIds = id2Orgs.computeIfAbsent(row.getLong("materiel_code"), k -> new HashSet());
                long orgId = row.getLong("production_org");
                orgIds.add(orgId);
                allOrgIds.add(orgId);
                allOrderNos.add(row.getString("plan_order_billno"));
            }
            this.getModel().setValue("allOrderNos_tag", (Object)SerializationUtils.toJsonString(allOrderNos));
        }
        finally {
            if (plsOrderDataSet != null) {
                plsOrderDataSet.close();
            }
        }
        int size = id2Orgs.size();
        HashMap mid2Number = Maps.newHashMapWithExpectedSize((int)size);
        HashMap<Long, Set<Long>> groupId2Mids = new HashMap<Long, Set<Long>>(16);
        HashMap id2CreateOrg = Maps.newHashMapWithExpectedSize((int)size);
        HashMap mid2GroupIds = Maps.newHashMapWithExpectedSize((int)size);
        String selectFields = "id, masterid, masterid.number number, createorg, mftcontrolentry.materialcontrol group, mftcontrolentry.materialcontrol.createorg groupCreateOrg,ctrlstrategy";
        QFilter filter1 = new QFilter("masterid", "in", id2Orgs.keySet());
        QFilter filter2 = new QFilter("createorg", "in", allOrgIds);
        QFilter filter3 = new QFilter("status", "=", (Object)"C");
        QFilter filter4 = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter1, filter2, filter3, filter4};
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "bd_materialmftinfo", selectFields, filters);){
            for (Row row : dataSet) {
                Long createOrgId;
                Long materialId = row.getLong("masterid");
                Set orgIds = id2Orgs.getOrDefault(materialId, Collections.emptySet());
                if (orgIds.remove(createOrgId = row.getLong("createorg")) || orgIds.isEmpty()) {
                    Long id = row.getLong("id");
                    mid2Number.putIfAbsent(id, row.getString("number"));
                    id2CreateOrg.putIfAbsent(id, createOrgId);
                    Long groupId = row.getLong("group");
                    if (groupId != null && !groupId.equals(0L)) {
                        Set mids = groupId2Mids.computeIfAbsent(groupId, k -> new HashSet());
                        mids.add(id);
                        id2CreateOrg.putIfAbsent(groupId, row.getLong("groupCreateOrg"));
                        List groupIds = mid2GroupIds.computeIfAbsent(materialId, k -> new ArrayList());
                        groupIds.add(groupId);
                    }
                }
                if (!orgIds.isEmpty()) continue;
                id2Orgs.remove(materialId);
            }
        }
        if (!id2Orgs.isEmpty()) {
            this.addNonExistentDetailMessage(id2Orgs, sb, mid2GroupIds, mid2Number, groupId2Mids, id2CreateOrg);
        }
        this.getModel().setValue("groupmapping_tag", (Object)SerializationUtils.toJsonString((Object)mid2GroupIds));
        return new ThreeTuple((Object)mid2Number, groupId2Mids, (Object)id2CreateOrg);
    }

    private List<Object> wrapMaterialCategoryValue(String category, Long materialGroupId, Long materialId, Long createOrgId) {
        ArrayList values = Lists.newArrayListWithExpectedSize((int)4);
        values.add(category);
        values.add(materialGroupId);
        values.add(materialId);
        values.add(createOrgId);
        return values;
    }

    private void clearAllEntryData(String type) {
        IDataModel model = this.getModel();
        if (type == null) {
            model.deleteEntryData("datasourceentry");
        }
        model.deleteEntryData("matcategoryentry");
        model.deleteEntryData("workcenterentry");
        model.setValue("mapping_tag", null);
    }

    private void fillDataSourceEntryData(List<List<Object>> values) {
        this.batchCreateEntryRow("datasourceentry", new String[]{"datasoure_id", "srcentity_id"}, values);
    }

    private void batchCreateEntryRow(String entryKey, String[] fields, List<List<Object>> values) {
        if (CollectionUtils.isEmpty(values)) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(fields);
        for (List<Object> value : values) {
            tvs.addRow(value.toArray());
        }
        model.batchCreateNewEntryRow(entryKey, tvs);
        model.endInit();
        this.getView().updateView(entryKey);
    }

    private int[] batchCreateEntryRow(String entryKey, String field, List<Object> values) {
        if (values.isEmpty()) {
            return new int[0];
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        TableValueSetter tvs = new TableValueSetter(new String[0]);
        tvs.addField(field, values.toArray());
        int[] rowIndexs = model.batchCreateNewEntryRow(entryKey, tvs);
        model.endInit();
        this.getView().updateView(entryKey);
        return rowIndexs;
    }

    private List<List<Object>> getDataSourceConfigs(Object resourceRegisterId) {
        String selectFields = "id, billfieldtransfer.srcbill";
        QFilter filter1 = new QFilter("cgnumber", "=", resourceRegisterId);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter1, filter2};
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        try (DataSet dataSet = ORM.create().queryDataSet(algoKey, "mrp_resource_dataconfig", selectFields, filters);){
            for (Row row : dataSet) {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(row.get(0));
                values.add(row.get(1));
                result.add(values);
            }
        }
        return result;
    }

    private void calculateWorkTime(ChangeData changeData) {
        int rowIndex = changeData.getRowIndex();
        String workStartTime = this.getModel().getValue("workstarttime", rowIndex).toString();
        String workEndTime = this.getModel().getValue("workendtime", rowIndex).toString();
        if (!StringUtils.equals((CharSequence)"-1", (CharSequence)workStartTime) && !StringUtils.equals((CharSequence)"-1", (CharSequence)workEndTime)) {
            BigDecimal workTime;
            BigDecimal startTime = new BigDecimal(workStartTime);
            BigDecimal endTime = new BigDecimal(workEndTime);
            BigDecimal help = new BigDecimal(3600);
            if (startTime.compareTo(endTime) < 0) {
                workTime = endTime.subtract(startTime).divide(help, 2, 1);
                this.getModel().setValue("iscrossday", (Object)Boolean.FALSE, rowIndex);
            } else {
                workTime = endTime.add(new BigDecimal(86400)).subtract(startTime).divide(help, 2, 1);
                this.getModel().setValue("iscrossday", (Object)Boolean.TRUE, rowIndex);
            }
            this.getModel().setValue("worktime", (Object)workTime, rowIndex);
        }
    }

    private List<List<Object>> createWorkShiftDatas() {
        DynamicObject obj;
        boolean isClassSystem = (Boolean)this.getModel().getValue("isclasssystem");
        String type = "workshift";
        if (isClassSystem) {
            type = "classsystem";
        }
        if ((obj = (DynamicObject)this.getModel().getValue(type)) == null) {
            return null;
        }
        DynamicObjectCollection col = this.queryDatas(obj, type);
        if (CollectionUtils.isEmpty((Collection)col)) {
            return null;
        }
        return this.createWorkShiftDatas(col, type);
    }

    private List<List<Object>> createWorkShiftDatas(DynamicObjectCollection col, String type) {
        ArrayList<List<Object>> datas = new ArrayList<List<Object>>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            ArrayList<Object> value = new ArrayList<Object>(6);
            DynamicObject obj = (DynamicObject)col.get(i);
            long workShiftId = obj.getLong("id");
            if (StringUtils.equals((CharSequence)"classsystem", (CharSequence)type)) {
                workShiftId = obj.getLong("entryentity.workshift");
            }
            value.add(Boolean.TRUE);
            value.add(workShiftId);
            value.add(obj.get("entryentity.workstarttime"));
            value.add(obj.get("entryentity.workendtime"));
            value.add(obj.get("entryentity.worktime"));
            value.add(obj.get("entryentity.iscrossday"));
            datas.add(value);
        }
        return datas;
    }

    private DynamicObjectCollection queryDatas(DynamicObject obj, String type) {
        long Id = obj.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)Id);
        String selectStr = "id,entryentity.workstarttime,entryentity.workendtime,entryentity.worktime,entryentity.iscrossday";
        String entityName = "mpdm_workshifts";
        if (StringUtils.equals((CharSequence)"classsystem", (CharSequence)type)) {
            selectStr = "id,entryentity.workshift,entryentity.workstarttime,entryentity.workendtime,entryentity.worktime,entryentity.iscrossday";
            entityName = "mpdm_classsystem";
        }
        return QueryServiceHelper.query((String)entityName, (String)selectStr, (QFilter[])new QFilter[]{qFilter});
    }

    protected void fillWorkShiftAbility(ChangeData changeData, String type) {
        Object newValue = changeData.getNewValue();
        if (newValue == null) {
            this.deleteWorkShiftEntry();
            return;
        }
        DynamicObjectCollection datas = this.queryDatas((DynamicObject)newValue, type);
        if (datas == null) {
            this.deleteWorkShiftEntry();
            return;
        }
        List<List<Object>> workShiftDatas = this.createWorkShiftDatas(datas, type);
        if (workShiftDatas.isEmpty()) {
            this.deleteWorkShiftEntry();
            return;
        }
        DynamicObjectCollection workCenterEntry = this.getModel().getEntryEntity("workcenterentry");
        for (int i = 0; i < workCenterEntry.size(); ++i) {
            this.getModel().setEntryCurrentRowIndex("workcenterentry", i);
            this.getModel().deleteEntryData("workshiftentry");
            this.batchCreateEntryRow("workshiftentry", FIELDS_WORKSHIFT, workShiftDatas);
        }
    }

    private void deleteWorkShiftEntry() {
        DynamicObjectCollection workCenterEntry = this.getModel().getEntryEntity("workcenterentry");
        for (int i = 0; i < workCenterEntry.size(); ++i) {
            this.getModel().setEntryCurrentRowIndex("workcenterentry", i);
            this.getModel().deleteEntryData("workshiftentry");
        }
    }

    static {
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[0] = "category_1";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[1] = "materialgroup_1_id";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[2] = "material_1_id";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[3] = "unit_1_id";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[4] = "abilitygroup_1_id";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[5] = "abilityname_1";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[6] = "abilitynumber_1";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[7] = "abilityvalue";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[8] = "efficiency";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[9] = "addefficiency";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[10] = "creator_1_id";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[11] = "createtime_1";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[12] = "modifier_1_id";
        SchemeEditPlugin.FIELDS_FIXEDCAPACITY[13] = "modifytime_1";
        SchemeEditPlugin.FIELDS_CALCRESULT[0] = "category_2";
        SchemeEditPlugin.FIELDS_CALCRESULT[1] = "materialgroup_2_id";
        SchemeEditPlugin.FIELDS_CALCRESULT[2] = "material_2_id";
        SchemeEditPlugin.FIELDS_CALCRESULT[3] = "unit_2_id";
        SchemeEditPlugin.FIELDS_CALCRESULT[4] = "abilitygroup_2_id";
        SchemeEditPlugin.FIELDS_CALCRESULT[5] = "abilityname_2";
        SchemeEditPlugin.FIELDS_CALCRESULT[6] = "expression";
        SchemeEditPlugin.FIELDS_CALCRESULT[7] = "workstype";
        SchemeEditPlugin.FIELDS_CALCRESULT[8] = "workunits";
        SchemeEditPlugin.FIELDS_CALCRESULT[9] = "precision";
        SchemeEditPlugin.FIELDS_CALCRESULT[10] = "completeresult";
        SchemeEditPlugin.FIELDS_CALCRESULT[11] = "capacitycalen";
        SchemeEditPlugin.FIELDS_WORKSHIFT[0] = "iscal";
        SchemeEditPlugin.FIELDS_WORKSHIFT[1] = "sub_workshift";
        SchemeEditPlugin.FIELDS_WORKSHIFT[2] = "workstarttime";
        SchemeEditPlugin.FIELDS_WORKSHIFT[3] = "workendtime";
        SchemeEditPlugin.FIELDS_WORKSHIFT[4] = "worktime";
        SchemeEditPlugin.FIELDS_WORKSHIFT[5] = "iscrossday";
    }
}

