/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.rpt;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mrp.rpt.enmus.TimeTypeEnum;

public class RptSchemePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit warehouseEdit = (BasedataEdit)this.getControl("warehouse");
        warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit locationEdit = (BasedataEdit)this.getControl("location");
        locationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourceEdit = (BasedataEdit)this.getControl("source");
        sourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        if (StringUtils.equals((CharSequence)"rpttype", (CharSequence)name)) {
            this.setRptFieldItems();
        } else if (StringUtils.equals((CharSequence)"planid", (CharSequence)name)) {
            this.planChanged(e);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("createorg", (Object)orgId);
        this.getModel().setValue("timetype", (Object)TimeTypeEnum.Day.getValue(), 0);
        this.getModel().setValue("timetype", (Object)TimeTypeEnum.Week.getValue(), 1);
        this.getModel().setValue("timetype", (Object)TimeTypeEnum.Month.getValue(), 2);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initSchemeSettings();
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        Control control = (Control)beforeF7SelectEvent.getSource();
        String key = control.getKey();
        ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        List<Object> qFilters = new ArrayList();
        if (StringUtils.equals((CharSequence)"warehouse", (CharSequence)key)) {
            qFilters = this.warehouseFilters();
        } else if (StringUtils.equals((CharSequence)"location", (CharSequence)key)) {
            qFilters = this.locationFilters();
        } else if (StringUtils.equals((CharSequence)"source", (CharSequence)key)) {
            qFilters = this.sourceFilters();
        }
        if (qFilters != null) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qFilters);
        }
    }

    private void initSchemeSettings() {
        this.setRptFieldItems();
    }

    private List<QFilter> warehouseFilters() {
        Object row;
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        DynamicObjectCollection planCol = (DynamicObjectCollection)this.getModel().getValue("planid");
        if (planCol == null || planCol.size() == 0) {
            return null;
        }
        ArrayList planIdList = new ArrayList(planCol.size());
        planCol.forEach(plan -> planIdList.add((Long)plan.get(2)));
        ArrayList<Long> stockSupplyIdList = new ArrayList<Long>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"mrp_rpt_scheme_queryPlan", (String)"mrp_planprogram", (String)"id,orgentryentity.entryinvstrategy", (QFilter[])new QFilter[]{new QFilter("id", "in", planIdList)}, null);){
            while (dataSet.hasNext()) {
                row = dataSet.next();
                stockSupplyIdList.add(row.getLong("orgentryentity.entryinvstrategy"));
            }
        }
        ArrayList<Long> storageOrgIdList = new ArrayList<Long>(8);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"mrp_rpt_scheme_queryStockSupply", (String)"mrp_stocksupply_policy", (String)"id,entryentity.storageorg", (QFilter[])new QFilter[]{new QFilter("id", "in", stockSupplyIdList)}, null);
        row = null;
        try {
            while (dataSet.hasNext()) {
                Row row2 = dataSet.next();
                storageOrgIdList.add(row2.getLong("entryentity.storageorg"));
            }
        }
        catch (Throwable throwable) {
            row = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (row != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)row).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        ArrayList<Long> warehouseIdList = new ArrayList<Long>(8);
        try (DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"mrp_rpt_scheme_queryWarehouseSet", (String)"im_warehousesetup", (String)"id,warehouse", (QFilter[])new QFilter[]{new QFilter("org", "in", storageOrgIdList)}, null);){
            while (dataSet2.hasNext()) {
                Row row3 = dataSet2.next();
                warehouseIdList.add(row3.getLong("warehouse"));
            }
        }
        qFilterList.add(new QFilter("id", "in", warehouseIdList));
        return qFilterList;
    }

    private List<QFilter> locationFilters() {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        DynamicObjectCollection warehouseCol = (DynamicObjectCollection)this.getModel().getValue("warehouse");
        ArrayList warehosueIdList = new ArrayList(warehouseCol.size());
        warehouseCol.forEach(warehouse -> warehosueIdList.add((Long)warehouse.get(2)));
        ArrayList<Long> locationIdList = new ArrayList<Long>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"mrp_rpt_scheme_queryWarehouse", (String)"bd_warehouse", (String)"id,entryentity.location", (QFilter[])new QFilter[]{new QFilter("id", "in", warehosueIdList)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                locationIdList.add(row.getLong("entryentity.location"));
            }
        }
        qFilterList.add(new QFilter("id", "in", locationIdList));
        return qFilterList;
    }

    private List<QFilter> sourceFilters() {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        DynamicObjectCollection planCol = (DynamicObjectCollection)this.getModel().getValue("planid");
        ArrayList planIdList = new ArrayList(8);
        planCol.forEach(plan -> planIdList.add((Long)plan.get(2)));
        ArrayList<Long> sourceIdList = new ArrayList<Long>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"mrp_rpt_scheme_queryPlan", (String)"mrp_planprogram", (String)"id,entryentity.resourceregister", (QFilter[])new QFilter[]{new QFilter("id", "in", planIdList)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                sourceIdList.add(row.getLong("entryentity.resourceregister"));
            }
        }
        qFilterList.add(new QFilter("id", "in", sourceIdList));
        return qFilterList;
    }

    private void setRptFieldItems() {
        MainEntityType dataEntityType;
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(8);
        String rptType = (String)this.getModel().getValue("rpttype");
        ComboEdit rptField = (ComboEdit)this.getControl("rptfield");
        try {
            dataEntityType = EntityMetadataCache.getDataEntityType((String)rptType);
        }
        catch (Exception exc) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230%s\u7c7b\u578b\u7684\u62a5\u8868\u3002", (String)"RptSchemePlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), rptType));
            rptField.setComboItems(propertyItems);
            return;
        }
        Map allFields = dataEntityType.getAllFields();
        for (Map.Entry next : allFields.entrySet()) {
            String key = (String)next.getKey();
            if (key.contains("head_")) continue;
            IDataEntityProperty value = (IDataEntityProperty)next.getValue();
            ComboItem comboItem = new ComboItem();
            comboItem.setId(key);
            comboItem.setValue(key);
            comboItem.setCaption(value.getDisplayName());
            propertyItems.add(comboItem);
        }
        rptField.setComboItems(propertyItems);
    }

    private void planChanged(PropertyChangedArgs e) {
        ChangeData changeData = e.getChangeSet()[0];
        DynamicObjectCollection oldCol = (DynamicObjectCollection)changeData.getOldValue();
        DynamicObjectCollection newCol = (DynamicObjectCollection)changeData.getNewValue();
        ArrayList oldIdList = new ArrayList(8);
        ArrayList newIdList = new ArrayList(8);
        if (oldCol.size() != newCol.size()) {
            this.getModel().setValue("source", null);
        } else {
            oldCol.forEach(old -> oldIdList.add((Long)old.get(2)));
            newCol.forEach(new1 -> newIdList.add((Long)new1.get(2)));
            Iterator iterator = oldIdList.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                if (newIdList.contains(id)) continue;
                this.getModel().setValue("source", null);
                break;
            }
        }
    }
}

