/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.formplugin.supdem;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.report.ReportTaskResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.orm.query.QFilter;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class SupplyDemandRptFormPlugin
extends AbstractReportFormPlugin
implements RowClickEventListener {
    private static final String TB_RANGE = "mrp_supdem_range";
    private static final String TB_QUERY = "mrp_supdem_query";
    private static final String TYPE_SCZJQD = "pom_mftstock";
    private static final String TYPE_WWZJQD = "om_mftstock";
    private static final String TYPE_XSDD = "sm_salorder";
    private static final String TYPE_WWGD = "om_mftorder";
    private static final String TYPE_CGDD = "pm_purorderbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button setting = (Button)this.getControl("setting");
        setting.addClickListener((ClickListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addRowClickListener((RowClickEventListener)this);
        this.getView().setEnable(Boolean.FALSE, new String[]{"sumentry"});
    }

    public void entryRowClick(RowClickEvent evt) {
        int idx = evt.getRow();
        ReportList reportList = (ReportList)evt.getSource();
        AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
        DynamicObject dyn = reportModel.getRowData(idx);
        if (dyn != null) {
            long mid = dyn.getLong("material_id");
            this.fillSum(mid);
        }
    }

    private void fillSum(long mid) {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
        ReportTaskResult result = reportModel.getReportTaskResult();
        String resultId = result.getResultId();
        CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)resultId);
        List list = cacheDataSet.getList(0, cacheDataSet.getRowCount());
        if (mid == 0L && list.size() > 0) {
            Long material = ((Row)list.get(0)).getLong("material");
            mid = material == null ? 0L : material;
        }
        long mmid = mid;
        List material = list.stream().filter(x -> {
            long mt = x.getLong("material") == null ? 0L : x.getLong("material");
            return mmid == mt;
        }).collect(Collectors.toList());
        list.clear();
        HashMap<Tuple<String, String>, Set<Long>> srcOrgMap = new HashMap<Tuple<String, String>, Set<Long>>(32);
        HashSet<Long> orgIds = new HashSet<Long>(32);
        for (Row r : material) {
            Long billId = r.getLong("billid");
            String type = r.getString("srctype");
            boolean added = this.getSrcOrgMap(srcOrgMap, type, billId);
            if (added) continue;
            orgIds.add(r.getLong("org"));
        }
        Map<String, Map<Long, String>> srcNameMap = this.getSrcNameMap(srcOrgMap);
        Map<Long, String> orgNameMap = this.getOrgMap(orgIds);
        LinkedHashMap<SumSrcOrg, QTY> sumMap = new LinkedHashMap<SumSrcOrg, QTY>(32);
        for (Row r : material) {
            Long mt = r.getLong("material");
            Long cc = r.getLong("configuredcode");
            Long tn = r.getLong("tracknumber");
            Long ap = r.getLong("auxproperty");
            Long pj = r.getLong("project");
            Long unit = r.getLong("unit");
            Long config = r.getLong("config");
            Long billId = r.getLong("billid");
            String type = r.getString("srctype");
            Long org = r.getLong("org");
            BigDecimal qty = r.getBigDecimal("qty");
            Map<Long, String> map = srcNameMap.get(type);
            String orgName = map == null ? orgNameMap.get(org) : map.get(billId);
            SumSrcOrg sumSrcOrg = new SumSrcOrg(mt, cc, tn, ap, pj, unit, config, orgName);
            sumMap.computeIfAbsent(sumSrcOrg, k -> new QTY()).add(qty);
        }
        this.setSumEntry(sumMap);
    }

    private void setSumEntry(Map<SumSrcOrg, QTY> sumMap) {
        this.getModel().deleteEntryData("sumentry");
        if (sumMap.isEmpty()) {
            return;
        }
        int[] sumentries = this.getModel().batchCreateNewEntryRow("sumentry", sumMap.size());
        int length = sumentries.length;
        DynamicObjectCollection cols = this.getModel().getEntryEntity("sumentry");
        int i = 0;
        BigDecimal left = BigDecimal.ZERO;
        Long lastConfig = 0L;
        Long lastauxproperty = 0L;
        Long lastProject = 0L;
        Long lastTrack = 0L;
        for (Map.Entry<SumSrcOrg, QTY> entry : sumMap.entrySet()) {
            if (i >= length) continue;
            SumSrcOrg key = entry.getKey();
            QTY value = entry.getValue();
            DynamicObject dyn = (DynamicObject)cols.get(i++);
            dyn.set("sum_material_id", (Object)key.mt);
            dyn.set("sum_configuredcode_id", (Object)key.configuredcode);
            dyn.set("sum_tracknumber_id", (Object)key.tracknumber);
            dyn.set("sum_auxproperty_id", (Object)key.auxproperty);
            dyn.set("sum_project_id", (Object)key.project);
            dyn.set("sum_config_id", (Object)key.config);
            dyn.set("sum_srcorg", (Object)key.orgNumber);
            dyn.set("sum_unit_id", (Object)key.unit);
            dyn.set("sum_qty", (Object)value.qty);
            if (Objects.equals(lastConfig, key.configuredcode) && Objects.equals(lastauxproperty, key.auxproperty) && Objects.equals(lastProject, key.project) && Objects.equals(lastTrack, key.tracknumber)) {
                left = left.add(value.qty);
            } else {
                left = value.qty;
                lastConfig = key.configuredcode;
                lastauxproperty = key.auxproperty;
                lastProject = key.project;
                lastTrack = key.tracknumber;
            }
            dyn.set("sum_leftqty", (Object)left);
        }
        this.getView().updateView("sumentry");
    }

    private Map<Long, String> getOrgMap(Set<Long> orgIds) {
        HashMap<Long, String> idMap = new HashMap<Long, String>(32);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"SupplyDemandRptFormPlugin.putOrgMap", (String)"bos_org", (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("id", "in", orgIds)}, null);){
            for (Row d : ds) {
                String join = String.join((CharSequence)" ", d.getString("number"), d.getString("name"));
                idMap.put(d.getLong("id"), join);
            }
        }
        return idMap;
    }

    public void click(EventObject evt) {
        Button bt;
        String key;
        Object source = evt.getSource();
        if (source instanceof Button && "setting".equals(key = (bt = (Button)source).getKey()) && this.editPerm()) {
            DynamicObject queryOne = QueryServiceHelper.queryOne((String)TB_RANGE, (String)"id", null);
            if (queryOne == null) {
                this.showCreate();
            } else {
                this.showEdit(queryOne.getLong("id"));
            }
        }
    }

    private boolean editPerm() {
        return PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"0MBBBZ1L5IAW", (String)TB_QUERY, (String)"1WTPJUI3R1+2");
    }

    private void showEdit(long id) {
        BillShowParameter parameter = this.getParam();
        parameter.setStatus(OperationStatus.EDIT);
        parameter.setPkId((Object)id);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private BillShowParameter getParam() {
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(TB_RANGE);
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setHasRight(true);
        return parameter;
    }

    private void showCreate() {
        BillShowParameter parameter = this.getParam();
        parameter.setStatus(OperationStatus.ADDNEW);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        this.getView().setVisible(Boolean.TRUE, new String[]{"reportlistap", "splitcontainerap"});
        this.fillSum(0L);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        HashMap<String, Set> pnumberMap = new HashMap<String, Set>(32);
        HashMap<Tuple<String, String>, Set<Long>> srcOrgMap = new HashMap<Tuple<String, String>, Set<Long>>(32);
        for (Object row : rowData) {
            String string = row.getString("srctype");
            long billId = row.getLong("billid");
            if (TYPE_SCZJQD.equals(string) || TYPE_WWZJQD.equals(string)) {
                pnumberMap.computeIfAbsent(string, k -> new HashSet(8)).add(billId);
            }
            this.getSrcOrgMap(srcOrgMap, string, billId);
        }
        HashMap idParentMap = new HashMap(32);
        for (Map.Entry entry : pnumberMap.entrySet()) {
            String key = (String)entry.getKey();
            Set value = (Set)entry.getValue();
            DataSet ds = QueryServiceHelper.queryDataSet((String)"SupplyDemandRptFormPlugin.processRowData", (String)key, (String)"id,productid.number", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)value)}, null);
            Throwable throwable = null;
            try {
                HashMap<Long, String> idToParentMap = new HashMap<Long, String>();
                for (Row d : ds) {
                    idToParentMap.put(d.getLong("id"), d.getString("productid.number"));
                }
                idParentMap.put(key, idToParentMap);
            }
            catch (Throwable idToParentMap) {
                throwable = idToParentMap;
                throw idToParentMap;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable idToParentMap) {
                        throwable.addSuppressed(idToParentMap);
                    }
                    continue;
                }
                ds.close();
            }
        }
        Map<String, Map<Long, String>> srcMap = this.getSrcNameMap(srcOrgMap);
        for (DynamicObject row : rowData) {
            Map<Long, String> map;
            String srcType = row.getString("srctype");
            long billId = row.getLong("billid");
            Map idPMap = (Map)idParentMap.get(srcType);
            if (idPMap != null) {
                String pnumber = (String)idPMap.get(billId);
                row.set("parentnumber", (Object)pnumber);
            }
            if ((map = srcMap.get(srcType)) != null) {
                String srcOrg = map.get(billId);
                row.set("srcorg", (Object)srcOrg);
                continue;
            }
            String srcNumber = row.getString("org.number");
            String srcName = row.getString("org.name");
            srcNumber = srcNumber == null ? "" : srcNumber;
            srcNumber = srcNumber.trim().equalsIgnoreCase("null") ? "" : srcNumber;
            srcName = srcName == null ? "" : srcName;
            srcName = srcName.trim().equalsIgnoreCase("null") ? "" : srcName;
            row.set("srcorg", (Object)String.join((CharSequence)" ", srcNumber, srcName));
        }
    }

    private Map<String, Map<Long, String>> getSrcNameMap(Map<Tuple<String, String>, Set<Long>> srcOrgMap) {
        HashMap<String, Map<Long, String>> srcMap = new HashMap<String, Map<Long, String>>(32);
        for (Map.Entry<Tuple<String, String>, Set<Long>> entry : srcOrgMap.entrySet()) {
            Tuple<String, String> t = entry.getKey();
            String key = (String)t.t1;
            String sel = (String)t.t2;
            Set<Long> value = entry.getValue();
            DataSet ds = QueryServiceHelper.queryDataSet((String)"SupplyDemandRptFormPlugin.srcMap", (String)key, (String)sel, (QFilter[])new QFilter[]{new QFilter("id", "in", value)}, null);
            Throwable throwable = null;
            try {
                HashMap<Long, String> idMap = new HashMap<Long, String>();
                for (Row d : ds) {
                    String join = String.join((CharSequence)" ", d.getString("number") == null ? "" : d.getString("number"), d.getString("name") == null ? "" : d.getString("name"));
                    idMap.put(d.getLong("id"), join);
                }
                srcMap.put(key, idMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ds == null) continue;
                if (throwable != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ds.close();
            }
        }
        return srcMap;
    }

    private boolean getSrcOrgMap(Map<Tuple<String, String>, Set<Long>> srcOrgMap, String srcType, long billId) {
        String sel = null;
        switch (srcType) {
            case "om_mftstock": {
                sel = "orderentryid.supplier";
                break;
            }
            case "sm_salorder": {
                sel = "customer";
                break;
            }
            case "om_mftorder": {
                sel = "treeentryentity.supplier";
                break;
            }
            case "pm_purorderbill": {
                sel = "supplier";
            }
        }
        if (sel != null) {
            sel = "(" + sel + ".name) as name,(" + sel + ".number) as number,id";
            Tuple<String, String> t = new Tuple<String, String>(srcType, sel);
            srcOrgMap.computeIfAbsent(t, k -> new HashSet(8)).add(billId);
        }
        return sel != null;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean hasSup;
        FilterInfo filter = queryParam.getFilter();
        FilterItemInfo material = filter.getFilterItem("keymaterial");
        List value = (List)material.getValue();
        if (value == null || value.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SupplyDemandRptFormPlugin_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (value.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6700\u591a\u53ef\u9009100\u4e2a\u7269\u6599\u3002", (String)"SupplyDemandRptFormPlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)TB_RANGE, (String)"demandentry.demandconfig,supplyentry.supplyconfig", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)"1", true)});
        if (dyn == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u66f4\u591a\u8fdb\u884c\u4f9b\u9700\u8bbe\u7f6e\u3002", (String)"SupplyDemandRptFormPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        FilterItemInfo rangeItem = filter.getFilterItem("range");
        String range = rangeItem.getString();
        DynamicObjectCollection demandentry = dyn.getDynamicObjectCollection("demandentry");
        DynamicObjectCollection supplyentry = dyn.getDynamicObjectCollection("supplyentry");
        boolean showDem = "1".equals(range) || "2".equals(range);
        boolean showSup = "1".equals(range) || "3".equals(range);
        boolean hasDem = showDem && !demandentry.isEmpty();
        boolean bl = hasSup = showSup && !supplyentry.isEmpty();
        if (!hasDem && !hasSup) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u70b9\u51fb\u66f4\u591a\u8fdb\u884c\u4f9b\u9700\u8bbe\u7f6e\u3002", (String)"SupplyDemandRptFormPlugin_11", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private static class Tuple<T1, T2> {
        final T1 t1;
        final T2 t2;

        Tuple(T1 t1, T2 t2) {
            this.t1 = t1;
            this.t2 = t2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tuple tuple = (Tuple)o;
            return Objects.equals(this.t1, tuple.t1) && Objects.equals(this.t2, tuple.t2);
        }

        public int hashCode() {
            return Objects.hash(this.t1, this.t2);
        }
    }

    private static class QTY {
        BigDecimal qty = BigDecimal.ZERO;

        private QTY() {
        }

        void add(BigDecimal add) {
            if (add != null) {
                this.qty = this.qty.add(add);
            }
        }
    }

    private static class SumSrcOrg {
        Long mt;
        Long configuredcode;
        Long tracknumber;
        Long auxproperty;
        Long project;
        Long unit;
        Long config;
        String orgNumber;

        SumSrcOrg(Long mt, Long configuredcode, Long tracknumber, Long auxproperty, Long project, Long unit, Long config, String orgNumber) {
            this.mt = mt;
            this.configuredcode = configuredcode;
            this.tracknumber = tracknumber;
            this.project = project;
            this.auxproperty = auxproperty;
            this.unit = unit;
            this.config = config;
            this.orgNumber = orgNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SumSrcOrg sumSrcOrg = (SumSrcOrg)o;
            return Objects.equals(this.mt, sumSrcOrg.mt) && Objects.equals(this.configuredcode, sumSrcOrg.configuredcode) && Objects.equals(this.tracknumber, sumSrcOrg.tracknumber) && Objects.equals(this.project, sumSrcOrg.project) && Objects.equals(this.auxproperty, sumSrcOrg.auxproperty) && Objects.equals(this.unit, sumSrcOrg.unit) && Objects.equals(this.config, sumSrcOrg.config) && Objects.equals(this.orgNumber, sumSrcOrg.orgNumber);
        }

        public int hashCode() {
            return Objects.hash(this.mt, this.configuredcode, this.tracknumber, this.project, this.auxproperty, this.unit, this.config, this.orgNumber);
        }
    }
}

