/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.task;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.common.util.LocalDateUtil;
import kd.mmc.mrp.task.MRPClearDataTask;
import kd.mmc.mrp.utils.MRPUtil;

public class CPSClearDataTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] dynamicObjects;
        if (map.get("reservedays") == null) {
            throw new KDException(new ErrorCode("RESERVEDAYS_IS_EMPTY", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u9f50\u5957\u8ba1\u5212\u8fd0\u7b97\u6570\u636e\u4fdd\u7559\u5929\u6570)\u3002", (String)"CPSClearDataTask_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), "reservedays")), new Object[0]);
        }
        int reservedays = (Integer)MRPUtil.convert((Object)map.get("reservedays"), (Object)0);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -reservedays);
        Date maxDate = calendar.getTime();
        LocalDate maxLocaDate = LocalDateUtil.date2LocalDate((Date)maxDate);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)LocalDateUtil.localDate2Date((LocalDate)maxLocaDate));
        QFilter clearstatusFilter = new QFilter("clearstatus", "!=", (Object)Character.valueOf('B'));
        QFilter runTypeFilter = new QFilter("runtype", "=", (Object)Character.valueOf('B'));
        HashSet<String> calogNumberSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id, number, clearstatus", (QFilter[])new QFilter[]{dateFilter, clearstatusFilter, runTypeFilter})) {
            calogNumberSet.add(dynamicObject.getString("number"));
            dynamicObject.set("clearstatus", (Object)Character.valueOf('B'));
        }
        MRPClearDataTask.clearMrpDatas("mrp_cps_detail", "caculatelog", calogNumberSet, false);
        MRPClearDataTask.clearMrpDatas("mrp_cps_shortage", "caculatelog", calogNumberSet, false);
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }
}

