/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.task;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ClearSimulationTask
extends AbstractTask {
    public void execute(RequestContext arg0, Map<String, Object> arg1) throws KDException {
        Date date = new Date();
        String[] status = new String[]{"A", "B"};
        QFilter statusQF = new QFilter("simulationstatus", "in", (Object)status);
        QFilter timeQF = new QFilter("createtime", "<", (Object)date);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"mrp_simulation", (String)"id", (QFilter[])new QFilter[]{statusQF, timeQF});
        HashSet set = new HashSet(col.size());
        col.forEach(obj -> set.add(obj.getLong("id")));
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])set.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)"mrp_simulation").getDynamicObjectType());
        Calendar instance = Calendar.getInstance();
        HashSet<String> logSet = new HashSet<String>(load.length);
        for (DynamicObject obj2 : load) {
            instance.setTime(obj2.getDate("createtime"));
            int day = obj2.getInt("retentiondays");
            instance.add(5, day);
            if (!instance.getTime().before(date)) continue;
            obj2.set("simulationstatus", (Object)"D");
            obj2.getDynamicObjectCollection("treeentryentity").clear();
            obj2.getDynamicObjectCollection("fieldentry").clear();
            obj2.getDynamicObjectCollection("groupentryentity").clear();
            logSet.add(obj2.getString("runlog.number"));
        }
        if (!logSet.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])load);
            DeleteServiceHelper.delete((String)"mrp_simcolorder", (QFilter[])new QFilter[]{new QFilter("planoperatenum", "in", logSet)});
            DeleteServiceHelper.delete((String)"mrp_simulateorder", (QFilter[])new QFilter[]{new QFilter("planoperatenum", "in", logSet)});
            DeleteServiceHelper.delete((String)"mrp_simulationdetail", (QFilter[])new QFilter[]{new QFilter("caculatelog", "in", logSet)});
            for (DynamicObject obj2 : load = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id,clearstatus", (QFilter[])new QFilter[]{new QFilter("number", "in", logSet)})) {
                obj2.set("clearstatus", (Object)Character.valueOf('B'));
            }
            SaveServiceHelper.update((DynamicObject[])load);
        }
    }
}

