/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.task;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.hint.HintCondition;
import kd.bos.xdb.hint.ShardingHintContext;
import kd.bos.xdb.sharding.sql.FilterType;
import kd.mmc.mrp.common.util.LocalDateUtil;
import kd.mmc.mrp.utils.MRPUtil;

public class MRPClearDataTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(MRPClearDataTask.class);
    public static final String RESERVEDAYS = "reservedays";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DynamicObject[] dynamicObjects;
        if (map.get(RESERVEDAYS) == null) {
            throw new KDException(new ErrorCode("RESERVEDAYS_IS_EMPTY", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](MRP\u8fd0\u7b97\u6570\u636e\u4fdd\u7559\u5929\u6570)\u3002", (String)"MRPClearDataTask_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), RESERVEDAYS)), new Object[0]);
        }
        int reservedays = (Integer)MRPUtil.convert((Object)map.get(RESERVEDAYS), (Object)0);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -reservedays);
        Date maxDate = calendar.getTime();
        LocalDate maxLocaDate = LocalDateUtil.date2LocalDate((Date)maxDate);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)LocalDateUtil.localDate2Date((LocalDate)maxLocaDate));
        QFilter clearstatusFilter = new QFilter("clearstatus", "!=", (Object)Character.valueOf('B'));
        QFilter runTypeFilter = new QFilter("runtype", "=", (Object)Character.valueOf('A'));
        HashSet<Long> calogIDSet = new HashSet<Long>(16);
        HashSet<String> calogNumberSet = new HashSet<String>(16);
        for (DynamicObject dynamicObject : dynamicObjects = BusinessDataServiceHelper.load((String)"mrp_caculate_log", (String)"id, number, clearstatus", (QFilter[])new QFilter[]{dateFilter, clearstatusFilter, runTypeFilter})) {
            calogIDSet.add(dynamicObject.getLong("id"));
            calogNumberSet.add(dynamicObject.getString("number"));
            dynamicObject.set("clearstatus", (Object)Character.valueOf('B'));
        }
        this.clearDatas(calogIDSet, calogNumberSet);
        SaveServiceHelper.update((DynamicObject[])dynamicObjects);
    }

    private void clearDatas(Set<Long> calogIDSet, Set<String> calogNumberSet) {
        MRPClearDataTask.clearMrpDatas("mrp_calcdetail", "caculatelog", calogNumberSet, false);
        MRPClearDataTask.clearMrpDatas("mrp_peginfodata", "billno", calogNumberSet, false);
        MRPClearDataTask.clearMrpDatas("mrp_gdd_source_base", "caculatelog", calogIDSet);
        MRPClearDataTask.clearMrpDatas("mrp_pur_fctdata", "caculatelog", calogNumberSet, false);
        MRPClearDataTask.clearMrpDatas("mrp_rpt_decuments_datas", "planid", calogNumberSet, false);
        MRPClearDataTask.clearMrpDatas("mrp_rpt_production_datas", "planid", calogNumberSet, false);
        MRPClearDataTask.clearMrpDatas("mrp_adjustsuggest", "plannum", calogIDSet);
        MRPClearDataTask.clearMrpDatas("mrp_replace_log", "runlog", calogIDSet, false);
    }

    public static void clearMrpDatas(String entityName, String calogFieldName, Set<?> calogNumberSet) {
        MRPClearDataTask.clearMrpDatas(entityName, calogFieldName, calogNumberSet, true);
    }

    public static void clearMrpDatas(String entityName, String calogFieldName, Set<?> calogNumberSet, boolean batchClearHead) {
        long startTime = System.currentTimeMillis();
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        ISimpleProperty primaryKey = mainEntityType.getPrimaryKey();
        int counts = 0;
        int batch = 1000;
        int size = 0;
        HashSet batchSet = new HashSet(batch);
        Iterator<?> iterator = calogNumberSet.iterator();
        int deleteBatch = batchClearHead ? batch : 1;
        do {
            size = 0;
            batchSet.clear();
            while (iterator.hasNext()) {
                batchSet.add(iterator.next());
                if (++size != batch) continue;
            }
            QFilter calogIdFilter = new QFilter(calogFieldName, "in", batchSet);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"clearMrpDatas", (String)entityName, (String)primaryKey.getName(), (QFilter[])new QFilter[]{calogIdFilter}, null);){
                ArrayList<Object> ids = new ArrayList<Object>(deleteBatch);
                for (Row row : dataSet) {
                    Object id = row.get(0);
                    ids.add(id);
                    if (ids.size() != deleteBatch) continue;
                    try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)mainEntityType.getAlias(), (HintCondition[])new HintCondition[]{new HintCondition(primaryKey.getAlias(), FilterType.in_range, ids)});){
                        counts += ids.size();
                        DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])ids.toArray());
                    }
                    ids.clear();
                }
                if (ids.isEmpty()) continue;
                try (ShardingHintContext ctx = ShardingHintContext.createAndSet((String)mainEntityType.getAlias(), (HintCondition[])new HintCondition[]{new HintCondition(primaryKey.getAlias(), FilterType.in_range, ids)});){
                    counts += ids.size();
                    DeleteServiceHelper.delete((IDataEntityType)mainEntityType, (Object[])ids.toArray());
                }
                ids.clear();
            }
        } while (size >= batch);
        log.info(String.format(ResManager.loadKDString((String)"MRP\u6e05\u7406\u8c03\u5ea6\uff1a\u5b9e\u4f53[%1$s]\u6e05\u9664\u6389[%2$s]\u6761\u6570\u636e\uff0c\u6e05\u7406\u65f6\u957f%3$s(MS)\u3002", (String)"MRPClearDataTask_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), mainEntityType.getDisplayName().toString(), counts, System.currentTimeMillis() - startTime));
    }
}

