/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mmc.mrp.business.helper.GlobalPlanHelper;

public class MRPRunningTask
extends AbstractTask {
    private static final String ISMPS = "ismps";
    private static final String ISMRP = "ismrp";
    private static final String ISREORDERPOINT = "isreorderpoint";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String ORG_NUMBER = "org_number";
    private static final String PLAN_GRAM_NUMBER = "plan_gram_number";
    private static final String ISALLOWDATEINPAST = "isallowdateinpast";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!map.containsKey(ORG_NUMBER)) {
            throw new KDException(new ErrorCode("ORG_NUMBER_IS_EMPTY", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8ba1\u5212\u7ec4\u7ec7\u7f16\u7801)\u3002", (String)"MRPRunningTask_0", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ORG_NUMBER)), new Object[0]);
        }
        if (!map.containsKey(PLAN_GRAM_NUMBER)) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_IS_EMPTY", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u7f16\u7801)\u3002", (String)"MRPRunningTask_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), PLAN_GRAM_NUMBER)), new Object[0]);
        }
        String orgNum = (String)map.get(ORG_NUMBER);
        String planNum = (String)map.get(PLAN_GRAM_NUMBER);
        boolean isallowdateinpast = (Boolean)map.getOrDefault(ISALLOWDATEINPAST, false);
        QFilter qFilterOrg = new QFilter("number", "=", (Object)orgNum);
        DynamicObject planorg = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{qFilterOrg});
        if (planorg == null) {
            throw new KDException(new ErrorCode("ORG_NUMBER_NOT_EXIST", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:\u201c%s\u201d\u7684\u8ba1\u5212\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"MRPRunningTask_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), orgNum)), new Object[0]);
        }
        QFilter qFilter = new QFilter("number", "=", (Object)planNum);
        DynamicObject plangram = QueryServiceHelper.queryOne((String)"mrp_planprogram", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (plangram == null) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_NOT_EXIST", String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a:\u201c%s\u201d\u7684\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"MRPRunningTask_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), planNum)), new Object[0]);
        }
        plangram = BusinessDataServiceHelper.loadSingle((Object)plangram.get("id"), (String)"mrp_planprogram");
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
        Long id = ORM.create().genLongId(MRP_CACULATE_LOG);
        caculateLog.set("id", (Object)id);
        caculateLog.set("createorg", (Object)planorg);
        caculateLog.set("runtype", (Object)"A");
        caculateLog.set("plantype", (Object)this.getPlanType(plangram));
        caculateLog.set("plangram", (Object)plangram.getLong("id"));
        caculateLog.set("programnumber", (Object)plangram.getString("number"));
        caculateLog.set("programname", (Object)plangram.getString("name"));
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)requestContext.getCurrUserId());
        caculateLog.set("operatmode", (Object)ResManager.loadKDString((String)"\u5168\u5c40\u8ba1\u5212", (String)"MRPRunningTask_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        caculateLog.set("operatmodekey", (Object)"mrp_globalplan");
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set(ISALLOWDATEINPAST, (Object)isallowdateinpast);
        String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_LOG, (DynamicObject)caculateLog, (String)planorg.getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new KDException(new ErrorCode("CAL_LOG_NUMBER_NOT_EXIST", ResManager.loadKDString((String)"\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\u4e0d\u5b58\u5728\u3002", (String)"MRPRunningTask_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        if (GlobalPlanHelper.isExistMRPRunning((Long)plangram.getLong("id"))) {
            throw new KDException(new ErrorCode("PLAN_NUMBER_IS_RUNING", ResManager.loadKDString((String)"\u8be5\u8ba1\u5212\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97\u3002", (String)"MRPRunningTask_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), new Object[0]);
        }
        caculateLog.set("number", (Object)number);
        DynamicObjectCollection plantags = plangram.getDynamicObjectCollection("plantags");
        DynamicObjectCollection calctags = caculateLog.getDynamicObjectCollection("plantags");
        calctags.clear();
        for (DynamicObject tag : plantags) {
            DynamicObject cal = calctags.addNew();
            cal.set("fbasedataid", tag.get("fbasedataid"));
        }
        DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mrp", (String)"IMRPRunnerApi", (String)"mrpStarter", (Object[])new Object[]{caculateLog});
    }

    private StringBuilder getPlanType(DynamicObject plangram) {
        Boolean ismrp = plangram.getBoolean(ISMRP);
        Boolean ismps = plangram.getBoolean(ISMPS);
        Boolean isrecord = plangram.getBoolean(ISREORDERPOINT);
        StringBuilder plantype = new StringBuilder();
        if (ismrp.booleanValue()) {
            plantype.append("MRP");
        }
        if (ismps.booleanValue() && !"".equals(plantype.toString())) {
            plantype.append("/MPS");
        } else if (ismps.booleanValue() && "".equals(plantype.toString())) {
            plantype.append("MPS");
        }
        if (isrecord.booleanValue() && !"".equals(plantype.toString())) {
            plantype.append(ResManager.loadKDString((String)"/\u518d\u8ba2\u8d27\u70b9", (String)"MRPRunningTask_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        } else if (isrecord.booleanValue() && "".equals(plantype.toString())) {
            plantype.append(ResManager.loadKDString((String)"\u518d\u8ba2\u8d27\u70b9", (String)"MRPRunningTask_8", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
        return plantype;
    }
}

