/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class EquipmentPlanAuditOp
extends AbstractOperationServicePlugIn {
    private ORM orm = ORM.create();
    private static final String[] synFields = new String[]{"sourcetype", "start", "starttaskid", "end", "endtaskid", "resource", "qty", "unit", "key", "choose", "stime", "ftime", "plantime", "usetime", "area", "pgres", "delivetime", "isdelive", "quittime", "isquit", "uselevel"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryentity.*");
        e.getFieldKeys().add("entryentity.sourcebillnumber");
        e.getFieldKeys().add("entryentity.srcbillentryid");
        e.getFieldKeys().add("entryentity.srcbillid");
        for (String field : synFields) {
            StringBuilder entryField = new StringBuilder("entryentity.");
            entryField.append(field);
            e.getFieldKeys().add(entryField.toString());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String operate = e.getOperationKey();
        if ("audit".equals(operate)) {
            Object entryIts;
            DynamicObject[] dynamicObjects = e.getDataEntities();
            HashSet<Long> tidSet = new HashSet<Long>(dynamicObjects.length);
            HashMap<Long, DynamicObjectCollection> entryMap = new HashMap<Long, DynamicObjectCollection>(dynamicObjects.length);
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long id = 0L;
                if (dynamicObject.get("id") != null) {
                    id = dynamicObject.getLong("id");
                }
                tidSet.add(id);
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                entryIts = dynamicObjectCollection.iterator();
                while (entryIts.hasNext()) {
                    DynamicObject entryDynamicObject = (DynamicObject)entryIts.next();
                    if (entryDynamicObject.get("srcbillentryid") == null || 0L == entryDynamicObject.getLong("srcbillentryid")) continue;
                    entryIts.remove();
                }
                if (dynamicObjectCollection.isEmpty()) continue;
                entryMap.put(id, dynamicObjectCollection);
            }
            TableDefine tableDefine = EntityMetadataCache.loadMainTableDefine((String)"msplan_eqneedplan");
            HashMap<Long, Long> changeMap = new HashMap<Long, Long>(dynamicObjects.length);
            HashSet<Long> sourceSet = new HashSet<Long>(dynamicObjects.length);
            StringBuilder updateChangeEquipSql = new StringBuilder("update t_msplan_eqxneedplanentry set fsrcbillid = ?, fsrcbillentryid= ?, fsourceentryseq = ?, fsourcebilltype = ?, fsourcebillnumber = ? where fentryid = ?");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(dynamicObjects.length);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)EquipmentPlanAuditOp.class.getName(), (String)"botp_billtracker", (String)"stableid, sbillid, tbillid", (QFilter[])new QFilter[]{new QFilter("tbillid", "in", tidSet), new QFilter("stableid", "=", (Object)tableDefine.getTableId())}, null);
            entryIts = null;
            try {
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Long sbillId = 0L;
                    if (row.get("sbillid") != null && 0L != row.getLong("sbillid")) {
                        sbillId = row.getLong("sbillid");
                        sourceSet.add(sbillId);
                    }
                    Long tbillid = 0L;
                    if (row.get("tbillid") != null && 0L != row.getLong("tbillid")) {
                        tbillid = row.getLong("tbillid");
                    }
                    if (sbillId == 0L || tbillid == 0L) continue;
                    changeMap.put(sbillId, tbillid);
                }
            }
            catch (Throwable throwable) {
                entryIts = throwable;
                throw throwable;
            }
            finally {
                if (dataSet != null) {
                    if (entryIts != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)entryIts).addSuppressed(throwable);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            DynamicObject[] sourceObjects = BusinessDataServiceHelper.load((Object[])sourceSet.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"msplan_eqneedplan"));
            HashSet<DynamicObject> updateObjects = new HashSet<DynamicObject>(sourceObjects.length);
            for (DynamicObject dynamicObject : sourceObjects) {
                Long equipId = 0L;
                if (changeMap.get(dynamicObject.getLong("id")) != null) {
                    equipId = (Long)changeMap.get(dynamicObject.getLong("id"));
                }
                if (equipId == 0L || entryMap.get(equipId) == null) continue;
                DynamicObjectCollection changeColl = (DynamicObjectCollection)entryMap.get(equipId);
                DynamicObjectCollection sourceColl = dynamicObject.getDynamicObjectCollection("entryentity");
                int sourceSize = sourceColl.size();
                for (int i = 0; i < changeColl.size(); ++i) {
                    DynamicObject changeObj = (DynamicObject)changeColl.get(i);
                    DynamicObject sourceEntry = this.newEntryObject(this.orm, "msplan_eqneedplan.entryentity");
                    Long entryId = this.newEntryId(this.orm, "msplan_eqneedplan.entryentity");
                    sourceEntry.setParent((Object)dynamicObject);
                    int seq = ++sourceSize;
                    sourceEntry.set("seq", (Object)seq);
                    sourceEntry.set("id", (Object)entryId);
                    this.synChangeEqupToEquip(changeObj, sourceEntry);
                    sourceColl.add((Object)sourceEntry);
                    Object[] param = new Object[]{dynamicObject.getLong("id"), entryId, seq, "1436969988240966656", dynamicObject.getString("billno"), changeObj.getLong("id")};
                    paramList.add(param);
                }
                updateObjects.add(dynamicObject);
            }
            if (paramList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateChangeEquipSql.toString(), paramList);
            }
            if (updateObjects.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])updateObjects.toArray(new DynamicObject[0]));
            }
        }
    }

    private void synChangeEqupToEquip(DynamicObject changeObj, DynamicObject sourceEntry) {
        for (String field : synFields) {
            sourceEntry.set(field, changeObj.get(field));
        }
    }

    private DynamicObject newEntryObject(ORM orm, String entryName) {
        return orm.newDynamicObject(entryName);
    }

    private Long newEntryId(ORM orm, String entryName) {
        return orm.genLongId(entryName);
    }
}

