/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mrp.business.helper.BillUnitAndQtytHelper;
import kd.mmc.mrp.model.enums.PrecisionAccountEnum;

public class CollaboPlanOrderToTransDirOp
extends AbstractConvertPlugIn {
    protected static final String UNIT_CONVERT_DIR_A = "A";
    protected static final String UNIT_CONVERT_DIR_C = "C";

    public void afterConvert(AfterConvertEventArgs e) {
        String targetEntityKey;
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] dataEntities = targetExtDataEntitySet.FindByEntityKey(targetEntityKey = this.getTgtMainType().getName());
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        Map<Object, DynamicObject> materialMap = this.reloadMaterialFromCache(dataEntities);
        HashMap<String, String> cacheMap = new HashMap<String, String>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject targetBill = dataEntity.getDataEntity();
            DynamicObjectCollection billEntry = targetBill.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billEntry) {
                this.coverMultiUnit(row, materialMap, cacheMap);
            }
        }
    }

    private void coverMultiUnit(DynamicObject row, Map<Object, DynamicObject> materialMap, Map<String, String> cacheMap) {
        DynamicObject unit2nd;
        DynamicObject materialInventoryInfo = row.getDynamicObject("material");
        if (materialInventoryInfo == null) {
            return;
        }
        DynamicObject inventoryUnit = materialInventoryInfo.getDynamicObject("inventoryunit");
        row.set("unit", (Object)inventoryUnit);
        DynamicObject baseUnit = row.getDynamicObject("baseunit");
        BigDecimal baseQty = row.getBigDecimal("baseqty");
        if (baseUnit == null || BigDecimal.ZERO.compareTo(baseQty) == 0) {
            return;
        }
        long baseUnitId = baseUnit.getLong("id");
        DynamicObject material = materialInventoryInfo.getDynamicObject("masterid");
        long materialId = material.getLong("id");
        material = materialMap.get(materialId);
        if (inventoryUnit != null) {
            long inventoryUnitId = inventoryUnit.getLong("id");
            BigDecimal unitRate = BillUnitAndQtytHelper.getUnitRateConv((Long)materialId, (Long)inventoryUnitId, (Long)baseUnitId, cacheMap);
            if (unitRate == null || BigDecimal.ZERO.compareTo(unitRate) == 0) {
                unitRate = BigDecimal.ONE;
            }
            int precision = inventoryUnit.getInt("precision");
            int precisionAccount = inventoryUnit.getInt("precisionaccount");
            int roundingMode = PrecisionAccountEnum.getEnumByVal((int)precisionAccount);
            BigDecimal qty = baseQty.divide(unitRate, precision, roundingMode);
            row.set("qty", (Object)qty);
        }
        if ((unit2nd = row.getDynamicObject("unit2nd")) != null) {
            long unit2ndId = unit2nd.getLong("id");
            String unitConvertDir = material.getString("unitconvertdir");
            if (UNIT_CONVERT_DIR_A.equals(unitConvertDir) || UNIT_CONVERT_DIR_C.equals(unitConvertDir)) {
                BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)materialId, (Long)unit2ndId, (Long)baseUnitId, cacheMap);
                if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
                    unit2ndRate = BigDecimal.ONE;
                }
                int precision = unit2nd.getInt("precision");
                int precisionAccount = unit2nd.getInt("precisionaccount");
                int roundingMode = PrecisionAccountEnum.getEnumByVal((int)precisionAccount);
                BigDecimal qtyUnit2nd = baseQty.divide(unit2ndRate, precision, roundingMode);
                row.set("qtyunit2nd", (Object)qtyUnit2nd);
            }
        }
    }

    private Map<Object, DynamicObject> reloadMaterialFromCache(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        ArrayList<Long> materialIdList = new ArrayList<Long>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject targetBill = dataEntity.getDataEntity();
            DynamicObjectCollection billEntry = targetBill.getDynamicObjectCollection("billentry");
            if (billEntry == null || billEntry.isEmpty()) continue;
            for (DynamicObject row : billEntry) {
                DynamicObject material;
                DynamicObject materialInventoryInfo = row.getDynamicObject("material");
                if (materialInventoryInfo == null || (material = materialInventoryInfo.getDynamicObject("masterid")) == null) continue;
                materialIdList.add(material.getLong("id"));
            }
        }
        QFilter filter = new QFilter("id", "in", materialIdList);
        return BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id, auxptyunit, unitconvertdir", (QFilter[])filter.toArray());
    }
}

