/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.planexecute;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mrp.business.helper.XPlanOrderChangeLoghelper;
import kd.mmc.mrp.opplugin.planexecute.XPlanOrderChangeValidator;

public class XPlanOrderChangeSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("sourceid");
        e.getFieldKeys().add("changeqty");
        e.getFieldKeys().add("changedate");
        e.getFieldKeys().add("changetype");
        e.getFieldKeys().add("changtracknumber");
        e.getFieldKeys().add("changsupplier");
        e.getFieldKeys().add("reason");
        e.getFieldKeys().add("sourceno");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("availabledate");
        e.getFieldKeys().add("tracknumber");
        e.getFieldKeys().add("issysgen");
        e.getFieldKeys().add("modifier");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("proorpurorg");
        e.getFieldKeys().add("org");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new XPlanOrderChangeValidator());
    }

    /*
     * WARNING - void declaration
     */
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        void var9_14;
        super.beginOperationTransaction(e);
        DynamicObject[] xPlanOrders = e.getDataEntities();
        ArrayList<Long> xPlanOrderIds = new ArrayList<Long>(xPlanOrders.length);
        ArrayList<DynamicObject> xPlanOrderChangeLogList = new ArrayList<DynamicObject>(xPlanOrders.length);
        HashSet<Long> sourceids = new HashSet<Long>(xPlanOrders.length);
        for (DynamicObject dynamicObject : xPlanOrders) {
            Long sourceid = dynamicObject.getLong("sourceid");
            sourceids.add(sourceid);
        }
        MainEntityType planorderType = EntityMetadataCache.getDataEntityType((String)"mrp_planorder");
        DynamicObject[] planOrders = BusinessDataServiceHelper.load((Object[])sourceids.toArray(new Object[0]), (DynamicObjectType)planorderType);
        HashMap<Long, DynamicObject> planOrderMap = new HashMap<Long, DynamicObject>(planOrders.length);
        for (DynamicObject planOrder : planOrders) {
            Long planOrderId = planOrder.getLong("id");
            planOrderMap.put(planOrderId, planOrder);
        }
        boolean bl = false;
        while (var9_14 < xPlanOrders.length) {
            DynamicObject planorderChangeBill = xPlanOrders[var9_14];
            Long xplanOrderId = planorderChangeBill.getLong("id");
            xPlanOrderIds.add(xplanOrderId);
            QFilter qFilter = new QFilter("xbillid", "=", (Object)xplanOrderId);
            qFilter.and("changestatus", "=", (Object)"B");
            boolean exists = QueryServiceHelper.exists((String)"mrp_xplanorderlog", (QFilter[])new QFilter[]{qFilter});
            if (exists) {
                return;
            }
            Long sourceId = planorderChangeBill.getLong("sourceid");
            DynamicObject planOrder = (DynamicObject)planOrderMap.get(sourceId);
            xPlanOrderChangeLogList.add(XPlanOrderChangeLoghelper.makeUpXPlanorderChangeLog((String)"A", (DynamicObject)planorderChangeBill, (DynamicObject)planOrder));
            ++var9_14;
        }
        this.deleteXPlanOrderChangeLogByXPlanOrderIds(xPlanOrderIds);
        SaveServiceHelper.save((DynamicObject[])xPlanOrderChangeLogList.toArray(new DynamicObject[0]));
    }

    private void deleteXPlanOrderChangeLogByXPlanOrderIds(List<Long> xplanOrderIds) {
        QFilter mftOrderLogFilter = new QFilter("xbillid", "in", xplanOrderIds);
        DeleteServiceHelper.delete((String)"mrp_xplanorderlog", (QFilter[])mftOrderLogFilter.toArray());
    }
}

