/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.opplugin.pls.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CompleteResultValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            this.validateCompleteResult(extendedDataEntity);
        }
    }

    private void validateCompleteResult(ExtendedDataEntity extendedDataEntity) {
        DynamicObjectCollection workCenterEntry = extendedDataEntity.getDataEntity().getDynamicObjectCollection("workcenterentry");
        boolean hasCalc = false;
        for (DynamicObject workCenter : workCenterEntry) {
            DynamicObjectCollection calcResultEntry = workCenter.getDynamicObjectCollection("calcresultsubentry");
            for (DynamicObject calcResult : calcResultEntry) {
                BigDecimal completeResult;
                if (!calcResult.getBoolean("ispartincalc_1") || (completeResult = StringUtils.isBlank((CharSequence)calcResult.getString("completeresult")) ? BigDecimal.ZERO : new BigDecimal(calcResult.getString("completeresult"))).compareTo(BigDecimal.ZERO) > 0) continue;
                hasCalc = true;
            }
        }
        if (hasCalc) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u53c2\u4e0e\u6392\u7a0b\u8ba1\u7b97\u80fd\u529b\u9879\u5e94\u5927\u4e8e0\u3002", (String)"CompleteResultValidator_0", (String)"mmc-mrp-opplugin", (Object[])new Object[0]), new Object[0]));
        }
    }
}

