/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mrp.controlnode.framework.runner;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mmc.mrp.controlnode.framework.runner.MRPRunner4Res;
import kd.mmc.mrp.framework.IMRPEnvProvider;
import kd.mmc.mrp.integrate.RESEnv;
import kd.mmc.mrp.res.RESErrorMessageUtil;

public class RESExecService
extends AbstractTask {
    private static final String ORG_NUMBER = "org_number";
    private static final String RES_GRAM_NUMBER = "res_gram_number";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (!map.containsKey(ORG_NUMBER)) {
            throw new KDException(new ErrorCode(ORG_NUMBER, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8ba1\u5212\u7ec4\u7ec7\u7f16\u7801)\u3002", (String)"RESExecService_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), ORG_NUMBER)), new Object[0]);
        }
        Long orgid = 0L;
        Long userid = Long.valueOf(requestContext.getUserId());
        DynamicObject queryorg = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)map.get(ORG_NUMBER).toString())});
        if (queryorg == null) {
            throw new KDException(new ErrorCode(ORG_NUMBER, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8ba1\u5212\u7ec4\u7ec7\u7f16\u7801)\u3002", (String)"RESExecService_0", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), ORG_NUMBER)), new Object[0]);
        }
        orgid = queryorg.getLong("id");
        if (!map.containsKey(RES_GRAM_NUMBER)) {
            throw new KDException(new ErrorCode(RES_GRAM_NUMBER, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8c03\u5ea6\u4f5c\u4e1a->\u6267\u884c\u53c2\u6570->\u81ea\u5b9a\u4e49\u53c2\u6570[%s](\u8fd0\u7b97\u65b9\u6848\u7f16\u7801)\u3002", (String)"RESExecService_1", (String)"mmc-mrp-mservice-controlnode", (Object[])new Object[0]), RES_GRAM_NUMBER)), new Object[0]);
        }
        String resno = map.get(RES_GRAM_NUMBER).toString();
        String[] items = resno.split(",");
        DynamicObjectCollection querysch = QueryServiceHelper.query((String)"mrp_res_scheme", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)items)});
        if (querysch != null) {
            for (DynamicObject obj : querysch) {
                this.execSchedulingScheme(obj.getLong("id"), orgid, userid);
            }
        }
    }

    private void execSchedulingScheme(Long schid, Long orgid, Long userid) {
        DynamicObject caculateLog = this.createNewLog(schid, orgid, userid);
        new MRPRunner4Res().run((IMRPEnvProvider)new RESEnv(caculateLog));
    }

    private DynamicObject createNewLog(Long schid, Long orgid, Long userid) {
        DynamicObject schedulingScheme = BusinessDataServiceHelper.loadSingle((Object)schid, (String)"mrp_res_scheme");
        String getFormId = "mrp_resourceplan_exec";
        if ("2".equals(schedulingScheme.getString("chkgroupplantype"))) {
            getFormId = "mrp_resourceassess_exec";
        }
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)orgid, (String)"bos_org");
        Long id = ORM.create().genLongId("mrp_caculate_log");
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)org.getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            number = caculateLog.getString("id");
        }
        caculateLog.set("id", (Object)id);
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)RESErrorMessageUtil.getExecMode((String)getFormId));
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)"mrp_res_scheme");
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)userid);
        caculateLog.set("operatmode", (Object)"RES");
        caculateLog.set("operatmodekey", (Object)getFormId);
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)Boolean.FALSE);
        caculateLog.set("isbomcheck", (Object)Boolean.FALSE);
        caculateLog.set("isallowdateinpast", (Object)Boolean.FALSE);
        if ("mrp_resourceassess_exec".equalsIgnoreCase(getFormId)) {
            caculateLog.set("runtype", (Object)"I");
        } else {
            caculateLog.set("runtype", (Object)"H");
        }
        caculateLog.set("iscommon", (Object)Boolean.FALSE);
        caculateLog.set("iscustomize", (Object)Boolean.FALSE);
        caculateLog.set("isselection", (Object)Boolean.FALSE);
        caculateLog.set("isnotsetup", (Object)Boolean.FALSE);
        if (number != null) {
            ORM.create().save(caculateLog);
            BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        }
        return caculateLog;
    }
}

